
/*
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <netinet/in.h>

#include "ifo.h"

char version[] = "V0.0.4";

/**
 *
 */

int main (int argc, char **argv)
{
	ifo_t *ifo;
	int fd;

	printf ("free InFormatiOn project %s\n", version);
	printf ("displays Commands\n");
	printf ("--------------------------------\n");
	printf ("(c) 1999 by Thomas Mirlacher\n\n");

	if ((fd = open (argv[1], O_RDONLY)) < 0) {
		fprintf (stderr, "error opening file %s.\n", argv[1]);
		exit (-1);
	}

	if (!(ifo = ifoOpen (fd, 0))) {
		fprintf (stderr, "error initializing ifo.\n");
		exit (-1);
	}

{
	int i;
	ifo_hdr_t *hdr = (ifo_hdr_t *) ifo->data[ID_TITLE_PGCI];

	if (hdr) {
		printf ("TITLE PGCI commands:\n");
		printf ("--------------------\n");

		for (i=0; i<ntohs(hdr->num); i++) {
			char *ptr;

			printf ("%d:\n---\n", i);

			if (ifoGetPGCI (hdr, i, &ptr) >= 0)
				ifo_print_pgc_cmd (ptr);

			printf ("\n");
		}
	}
}

{
	int i, s;
	ifo_hdr_t *_hdr = (ifo_hdr_t *) ifo->data[ID_MENU_PGCI];

	if (_hdr) {
		printf ("MENU PGCI commands:\n");
		printf ("--------------------\n");

		for (i=0; i<ntohs(_hdr->num); i++) {
			ifo_hdr_t *hdr;

			printf ("lu%d:\n---\n", i);

			if (ifoGetPGCI ((ifo_hdr_t *) ifo->data[ID_MENU_PGCI], i, (char **) &hdr) < 0)
				return -1;

			for (s=0; s<ntohs(hdr->num); s++) {
				char *ptr_pgc;

				printf ("%d:\n---\n", s);
			
				if (ifoGetPGCI (hdr, s, &ptr_pgc) >= 0)
					ifo_print_pgc_cmd (ptr_pgc);

				printf ("\n");
			}
		}
	}
}

	close (fd);

	return 0;
}
