
/*
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */


#ifdef PARSER
#include <stdio.h>
#endif
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include "ifo.h"

#include "misc.h"
#include "decode.h"

/*
 audio_struct [1..8] audio_table_struct
*/

struct audio_struct {
	u_int	foo		: 24;	// ???
	u_char	num		: 8;	// number of subchannels
};

struct audio_sub_struct {
#if 1	//#if BYTE_ORDER == LITTLE //BIG_ENDIAN
	u_char num_channels	: 3;	// number of channels (n+1)
	u_char sample_freq	: 2;	// sampling frequency
	u_char quantization	: 2;	// quantization
	u_char appl_mode2	: 1;	// audio application mode

	u_char appl_mode1	: 1;	//
	u_char type		: 2;	// audio type (language included?)
	u_char multichannel_extension: 1;
	u_char coding_mode	: 2;
#else
	u_char coding_mode	: 2;
	u_char multichannel_extension: 1;
	u_char type		: 2;
	u_char appl_mode1	: 1;

	u_char appl_mode2	: 1;
	u_char quantization	: 2;
	u_char sample_freq	: 2;
	u_char num_channels	: 3;
#endif
	u_short	lang_code	: 16;	// <char> description
	u_int	foo		: 8;	// 0x00000000 ?
	u_int	caption		: 8;
	u_int	bar		: 8;	// 0x00000000 ?
};


/**
 *
 */

ifo_audio_t *ifoGetAudio (u_char *ptr)
{
	ifo_audio_t *audio;
	int i;

	if (!ptr)
		return NULL;

	if (!(audio = (ifo_audio_t *) malloc (sizeof (ifo_audio_t))))
		return NULL;

printf ("audio unknown 1: %x\n", ((struct audio_struct *)ptr)->foo);

	audio->num = ((struct audio_struct *)ptr)->num;
	audio->sub = NULL;
printf ("number audio 1: %x\n", audio->num);

	ptr += sizeof (struct audio_struct);

	if (!(audio->sub = (ifo_audio_sub_t *) calloc (audio->num, sizeof (ifo_audio_sub_t))))
		return NULL;

	for (i=0; i<audio->num; i++) {
		ifo_audio_sub_t *audio_sub = (ifo_audio_sub_t *) audio->sub + i;
	
		audio_sub->coding_mode	= ((struct audio_sub_struct *)ptr)->coding_mode;
		audio_sub->multichannel_extension	= ((struct audio_sub_struct *)ptr)->multichannel_extension;
		audio_sub->type		= ((struct audio_sub_struct *)ptr)->type;
		audio_sub->appl_mode	= ((struct audio_sub_struct *)ptr)->appl_mode1 <<1 | ((struct audio_sub_struct *)ptr)->appl_mode2;
		audio_sub->quantization	= ((struct audio_sub_struct *)ptr)->quantization;
		audio_sub->sample_freq	= ((struct audio_sub_struct *)ptr)->sample_freq;
		audio_sub->num_channels	= ((struct audio_sub_struct *)ptr)->num_channels;
		audio_sub->lang_code	= ((struct audio_sub_struct *)ptr)->lang_code;
		audio_sub->caption	= ((struct audio_sub_struct *)ptr)->caption;
printf ("audio unknown 2: %x\n", ((struct audio_sub_struct *)ptr)->foo);
printf ("audio unknown 3: %x\n", ((struct audio_sub_struct *)ptr)->bar);

		ptr += sizeof (struct audio_sub_struct);
	}

	return audio;
}	

#ifdef PARSER
/**
 *
 */

void ifoPrintAudio (ifo_audio_t *audio)
{
	int i;

	if (!audio)
		return;

	printf ("\nAUDIO\n");
	printf ("---\n");

	printf ("number of streams:\t%d\n", audio->num);

	for (i=0; i<audio->num; i++) {
		char *appl_mode;
		char *caption;

		ifo_audio_sub_t *audio_sub = (ifo_audio_sub_t *) audio->sub + i;

// ???		if (audio_sub->type) // language included
			printf ("\tlang_code:\t%s\n",   decode_lang (audio_sub->lang_code));
//		else
//			printf ("\tno language specified in stream\n");

		printf ("\tmode:\t\t%s(%dCh)%s\n",
			decode_audiomode (audio_sub->coding_mode),
			audio_sub->num_channels,
			audio_sub->multichannel_extension ? "+multichannel" : ""
			);

		printf ("\tsampling:\t%dkHz\n", audio_sub->sample_freq ? 96 : 48);
		//printf ("\tquantization:\t%dkHz\n", audio_sub->sample_freq ? 96 : 48);
		//if (MPEG) quantization=1 ... DRC exists
		//else			 0=16bit, 1=20bit 2=24bit); 

		if ((appl_mode = decode_audiomodeappl (audio_sub->appl_mode)))
			printf ("\tappl_mode:\t%s\n", appl_mode);
		if ((caption = decode_caption (audio_sub->caption)))
			printf ("\tcaption:\t%s\n", caption);

//		printf ("\tfreq:\t\t%x\n",      audio_sub->freq);
//		printf ("\tquant:\t\t%x\n",     audio_sub->quant);
		printf ("\n");
	}
}
#endif
