
/*
 * SUBPICTURE TABLE
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */


#ifdef PARSER
#include <stdio.h>
#endif
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include "ifo.h"

#include "misc.h"
#include "decode.h"

#define SUBPIC_LEN    6

struct subpic_struct {
	u_int   zero	: 32;		// 0x00000000 ?
	u_char  zero1	: 8;		// 0x00 ?
	u_char  num	: 8;		// number of SPUs
};

#define SUBPIC_TBL_LEN 6

struct subpic_sub_struct {
	u_short prefix  : 16;		// 0x0100 ?
	u_short lang_code : 16;		// <char> description
	u_char foo	: 8;		// dont know
	u_char caption	: 8;		// 0x00 ?
};


/**
 * Sub Picture Unit
 */

ifo_subpic_t *ifoGetSPU (u_char *ptr)
{
	ifo_subpic_t *subpic;
	int i;

	if (!ptr)
		return NULL;
	
	if (!(subpic = (ifo_subpic_t *) malloc (sizeof (ifo_subpic_t))))
		return NULL;

	subpic->num = ((struct subpic_struct *)ptr)->num;
	subpic->sub = NULL;

	ptr += SUBPIC_LEN;

	if (!(subpic->sub = (ifo_subpic_sub_t *) calloc (subpic->num, sizeof (ifo_subpic_sub_t))))
		return NULL;

	for (i=0; i<subpic->num; i++) {
		ifo_subpic_sub_t *subpic_sub = (ifo_subpic_sub_t *) subpic->sub + i;

printf ("s: %x\n", ((struct subpic_sub_struct *)ptr)->foo);
	
		subpic_sub->lang_code	= ((struct subpic_sub_struct *)ptr)->lang_code;
		subpic_sub->caption	= ((struct subpic_sub_struct *)ptr)->caption;

		ptr += SUBPIC_TBL_LEN;
	}

	return subpic;
}	


#ifdef PARSER
/**
 *
 */

void ifoPrintSPU (ifo_subpic_t *subpic)
{
	int i;

	if (!subpic) 
		return;

	printf ("\nSUBPICTURE\n");
	printf ("---\n");

	printf ("number of streams:\t%d\n", subpic->num);

	for (i=0; i<subpic->num; i++) {
		ifo_subpic_sub_t *subpic_sub = (ifo_subpic_sub_t *) subpic->sub + i;
		char *caption;

		printf ("\tlang_code:\t%s\n",   decode_lang (subpic_sub->lang_code));
		if ((caption = decode_caption (subpic_sub->caption)))
			printf ("\tcaption:\t%s\n", caption);
		printf ("\n");
	}
}
#endif
