
/*
 * TIME MAP TABLE
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */


#ifdef PARSER
#include <stdio.h>
#endif
#include <sys/types.h>
#include <unistd.h>
#include "ifo.h"

#include "misc.h"
#include "decode.h"

#define TMT_SUB_LEN 4

typedef struct {
	u_char	tu		: 8;	// time unit (in seconds)
	u_int			: 24;	// don't know
} tmt_sub_t;

#ifdef PARSER
/**
 *
 */

void ifo_print_tmt (ifo_t *ifo)
{
	u_char *ptr = ifo->data[ID_TMT];
	ifo_hdr_t *hdr = (ifo_hdr_t *) ifo->data[ID_TMT];
	int i;

	if (!ifo->data[ID_TMT])
		return;

	printf ("\nTIME MAP TABLE\n");
	printf ("---\n");
	printf ("number of maps: %d\n", ntohs (hdr->num));	
	printf ("length of table: %d\n", ntohl (hdr->len));	

	ptr += IFO_HDR_LEN;

	for (i=0; i<ntohs (hdr->num); i++) {
		printf ("%d start 0x%x\n", i, get4bytes (ptr));
		ptr += 4;
	}

	{
		tmt_sub_t *tmt_sub = (tmt_sub_t *) ptr;

		printf ("time unit (in seconds): %d\n", tmt_sub->tu);

		ptr += TMT_SUB_LEN;
	}

	while (ptr < (((u_char *) hdr) + ntohl (hdr->len))) {
		printf ("0x%06x%c ", get4bytes (ptr)&0x7FFFFFFF,
				get4bytes (ptr)&0x80000000 ? 'L' : ' ');

		ptr += 4;
	}
}	
#endif
