
/*
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */


#ifdef PARSER
#include <stdio.h>
#endif
#include <sys/types.h>
#include <unistd.h>
#include "ifo.h"

#include "misc.h"
#include "decode.h"

#ifdef PARSER
/**
 *
 */

void ifoPrintVideo (u_char *ptr)
{
	ifo_video_info_t *video = (ifo_video_info_t *) ptr;

	printf ("\nVIDEO\n");
	printf ("---\n");

	printf ("\tcompression : MPEG-%d\n", video->compression+1);
	printf ("\tTV system   : %s Hz\n", video->system ? "PAL 625/50" : "NTSC 525/60");

	printf ("\tAspect ratio: ");
	switch (video->ratio) {
		case 0:
			printf ("4:3\n");
			break;
		case 3:
			printf ("16:9\n");
			break;
		default:
			printf ("undefined\n");
	}

{
	char perm_displ[][23] = {
		"pan-scan & letterboxed",
		"pan-scan",
		"letterboxed",
		"not specified"
	};

	printf ("\tDisplay Mode: %s\n", perm_displ[video->perm_displ]);
}

	printf ("\tLine21-1    : %s\n", video->line21_1 ? "data present in GOP" : "");
	printf ("\tLine21-2    : %s\n", video->line21_2 ? "data present in GOP" : "");

{
	char source_res[][28] = {
		"720x480 NTSC or 720x576 PAL",
		"704x480 NTSC or 704x576 PAL",
		"352x480 NTSC or 352x576 PAL",
		"352x240 NTSC or 352x288 PAL"
	};

	printf ("\tSource Res  : %s\n", source_res[video->source_res]);
}
	printf ("\tLetterboxed : %s\n", video->letterboxed ? "yes" : "no");
	printf ("\tMode        : %s\n", video->mode ? "Film (625/50 only)" : "Camera");
}
#endif
