
/*
 * PGROGRAM CHAIN INFORMATION
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 * $log$
 */


#ifdef PARSER
#include <stdio.h>
#endif
#include <sys/types.h>
#include <unistd.h>
#include "ifo.h"

#include "misc.h"
#include "pgc.h"
#include "decode.h"

#define OFFSET_START_TBL_CMD (12+8*2+32*4+8+16*PGCI_COLOR_LEN)

typedef struct {
	u_char			: 8;	// don't know
	u_char	y		: 8;
	u_char	cr		: 8;
	u_char	cb		: 8;	
} pgci_color_t;

#define PGCI_COLOR_LEN 4

void ifo_print_cell_position (u_char *ptr, u_int num);


/**
 *
 */

int ifoGetCLUT (char *pgc, char **ptr)
{
	*ptr = pgc;

	if (!pgc)
		return -1;

	*ptr += 2;	
	*ptr += 10;
	*ptr += 8 * 2;			// AUDIO
	*ptr += 32 * 4;			// SUBPICTURE
	*ptr += 8;

	return 0;
}


/**
 *
 */

int ifoGetProgramMap (char *pgc, char **ptr)
{
	int num;
	*ptr = pgc;

	if (!pgc)
		return -1;

	*ptr += 2;	
	num = **ptr;

	*ptr += 10;
	*ptr += 8 * 2;			// AUDIO
	*ptr += 32 * 4;			// SUBPICTURE
	*ptr += 8;
	*ptr += 16 * PGCI_COLOR_LEN;	// CLUT
	*ptr += 2;

	*ptr = get2bytes (*ptr) + pgc;

	return num;
}


/**
 *
 */

int ifoGetCellPlayInfo (char *pgc, char **ptr)
{
	int num;
	*ptr = pgc;

	if (!pgc)
		return -1;

	*ptr += 3;	
	num = **ptr;

	*ptr += 9;
	*ptr += 8 * 2;			// AUDIO
	*ptr += 32 * 4;			// SUBPICTURE
	*ptr += 8;
	*ptr += 16 * PGCI_COLOR_LEN;	// CLUT
	*ptr += 4;

	*ptr =  get2bytes (*ptr) + pgc;

	return num;
}


/**
 *
 */

int ifoGetCellPos (char *pgc, char **ptr)
{
	int num;
	*ptr = pgc;

	if (!pgc)
		return -1;

	*ptr += 3;	
	num = **ptr;

	*ptr += 9;
	*ptr += 8 * 2;			// AUDIO
	*ptr += 32 * 4;			// SUBPICTURE
	*ptr += 8;
	*ptr += 16 * PGCI_COLOR_LEN;	// CLUT
	*ptr += 6;

	*ptr = get2bytes (*ptr) + pgc;

	return num;
}


/**
 *
 */

void ifo_print_pgc (u_char *pgc_ptr)
{
	int i;
	u_int num;
	char *ptr = pgc_ptr;

	if (!ptr)
		return;

	printf ("\n\tPROGRAM CHAIN\n");
	printf ("\t---\n");

/*****/
	printf ("foo1: %x %x\n", *ptr++, *ptr++);
	printf ("num_programs: %x  num_cells: %x\n", *ptr++, *ptr++); 

/*****/
	printf ("\n\t\tchain time: %02x:%02x:%02x:%02x\n",
		ptr[0],
		ptr[1],
		ptr[2],
//		ptr[3] & 0x1F);
		ptr[3] & 0x7F);

//	printf ("VideoMode: %s\n", decode_videomode (ptr[3] >> 8));
	printf ("%sframes/s\n", ptr[3]&0x80 ? "30" : "25 non-drop");

	ptr += 4;

/*****/
//UNKNOWN
	printf ("foo2: %x %x\n", *ptr++, *ptr++);
	printf ("foo3: %x %x\n", *ptr++, *ptr++);

/*****/
	printf ("\n\t\tAUDIO\n");
	for (i=0; i<8; i++) {		// 8 subaudio streams
		if (*ptr & 0x80) {	// avail
			printf ("\t\t\t0x%02x->0x%02x unknown:0x%02x\n",
				i,
				*ptr&0x7f,
				*(ptr+1));
		}

		ptr+=2;
	}
	
/*****/
	printf ("\n\t\tSUBPICTURE\n");
	for (i=0; i<32; i++) {
		if (*ptr & 0x80) {	// avail
			printf ("\t\t\t0x%02x 4:3 0x%02x wide 0x%02x letter 0x%02x pan 0x%02x\n",
				i,
				*ptr&0x7f,
				*(ptr+1),
				*(ptr+2),
				*(ptr+3));
		}

		ptr+=4;
	}

/*****/
//UNKNOWN
	for (i=0; i<8; i++) {
		if (!(i%16))
			printf ("\n\t0x%04x: ", i);

		printf ("%02x  ", *ptr++);
	}

/*****/
	if (ifoGetCLUT (pgc_ptr, &ptr) >= 0)
		ifoPrintCLUT (ptr);

	ifo_print_pgc_cmd (pgc_ptr);

	if ((num = ifoGetProgramMap (pgc_ptr, &ptr)))
		ifoPrintProgramMap (ptr, num);

	if ((num = ifoGetCellPlayInfo (pgc_ptr, &ptr)))
		ifoPrintCellInfo (ptr, num);

	if ((num = ifoGetCellPos (pgc_ptr, &ptr)))
		ifoPrintCellPos (ptr, num);

/*****/

}	


/**
 *
 */

void ifoPrintCellPos (u_char *ptr, u_int num)
{ int i;


	printf ("\n\tCELL POSITION (num: %d)\n", num);
	for (i=0; i<num; i++) {
		printf ("\t\tVOB ID: %02x ", get2bytes (ptr));
		ptr += 2;
		printf ("Cell ID: %02x\n", get2bytes (ptr));
		ptr += 2;
	}
}


void _print_pgc (u_int cmd)
{
	switch (cmd >> 8) {
		case 0x00:
			printf ("NoP ");
			break;
		case 0x20:
			printf ("Lnk ");
			break;
		case 0x30:
			printf ("Jmp ");
			break;
	}

	switch (cmd&0xff) {
		case 0x01:
			printf ("SIns/Exit ");
			break;
		case 0x02:
			printf ("VTS nn ");
			break;
		case 0x03:
			printf ("VTS Title nn ");
			break;
		case 0x04:
			printf ("PGC ");
			break;
		case 0x05:
			printf ("PTT ");
			break;
		case 0x06:
			printf ("Program nn This PGC ");
			break;
		case 0x07:
			printf ("Cell nn This PGC ");
			break;
	}
}

/**
 *
 */

void ifo_print_pgc_cmd (u_char *pgc_ptr)
{
	int i;
	u_int num_pre_cmd;
	u_int num_post_cmd;
	u_int num_cell_cmd;
	u_int len_cmd_tbl;
	u_char *ptr;

	if ((ptr = get2bytes (pgc_ptr + OFFSET_START_TBL_CMD) + pgc_ptr) == pgc_ptr) 
		return;

	num_pre_cmd	 = get2bytes (ptr);
	ptr+=2;
	num_post_cmd	 = get2bytes (ptr);
	ptr+=2;

/*****/
//cell commands
	num_cell_cmd = get2bytes (ptr);
	ptr+=2;
	len_cmd_tbl = get2bytes (ptr);
	ptr+=2;

	printf ("\n\t\tcell commands: (num: 0x%02x)", num_cell_cmd);

/*****/
//pre commands
	printf ("\n\t\tpre commands: (num: 0x%02x)", num_pre_cmd);
	for (i=0; i<num_pre_cmd*8; i++) {
		if (!(i%6)) {
			printf ("\n\t\t\t0x%04x: ", i/8);
			_print_pgc (*ptr<<8 | *(ptr+1));
			ptr += 2;
		}

		printf ("%02x ", *ptr++);
	}

/*****/
//post commands
	printf ("\n\n\t\tpost commands: (num: 0x%02x)", num_post_cmd);
	for (i=0; i<num_post_cmd*8; i++) {
		if (!(i%6)) {
			printf ("\n\t\t\t0x%04x: ", i/8);
			_print_pgc (*ptr<<8 | *(ptr+1));
			ptr += 2;
		}

		printf ("%02x ", *ptr++);
	}
}


/**
 *
 */

void ifoPrintCellInfo (u_char *ptr, u_int num_cell_play_info)
{
	int i;

	printf ("\n\tCELL PLAY INFO (num: %d)\n", num_cell_play_info);
	for (i=0; i<num_cell_play_info; i++) {
		ifo_pgci_cell_addr_t *cell_addr = (ifo_pgci_cell_addr_t *) ptr;
		printf ("\t\tstill_time: %02xs\t cell_cmd: 0x%x\tlen: %02x:%02x:%02x:%02x\t1st_vobu_start: 0x%x\n",
			(ntohl (cell_addr->foo) >> 8) & 0xFF,
			(ntohl (cell_addr->foo)) & 0xFF,
			(ntohl (cell_addr->len_time) >> 24) & 0xFF,
			(ntohl (cell_addr->len_time) >> 16) & 0xFF,
			(ntohl (cell_addr->len_time) >> 8) & 0xFF,
			ntohl (cell_addr->len_time) & 0x7F,
			ntohl (cell_addr->vobu_start));
		printf ("%sframes/s\n", ntohl (cell_addr->len_time) & 0x80 ? "30" : "25 non-drop");
		printf ("\t\t1st_ilvu_end: 0x%x\tlast_vobu_start: 0x%x\t\tlast_vobu_end  : 0x%x\n",
			ntohl (cell_addr->ilvu_end),
			ntohl (cell_addr->vobu_last_start),
			ntohl (cell_addr->vobu_last_end));
		ptr += PGCI_CELL_ADDR_LEN;
	}
}		


/**
 *
 */

void ifoPrintCLUT (u_char *clut)
{
	pgci_color_t *pgci_color = (pgci_color_t *) clut;
	int num = 16;

	printf ("\n\t\tCLUT:\n");

	while (num--) {
		printf ("\t\t\t0xY:0x%x Cr:0x%x Cb:0x%x\n",
			pgci_color->y,
			pgci_color->cr,
			pgci_color->cb);

		pgci_color++;
	}
}


/**
 *
 */

void ifoPrintProgramMap (u_char *ptr, u_int num)
{
	int i;

	printf ("\n\n\t\tcell links: (num: %d)\n", num);
	for (i=0; i<num; i++) {
		printf ("\t\t\t0x%02x -> 0x%02x\n",
			i, *ptr);
		ptr++;
	}
}


