
/*
 * VIDEO TITLE SET MANAGEMENT INFORMATION
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 * $log$
 */


#include <sys/types.h>
#include <stdlib.h>

#include "misc.h"
#include "ifo.h"
#include "ifo_tat.h"

/**
 * 
 */

tat_t *ifo_get_tat_vmg (u_char *buf)
{
	tat_t *tat;
	int i;

	if (!(tat = (tat_t *) malloc (sizeof (tat_t))))
		return NULL;

	tat->num_menu_vobs		= 0; //get4bytes (buf + 0xC0);
	tat->num_title_vobs		= 0; //get4bytes (buf + 0xC4);
	tat->start_ptt			= get4bytes (buf + 0xc4); // change
	tat->start_title_pgci		= 0; //get4bytes (buf + 0xC4);
	tat->start_menu_pgci		= get4bytes (buf + 0xC8);
	tat->start_tmt			= get4bytes (buf + 0xD0); // change
	tat->start_menu_cell_addr	= get4bytes (buf + 0xD8);
	tat->start_menu_vobu_addr_map	= get4bytes (buf + 0xDC);
	tat->start_title_cell_addr	= 0; //get4bytes (buf + 0xE0);
	tat->start_title_vobu_addr_map	= 0; //get4bytes (buf + 0xE4);

for (i=0xC0; i<=0xE4; i+=4)
	printf ("%02x %02x\n", i, get4bytes (buf + i)*0x800);

	ifo_print_tat (tat);

	return tat;
}	


/**
 * 
 */

tat_t *ifo_get_tat_vts (u_char *buf)
{
	tat_t *tat;
	int i;

	if (!(tat = (tat_t *) malloc (sizeof (tat_t))))
		return NULL;

	tat->num_menu_vobs		= get4bytes (buf + 0xC0);
	tat->num_title_vobs		= get4bytes (buf + 0xC4);
	tat->start_ptt			= get4bytes (buf + 0xC8);
	tat->start_title_pgci		= get4bytes (buf + 0xCC);
	tat->start_menu_pgci		= get4bytes (buf + 0xD0);
	tat->start_tmt			= get4bytes (buf + 0xD4);
	tat->start_menu_cell_addr	= get4bytes (buf + 0xD8);
	tat->start_menu_vobu_addr_map	= get4bytes (buf + 0xDC);
	tat->start_title_cell_addr	= get4bytes (buf + 0xE0);
	tat->start_title_vobu_addr_map	= get4bytes (buf + 0xE4);

	ifo_print_tat (tat);

	return tat;
}	


/**
 *
 */

void ifo_print_tat (tat_t *tat)
{
        printf ("\nTAT\n");
        printf ("---\n");

        printf ("num_menu_vobs:\t\t0x%x\n",	tat->num_menu_vobs*DVD_BLOCKSIZE);
        printf ("num_title_vobs:\t\t0x%x\n",	tat->num_title_vobs*DVD_BLOCKSIZE);
        printf ("start_ptt:\t\t0x%x\n",	tat->start_ptt*DVD_BLOCKSIZE);
        printf ("start_title_pgci:\t\t0x%x\n",	tat->start_title_pgci*DVD_BLOCKSIZE);
        printf ("start_menu_pgci:\t\t0x%x\n",	tat->start_menu_pgci*DVD_BLOCKSIZE);
        printf ("start_tmt:\t\t0x%x\n",		tat->start_tmt*DVD_BLOCKSIZE);
        printf ("start_menu_cell_addr:\t\t0x%x\n",	tat->start_menu_cell_addr*DVD_BLOCKSIZE);
        printf ("start_menu_vobu_addr_map:\t0x%x\n",	tat->start_menu_vobu_addr_map*DVD_BLOCKSIZE);
        printf ("start_title_cell_addr:\t\t0x%x\n",	tat->start_title_cell_addr*DVD_BLOCKSIZE);
        printf ("start_title_vobu_addr_map:\t0x%x\n",	tat->start_title_vobu_addr_map*DVD_BLOCKSIZE);
}
