
/*
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>

#include "ifo.h"
#include "misc.h"

char version[] = "V0.1.1";

/**
 *
 */

int main (int argc, char **argv)
{
	ifo_t *ifo;
	int fd;

	printf ("free InFormatiOn project %s\n", version);
	printf ("--------------------------------\n");
	printf ("(c) 1999 by Thomas Mirlacher\n\n");

	if ((fd = open (argv[1], O_RDONLY)) < 0) {
		fprintf (stderr, "error opening file %s.\n", argv[1]);
		exit (-1);
	}

	if (!(ifo = ifoOpen (fd, 0))) {
		fprintf (stderr, "error initializing ifo.\n");
		exit (-1);
	}

	ifoPrintVideo (ifo->data[ID_MAT] + IFO_OFFSET_VIDEO);

	if (!ifoIsVTS (ifo)) {
		ifoPrintAudio (ifoGetAudio (ifo->data[ID_MAT] + IFO_OFFSET_AUDIO));
		ifoPrintSPU (ifoGetSPU (ifo->data[ID_MAT] + IFO_OFFSET_SUBPIC));

		ifo_print_tmt (ifo);
		ifo_print_ptt (ifo_get_ptt (ifo));
	}

	if (!ifoIsVMG (ifo)) {
		ifo_print_toast (ifo->data[ID_PTT]);
//		ifo_print_audiosub (ifo->start_tmt);

//		ifo_print_ptt (ifo_get_ptt (ifo));
	}

	ifo_print_title_pgci (ifo);

	ifo_print_menu_pgci (ifo);
	ifo_print_vtsm_cell_addr (ifo);
	ifo_print_vtsm_vobu_addr_map (ifo);

	ifo_print_vts_cell_addr (ifo);
	ifo_print_vts_vobu_addr_map (ifo);

	ifoClose (ifo);

	return 0;
}
