/* 
 *    display.c
 *
 *	Copyright (C) Aaron Holtzman - Aug 1999
 *
 *  This file is part of mpeg2dec, a free MPEG-2 video stream decoder.
 *	
 *  mpeg2dec is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  mpeg2dec is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>
//#include "drivers/mga_vid.h"


#include "old_config.h"
#include "global.h"

typedef struct mga_vid_config_s
{
	uint_32 width;	
	uint_32 height;	
	uint_32 x_org;	
	uint_32 y_org;	
} mga_vid_config_t;

#define MGA_VID_CONFIG _IOR('J', 1, mga_vid_config_t)
#define MGA_VID_ON     _IO ('J', 2)
#define MGA_VID_OFF    _IO ('J', 3)

mga_vid_config_t config;
char* vid_data;

void do_display(unsigned char *src[])
{
	int i,j;
	uint_32 *dest;
	uint_32 *source;

	
	dest = vid_data;
	source = src[0];

	for(j=0;j < Coded_Picture_Height; j++)
	{
		for(i=0;i< Coded_Picture_Width/4; i++)
			*dest++ = *source++;

		dest +=16/4;
	}

	source = src[1];
	for(j=0;j < Coded_Picture_Height/2 ; j++)
	{
		for(i=0;i< Coded_Picture_Width/(2*4) ; i++)
			*dest++ = *source++;

		dest +=8/4;
	}

	source = src[2];
	for(j=0;j < Coded_Picture_Height/2 ; j++)
	{
		for(i=0;i< Coded_Picture_Width/(2*4) ; i++)
			*dest++ = *source++;

		dest +=8/4;
	}
}

void Display_Second_Field()
{
}

void Terminate_Display_Process()
{
}

void Initialize_Display_Process(char *name)
{
	int f;
	int i;


	f = open("/dev/mga_vid",O_RDWR);

	if(!f)
	{
		fprintf(stderr,"Couldn't open driver\n");
		exit(1);
	}

	config.width = Coded_Picture_Width;
	config.height= Coded_Picture_Height;
	config.x_org= 10;
	config.y_org= 10;

	if (ioctl(f,MGA_VID_CONFIG,&config))
	{
		perror("Error in config ioctl");
	}
	
	//ioctl(f,MGA_VID_ON,0);
	vid_data = (char*)mmap(0,204 * 4096,PROT_WRITE,MAP_SHARED,f,0);

	printf("vid_data = 0x%08x\n",vid_data);
}
