
/* very simple app to set the tv frequency */

#include <sys/time.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <linux/fs.h>
#include <linux/videodev2.h>

int main(int argc,char **argv) {
  int vfd = 0;
  int arg = 0;
  char *devname = "/dev/video";

  if( argc != 1 ) {
        puts("Usage: preview_off\n");
        exit(1);
  }

  vfd = open(devname,O_RDWR|O_NONCAP);
  if (vfd <= 0) {
    fprintf(stderr,"sorry, no such device %s\n",devname);
    exit(1);
  }

  if (ioctl(vfd,VIDIOC_PREVIEW,&arg) < 0)
    perror("setting frequency"),exit(1);
  close(vfd);
  return 0;
}
