/*	Capture a frame of video from a V4L2 driver and send it
 *	to stdout. Use vctrl to set image width, height, depth.
 *
 *	This program was written by Bill Dirks.
 *	This program is in the public domain.
 *
 *	gcc -o xcaptest -L/usr/X11R6/lib/ -lXt -lXaw -Wall xcaptest.c
 *
 *	./vcat [-rgb | -bgr] [device-node]
 */


#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/mman.h>
#include <errno.h>

/* These are needed to use the Videum driver */
#include <linux/fs.h>
#include <linux/kernel.h>
#include <linux/videodev2.h>  /* Video for Linux Two */

int
main(int argc, char *argv[])
{
	char			*device	= NULL;
	int			vid;
	int			err;
	int			i;
	int			n;
	struct v4l2_capability	cap;
        struct v4l2_format	fmt;
	int			bgr	= 0;
	int			rgb	= 0;
	int			rgbswap	= 0;
	char			*data;
	char			t;


	for (i = 1; i < argc; ++i)
	{
		if (strcmp(argv[i], "-rgb") == 0)
			rgb = 1;
		else if (strcmp(argv[i], "-bgr") == 0)
			bgr = 1;
		else if (argv[i][0] == '-')
			continue;
		else
			device = argv[i];
	}
	if (device == NULL)
		device = "/dev/video";


	vid = open(device, O_RDONLY);
	if (vid < 0)
	{
		fprintf(stderr, "Can't open %s\n", device);
		return 1;
	}

	err = ioctl(vid, VIDIOC_QUERYCAP, &cap);
	if (err)
	{
		fprintf(stderr, "QUERYCAP returned error %d\n", errno);
		return 1;
	}
	if (cap.type != V4L2_TYPE_CAPTURE)
	{
		fprintf(stderr, "Device %s is not a video capture device.\n",
			device);
		return 1;
	}
	if (!(cap.flags & V4L2_FLAG_READ))
	{
		fprintf(stderr, "Device %s doesn't support read().\n", device);
		return 1;
	}


	err = ioctl(vid, VIDIOC_G_FMT, &fmt);
	if (err)
	{
		fprintf(stderr, "G_FMT returned error %d\n", errno);
		return 1;
	}

	if ((fmt.pixelformat == V4L2_PIX_FMT_RGB24 && bgr) ||
	    (fmt.pixelformat == V4L2_PIX_FMT_BGR24 && rgb))
		rgbswap = 1;


	data = malloc(fmt.sizeimage);
	if (data == NULL)
	{
		fprintf(stderr, "malloc(%d) failed\n", fmt.sizeimage);
		return 1;
	}

	n = read(vid, data, fmt.sizeimage);
	if (n < 0)
	{
		fprintf(stderr, "read() returned error %d\n", errno);
		return 1;
	}

	if (rgbswap)
		for (i = 0; i < n; i += 3)
		{
			t = data[i];
			data[i] = data[i + 2];
			data[i + 2] = t;
		}

	if (n)
		fwrite(data, (size_t)n, 1, stdout);

	return 0;
}
