/*	X Window Backend Scale Tool
 *      Version 0.2
 *
 *	This program is based on parts from
 *      xcaptest which was written by Bill Dirks
 *      and modified by Ryan Drake.
 *      Some modifications to the driver of Ryan Drake
 *      are necessary. (fixes include in 0.0.7-mb2)
 *      Code mostly rewriten by Alexader Werth
 *      to support Backend Scaler.
 *	This program is in the public domain.
 *
 *	gcc -o xbs -Wall xbs.c
 *
 */

/*  This program does not properly detect when the X Windows desktop is
 *  32 bits per pixel. (Some X functions use a value of 24 for the depth
 *  when it is really 32 for reasons I don't understand.) As a workaround,
 *  if you are running a 32-bpp X Windows screen, use -b on the command
 *  line, or uncomment this line:  */
/*#define X_DEPTH  32*/
#define SCREEN_X      1152
#define SCREEN_Y      864


/*  Set these according to your capture device set-up */
#define DEFAULT_STD	  "PAL"		/*-> "PAL" or "NTSC" */
#define DEFAULT_WIDTH  356
#define DEFAULT_HEIGHT 288
#define DEFAULT_X      0
#define DEFAULT_Y      0
#define DEFAULT_INPUT  1
#define DEFAULT_CROMA  268

#define MY_WIDTH  488
#define MY_HEIGHT 366
#define MY_X      SCREEN_X-MY_WIDTH
#define MY_Y      SCREEN_Y-MY_HEIGHT
#define MY_CROMA  268

/*  MY_PIXELFORMAT should match your X Window screen mode  */
/*  If MY_PIXELFORMAT is not defined, capturing will be set to the
    screen format automatically (I hope)  */
//#define MY_PIXELFORMAT V4L2_PIX_FMT_BGR32
/* V4L2_PIX_FMT_YUYV */
/* V4L2_PIX_FMT_GREY */
/* V4L2_PIX_FMT_YUV420 */
/* V4L2_PIX_FMT_RGB555 */
/* V4L2_PIX_FMT_RGB565 */
/* V4L2_PIX_FMT_BGR24 */
/* V4L2_PIX_FMT_BGR32 */

/*  Uncomment the following to test stuff  */
#define TEST_INPUTS      /* enumerate the inputs */
#define TEST_FORMATS     /* enumerate the image formats */
#define TEST_CONTROLS    /* enumerate the controls */
#define TEST_CAPTURE     /* test video capture */

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/mman.h>
#include <errno.h>
#define max(a,b) ((a) > (b) ? (a) : (b))

/* These are needed to use the Videum driver */
#include <linux/fs.h>
#include <linux/kernel.h>
#include <linux/videodev2.h>  /* Video for Linux Two */

int		x_depth;

#define VIDIN_ID 1010

void printctrl(struct v4l2_queryctrl *qc)
{	
	printf("  %-12s %-6s %8d %8d %7d %8d  %s\n",
	       qc->name,
	       (qc->type == V4L2_CTRL_TYPE_MENU) ? "(menu)" : 
	       (qc->type == V4L2_CTRL_TYPE_BOOLEAN) ? "(bool)" :
	       "(int)",
	       qc->minimum, qc->maximum, qc->step, qc->default_value,
	       qc->catname);
}

int CallBS(int x, int y, int w, int h, int croma, int source, int enableBS, char* device, 
           int argc, char** argv,int laber, int debug){
  struct   v4l2_capability      cap;
  struct   v4l2_captureparm     parm;
  struct   v4l2_standard        std;
  struct   v4l2_window          bswin;
  struct   v4l2_queryctrl       qc;
  struct   v4l2_control         vc;
  int      err;
  int      i;
  int      vid;
  int      input;

  // ---> Put in the device node name <---
  vid = open(device, O_RDONLY);
  if (vid < 0)
  {
    printf("No video device \"%s\"\n", device);
    return -1;
  }

  err = ioctl(vid, VIDIOC_QUERYCAP, &cap);
  if (err)
  {
    printf("QUERYCAP returned error %d\n", errno);
    return -1;
  }
  if (laber) printf("Device node:  %s\n", device);
  if (laber) printf("Device:       %s\n", cap.name);
  if (debug) printf("Croma:        %d\n", croma);
  if (debug) printf("Input:        %d\n", source);
  if (laber) printf("Capabilities:");
  if (laber) if (cap.flags & V4L2_FLAG_READ)       printf(" capture via read();");
  if (laber) if (cap.flags & V4L2_FLAG_STREAMING)  printf(" streaming capture;");
  if (laber) if (cap.flags & V4L2_FLAG_PREVIEW)    printf(" automatic preview;");
  if (laber) if (cap.flags & V4L2_FLAG_SELECT)     printf(" select() call;");
  if (laber) if (cap.flags & V4L2_FLAG_TUNER)      printf(" tuner;");
  if (laber) if (cap.flags & V4L2_FLAG_MONOCHROME) printf(" monochrome only;");
  if (laber) printf("\n");
  if (cap.type != V4L2_TYPE_CAPTURE)
  {
    printf("Not a capture device.\n");
    return 1;
  }

  if(laber) {
    printf("Video inputs on this device:\n");
    for (i = 0, err = 0; err == 0; ++i)
    {	
      struct v4l2_input inp;
      inp.index = i;
      err = ioctl(vid, VIDIOC_ENUMINPUT, &inp);
      if (!err) 
        printf("  %d: \"%s\" is a%s, %s audio\n", i,
                  inp.name,
                  (inp.type == V4L2_INPUT_TYPE_TUNER) ?
                  " TV tuner" : "n analog input",
                  (inp.capability & V4L2_INPUT_CAP_AUDIO) ? 
                  "has" : "no"
               );
    }
  }
  input = source;
  err = ioctl(vid, VIDIOC_S_INPUT, input);
  if (err)
    printf("S_INPUT returned error %d\n",errno);
  if (laber) {
    printf("Video standards supported:");
    for (i = 0, err = 0; err == 0; ++i) {
      struct v4l2_enumstd	estd;
      estd.index = i;
      err = ioctl(vid, VIDIOC_ENUMSTD, &estd);
      if (!err)	{
        printf("%c %s", i?',':' ', estd.std.name);
#ifdef DEFAULT_STD
        if (strcmp(DEFAULT_STD, estd.std.name) == 0)
        std = estd.std;
#endif
      }
    }
    printf("\n");
  }
  if (laber) {
    printf("Video capture image formats supported:\n");
    for (i = 0, err = 0; err == 0; ++i)
    {
      struct v4l2_fmtdesc fmtd;
      fmtd.index = i;
      err = ioctl(vid, VIDIOC_ENUM_CAPFMT, &fmtd);
      if (!err)
      printf("  %d: %s  (%s)\n", i,
      fmtd.description,
         (fmtd.flags & V4L2_FMT_FLAG_COMPRESSED) ?
         "compressed" : "uncompressed");
    }
  }
  if (laber) {
    printf("Controls supported:\n");
    printf("  Label        type    Minimum  Maximum    Step  Default  Category\n");
    qc.id = V4L2_CID_BRIGHTNESS;
    if (ioctl(vid, VIDIOC_QUERYCTRL, &qc) == 0)
      printctrl(&qc);
    qc.id = V4L2_CID_CONTRAST;
    if (ioctl(vid, VIDIOC_QUERYCTRL, &qc) == 0)
      printctrl(&qc);
    qc.id = V4L2_CID_SATURATION;
    if (ioctl(vid, VIDIOC_QUERYCTRL, &qc) == 0)
      printctrl(&qc);
    qc.id = V4L2_CID_HUE;
    if (ioctl(vid, VIDIOC_QUERYCTRL, &qc) == 0)
      printctrl(&qc);
  }

  vc.value = 120;
  vc.id = V4L2_CID_BRIGHTNESS;
  ioctl(vid, VIDIOC_S_CTRL, &vc);

  vc.value = 10;
  vc.id = V4L2_CID_CONTRAST;
  ioctl(vid, VIDIOC_S_CTRL, &vc);

  vc.value = 0;
  vc.id = V4L2_CID_BRIGHTNESS;
  ioctl(vid, VIDIOC_S_CTRL, &vc);

  vc.value = 0;
  vc.id = V4L2_CID_HUE;
  ioctl(vid, VIDIOC_S_CTRL, &vc);

  ioctl(vid, VIDIOC_G_PARM, &parm);
  err = ioctl(vid, VIDIOC_S_PARM, &parm);
  if (err) printf("S_PARM returned error %d\n",err);

  //#ifdef DEFAULT_STD
  //err = ioctl(vid, VIDIOC_S_STD, &std);
  //if (err) printf("S_STD returned error %d\n",errno);
  //#endif

  //ioctl(vid, VIDIOC_G_FMT, &fmt);


  bswin.x = x;
  bswin.y = y;
  bswin.width = w;
  bswin.height = h;
  bswin.chromakey = croma;
  bswin.clips = NULL;
  bswin.clipcount = 0;
  err = ioctl(vid, VIDIOC_S_WIN, &bswin);
  if (debug) printf("err = ioctl(vid, VIDIOC_S_WIN, &bswin); %d\n",err);

  err = ioctl(vid, VIDIOC_PREVIEW ,&enableBS);
  if (debug) printf("err = ioctl(vid, VIDIOC_PREVIEW ,0); %d\n",err);


  return 0;
}

int CloseBSWin( int laber, int debug){
  return 0;
}

void PrintUsage(char* programname);

void PrintHelp();

int strtodec(char* s,long* val);

int main( int argc, char** argv )
{
  int enableBS=1;
  int x=DEFAULT_X;
  int y=DEFAULT_Y;
  int w=DEFAULT_WIDTH;
  int h=DEFAULT_HEIGHT;
  int croma=DEFAULT_CROMA;
  int source=DEFAULT_INPUT;
  char* device="/dev/video0";
  int err=0;
  int arguments=0;           // zum Parsen der Kommandozeile
  int option;                // zum Parsen der Kommandozeile
  int fehlerflag=0;          // Fehler in der Komandozeile
  char *av0;                 // enthlt den Namen des aufgerufenen Programms
  int laber=0;               // Ausgabelevel
  int debug=0;               // Debuglevel

  av0 = (char*) strrchr(argv[0], '/');                                         // Namen des aufgerufenen Programms holen 
  if (av0 == NULL) av0 = argv[0];
  else av0++;
  while ((option = getopt(argc, argv, "vhdp::s::k:i:brfouc")) != -1)           // Programmoptionen parsen
    {
    switch (option)
      {
      case 'p':
        strtodec(argv[optind],(long*)&x);
        strtodec(argv[optind+1],(long*)&y);
        arguments+=2;
        break;
      case 's':
        strtodec(argv[optind],(long*)&w);
        strtodec(argv[optind+1],(long*)&h);
        arguments+=2;
        break;
      case 'k':
        if (!strcmp(argv[optind-1],"lb")) {
          croma= 268;
        } else if (!strcmp(argv[optind-1],"p")) {
          croma= 2031647;
        } else strtodec(argv[optind-1],(long*)&croma);
        arguments+=1;
        break;
      case 'i':
        if (!strcasecmp(argv[optind-1],"Composite")) {
          source= 0;
        } else if (!strcasecmp(argv[optind-1],"SVHS")) {
          source= 1;
        } else if (!strcasecmp(argv[optind-1],"Tuner")) {
          source= 2;
        } else strtodec(argv[optind-1],(long*)&source);
        arguments+=1;
        break;
      case 'b':
        x_depth = 32;
        break;
      case 'r':
        x=SCREEN_X-w;
        y=SCREEN_Y-h;
        break;
      case 'f':
        x=0;
        y=0;
        w=SCREEN_X;
        h=SCREEN_Y;
        break;
      case 'o':
        croma=-1;
        break;
      case 'u':
        x=MY_X;
        y=MY_Y;
        w=MY_WIDTH;
        h=MY_HEIGHT;
        croma=MY_CROMA;
        break;
      case 'c':
        enableBS = 0;
        break;
      case 'v':
        laber += 1;
        break;
      case 'h':
        PrintUsage(av0);
        PrintHelp();
        exit(1);
        break;
      case 'd':
        debug += 1;
        break;
      case '?':
        fehlerflag = 1;
      };
      if (debug) printf("option: %c  optind: %d\n",option,optind);
    };
  if (fehlerflag) {
    PrintUsage(av0);
    exit(1);
    };
  if (debug) printf("optind: %d  argc: %d  arguments: %d\n",optind,argc,arguments);
  if (optind+arguments<argc) {  
    if (debug) printf("last argument: %s\n",argv[argc-1]);
    device=argv[argc-1];
  }
  if (debug) printf("debug     : %d\n",debug);
  if (debug) printf("verbose   : %d\n",laber);
  if (laber) printf("pos  x y  : %d %d\n",x,y);
  if (laber) printf("size w h  : %d %d\n",w,h);
  err = CallBS(x,y,w,h,croma,source,enableBS,device,argc,argv,laber,debug);                                                      
  if (err) { fprintf( stderr, "OpenBSWin returns %d\n", err ); }                         
  return 0;
}

int NumberCharacter(char c) {
  if ( (c>='0') & (c<='9') ) return -1;
  return 0;
}

int strtodec(char* s,long* val) { 
  int i=0;                                                                                         // interpret string as value
  long l=0;
  while(s[i]!=0) {
    if (!NumberCharacter(s[i]) ) return -1;
    l= l*10+(s[i]-'0');
    i++;
  }
  *val= l;
  return 0;
};


void PrintUsage(char* programname)
{
  fprintf(stderr,"usage: %s [-hvdbcufor] [-k color] [-i input] [-p xpos ypos] [-s width height] [device]\n", programname);       // usage
}

void PrintHelp()
{
  fprintf(stderr,"This program fires up the backend scaler of the Marvel G200.\n");                // help message
  fprintf(stderr,"-h : displays this help message\n");                                             
  fprintf(stderr,"-v : adds some infos\n");
  fprintf(stderr,"-d : debug infos\n");
  //fprintf(stderr,"-t : type of video format NTSC|PAL|SECAM.(not yet supported)\n");
  fprintf(stderr,"-i : Video input (0:Composite | 1:SVHS | 2:Tuner)\n");
  fprintf(stderr,"-b : for 32bit color X-Servers.\n");
  fprintf(stderr,"-c : close backend scaler.\n");
  fprintf(stderr,"-k : croma key format rgb 24bit (default is overlay).\n");
  fprintf(stderr,"-u : user prefered mode.\n");
  fprintf(stderr,"-p : pos xpos ypos. The position of the top left corner of the window.\n");
  fprintf(stderr,"-s : size width height. The width and height of the window.\n");
  fprintf(stderr,"-f : full screen.\n");
  fprintf(stderr,"-o : overlay mode.\n");
  fprintf(stderr,"-r : set window in bottom right corner of the screen.\n");
}
