/* -*- linux-c -*- --------------------------------------------------------- *  
 * This is file is part of the ZORAN zr367x0 driver
 *
 * Copyright (C) 1999 David Barth <dbarth@besancon.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef _I34_H
#define _I34_H

#include "mgavideo.h"

#define I34_NTSC	01
#define I34_NTSC_ALT	02
#define I34_PAL		03
#define I34_PAL_ALT	04

#define I34_CMD_START	0x0000
#define I34_CMD_PAUSE	0x0100
#define I34_CMD_STEP	0x0300
#define I34_CMD_SLOW	0x0500
#define I34_CMD_END    	0x0700
#define I34_CMD_FAST	0x0800
#define I34_CMD_CONT	0x0900
#define I34_CMD_ENDC	0x0E00

struct VideoStandard {
  __u16 VidFPS;
  __u16 unknown0;
  __u16 FieldSel;
  __u16 unknown1;
  __u16 HTotal;
  __u16 VTotal;
  __u16 HSyncSize;
  __u16 VSyncSize;
  __u16 ActiveStartX;
  __u16 ActiveStartY;
  __u16 ActiveEndX;
  __u16 ActiveEndY;
  __u16 ActiveSizeX;
  __u16 ActiveSizeY;
  __u16 VidConfig;
};

struct CompositeBlankSync {
  __u16 CBHStart;
  __u16 CBVStart;
  __u16 CBHEnd;
  __u16 CBVEnd;
};

struct ColorKey {
  int y;
  int u;
  int v;
};

#define I34_UCODE_CHUNK_MAX_SIZE	200

struct i34_ucode_chunk
{
  __u8 length;
  __u8 buffer[I34_UCODE_CHUNK_MAX_SIZE];
};

/* the IOCTL number depends on videodev2.h, but I get parse error when including it
   from inside this header...
*/
#define I34_IOCSUCODE		_IOW  ('V',  BASE_VIDIOC_PRIVATE,     struct i34_ucode_chunk)
#define I34_IOCSVIDEOSTD	_IOW  ('V',  BASE_VIDIOC_PRIVATE + 1, int)
#define I34_IOCSVDSTDCST	_IOW  ('V',  BASE_VIDIOC_PRIVATE + 2, struct VideoStandard)
#define I34_IOCSCOLORKEY	_IOW  ('V',  BASE_VIDIOC_PRIVATE + 3, struct ColorKey)
#define I34_IOCSCBSYNC		_IOW  ('V',  BASE_VIDIOC_PRIVATE + 4, struct CompositeBlankSync)
#define I34_IOCGSTATE		_IOR  ('V',  BASE_VIDIOC_PRIVATE + 5, int)
#define I34_IOCTSTRTDSPL	_IO   ('V',  BASE_VIDIOC_PRIVATE + 6)
#define I34_IOCTCMD		_IO   ('V',  BASE_VIDIOC_PRIVATE + 7)
#define I34_IOCTINIT		_IO   ('V',  BASE_VIDIOC_PRIVATE + 8)

#ifdef __KERNEL__
int I34_Reset(struct mga_dev *mga);
int I34_Detect(struct mga_dev *mga);
int I34_Init(struct mga_dev *mga);
int I34_ColorKey(struct mga_dev* mga, struct ColorKey *ck);
int I34_OutputVideoStandard(struct mga_dev *mga, int standard);
int I34_LoadVideoStandard(struct mga_dev *mga, struct VideoStandard *vs);
int I34_CompositeBlankSync(struct mga_dev *mga, struct CompositeBlankSync *cb);
int I34_StartDisplay(struct mga_dev *mga);
int I34_State(struct mga_dev *mga, int *s);
int I34_Command(struct mga_dev *mga, u16 cmd);
int I34_ioctl(struct mga_dev *mga, unsigned int cmd, void *arg);
#endif /* __KERNEL__ */

#endif /* _I34_H */
