#include <iostream>
#include "ditherer.hh"

map<string,Ditherer * (*)()> Ditherer::ditherStore;

int Ditherer::addModule(class Ditherer * (*alloc)(),string name) {
   Ditherer::ditherStore[name]=alloc;
}

Ditherer * Ditherer::allocModule(string name) {
   map<string,Ditherer * (*)()>::iterator store_it;

   if (ditherStore.empty()) {
      Ditherer::loadDefaultModules();
   }
   store_it=ditherStore.find(name);
   if (store_it != ditherStore.end()) {
      return ((store_it->second))();
   } else {
      return 0;
   }
}

string Ditherer::getRegisteredModules() {
   if (ditherStore.empty()) {
      Ditherer::loadDefaultModules();
   }
   
}

void Ditherer::setBpp(int bpp) {
   if (!_bpp) {
      _bpp=bpp;
      if (!_pixelSize) {_pixelSize=bpp/8+((bpp%8 != 0)?1:0);}
   } else {
      if (bpp!=_bpp) {
         cerr<<"Ditherer::setBpp() can't be called if _bpp is already set"
             << endl;
         exit(1);
      }
   }
}

void Ditherer::setPixelSize(int pixelSize) {
   if (_pixelSize == 0 || pixelSize == _pixelSize) {
      _pixelSize=pixelSize;
   } else {
      cerr<<"Ditherer::setPixelSize() can't be called if _pixelSize is already set"
          << endl;
      exit(1);
   }
}

GenericDitherer::GenericDitherer() {
   tempory_Y=(unsigned char*)0;
   tempory_Cr=(unsigned char*)0;
   tempory_Cb=(unsigned char*)0;
}

GenericDitherer::~GenericDitherer() {
   delete tempory_Y;
   delete tempory_Cr;
   delete tempory_Cb;
}

void GenericDitherer::resizeYandDither(unsigned char * tY,
                                       unsigned char * tCr,
                                       unsigned char * tCb,
                                       unsigned char * dithered_img,
                                       int origXsize,int origYsize,
                                       int newYsize,int screenWidth) {
   int nb_skip=origYsize-newYsize+1;
   int skipped;
   int block_height;
   
   for (skipped=0;skipped<nb_skip;++skipped) {
      block_height=(skipped+1)*origYsize/nb_skip-(skipped)*origYsize/nb_skip;
      ditherBlock(tY,tCr,tCb,
                  dithered_img,
                  origXsize,block_height-1,screenWidth);
      tY+=block_height*origXsize;
      tCr+=block_height/2*origXsize/2;
      tCb+=block_height/2*origXsize/2;
      dithered_img+=(block_height-1)*origXsize*_pixelSize;
   }
}

void GenericDitherer::changeSize(unsigned char * orig,unsigned char * dst,
                                 int origXsize,int origYsize,
                                 int newXsize, int newYsize) {
   int k,l=0;
   int ll;
   
   for(l=0;l<newYsize;l++) {
      ll=(l*origYsize/newYsize)*origXsize;
      if (origXsize==newXsize) {
         /* just a vertical aspect ratio change) */
         memcpy(dst,orig+ll,origXsize);
         dst+=origXsize;
      } else {
         for(k=0;k<newXsize;++k) {
            *(dst++)=orig[ll+(k*origXsize/newXsize)];
         }
      }
   }
}

void  GenericDitherer::checking() {
   if (_pixelSize==0) {
      cerr<<"method GenericDitherer::setBpp() or GenericDitherer:setPixelSize() must be called before dithering"
          <<endl;
      exit(1);
   }
}

void GenericDitherer::dither(unsigned char * tY,
                             unsigned char * tCr,
                             unsigned char * tCb,
                             unsigned char * dithered_img,
                             int imgWidth,
                             int imgHeight,
                             int viewWidth,
                             int viewHeight,
                             int screenWidth) {
   checking();

   if (tempory_Y==0) {
      tempory_Y=new unsigned char[viewWidth*viewWidth];
      tempory_Cr=new unsigned char[viewWidth/2*viewWidth/2];
      tempory_Cb=new unsigned char[viewWidth/2*viewWidth/2];
   }
   
   if (imgWidth!=viewWidth
       || imgHeight!= viewHeight) {
      if ((imgWidth==viewWidth)
          && (imgHeight>viewHeight)
          && (viewHeight>(imgHeight/2))) {
         resizeYandDither(tY,tCr,tCb,
                          dithered_img,
                          imgWidth,imgHeight,viewHeight,screenWidth);
      } else {
         /* full resize needed */
         changeSize(tY,tempory_Y,imgWidth,imgHeight,viewWidth,viewHeight);
         changeSize(tCr,tempory_Cr,imgWidth/2,imgHeight/2,viewWidth/2,viewHeight/2);
         changeSize(tCb,tempory_Cb,imgWidth/2,imgHeight/2,viewWidth/2,viewHeight/2);
         ditherBlock(tempory_Y,tempory_Cr,tempory_Cb,
                     dithered_img,
                     viewWidth,viewHeight,screenWidth);
      }
   } else {
      ditherBlock(tY,tCr,tCb,
                  dithered_img,
                  viewWidth,viewHeight,screenWidth);
   }
}






