#ifndef _ditherer_hh_
#define _ditherer_hh_
#include <map>
#include <string>

class Ditherer {
public:
   Ditherer() {_bpp=0;_pixelSize=0;}
   virtual ~Ditherer() {};
   
   virtual void dither(unsigned char * tY,
                       unsigned char * tCr,
                       unsigned char * tCb,
                       unsigned char * dithered_img,
                       int imgWidth,
                       int imgHeight,
                       int viewWidth,
                       int viewHeight,
                       int screenWidth)=0;
   virtual void setBpp(int bpp);
   virtual void setPixelSize(int pixelSize);
   // ditherer modules admin
   static int addModule(class Ditherer * (*alloc)(),string name);
   static Ditherer * allocModule(string name);
   static string getRegisteredModules();
   static void loadDefaultModules();
protected:
   int _bpp;
   int _pixelSize;
private:
   static map<string,Ditherer * (*)()> ditherStore;
};

class GenericDitherer: public Ditherer {
public:
   GenericDitherer();
   virtual ~GenericDitherer();

   virtual void dither(unsigned char * tY,
                       unsigned char * tCr,
                       unsigned char * tCb,
                       unsigned char * dithered_img,
                       int imgWidth,
                       int imgHeight,
                       int viewWidth,
                       int viewHeight,
                       int screenWidth);
protected:
   virtual void  ditherBlock(unsigned char * tY,
                             unsigned char * tCr,
                             unsigned char * tCb,
                             unsigned char * dithered_img,
                             int height,
                             int width,
                             int display_width)=0;
private:
   unsigned char * tempory_Y;
   unsigned char * tempory_Cr;
   unsigned char * tempory_Cb;

   void checking();
   void changeSize(unsigned char * orig,unsigned char * dst,
                   int origXsize,int origYsize,
                   int newXsize, int newYsize);
   void resizeYandDither(unsigned char * tY,
                         unsigned char * tCr,
                         unsigned char * tCb,
                         unsigned char * dithered_img,
                         int origXsize,int origYsize,
                         int newYsize,int screenWidth);
};
#endif



