#include "ditherer_lk16.hh"
#include <iostream>

unsigned short * DitherLK16::lookUpTable16=0;
unsigned short * DitherLK16::lookUpTable15=0;

DitherLK16::DitherLK16() {
   _pixelSize=2;_bpp=0;
   lookUpTable=0;
}

void DitherLK16::setBpp(int bpp) {
   int i,j,k;
   unsigned char *clp; // clip table
   unsigned int r,v,b;
   
   Ditherer::setBpp(bpp);

   if (bpp==16) {
      lookUpTable=lookUpTable16;
   } else if (bpp==15) {
      lookUpTable=lookUpTable15;
   } else {
      cerr<<"only 15 and 16 are valid bpp for DitherLK16.setBpp()"<<endl;
      exit (1);
   }
   
   if (lookUpTable==0) {
      clp=new unsigned char[1024];  // clip table
      clp += 384;
      for (i=-384; i<640; i++) 
         clp[i] = (i<0) ? 0 : ((i>255) ? 255 : i);
      
      lookUpTable=new unsigned short[1<<18];
      if (bpp==16) {
         lookUpTable16=lookUpTable;
      } else if (bpp==15) {
         lookUpTable15=lookUpTable;
      }
      
      for (i=0;i<(1<<6);++i) { /* Y */
         int Y=i<<2;
         for(j=0;j<(1<<6);++j) { /* Cr */
            int Cr=j<<2;
            for(k=0;k<(1<<6);k++) { /* Cb */
               int Cb=k<<2;
               /*
                 R = clp[(int)(*Y + 1.371*(*Cr-128))];  
                 V = clp[(int)(*Y - 0.698*(*Cr-128) - 0.336*(*Cr-128))]; 
                 B = clp[(int)(*Y++ + 1.732*(*Cb-128))];
               */
               r=clp[(Y*1000 + 1371*(Cr-128))/1000] >>3;
               v=clp[(Y*1000 - 698*(Cr-128) - 336*(Cr-128))/1000] >> (bpp==16?2:3);
               b=clp[(Y*1000 + 1732*(Cb-128))/1000] >> 3;
               lookUpTable[i|(j<<6)|(k<<12)] = r | (v << 5) | (b <<  (bpp==16?11:10));
            }
         }
      }
      delete (clp-384);
   }
}

DitherLK16::~DitherLK16() {
}

void DitherLK16::dither(unsigned char * tY,
                        unsigned char * tCr,
                        unsigned char * tCb,
                        unsigned char * imgDst,
                        int imgWidth,
                        int imgHeight,
                        int viewWidth,
                        int viewHeight,
                        int screenWidth) {
   int i,j;
   int shift=screenWidth-viewWidth;
   int realX,realY;
   unsigned short * ditheredImage=(unsigned short *)imgDst;

   unsigned char * tY_l;
   unsigned char * tCr_l;
   unsigned char * tCb_l;

#if 0
   cerr<<"imgWidth="<<imgWidth<<" "
       <<"imgHeight="<<imgHeight<<" "
       <<"viewWidth="<<viewWidth<<" "
       <<"viewHeight="<<viewHeight<<" "
       <<"screenWidth="<<screenWidth
       <<endl;
#endif

   if (_bpp==0) {
      setBpp(16);
   }
   
   for (j=0;j<viewHeight;j++) {
      realY=j*imgHeight/viewHeight;
      //cerr<< "j=" << j << " realY="<<realY<<"     ";
      tY_l=tY+(realY*imgWidth);
      tCr_l=tCr+(realY/2*imgWidth/2);
      tCb_l=tCb+(realY/2*imgWidth/2);
      for (i=0;i<viewWidth;i++) {
         realX=i*imgWidth/viewWidth;
         *ditheredImage++ =             
            lookUpTable[(tY_l[realX]>>2)
                       |((tCr_l[realX/2]>>2)<<6)
                       |((tCb_l[realX/2]>>2)<<12)
               ]
                                        ;
      }
      ditheredImage+=shift;
   }
}
  

 





