#include "ditherer_lkbw.hh"
#include <iostream>

short unsigned int * DitherLK16BW::lookUpTable=0;
DitherLK16BW::DitherLK16BW() {

   _pixelSize=2;_bpp=16;
   int i;
   
   if (lookUpTable==0) {
      lookUpTable=new unsigned short[1<<8];
      
      for (i=0;i<256;++i) {
         lookUpTable[i]=(i>>3)|((i>>2)<<5)|((i>>3)<<11);
         //fprintf(stdout,"%d=%02x ",i, look_up_table[i]);
      }
   }
}

DitherLK16BW::~DitherLK16BW() {
}

void DitherLK16BW::dither(unsigned char * tY,
                        unsigned char * tCr,
                        unsigned char * tCb,
                        unsigned char * imgDst,
                        int imgWidth,
                        int imgHeight,
                        int viewWidth,
                        int viewHeight,
                        int screenWidth) {
   int i,j;
   int shift=screenWidth-viewWidth;
   int realX,realY;
   unsigned short * ditheredImage=(unsigned short *)imgDst;

   unsigned char * tY_l;
   
#if 0
   cerr<<"imgWidth="<<imgWidth<<" "
       <<"imgHeight="<<imgHeight<<" "
       <<"viewWidth="<<viewWidth<<" "
       <<"viewHeight="<<viewHeight<<" "
       <<"screenWidth="<<screenWidth
       <<endl;
#endif
   
   for (j=0;j<viewHeight;j++) {
      realY=j*imgHeight/viewHeight;
      //cerr<< "j=" << j << " realY="<<realY<<"     ";
      tY_l=tY+(realY*imgWidth);
      for (i=0;i<viewWidth;i++) {
         realX=i*imgWidth/viewWidth;
         *ditheredImage++ =             
            lookUpTable[tY_l[realX]];
      }
      ditheredImage+=shift;
   }
}
  

 





