#ifndef _ditherer_mmx16_hh_
#define _ditherer_mmx16_hh_

#if defined(HAVE_MMX)
   
#include "ditherer.hh"

class Dither_MMX16: public GenericDitherer {
public:
   static Ditherer * alloc() {return new Dither_MMX16();}
   Dither_MMX16() { _pixelSize=2;_bpp=16;}
   
   void  ditherBlock(unsigned char *lum, unsigned char *cb, unsigned char *cr,
                     unsigned char *out,
                     int cols, int rows, int screen_width);
};


extern "C" void yuv_2_rgb(void *,void *,void *,int,int,int,int,int,void *,int,int,int,int);

class Dither_MMX16B: public GenericDitherer {
public:
   static Ditherer * alloc() {return new Dither_MMX16B();}
   Dither_MMX16B() { _pixelSize=2;_bpp=0;}
   
   void  ditherBlock(unsigned char *Y, unsigned char *U, unsigned char *V,
                     unsigned char *out,
                     int cols, int rows, int screen_width) {
      if (_bpp==0) {
         setBpp(16);
      }
      yuv_2_rgb(Y,U,V,cols,rows,cols,cols/2,0,out,0,0,screen_width*2,
                (_bpp==16?0:1));
   }
};
   
#endif

#endif




