$! PARALLELTEST.COM
$! 23-OCT-1997, David Mathog
$!
$! Verify that all HTTP:// links in a file are valid.  It can handle
$! any text file type, so long as links don't wrap around ends of lines.
$! Symbol FETCH_HTTP must be defined, and it must be the version that supports
$! the -y option!
$!
$! This routine submits up to N jobs of TESTURLS, where the actual work is
$! done.  This allows for *much* faster checking, if the queue used is
$! wide enough to run them all at once.
$!
$ put := write sys$output
$ on control_y then goto abort
$!
$ if P1 .eqs. "" .or. P2  .eqs. ""
$ then
$   type sys$input

Usage: $ @paralleltest.com P1 P2 [P3] [P4] [P5] [P6] [P7]

   Tests all http://whatever/ URLs that are found in a file to see
   if they will download.  Results are output like: HTTP_CODE  URL

   A code of 000 means that the address couldn't be resolved

   P1 search specification for an input file (which contains urls)
   P2 final results file
   P3 is the frequency of "testing blah" messages.  If an integer, then every 
      Nth test. If not an integer, then on every one.  If not defined
      then no messages.
   P4 if present, enable end of line as a URL terminator
   P5 if set, is number of processes to spawn, default is 10
   P6 if set, is name prefix, if not set, uses PARURLXXX
   P7 if set, is timeout for FETCH_HTTP in seconds (integer, defaults to 100)
   P8 if set, is the queue name to send them to

   Both P1 and P2 must be specified.

   This program requires that the foreign symbol FETCH_HTTP be defined and
   that the version used must support the -y flag

   The jobs are submitted /AFTER=TOMORROW unless the global symbol DO_IT_WHEN
   is defined.  If that symbol is empty, then the jobs start now, otherwise
   after the time specified in the symbol.

$   exit
$ endif
$!
$ if(f$type(P5) .eqs. "INTEGER")
$ then
$   processes = f$integer(P5)
$   if (processes .lt.2)
$   then
$     write sys$output "Bad number of subprocesses = ''P5', must be >= 2"
$     exit
$   endif
$ else
$   processes = 10
$ endif
$!
$ if(P6 .nes. "")
$ then
$   prefix = f$string(P6)
$ else
$   prefix = "PARURL"
$ endif
$!
$ if(f$type(P7) .eqs. "INTEGER")
$ then
$    timeout=f$integer(P7)
$    if (timeout .lt. 1)
$    then
$      put "Aborted, bad timeout value = ''timeout'"
$      exit
$    endif
$ else
$    timeout="""""
$ endif
$!
$ if(P8 .eqs. "")
$ then
$    inqueue = ""
$ else
$    inqueue = "/queue=''P8'"
$ endif
$!
$ if f$type(fetch_http) .nes. "STRING"
$ then
$   type sys$input

PARALLELTEST aborted because the foreign command FETCH_HTTP is not defined.

$   exit
$ endif
$
$ if f$search("fetch_http:testurls.com") .eqs. ""
$ then
$   type sys$input

PARALLELTEST aborted, cannot find FETCH_HTTP:TESTURLS.COM.

  (Define the logical FETCH_HTTP so that PARALLELTEST can find
   TESTURLS.COM.)

$   exit
$ endif
$!
$! when should the jobs start?  Depends on the symbol DO_IT_WHEN
$!
$ if (f$type(do_it_when) .eqs. "")
$ then
$   startat = "/after=tomorrow"
$ else
$   if (do_it_when .eqs. "")
$   then
$      startat = ""
$   else
$      startat = "/after=''do_it_when'"
$   endif
$ endif
$!
$! create the results file, all files will append into it
$!
$ ofile = P2
$ open/write/error=noout ofil: 'ofile'
$ close ofil:
$ oofile = f$search(ofile)
$!
$!
$! Ok, now submit N of these processes
$!
$ count = 0
$ pidlist = ""
$ top:
$  count = count + 1
$  pname = "00000000''count'"
$  plen = f$length(pname)
$  pname = prefix + f$extract(plen-3,3,pname)
$  submit 'inqueue'/name='pname'/parameters=('P1','oofile','P3','P4', -
   'processes','count','timeout')/log 'startat' fetch_http:testurls.com
$  if(count .lt. processes)then goto top
$!
$! they are off and running, so exit
$!
$ done:
$ put "All jobs submitted"
$ exit
$!
$ noout:
$ put "Aborted - could not open the output file ''ofile'"
$ exit
$!
$ abort:
$ put "Aborted"
$ exit
