$! TESTURLS.COM
$! 22-OCT-1997, David Mathog
$!
$! Verify that all HTTP:// links in a file are valid.  It can handle
$! any text file type, so long as links don't wrap around ends of lines.
$! Symbol FETCH_HTTP must be defined, and it must be the version that supports
$! the -y option!
$!
$! A URL is identified by a <http://> at the beginning, and a " or > at the end.
$!
$! P1 is a search specification for the input file
$! P2 is output file
$! P3 is frequency of "testing blah" message.  If an integer, then every 
$!     Nth test. If not an integer, then on every one.  If not defined
$!     then no messages.
$! P4 if set, enable end of line as a URL terminator.
$! P5 if set, determines PERIOD
$! P6 if set, determines PHASE (1-Period)
$! P7 if set, is timeout for FETCH_HTTP in seconds (defaults to 100)
$!
$! if period isn't 1 then 3 digits of phase prefix all output, and
$! the output file is opened open/append/share
$!
$ put := write sys$output
$ space = " "
$ quote = """
$ endtag ="</"
$ count = 0
$ on control_y then goto abort
$!
$ if P1 .eqs. "" .or. P2  .eqs. ""
$ then
$   type sys$input

Usage: $ @testurls.com P1 P2 [P3] [P4] [P5] [P6] [P7]

   Tests all http://whatever/ URLs that are found in a file to see
   if they will download.  Results are output like: HTTP_CODE  URL

   A code of 000 means that the address couldn't be resolved

   P1 search specification for an input file (which contains urls)
   P2 results file
   P3 is the frequency of "testing blah" messages.  If an integer, then every 
      Nth test. If not an integer, then on every one.  If not defined
      then no messages.
   P4 if present, enable end of line as a URL terminator
   P5 if set, determines PERIOD (an integer)
   P6 if set, determines PHASE (1 to Period) (an integer)
   P7 if set, is timeout for FETCH_HTTP in seconds (integer, defaults to 100)

   Both P1 and P2 must be specified.
   P5 and P6 are meaningless without each other!

   if PERIOD isn't 1 then 3 digits of PHASE prefix all output, and
   the output file is opened open/append/share

   This program requires that the foreign symbol FETCH_HTTP be defined and
   that the version used must support the -y flag

$   exit
$ endif
$!
$ if(P3 .eqs. "")
$ then
$   mfreq = 0
$ else
$   if(f$type(P3) .eqs. "INTEGER")
$   then
$     mfreq = f$integer(P3)
$   else
$     mfreq = 1
$   endif
$ endif
$!
$ pad = 0
$ if(P4 .nes. "")then pad = 1
$!
$ if(f$type(P5) .eqs. "INTEGER" .and. f$type(P6) .eqs. "INTEGER")
$ then
$   period = f$integer(P5)
$   phase  = f$integer(P6)
$   if ((period .lt.1) .or. -
        (phase .lt. 1) .or. -
        (phase .gt. period))
$   then
$     write sys$output "Bad P5/P5 (Period/Phase) combination ''P5'/''P6'"
$     exit
$   endif
$   hcount = period - phase
$ else
$   period = 1
$   hcount = 0
$ endif
$ if (period .ne. 1)
$ then
$   ophase = "       ''phase'>"
$   length = f$length(ophase)
$   ophase = f$extract(length-4,4,ophase)
$ else
$   ophase = ""
$ endif
$!
$ if(f$type(P7) .eqs. "INTEGER")
$ then
$    timeout=f$integer(P7)
$    if (timeout .lt. 1)then
$ endif
$!
$ if f$type(fetch_http) .nes. "STRING"
$ then
$   type sys$input

TESTURLS aborted because the foreign command FETCH_HTTP is not defined.

$   exit
$ endif
$!
$!
$ if(ophase .eqs. "")
$ then
$    open/write/error=noout ofil: 'P2
$ else
$    open/append/share/error=noout ofil: 'P2
$ endif
$!
$ searchfor = P1
$ length = f$length(searchfor)
$ isstar = f$locate("*",searchfor)
$ isperc = f$locate("%",searchfor)
$ isdots = f$locate("...",searchfor)
$ if((length .ne. isstar) .or. (length .ne. isperc) .or. (length .ne. isdots))
$ then 
$   doonce = 0
$ else
$   doonce = 1
$ endif
$ file := ""
$!
$!
$ scantop:
$ close/nolog ifil:
$ if(doonce .eq. 1 .and. file .nes. "")then goto done
$ file = f$search(searchfor)
$ if(file .eqs. "")then goto done
$ write ofil: "''ophase'Scanning ''file'"
$!
$ open/read/error=noin ifil: 'file
$ top:
$   read/error=scantop/end=scantop ifil: string
$   if(pad .eq. 1)then string = string + quote
$!
$! find the http:// part
$!
$ multiple:
$   lower = f$locate("http://",string)
$   upper = f$locate("HTTP://",string)
$   if(lower .lt. upper)
$   then
$       front = lower
$   else
$     if(upper .eq. lower)then goto top ! if equal, neither is present
$     front = upper
$   endif
$!
$! there is one, now find the back piece of it,
$! indicated by either a space or a "
$!
$   length = f$length(string)
$   string = f$extract(front,length-front,string)
$   length = f$length(string)
$!   
$   qback = f$locate(quote,string)
$   sback = f$locate(space,string)
$   tback = f$locate(endtag,string)
$!
$   if(tback .lt. sback)then sback=tback
$   if(sback .lt. qback)
$   then
$       back = sback
$   else
$     if(sback .eq. qback)
$     then
$       write ofil: "''ophase'INVALID URL: ''string'"
$       goto remainder
$     else
$       back = qback
$     endif
$   endif
$!
$!  hack out the piece to test
$!
$   test = f$extract(0,back,string)
$!
$! handle period/phase tests.  The phase was set above,
$! the period is handled here.
$!
$ hcount = hcount + 1
$ if(hcount .eq. period)
$ then
$ hcount = 0
$!
$   count = count + 1
$   if(mfreq .eqs. count)
$   then
$     write sys$output "testing ''test'"
$     count = 0
$   endif
$!
$! for unknown reasons if a URL like http://valid
$! is entered (no terminal "/") fetch_http bails and there
$! is no way to override it with "on condition then". The "solution"
$! used here is to detect these and add the "/"
$!
$   badformat = f$extract(7,length-6,test)
$   if(f$element(1,"/",badformat) .eqs. "/")
$   then
$     write ofil: "''ophase'BADFORMAT ''test'"
$   else 
$!
$     ON SEVERE_ERROR THEN CONTINUE
$     ON ERROR THEN CONTINUE
$     ON WARNING THEN CONTINUE
$     define/user sys$output nla0:
$     define/user sys$error nla0:
$     fetch_http "''test'" -y
$     if(f$locate(" 302",http_result) .lt. 12)
$     then
$       write ofil: ophase,"''http_result' ''test' is now ''http_redirect'"
$     else
$       write ofil: ophase,"''http_result' ''test'"
$     endif
$   endif
$!
$! end of phase/period structure
$ endif
$!
$!
$ remainder:
$   string=f$extract(back,length-back,string)
$   length=f$length(string)
$   if(length .gt. 8)then goto multiple !room for another, maybe
$   goto top
$!
$ noin:
$ put "Input file ''P1' would not open"
$ close/nolog ofil:
$ exit
$!
$ noout:
$ put "Output file ''P2' could not be created"
$ exit
$!
$ done:
$ put "Done"
$ close/nolog ifil:
$ close/nolog ofil:
$ exit
$!
$ abort:
$ put "Aborted"
$ close/nolog ifil:
$ close/nolog ofil:
$ exit
