// CapDll.cpp : Defines the initialization routines for the DLL.
//

#include "resource.h"		// main symbols
#include "stdafx.h"
#include <CapDll.h>
#include "CaptureDlg.h"
#include "SelectAdapter.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define MFR_C1 "Il comando "
#define MFR_C2 "  fallito!"
#else
#define MFR_C1 "Command: "
#define MFR_C2 " failed!"
#endif

/////////////////////////////////////////////////////////////////////////////
// Library init

#include "capdll.h"

BOOL CCapDllApp::InitInstance()
{
	// any DLL initialization goes here
	TRACE0("CAPDLL.DLL initializing\n");

	return TRUE;
}

int CCapDllApp::ExitInstance()
{
	// any DLL termination goes here (WEP-like code)
	return CWinApp::ExitInstance();
}

CCapDllApp capDll(_T("Analyzer_Capture.dll"));

/////////////////////////////////////////////////////////////////////////////
// CCapDll construction

CCapDll::CCapDll()
{
	Path=NULL;
	Adapter=NULL;
	FileName=NULL;
	Filter=NULL;
}

HINSTANCE hres;

void __declspec(dllexport) InitCapDll(const char* INI)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState( ));
	hres=AfxGetResourceHandle();
	free((void*)(AfxGetApp()->m_pszProfileName));
	AfxGetApp()->m_pszProfileName=_tcsdup(INI);
}

CCapDll::~CCapDll()
{
	if (Path) delete[]Path;
	if (Adapter) delete[]Adapter;
	if (FileName) delete[]FileName;
	if (Filter) delete[]Filter;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CCapDllApp object

char* CCapDll::SetPath(const char * a)
{
	if (!a) return NULL;
	if (Path) delete[]Path;
	Path=new char[strlen(a)+1];
	if (!Path) return NULL;
	strcpy(Path,a);
	return Path;
}

char* CCapDll::SetAdapter(const char * a)
{
	if (!a) return NULL;
	if (Adapter) delete[]Adapter;
	Adapter=new char[strlen(a)+1];
	if (!Adapter) return NULL;
	strcpy(Adapter,a);
	return Adapter;
}

char* CCapDll::SetFileName(const char * a)
{
	if (!a) return NULL;
	if (FileName) delete[]FileName;
	FileName=new char[strlen(a)+1];
	if (!FileName) return NULL;
	strcpy(FileName,a);
	return FileName;
}

char* CCapDll::SetFilter(const char * a)
{
	if (!a) return NULL;
	if (Filter) delete[]Filter;
	Filter=new char[strlen(a)+1];
	if (!Filter) return NULL;
	strcpy(Filter,a);
	return Filter;
}

const char* CCapDll::GetPath()
{
	return Path;
}

const char* CCapDll::GetAdapter()
{
	return Adapter;
}

const char* CCapDll::GetFileName()
{
	return FileName;
}

const char* CCapDll::GetFilter()
{
	return Filter;
}

int CCapDll::CaptureDialog(const char* Adapter,const char* P, CWnd* mw)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState( ));
	CCaptureDlg cap(mw);
	SetPath(P);
	cap.Adapter=Adapter;
	cap.Path=P;
	int i;
	i=cap.DoModal();
	if (i==IDOK)
	{
	 SetAdapter(cap.Adapter);
	 SetFilter(cap.m_Filter);
	 SetFileName(cap.m_File);
	}
	return i;
}

#ifndef ENGLISH
#define MP_ERROBJ "Errore eseguendo WinDump"
#else
#define MP_ERROBJ "Error executing WinDump"
#endif

#include <console.h>

int ExecuteApp(CString & s)
{
	int r;
	HANDLE in,out,err;
	HANDLE proc;
	DWORD dwProcessId;
	int l=0;
	r=ExecuteProgram ((const char*)s,&in,&out,&err,&proc,&dwProcessId);
	if (r) {AfxMessageBox(MP_ERROBJ);return 1;}
	BOOL b;
	DWORD d=1;
	s="";
	if(d)
	{
		char t2[1000];
		do
		{
		 b=ReadFile(out,t2,998,&d,NULL);
		 t2[d]='\0';
		 s+=t2;
		} while (b);
		do
		{
		 b=ReadFile(err,t2,998,&d,NULL);
		 t2[d]='\0';
		 s+=t2;
		} while (b);
		d=WaitExit(proc);
		if (d)
		{
		 CloseHandle(in);
		 CloseHandle(out);
		 CloseHandle(err);
		 return 1;
		}
	}
	CloseHandle(in);
	CloseHandle(out);
	CloseHandle(err);
	return 0;
}

int CCapDll::ChooseAdapter(const char* Adapter, CWnd* mw)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState( ));
	CSelectAdapter dlg(mw);
	dlg.m_Adapter=Adapter;
	int i;
	i=dlg.DoModal();
	if (i==IDOK)
	{
 	 SetAdapter(dlg.m_Adapter);
	}
	return i;
}

#include "ProgCaptDlg.h"

UINT MyThreadProc( LPVOID pParam );

extern DWORD d;

const char* CCapDll::Capture(const char* Command, CWnd* mw)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState( ));
	CProgCaptDlg prog(mw);
	CCapPars pars;
	prog.m_Main=&pars;
	pars.prg=&prog;
	pars.dll=this;
	pars.m_Cmd=Command;

	CWinThread* thr=AfxBeginThread(MyThreadProc, &pars);
	if(!thr) {AfxMessageBox(MFR_C1 /*Il comando */+ (CString)Command + MFR_C2 /*  fallito!*/);return NULL;}
	HANDLE thread=thr->m_hThread;
	prog.DoModal();

	WaitForSingleObject(thread,INFINITE);
	if (prog.m_hWnd) 
		{
			::SendMessage(prog.m_hWnd,WM_CLOSE,0,0);
			::ShowWindow(prog.m_hWnd,SW_HIDE);
		}
	if (d) return pars.m_Cmd;
	 else return NULL;
}

