// CaptureDlg.cpp : implementation file
//

#include "stdafx.h"
#include <capdll.h>
#include "CaptureDlg.h"
#include "Capturewiz.h"
#include "SelFilter.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define CAP_DLG_FILE "Selezionare il file ACP da creare"
#define CAPDLG_EMPTYFLT_ERR "Impossibile salvare un filtro vuoto"
#define FLTR_FILE "cap_fltr.dat"
#define FLTR_FILE_SEC "DAT"
#else
#define CAP_DLG_FILE "Choose the ACP filename"
#define CAPDLG_EMPTYFLT_ERR "Unable to save an empty filter"
#define FLTR_FILE "cap_fltr_e.dat"
#define FLTR_FILE_SEC "DAT_E"
#endif

/////////////////////////////////////////////////////////////////////////////
// CCaptureDlg dialog


CCaptureDlg::CCaptureDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCaptureDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCaptureDlg)
	m_File = _T("");
	m_Filter = _T("-s 1514 ");
	m_IsTemp = FALSE;
	//}}AFX_DATA_INIT
}


void CCaptureDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCaptureDlg)
	DDX_Text(pDX, IDC_EDIT2, m_File);
	DDX_Text(pDX, IDC_EDIT1, m_Filter);
	DDX_Check(pDX, IDC_CHECK2, m_IsTemp);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCaptureDlg, CDialog)
	//{{AFX_MSG_MAP(CCaptureDlg)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_BN_CLICKED(IDC_CHECK2, OnCheck2)
	ON_BN_CLICKED(IDC_BROWSE_FLT, OnBrowseFlt)
	ON_BN_CLICKED(IDC_SAVE, OnSave)
	ON_BN_CLICKED(IDC_WIZARD, OnWizard)
	ON_BN_CLICKED(IDC_CHOOSE_AD, OnChooseAdapter)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCaptureDlg message handlers

void CCaptureDlg::OnBrowse() 
{
	 CFileDialog dlgFile(TRUE);
	 BOOL bResult;

	 CString title=CAP_DLG_FILE /*Selezionare il file CAP da creare*/;
	 CString fileName;
     UINT nIDSTitle=AFX_IDS_OPENFILE;
     DWORD lFlags=OFN_HIDEREADONLY; //| OFN_FILEMUSTEXIST;
     BOOL bOpenFileDialog=FALSE; 

	 dlgFile.m_ofn.Flags |= lFlags;

	 CString strFilter="files cap (*.acp)";
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += _T("*.acp");
	 strFilter += (TCHAR)'\0';   // last string
	 CString strDefault;
	 // append the '*.*' all files filter
	 CString allFilter;
	 VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	 strFilter += allFilter;
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += _T("*.*");
	 strFilter += (TCHAR)'\0';   // last string
	 dlgFile.m_ofn.nMaxCustFilter++;

	 dlgFile.m_ofn.lpstrFilter = strFilter;
	 dlgFile.m_ofn.lpstrTitle = title;
	 dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	 bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	 fileName.ReleaseBuffer();
	 if (!bResult) return;
	 m_eFile->SetWindowText("\"" + fileName + "\"");
	 return ;
}

void CCaptureDlg::OnOK() 
{
	m_IsTemp=!m_cTemp->GetCheck();
	if (m_IsTemp)  {m_File=""; m_eFile->SetWindowText("");}
	CDialog::OnOK();
}

void CCaptureDlg::OnCheck2() 
{
	m_IsTemp=!m_cTemp->GetCheck();
	if (m_IsTemp) m_eFile->SetReadOnly(TRUE); 
		else m_eFile->SetReadOnly(FALSE); 
}

BOOL CCaptureDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_eFile=(CEdit*)GetDlgItem(IDC_EDIT2);
	m_eFilter=(CEdit*)GetDlgItem(IDC_EDIT1);
	m_cTemp=(CButton*)GetDlgItem(IDC_CHECK2);
	m_cTemp->SetCheck(FALSE);
	m_eFile->SetReadOnly(TRUE); 
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CCaptureDlg::OnBrowseFlt() 
{
	CSelFilter dlg;
	dlg.Path=Path;
	dlg.m_Type=1;
	CWinApp* pApp = AfxGetApp();   
	dlg.m_FileName=pApp->GetProfileString(FLTR_FILE_SEC, "CapFilters", Path+FLTR_FILE);
	if(dlg.m_FileName[1]!=':') dlg.m_FileName=Path+dlg.m_FileName;
	if(dlg.DoModal()==IDOK)
	{
		m_eFilter->SetWindowText(dlg.m_Filter);
	}
}

void CCaptureDlg::OnSave() 
{
	CSelFilter dlg;
	CWinApp* pApp = AfxGetApp();   
	dlg.m_FileName=pApp->GetProfileString(FLTR_FILE_SEC, "CapFilters", Path+FLTR_FILE);
	if(dlg.m_FileName[1]!=':') dlg.m_FileName=Path+dlg.m_FileName;
	m_eFilter->GetWindowText(dlg.m_Add);
	if (dlg.m_Add=="") {AfxMessageBox(CAPDLG_EMPTYFLT_ERR /*Impossibile salvare un filtro vuoto*/);return;}
	if(dlg.DoModal()==IDOK)
	{
		m_eFilter->SetWindowText(dlg.m_Filter);
	}
}

void CCaptureDlg::OnWizard() 
{
	CCaptureWiz dlg;
	if(dlg.DoModal()==IDOK)
	{
		m_eFilter->SetWindowText(dlg.m_Filter);
	}
}

#include "SelectAdapter.h"

void CCaptureDlg::OnChooseAdapter() 
{
	CSelectAdapter dlg;
	dlg.m_Cmd=m_Cmd;
	dlg.m_Adapter=Adapter;
	if (dlg.DoModal()==IDOK) Adapter=dlg.m_Adapter;
}
