// CaptureWiz.cpp : implementation file
//

#include "stdafx.h"
#include <capdll.h>
#include "CaptureWiz.h"
#include "SelFilter.h"
#include "hex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define CAPWIZ_SRC "Sorgente (SRC)"
#define CAPWIZ_DST "Destinazione (DST)"
#define CAPWIZ_FIRST "Primo Host (HOST1)"
#define CAPWIZ_SECOND "Secondo Host (HOST2)"
#define CAPWIZ_SD "Host Sorgente/Destinazione"
#define CAPWIZ_NP "Pacchetti da Catturare"
#define CAPWIZ_LEN "Lunghezza Pacchetti Salvata"
#define CAPWIZ_FLTR "Filtro"
#define CAPWIZ_DESC "Descrizione"
#define CAPWIZ_OPT "Opzioni"
#define CAPWIZ_DEF_OPT "NumeroPacchetti:Infinito - LunghezzaPacchetti:1514"
#define CAPWIZ_PNUM "NumeroPacchetti:%d"
#define CAPWIZ_PNUMINF "NumeroPacchetti:Infinito"
#define CAPWIZ_PLENDEF "LunghezzaPacchetti:Default"
#define CAPWIZ_PLEN "LunghezzaPacchetti:%d"
#else
#define CAPWIZ_SRC "Source (SRC)"
#define CAPWIZ_DST "Destination (DST)"
#define CAPWIZ_FIRST "First Host (HOST1)"
#define CAPWIZ_SECOND "Second Host (HOST2)"
#define CAPWIZ_SD "Source/Destination Host"
#define CAPWIZ_NP "Packet Number"
#define CAPWIZ_LEN "Saved Packet Length"
#define CAPWIZ_FLTR "Filter"
#define CAPWIZ_DESC "Description"
#define CAPWIZ_OPT "Options"
#define CAPWIZ_DEF_OPT "PacketNumber:NotDefined - PacketLength:1514"
#define CAPWIZ_PNUM "PacketNumber:%d"
#define CAPWIZ_PNUMINF "PacketNumber:NotDefined"
#define CAPWIZ_PLENDEF "PacketLength:Default"
#define CAPWIZ_PLEN "PacketLength:%d"
#endif

/////////////////////////////////////////////////////////////////////////////
// CCaptureWiz dialog


CCaptureWiz::CCaptureWiz(CWnd* pParent /*=NULL*/)
	: CDialog(CCaptureWiz::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCaptureWiz)
	m_NumPcks = 0;
	m_SnapLen = 1514;
	//}}AFX_DATA_INIT
	m_IpD1 = 0;
	m_IpD2 = 0;
	m_IpD3 = 0;
	m_IpD4 = 0;
	m_IpS1 = 0;
	m_IpS2 = 0;
	m_IpS3 = 0;
	m_IpS4 = 0;
	m_MacD6=0;
	m_MacD5=0;
	m_MacD4=0;
	m_MacD3=0;
	m_MacD2=0;
	m_MacD1=0;
	m_MacS6=0;
	m_MacS5=0;
	m_MacS4=0;
	m_MacS3=0;
	m_MacS2=0;
	m_MacS1=0;
	modo=0;
}


void CCaptureWiz::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCaptureWiz)
	DDX_Control(pDX, IDC_REMOVE, m_Remove);
	DDX_Control(pDX, IDC_ADD, m_Add);
	DDX_Control(pDX, IDC_REPLACE, m_Replace);
	DDX_Control(pDX, IDC_ST3, m_S3);
	DDX_Control(pDX, IDC_ST2, m_S2);
	DDX_Control(pDX, IDC_ST1, m_S1);
	DDX_Control(pDX, IDC_TAB2, m_Tab);
	DDX_Control(pDX, IDC_LIST1, m_ListCtrl);
	DDX_Control(pDX, IDC_COMBO2, m_Direction);
	//}}AFX_DATA_MAP
	int dir=m_Direction.GetCurSel();
	if(modo==0)
	{
	  if (dir==0 || dir==1 || dir==3 || dir==4)
	  {
		DDX_HEX(pDX, IDC_MS6, m_MacS6);
		DDV_MinMaxDWord(pDX, m_MacS6, 0, 255);
		DDX_HEX(pDX, IDC_MS5, m_MacS5);
		DDV_MinMaxDWord(pDX, m_MacS5, 0, 255);
		DDX_HEX(pDX, IDC_MS4, m_MacS4);
		DDV_MinMaxDWord(pDX, m_MacS4, 0, 255);
		DDX_HEX(pDX, IDC_MS3, m_MacS3);
		DDV_MinMaxDWord(pDX, m_MacS3, 0, 255);
		DDX_HEX(pDX, IDC_MS2, m_MacS2);
		DDV_MinMaxDWord(pDX, m_MacS2, 0, 255);
		DDX_HEX(pDX, IDC_MS1, m_MacS1);
		DDV_MinMaxDWord(pDX, m_MacS1, 0, 255);
	  }
	  if (dir==0 || dir==2 || dir==4)
	  {
		DDX_HEX(pDX, IDC_MD6, m_MacD6);
		DDV_MinMaxDWord(pDX, m_MacD6, 0, 255);
		DDX_HEX(pDX, IDC_MD5, m_MacD5);
		DDV_MinMaxDWord(pDX, m_MacD5, 0, 255);
		DDX_HEX(pDX, IDC_MD4, m_MacD4);
		DDV_MinMaxDWord(pDX, m_MacD4, 0, 255);
		DDX_HEX(pDX, IDC_MD3, m_MacD3);
		DDV_MinMaxDWord(pDX, m_MacD3, 0, 255);
		DDX_HEX(pDX, IDC_MD2, m_MacD2);
		DDV_MinMaxDWord(pDX, m_MacD2, 0, 255);
		DDX_HEX(pDX, IDC_MD1, m_MacD1);
		DDV_MinMaxDWord(pDX, m_MacD1, 0, 255);
	  }
	}
	else
	{
	  if (dir==0 || dir==2 || dir==4)
	  {
		DDX_Text(pDX, IDC_ID1, m_IpD1);
		DDV_MinMaxDWord(pDX, m_IpD1, 0, 255);
		DDX_Text(pDX, IDC_ID2, m_IpD2);
		DDV_MinMaxDWord(pDX, m_IpD2, 0, 255);
		DDX_Text(pDX, IDC_ID3, m_IpD3);
		DDV_MinMaxDWord(pDX, m_IpD3, 0, 255);
		DDX_Text(pDX, IDC_ID4, m_IpD4);
		DDV_MinMaxDWord(pDX, m_IpD4, 0, 255);
	  }
	  if (dir==0 || dir==1 || dir==3 || dir==4)
	  {
		DDX_Text(pDX, IDC_IS1, m_IpS1);
		DDV_MinMaxDWord(pDX, m_IpS1, 0, 255);
		DDX_Text(pDX, IDC_IS2, m_IpS2);
		DDV_MinMaxDWord(pDX, m_IpS2, 0, 255);
		DDX_Text(pDX, IDC_IS3, m_IpS3);
		DDV_MinMaxDWord(pDX, m_IpS3, 0, 255);
		DDX_Text(pDX, IDC_IS4, m_IpS4);
		DDV_MinMaxDWord(pDX, m_IpS4, 0, 255);
	  }
	}
}


BEGIN_MESSAGE_MAP(CCaptureWiz, CDialog)
	//{{AFX_MSG_MAP(CCaptureWiz)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_CBN_SELCHANGE(IDC_COMBO2, OnDirectionChange)
	ON_BN_CLICKED(IDC_REPLACE, OnReplace)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB2, OnProtoSelChange)
	ON_NOTIFY(NM_CLICK, IDC_LIST1, OnListClick)
	ON_BN_CLICKED(IDC_REMOVE, OnRemove)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCaptureWiz message handlers

void CCaptureWiz::OnAdd() 
{
	int dir=m_Tab.GetCurSel();
	int n=m_ListCtrl.GetItemCount();
	CString str;
	if (dir==1)
	{
		if (Mac2Str(str)) return;
		AddItem(n,0,"MAC",1);
	}
	else if (dir==2)
	{
		if (Ip2Str(str)) return;
		AddItem(n,0,"IP",2);
	}
	else
	{
		return;
	}
	AddItem(n,1,str);
	m_ListCtrl.SetItemState(n,0xFFFFFFFF,LVIS_SELECTED);
	OnListClick(NULL,NULL);
}

void __declspec(dllexport) Enable(CButton& button,BOOL b)
{
	if (button.m_hWnd==NULL) return;
	DWORD d=button.GetStyle();
	if (b) button.ModifyStyle(WS_DISABLED,0);
	else button.ModifyStyle(0,WS_DISABLED);
	button.Invalidate();
}

void CCaptureWiz::OnDirectionChange() 
{
	int dir=m_Direction.GetCurSel();
	if (dir==0 || dir==4) 
	{
		m_MS1->SetReadOnly(FALSE);
		m_MS2->SetReadOnly(FALSE);
		m_MS3->SetReadOnly(FALSE);
		m_MS4->SetReadOnly(FALSE);
		m_MS5->SetReadOnly(FALSE);
		m_MS6->SetReadOnly(FALSE);
		m_MD1->SetReadOnly(FALSE);
		m_MD2->SetReadOnly(FALSE);
		m_MD3->SetReadOnly(FALSE);
		m_MD4->SetReadOnly(FALSE);
		m_MD5->SetReadOnly(FALSE);
		m_MD6->SetReadOnly(FALSE);
		m_IS1->SetReadOnly(FALSE);
		m_IS2->SetReadOnly(FALSE);
		m_IS3->SetReadOnly(FALSE);
		m_IS4->SetReadOnly(FALSE);
		m_ID1->SetReadOnly(FALSE);
		m_ID2->SetReadOnly(FALSE);
		m_ID3->SetReadOnly(FALSE);
		m_ID4->SetReadOnly(FALSE);
		if (dir==0)
		{
			m_S1.SetWindowText(CAPWIZ_SRC /*Sorgente (SRC)*/);
			m_S2.SetWindowText(CAPWIZ_DST /*Destinazione (DST)*/);
		}
		else 
		{
			m_S1.SetWindowText(CAPWIZ_FIRST /*Primo Host (HOST1)*/);
			m_S2.SetWindowText(CAPWIZ_SECOND /*Secondo Host (HOST2)*/);
		}
	}
	else if (dir==1 || dir==3) 
	{
		m_MS1->SetReadOnly(FALSE);
		m_MS2->SetReadOnly(FALSE);
		m_MS3->SetReadOnly(FALSE);
		m_MS4->SetReadOnly(FALSE);
		m_MS5->SetReadOnly(FALSE);
		m_MS6->SetReadOnly(FALSE);
		m_MD1->SetReadOnly(TRUE);
		m_MD2->SetReadOnly(TRUE);
		m_MD3->SetReadOnly(TRUE);
		m_MD4->SetReadOnly(TRUE);
		m_MD5->SetReadOnly(TRUE);
		m_MD6->SetReadOnly(TRUE);
		m_IS1->SetReadOnly(FALSE);
		m_IS2->SetReadOnly(FALSE);
		m_IS3->SetReadOnly(FALSE);
		m_IS4->SetReadOnly(FALSE);
		m_ID1->SetReadOnly(TRUE);
		m_ID2->SetReadOnly(TRUE);
		m_ID3->SetReadOnly(TRUE);
		m_ID4->SetReadOnly(TRUE);
		if (dir==1)
		{
			m_S1.SetWindowText(CAPWIZ_SRC /*Sorgente (SRC)*/);
			m_S2.SetWindowText(CAPWIZ_DST /*Destinazione (DST)*/);
		}
		else 
		{
			m_S1.SetWindowText(CAPWIZ_SD /*Host Sorgente/Destinazione*/);
			m_S2.SetWindowText("");
		}
	}
	else
	{
		m_MS1->SetReadOnly(TRUE);
		m_MS2->SetReadOnly(TRUE);
		m_MS3->SetReadOnly(TRUE);
		m_MS4->SetReadOnly(TRUE);
		m_MS5->SetReadOnly(TRUE);
		m_MS6->SetReadOnly(TRUE);
		m_MD1->SetReadOnly(FALSE);
		m_MD2->SetReadOnly(FALSE);
		m_MD3->SetReadOnly(FALSE);
		m_MD4->SetReadOnly(FALSE);
		m_MD5->SetReadOnly(FALSE);
		m_MD6->SetReadOnly(FALSE);
		m_IS1->SetReadOnly(TRUE);
		m_IS2->SetReadOnly(TRUE);
		m_IS3->SetReadOnly(TRUE);
		m_IS4->SetReadOnly(TRUE);
		m_ID1->SetReadOnly(FALSE);
		m_ID2->SetReadOnly(FALSE);
		m_ID3->SetReadOnly(FALSE);
		m_ID4->SetReadOnly(FALSE);
		m_S1.SetWindowText(CAPWIZ_SRC /*Sorgente (SRC)*/);
		m_S2.SetWindowText(CAPWIZ_DST /*Destinazione (DST)*/);
	}
	OnProtoSelChange(NULL,NULL);
}

void CCaptureWiz::OnReplace() 
{
	CString str;
	int dir=m_Tab.GetCurSel();
	if (dir==1)
	{
		if (Mac2Str(str)) return;
	}
	else if (dir==2)
	{
		if (Ip2Str(str)) return;
	}
	else
	{
		if (Opt2Str(str)) return;
	}
	if(m_CurSel>=0)
		m_ListCtrl.SetItemText(m_CurSel,1,str);
}

void CCaptureWiz::OnProtoSelChange(NMHDR* pNMHDR, LRESULT* pResult) 
{
	
	if (m_Tab.GetCurSel()==1)
	{
		m_MS1->ShowWindow(SW_SHOW);
		m_MS2->ShowWindow(SW_SHOW);
		m_MS3->ShowWindow(SW_SHOW);
		m_MS4->ShowWindow(SW_SHOW);
		m_MS5->ShowWindow(SW_SHOW);
		m_MS6->ShowWindow(SW_SHOW);
		m_MD1->ShowWindow(SW_SHOW);
		m_MD2->ShowWindow(SW_SHOW);
		m_MD3->ShowWindow(SW_SHOW);
		m_MD4->ShowWindow(SW_SHOW);
		m_MD5->ShowWindow(SW_SHOW);
		m_MD6->ShowWindow(SW_SHOW);
		m_IS1->ShowWindow(SW_HIDE);
		m_IS2->ShowWindow(SW_HIDE);
		m_IS3->ShowWindow(SW_HIDE);
		m_IS4->ShowWindow(SW_HIDE);
		m_ID1->ShowWindow(SW_HIDE);
		m_ID2->ShowWindow(SW_HIDE);
		m_ID3->ShowWindow(SW_HIDE);
		m_ID4->ShowWindow(SW_HIDE);
		m_Direction.ShowWindow(SW_SHOW);

		if (m_Direction.GetCurSel()==3) 
		{
			m_S1.SetWindowText(CAPWIZ_SD /*Host Sorgente/Destinazione*/);
			m_S2.SetWindowText("");
			m_MD1->ShowWindow(SW_HIDE);
			m_MD2->ShowWindow(SW_HIDE);
			m_MD3->ShowWindow(SW_HIDE);
			m_MD4->ShowWindow(SW_HIDE);
			m_MD5->ShowWindow(SW_HIDE);
			m_MD6->ShowWindow(SW_HIDE);
		}
		
		m_S3.ShowWindow(SW_SHOW);
		m_SLen->ShowWindow(SW_HIDE);
		m_NPcks->ShowWindow(SW_HIDE);

		if (pResult)
		{
			m_MS1->SetWindowText("");
			m_MS2->SetWindowText("");
			m_MS3->SetWindowText("");
			m_MS4->SetWindowText("");
			m_MS5->SetWindowText("");
			m_MS6->SetWindowText("");
			m_MD1->SetWindowText("");
			m_MD2->SetWindowText("");
			m_MD3->SetWindowText("");
			m_MD4->SetWindowText("");
			m_MD5->SetWindowText("");
			m_MD6->SetWindowText("");
			m_CurSel=-1;
			modo=0;
			Enable(m_Replace,FALSE);
			Enable(m_Remove,FALSE);
			Enable(m_Add,TRUE);
		}
	}
	else if (m_Tab.GetCurSel()==2) 
	{
		m_MS1->ShowWindow(SW_HIDE);
		m_MS2->ShowWindow(SW_HIDE);
		m_MS3->ShowWindow(SW_HIDE);
		m_MS4->ShowWindow(SW_HIDE);
		m_MS5->ShowWindow(SW_HIDE);
		m_MS6->ShowWindow(SW_HIDE);
		m_MD1->ShowWindow(SW_HIDE);
		m_MD2->ShowWindow(SW_HIDE);
		m_MD3->ShowWindow(SW_HIDE);
		m_MD4->ShowWindow(SW_HIDE);
		m_MD5->ShowWindow(SW_HIDE);
		m_MD6->ShowWindow(SW_HIDE);
		m_IS1->ShowWindow(SW_SHOW);
		m_IS2->ShowWindow(SW_SHOW);
		m_IS3->ShowWindow(SW_SHOW);
		m_IS4->ShowWindow(SW_SHOW);
		m_ID1->ShowWindow(SW_SHOW);
		m_ID2->ShowWindow(SW_SHOW);
		m_ID3->ShowWindow(SW_SHOW);
		m_ID4->ShowWindow(SW_SHOW);
		m_Direction.ShowWindow(SW_SHOW);

		if (m_Direction.GetCurSel()==3) 
		{
			m_S1.SetWindowText("Host Sorgente/Destinazione");
			m_S2.SetWindowText("");
			m_ID1->ShowWindow(SW_HIDE);
			m_ID2->ShowWindow(SW_HIDE);
			m_ID3->ShowWindow(SW_HIDE);
			m_ID4->ShowWindow(SW_HIDE);
		}

		m_S3.ShowWindow(SW_SHOW);
		m_SLen->ShowWindow(SW_HIDE);
		m_NPcks->ShowWindow(SW_HIDE);
		if (pResult)
		{
			m_IS1->SetWindowText("");
			m_IS2->SetWindowText("");
			m_IS3->SetWindowText("");
			m_IS4->SetWindowText("");
			m_ID1->SetWindowText("");
			m_ID2->SetWindowText("");
			m_ID3->SetWindowText("");
			m_ID4->SetWindowText("");
			m_CurSel=-1;
			modo=1;
			Enable(m_Remove,FALSE);
			Enable(m_Replace,FALSE);
			Enable(m_Add,TRUE);
		}
	}
	else
	{
		m_Direction.ShowWindow(SW_HIDE);
		m_S1.SetWindowText(CAPWIZ_NP /*Pacchetti da Catturare*/);
		m_S2.SetWindowText(CAPWIZ_LEN /*Lunghezza Pacchetti Salvata*/);
		m_S3.ShowWindow(SW_HIDE);
		m_MS1->ShowWindow(SW_HIDE);
		m_MS2->ShowWindow(SW_HIDE);
		m_MS3->ShowWindow(SW_HIDE);
		m_MS4->ShowWindow(SW_HIDE);
		m_MS5->ShowWindow(SW_HIDE);
		m_MS6->ShowWindow(SW_HIDE);
		m_MD1->ShowWindow(SW_HIDE);
		m_MD2->ShowWindow(SW_HIDE);
		m_MD3->ShowWindow(SW_HIDE);
		m_MD4->ShowWindow(SW_HIDE);
		m_MD5->ShowWindow(SW_HIDE);
		m_MD6->ShowWindow(SW_HIDE);
		m_IS1->ShowWindow(SW_HIDE);
		m_IS2->ShowWindow(SW_HIDE);
		m_IS3->ShowWindow(SW_HIDE);
		m_IS4->ShowWindow(SW_HIDE);
		m_ID1->ShowWindow(SW_HIDE);
		m_ID2->ShowWindow(SW_HIDE);
		m_ID3->ShowWindow(SW_HIDE);
		m_ID4->ShowWindow(SW_HIDE);
		m_SLen->ShowWindow(SW_SHOW);
		m_NPcks->ShowWindow(SW_SHOW);

		m_ListCtrl.SetItemState(0,0xFFFFFFFF,LVIS_SELECTED);

		CString str;
		str=m_ListCtrl.GetItemText(0,1);
		Str2Opt(str);
		m_CurSel=0;
		Enable(m_Replace,TRUE);
		Enable(m_Remove,FALSE);
		Enable(m_Add,FALSE);
	}

	if (pResult)*pResult = 0;
	if (pResult) OnDirectionChange();
}

BOOL CCaptureWiz::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
    m_ListCtrl.InsertColumn(0,CAPWIZ_FLTR /*Filtro*/, LVCFMT_LEFT,60);
    m_ListCtrl.InsertColumn(1,CAPWIZ_DESC /*Descrizione*/, LVCFMT_LEFT,400);
	m_ctlImage.Create(IDB_CAP_WIZ,16,0,RGB(255,0,255));
	m_ListCtrl.SetImageList(&m_ctlImage,LVSIL_SMALL);

	TC_ITEM tci;
	tci.mask=TCIF_TEXT;
	tci.iImage=-1;
	tci.pszText=CAPWIZ_OPT /*Opzioni*/;
	m_Tab.InsertItem(0,&tci);
	tci.pszText="MAC";
	m_Tab.InsertItem(1,&tci);
	tci.pszText="IP";
	m_Tab.InsertItem(2,&tci);

	m_MS1 = (CEdit*) GetDlgItem (IDC_MS1);
	m_MS2 = (CEdit*) GetDlgItem (IDC_MS2);
	m_MS3 = (CEdit*) GetDlgItem (IDC_MS3);
	m_MS4 = (CEdit*) GetDlgItem (IDC_MS4);
	m_MS5 = (CEdit*) GetDlgItem (IDC_MS5);
	m_MS6 = (CEdit*) GetDlgItem (IDC_MS6);
	m_MD1 = (CEdit*) GetDlgItem (IDC_MD1);
	m_MD2 = (CEdit*) GetDlgItem (IDC_MD2);
	m_MD3 = (CEdit*) GetDlgItem (IDC_MD3);
	m_MD4 = (CEdit*) GetDlgItem (IDC_MD4);
	m_MD5 = (CEdit*) GetDlgItem (IDC_MD5);
	m_MD6 = (CEdit*) GetDlgItem (IDC_MD6);

	m_IS1 = (CEdit*) GetDlgItem (IDC_IS1);
	m_IS2 = (CEdit*) GetDlgItem (IDC_IS2);
	m_IS3 = (CEdit*) GetDlgItem (IDC_IS3);
	m_IS4 = (CEdit*) GetDlgItem (IDC_IS4);
	m_ID1 = (CEdit*) GetDlgItem (IDC_ID1);
	m_ID2 = (CEdit*) GetDlgItem (IDC_ID2);
	m_ID3 = (CEdit*) GetDlgItem (IDC_ID3);
	m_ID4 = (CEdit*) GetDlgItem (IDC_ID4);

	m_SLen = (CEdit*) GetDlgItem (IDC_SNAP_LEN);
	m_NPcks = (CEdit*) GetDlgItem (IDC_NUM_PACKETS);

	m_Direction.InsertString(0,"(SRC->DST)");
	m_Direction.InsertString(1,"(SRC->...)");
	m_Direction.InsertString(2,"(...->DST)");
	m_Direction.InsertString(3,"(HOST<->...)");
	m_Direction.InsertString(4,"(HOST1<->HOST2)");

	m_Direction.SetCurSel(0);
	m_Tab.SetCurSel(0);
	AddItem(0,0,CAPWIZ_OPT /*Opzioni*/,0);
	AddItem(0,1,CAPWIZ_DEF_OPT /*NumeroPacchetti:Infinito - LunghezzaPacchetti:1514*/,-1);
	m_CurSel=0;
	Enable(m_Add,FALSE);
	Enable(m_Replace,TRUE);
	Enable(m_Remove,FALSE);
	m_ListCtrl.SetItemState(0,0xFFFFFFFF,LVIS_SELECTED);
	CString str;
	str.Format("%d",m_SnapLen);
	m_SLen->SetWindowText(str);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CCaptureWiz::Str2Mac(CString & s)
{
	int ss,sd;
	CString str=s.Mid(0,10);
	if (str=="(SRC->DST)")
	{
		ss=10;
		sd=ss+20;
		m_Direction.SetCurSel(0);
		OnDirectionChange();
	}
	else if (str=="(SRC->...)")
	{
		ss=10;
		sd=-1;
		m_Direction.SetCurSel(1);
		OnDirectionChange();
	}
	else if (str=="(...->DST)")
	{
		ss=-1;
		sd=10;
		m_Direction.SetCurSel(2);
		OnDirectionChange();
	}
	else if (str=="(HOST<->..")
	{
		ss=12;
		sd=-1;
		m_Direction.SetCurSel(3);
		OnDirectionChange();
	}
	else if (str=="(HOST1<->H")
	{
		ss=15;
		sd=ss+20;
		m_Direction.SetCurSel(4);
		OnDirectionChange();
	}
	if(ss>=0)
	{
		m_MS1->SetWindowText(s.Mid(0+ss,2));
		m_MS2->SetWindowText(s.Mid(3+ss,2));
		m_MS3->SetWindowText(s.Mid(6+ss,2));
		m_MS4->SetWindowText(s.Mid(9+ss,2));
		m_MS5->SetWindowText(s.Mid(12+ss,2));
		m_MS6->SetWindowText(s.Mid(15+ss,2));
	}
	else 
	{
		m_MS1->SetWindowText("");
		m_MS2->SetWindowText("");
		m_MS3->SetWindowText("");
		m_MS4->SetWindowText("");
		m_MS5->SetWindowText("");
		m_MS6->SetWindowText("");
	}
	if(sd>=0)
	{
		m_MD1->SetWindowText(s.Mid(0+sd,2));
		m_MD2->SetWindowText(s.Mid(3+sd,2));
		m_MD3->SetWindowText(s.Mid(6+sd,2));
		m_MD4->SetWindowText(s.Mid(9+sd,2));
		m_MD5->SetWindowText(s.Mid(12+sd,2));
		m_MD6->SetWindowText(s.Mid(15+sd,2));
	}
	else 
	{
		m_MD1->SetWindowText("");
		m_MD2->SetWindowText("");
		m_MD3->SetWindowText("");
		m_MD4->SetWindowText("");
		m_MD5->SetWindowText("");
		m_MD6->SetWindowText("");
	}
}

void CCaptureWiz::Str2Ip(CString & s)
{
	int ss,sd,n=0;
	CString str=s.Mid(0,10);
	if (str=="(SRC->DST)")
	{
		ss=10;
		for(int i=ss;i<str.GetLength();i++)
		{
			if (str[i]==' ') 
			{
				n++;
				if (n==2)
					{sd=i+1;break;}
			}
		}
		m_Direction.SetCurSel(0);
		OnDirectionChange();
	}
	else if (str=="(SRC->...)")
	{
		ss=10;
		sd=-1;
		m_Direction.SetCurSel(1);
		OnDirectionChange();
	}
	else if (str=="(...->DST)")
	{
		ss=-1;
		sd=10;
		m_Direction.SetCurSel(2);
		OnDirectionChange();
	}
	else if (str=="(HOST<->..")
	{
		ss=12;
		sd=-1;
		m_Direction.SetCurSel(3);
		OnDirectionChange();
	}
	else if (str=="(HOST1<->H")
	{
		ss=15;
		for(int i=ss;i<str.GetLength();i++)
		{
			if (str[i]==' ') 
			{
				n++;
				if (n==2)
					{sd=i+1;break;}
			}
		}
		m_Direction.SetCurSel(4);
		OnDirectionChange();
	}
	if(ss>=0)
	{
		sscanf(((const char*)s)+ss,"%d.%d.%d.%d",&m_IpS1,&m_IpS2,&m_IpS3,&m_IpS4);
		s.Format("%d",m_IpS1);
		m_IS1->SetWindowText(s);
		s.Format("%d",m_IpS2);
		m_IS2->SetWindowText(s);
		s.Format("%d",m_IpS3);
		m_IS3->SetWindowText(s);
		s.Format("%d",m_IpS4);
		m_IS4->SetWindowText(s);
	}
	else 
	{
		m_IS1->SetWindowText("");
		m_IS2->SetWindowText("");
		m_IS3->SetWindowText("");
		m_IS4->SetWindowText("");
	}
	if(sd>=0)
	{
		sscanf(((const char*)s)+sd,"%d.%d.%d.%d",&m_IpD1,&m_IpD2,&m_IpD3,&m_IpD4);
		s.Format("%d",m_IpD1);
		m_ID1->SetWindowText(s);
		s.Format("%d",m_IpD2);
		m_ID2->SetWindowText(s);
		s.Format("%d",m_IpD3);
		m_ID3->SetWindowText(s);
		s.Format("%d",m_IpD4);
		m_ID4->SetWindowText(s);
	}
	else 
	{
		m_ID1->SetWindowText("");
		m_ID2->SetWindowText("");
		m_ID3->SetWindowText("");
		m_ID4->SetWindowText("");
	}
}

int CCaptureWiz::Mac2Str(CString & s)
{
	int dir;
	dir=m_Direction.GetCurSel();

	if (!UpdateData(TRUE)) return 1;
	CString Str;
	if (dir==0 || dir==4)
		s.Format("%02X:%02X:%02X:%02X:%02X:%02X - %02X:%02X:%02X:%02X:%02X:%02X",
		 m_MacS1,m_MacS2,m_MacS3,m_MacS4,m_MacS5,m_MacS6,
		 m_MacD1,m_MacD2,m_MacD3,m_MacD4,m_MacD5,m_MacD6);
	else if (dir==1 || dir==3)
		s.Format("%02X:%02X:%02X:%02X:%02X:%02X",
		 m_MacS1,m_MacS2,m_MacS3,m_MacS4,m_MacS5,m_MacS6);
	else
		s.Format("%02X:%02X:%02X:%02X:%02X:%02X",
		 m_MacD1,m_MacD2,m_MacD3,m_MacD4,m_MacD5,m_MacD6);

	if (dir==0) s="(SRC->DST)"+s;
	else if (dir==1) s="(SRC->...)"+s;
	else if (dir==3) s="(HOST<->...)"+s;
	else if (dir==4) s="(HOST1<->HOST2)"+s;
	else s="(...->DST)"+s;
	return 0;
}

int CCaptureWiz::Ip2Str(CString & s)
{
	int dir;
	dir=m_Direction.GetCurSel();

	if (!UpdateData(TRUE)) return 1;
	CString Str;
	if (dir==0 || dir==4)
		s.Format("%d.%d.%d.%d - %d.%d.%d.%d",
		 m_IpS1,m_IpS2,m_IpS3,m_IpS4,
		 m_IpD1,m_IpD2,m_IpD3,m_IpD4);
	else if (dir==1 || dir==3)
		s.Format("%d.%d.%d.%d",
		 m_IpS1,m_IpS2,m_IpS3,m_IpS4);
	else
		s.Format("%d.%d.%d.%d",
		 m_IpD1,m_IpD2,m_IpD3,m_IpD4);

	if (dir==0) s="(SRC->DST)"+s;
	else if (dir==1) s="(SRC->...)"+s;
	else if (dir==3) s="(HOST<->...)"+s;
	else if (dir==4) s="(HOST1<->HOST2)"+s;
	else s="(...->DST)"+s;
	return 0;
}

void CCaptureWiz::Str2Opt(CString & s)
{
	CString str;
	int i;
	for (i=0;i<s.GetLength();i++)
		if (s[i]==':') {s=s.Right(s.GetLength()-i-1);break;}
	if (sscanf(s,"%d",&m_NumPcks)!=1) m_NumPcks=INT_MAX;
	for (i=0;i<s.GetLength();i++)
		if (s[i]==':') {s=s.Right(s.GetLength()-i-1);break;}
	if (sscanf(s,"%d",&m_SnapLen)!=1) m_SnapLen=INT_MAX;
	if (m_NumPcks>=INT_MAX) str="";
	else str.Format("%d",m_NumPcks);
	m_NPcks->SetWindowText(str);
	if (m_SnapLen>=INT_MAX) str="";
	else str.Format("%d",m_SnapLen);
	m_SLen->SetWindowText(str);
}

int CCaptureWiz::Opt2Str(CString & s)
{
	CString str;
	m_NPcks->GetWindowText(str);
	if (sscanf(str,"%d",&m_NumPcks)!=1) m_NumPcks=UINT_MAX;
	if (m_NumPcks>=INT_MAX) str= CAPWIZ_PNUMINF /*NumeroPacchetti:Infinito*/;
	else str.Format(CAPWIZ_PNUM /*NumeroPacchetti:%d*/,m_NumPcks);
	m_SLen->GetWindowText(s);
	if (sscanf(s,"%d",&m_SnapLen)!=1) m_SnapLen=UINT_MAX;
	if (m_SnapLen>=INT_MAX) s=CAPWIZ_PLENDEF /*LunghezzaPacchetti:Default*/;
	else s.Format(CAPWIZ_PLEN /*LunghezzaPacchetti:%d*/,m_SnapLen);
	s=str+" - "+s;
	return 0;
}

void CCaptureWiz::AddItem(int nItem, int nSubItem, LPCTSTR strItem, int nImageIndex)
{
	LV_ITEM lvItem;
	lvItem.mask = LVIF_TEXT;
	lvItem.iItem = nItem;
	lvItem.iSubItem = nSubItem;
	lvItem.pszText = (LPTSTR) strItem;
	if(nImageIndex != -1){
		lvItem.mask |= LVIF_IMAGE;
		lvItem.iImage = nImageIndex;
	}
	if(nSubItem == 0)
		m_ListCtrl.InsertItem(&lvItem);
	else m_ListCtrl.SetItem(&lvItem);
}

void CCaptureWiz::OnListClick(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int i,n=m_ListCtrl.GetItemCount();
	CString str; 
	int tipo=2;
	for(i=0;i<n;i++)
	{
		if (m_ListCtrl.GetItemState(i,LVIS_SELECTED))
		{
			str=m_ListCtrl.GetItemText(i,0);
			if (str=="MAC") tipo=0;
			else if (str=="IP") tipo=1;
			else tipo=2;
			str=m_ListCtrl.GetItemText(i,1);
			m_CurSel=i;
			break;
		}
	}
	if (i==n) {i=0;str=m_ListCtrl.GetItemText(i,1);}
	if (tipo==0) {m_Tab.SetCurSel(1);OnProtoSelChange(NULL,NULL); Str2Mac(str);}
	else if (tipo==1) {m_Tab.SetCurSel(2);OnProtoSelChange(NULL,NULL);Str2Ip(str);}
	else {m_Tab.SetCurSel(0);OnProtoSelChange(NULL,NULL);Str2Opt(str);}
	if(m_CurSel>0)
	{
		Enable(m_Remove,TRUE);
		Enable(m_Replace,TRUE);
		Enable(m_Add,TRUE);
	}
	else
	{
		Enable(m_Replace,TRUE);
		Enable(m_Remove,FALSE);
		Enable(m_Add,FALSE);
	}
	if (pResult) *pResult = 0;
}

void CCaptureWiz::OnOK() 
{
	CString str,s;
	int flags;
	int i,n=m_ListCtrl.GetItemCount();

	s=m_ListCtrl.GetItemText(0,1);
	for (i=0;i<s.GetLength();i++)
		if (s[i]==':') {s=s.Right(s.GetLength()-i-1);break;}
	if (sscanf(s,"%d",&m_NumPcks)!=1) m_NumPcks=INT_MAX;
	for (i=0;i<s.GetLength();i++)
		if (s[i]==':') {s=s.Right(s.GetLength()-i-1);break;}
	if (sscanf(s,"%d",&m_SnapLen)!=1) m_SnapLen=INT_MAX;
	if (m_NumPcks>=INT_MAX) str="";
	else str.Format("-c %d",m_NumPcks);
	m_Filter=str;
	if (m_SnapLen>=INT_MAX) str="";
	else str.Format(" -s %d",m_SnapLen);
	m_Filter+=str;

	for(i=1;i<n;i++)
	{
		s=m_ListCtrl.GetItemText(i,1);
		str=s.Mid(0,10);
		if (str=="(SRC->DST)")
		{
			flags= 1 | 2;
		}
		else if (str=="(SRC->...)")
		{
			flags=1;
		}
		else if (str=="(...->DST)")
		{
			flags=2;
		}
		else if (str=="(HOST<->..")
		{
			flags=16;
			s=s.Mid(2);
		}
		else if (str=="(HOST1<->H")
		{
			flags=32 | 1 | 2;
			s=s.Mid(5);
		}
		str=s.Mid(10);
		s=m_ListCtrl.GetItemText(i,0);
		if (s=="MAC")
		{
			flags|=4;
		}
		else if (s=="IP")
		{
			flags|=8;
		}
		else continue;
		str.TrimLeft();
		str.TrimRight();
		s=str;
		for(int j=0;j<str.GetLength();j++)
			if (str[j]==' ') {s=str.Left(j);str=str.Mid(j+3);break;}
		if (flags&1||flags&16)s.TrimRight(); else s="";
		if (flags&2)str.TrimLeft(); else str="";
		CString Fs,Fstr;
lab:
		if (flags & 1 && flags & 4)
		{
			Fs=" ether src "+s; 
		}
		else if (flags & 1 && flags & 8)
		{
			Fs=" src host "+s; 
		}
		else if (flags & 16 && flags & 4)
		{
			Fs=" ether host "+s; 
		}
		else if (flags & 16 && flags & 8)
		{
			Fs=" host "+s; 
		}
		if (flags & 1 && flags & 2)
			Fs=Fs+" and";
		if (flags & 2 && flags & 4)
		{
			Fstr=" ether dst "+str; 
		}
		else if (flags & 2 && flags & 8)
		{
			Fstr=" dst host "+str; 
		}
		m_Filter+=(" ("+Fs+Fstr+" )");
		if (flags & 32)
		{
			m_Filter+= " or";
			flags = flags & (~32);
			CString h;
			h=s;
			s=str;
			str=h;
			goto lab;
		}
		if (i<n-1) m_Filter+= " or";
	}
	if (m_Filter!="")
	if (m_Filter[0]==' ')
	 if (m_Filter.GetLength()>1)
		m_Filter=m_Filter.Mid(1);
	 else
		m_Filter="";
	CDialog::EndDialog(IDOK);
}


void CCaptureWiz::OnRemove() 
{
	if(m_CurSel>=0)
		m_ListCtrl.DeleteItem(m_CurSel);
	m_CurSel=0;
	Enable(m_Add,FALSE);
	Enable(m_Replace,TRUE);
	Enable(m_Remove,FALSE);
	m_ListCtrl.SetItemState(0,0xFFFFFFFF,LVIS_SELECTED);
	OnListClick(NULL,NULL);
}
