// HEX.cpp : implementation of DDX_HEX

#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>

void SetHEX(HWND hWnd, DWORD dwHex);
BOOL GetHEX(HWND hWnd, DWORD& dwHex);
void SetHEX(CWnd* pWnd, DWORD dwHex);
BOOL GetHEX(CWnd* pWnd, DWORD& dwHex);

#ifndef ENGLISH
#define HEX_ERR "Il valore immesso non  un valore esadecimale valido"
#else
#define HEX_ERR "Invalid Hexadecimal value"
#endif

/////////////////////////////////////////////////////////////////////////////
// Public functions

void AFXAPI DDX_HEX(CDataExchange* pDX, int nIDC, DWORD& dwHex)
{
	HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
	if (pDX->m_bSaveAndValidate)
	{
		if (!GetHEX(hWndCtrl, dwHex))
		{
			AfxMessageBox(HEX_ERR /*Il valore immesso non  un valore esadecimale valido*/);
			pDX->Fail();
		}
	}
	else
	{
		SetHEX(hWndCtrl, dwHex);
	}
}


BOOL GetHEX(CWnd* pWnd, DWORD& dwHex)
{
	ASSERT(pWnd != NULL);
	return GetHEX(pWnd->m_hWnd, dwHex);
}

BOOL GetHEX(HWND hWnd, DWORD& dwHex)
{
	TCHAR szWindowText[20];
	::GetWindowText(hWnd, szWindowText, 19);
	if (sscanf(szWindowText,"%x",&dwHex)!=1) return FALSE;
	return TRUE;
}


void SetHEX(CWnd* pWnd, DWORD dwHex)
{
	ASSERT(pWnd != NULL);
	SetHEX(pWnd->m_hWnd, dwHex);
}

void SetHEX(HWND hWnd, DWORD dwHex)
{
	CString str;
	str.Format("%X",dwHex);
	::SetWindowText(hWnd, str);
}


