// Analyzer.cpp : Defines the class behaviors for the Analyzer application.
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1995 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

#include "stdafx.h"
#include <CapDll.h>
#include "Analyzer.h"
#include "messages.h"
#include "mytreevw.h"
#include "query.h"
#include <locale.h>
#include <afxcmn.h>
#include "htmlhelp.h"
#include "CQuerySheet.h"
#include "MDISplittedWnd.h"
#include "MDINormalWnd.h"
#include "CRawView.h"
#include "CListView.h"
#include "CommandDlg.h"
#include "GenSetupDlg.h"
#include <console.h>
#include "resource.h"
#include "csvdoc.h"
#include "mytablevw.h"
#include "tbldocument.h"
#include "tblvw.h"

#ifndef ENGLISH
#define MP_SPOGG "Specificare almeno un file oggetto."
#define MP_SPSRC "E' necessario specificare il file sorgente."
#define MP_FUTMODLFF "Il file  stato esaminato con successo"
#define MP_FUTMOD "Queste impostazioni saranno valide a partire dalla prossima analisi"
#define MP_OLEERR "Errore di inizializzazione OLE"
#define MP_STAT "Si vogliono valutare le Statistiche sul documento di catture attivo?"
#define MP_T0 "Selezione del formato delle catture"
#define MP_T0B "Selezione del file creato dalle descrizioni di catture"
#define MP_T1 "Selezione file di Definizione Protocolli"
#define MP_T2 "Selezione file di Descrizione delle Analisi"
#define MP_T3 "Selezione file di Creazione Indice"
#define MP_HELPERR "Impossibile aprire l'aiuto"
#define MP_ERROBJ "Errore nel tentativo di generare il file oggetto."
#define MP_CAPERR "Errori riscontrati"
#define MP_ERRTMP "Impossibile Creare un file temporaneo"
#define MP_AGG "Si vogliono aggiornare anche i file dff ed iff?"
#define ERR_MCO "Il documento  gi aperto. Impossibile aprirne pi copie"
#define ERR_MCC "Impossibile aprire il file contenente gli appunti di Analyzer"
#define CAP_FMT "Catture di Analyzer"
#define CAP_EXT "acp"
#define ERR_EXT "exts.dat"
#define FLTR_FILE_SEC "DAT"
#define ERR_ACC "Impossibile salvare le associazioni"
#define ERR_LFF "Il file LFF  errato"
#define TOO_CMDS "Too many commands"
#define MP_ERRAPP "Impossibile eseguire l'applicazione"
#define MFR_TEMP_ERR "Impossibile Creare un file temporaneo"
#define APP_NONAME "Senza Nome"
#define AN_DELTMP "Si desidera cancellare il file temporaneo: "
#define M_DATFILES "File DAT (*.dat)"
#define M_DATFLT "*.dat"
#else
#define M_DATFILES "DAT files (*.dat)"
#define M_DATFLT "*.dat"
#define MP_ERRAPP "Unable to execute external command"
#define TOO_CMDS "Troppi comandi"
#define MP_SPOGG "You must specify at least an object file."
#define MP_SPSRC "You must specify source file."
#define MP_FUTMODLFF "Input file examined correctly"
#define MP_FUTMOD "These settings will be used from next capture opened"
#define MP_OLEERR "Error opening OLE"
#define MP_STAT "Do you wish to evaluete Statistics on opened capture file?"
#define MP_T0 "Choose Capture Format file"
#define MP_T0B "Choose Capture Object Format file"
#define MP_T1 "Choose Protocol Definition file"
#define MP_T2 "Choose analysis description file"
#define MP_T3 "Choose Index Definition file"
#define MP_HELPERR "Errors opening help"
#define MP_ERROBJ "Errors creating object."
#define MP_CAPERR "Errors encountered"
#define MP_ERRTMP "Errors creating temp. file"
#define MP_AGG "Can I update also dff and iff files?"
#define ERR_MCO "Document already open. Unable to open another copy"
#define ERR_MCC "Unable to open file containing Analyzer Clipboard"
#define CAP_FMT "Analyzer Captures"
#define CAP_EXT "acp"
#define ERR_EXT "exts_e.dat"
#define FLTR_FILE_SEC "DAT_E"
#define ERR_ACC "Unable to save associations"
#define ERR_LFF "LFF file is wrong"
#define MFR_TEMP_ERR "Unable to create a temporary file"
#define APP_NONAME "Untitled"
#define AN_DELTMP "Can Analyzer deletes file: "
#endif

CAnalyzerApp theApp;
CPageSetupDlg dlgPageSetup;

BEGIN_MESSAGE_MAP(CAnalyzerApp, CWinApp)
	//{{AFX_MSG_MAP(CAnalyzerApp)
	ON_COMMAND(ID_CONF_OPEN,OnFileOpen)
	ON_COMMAND(ID_FILE_NEW,OnFileNew)
	ON_COMMAND(ID_FILE_OPEN,OnLogOpen)
	ON_COMMAND(IDM_QRY_NEW,OnQryNew)
	ON_COMMAND(ID_CATTURA_SEL_F_LOG, OnCatturaSelFLog)
	ON_COMMAND(ID_IMPOSTAZIONI_DEFINIZIONIDEIPROTOCOLLI, OnImpDefProts)
	ON_COMMAND(ID_IMPOSTAZIONI_DESCRIZIONIDEIPACCHETTI, OnImpDescPack)
	ON_COMMAND(ID_IMPOSTAZIONI_INDICEDEIPACCHETTI, OnImpIndex)
	ON_COMMAND(IDM_OPEN_QRY, OnOpenQry)
	ON_COMMAND(IDM_LOG_NEW, OnLogNew)
	ON_COMMAND(ID_IMPOSTAZIONI_APRI_CON_ALBERO, OnImpostazioniApriConAlbero)
	ON_UPDATE_COMMAND_UI(ID_IMPOSTAZIONI_APRI_CON_ALBERO, OnUpdateImpostazioniApriConAlbero)
	ON_COMMAND(ID_ASSOCIAZIONI_CATTURE, OnAssociazioniCatture)
	ON_COMMAND(IDM_PERS, OnPersonalizza)
	ON_COMMAND(ID_PAGE_SETUP, OnPageSetup)
	ON_COMMAND(IDM_ORIG_CAP, OnOrigCap)
	ON_UPDATE_COMMAND_UI(IDM_ORIG_CAP, OnUpdateOrigCap)
	ON_COMMAND(IDM_STAT_TABLE, OnStatTable)
	ON_UPDATE_COMMAND_UI(IDM_STAT_TABLE, OnUpdateStatTable)
	ON_COMMAND(IDM_STAT_CSV, OnStatCsv)
	ON_UPDATE_COMMAND_UI(IDM_STAT_CSV, OnUpdateStatCsv)
	ON_COMMAND(IDM_STAT_TBL, OnStatTbl)
	ON_UPDATE_COMMAND_UI(IDM_STAT_TBL, OnUpdateStatTbl)
	ON_COMMAND(IDM_LOG_OPEN,OnLogOpen)
	ON_COMMAND(ID_HELP,OnHelp)
	ON_COMMAND(IDM_TBL_OPEN, OnTblOpen)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
	ON_COMMAND(ID_HELP_INDEX, CWinApp::OnHelpIndex)
	ON_COMMAND(ID_HELP_USING, CWinApp::OnHelpUsing)
	ON_COMMAND(ID_CONTEXT_HELP, CWinApp::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CWinApp::OnHelpIndex)
END_MESSAGE_MAP()

CAnalyzerApp::CAnalyzerApp() 
{
	OpenTree=1;
	OpenOrig=FALSE;
	CapFormats.SetSize(1);
	CapFormats[0]=CAP_FMT;
	CapExts.SetSize(1);
	CapExts[0]=CAP_EXT;
	CapLFF.SetSize(1);
	CapLFF[0]="";
	AskCsv=0;
}

int UpdateFile(CString& f1,CString& f2);

UINT toolbars[]=
{      
	IDR_MAINFRAME,
	IDB_BITMAP2,
	IDR_BMP_1
};

BOOL CAnalyzerApp::InitInstance()
{
	if (!FirstInstance()) return FALSE;

    initiated=FALSE;
	_tsetlocale(LC_ALL, _T(""));

	Enable3dControls();

	// Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(MP_OLEERR /*Errore di inizializzazione OLE*/);
		return FALSE;
	}

    char dir[1000];
    if(GetCurrentDirectory(1000,dir)) Path=dir; else Path="";
    if(Path[Path.GetLength()-1]!='\\') Path+="\\";
	free((void*)m_pszProfileName);
	m_pszProfileName=_tcsdup(Path+"Analyzer.INI");

	LoadStdProfileSettings();

    defTemplate=new CMultiDocTemplate(IDR_TEXTTYPE,
		RUNTIME_CLASS(CPadDoc), RUNTIME_CLASS(CMDINormalWnd),
		RUNTIME_CLASS(CMultiView));
	roTemplate=new CMultiDocTemplate(IDR_TEXTTYPE,
		RUNTIME_CLASS(CPadDoc), RUNTIME_CLASS(CMDINormalWnd),
		RUNTIME_CLASS(CMultiView));
	logTreeTemplate=new CMultiDocTemplate(IDR_TEXTTYPE2,
		RUNTIME_CLASS(CLogDocument), RUNTIME_CLASS(CMDISplittedWnd),
		RUNTIME_CLASS(CMyTreeView));
	logListTemplate=new CMultiDocTemplate(IDR_TEXTTYPE2,
		RUNTIME_CLASS(CLogDocument), RUNTIME_CLASS(CMDISplittedWnd),
		RUNTIME_CLASS(CListAllView));
	logRawTemplate=new CMultiDocTemplate(IDR_TEXTTYPE2,
		RUNTIME_CLASS(CLogDocument), RUNTIME_CLASS(CMDISplittedWnd),
		RUNTIME_CLASS(CRawView));
	logTemplate=new CMultiDocTemplate(IDR_TEXTTYPE2,
		RUNTIME_CLASS(CLogDocument), RUNTIME_CLASS(CMDINormalWnd),
		RUNTIME_CLASS(CMultiView));
	csvTemplate=new CMultiDocTemplate(IDR_TEXTTYPE2,
		RUNTIME_CLASS(CCsvDocument), RUNTIME_CLASS(CMDINormalWnd),
		RUNTIME_CLASS(CMyTableView));
	tblTemplate=new CMultiDocTemplate(IDR_TEXTTYPE2,
		RUNTIME_CLASS(CTblDocument), RUNTIME_CLASS(CMDINormalWnd),
		RUNTIME_CLASS(CTblView));
	AddDocTemplate(defTemplate);
	AddDocTemplate(roTemplate);
	AddDocTemplate(logTreeTemplate);
	AddDocTemplate(logRawTemplate);
	AddDocTemplate(logListTemplate);
	AddDocTemplate(logTemplate);
	AddDocTemplate(csvTemplate);
	AddDocTemplate(tblTemplate);
	log=NULL;

	
	m_pMainWnd = new CMainFrame;
	((CFrameWnd*)m_pMainWnd)->LoadFrame(IDR_MAINFRAME);
	m_pMainWnd->ShowWindow(m_nCmdShow);

	// enable file manager drag/drop and DDE Execute open
	m_pMainWnd->DragAcceptFiles();
	EnableShellOpen();
	RegisterShellFileTypes(TRUE);

	// Menu Setup 
	m_MainMenu.LoadMenu(IDR_VOIDMENU);
	m_TxtMenu.LoadMenu(IDR_TXTMENU);
	m_CapMenu.LoadMenu(IDR_CAPMENU);
	m_TblMenu.LoadMenu(IDR_TBLMENU);

	LoadCmds();
	SetupMenu(&m_MainMenu,"MainMenu");
	SetupAppMenu(&m_MainMenu);
	SetupMenu(&m_TxtMenu,"TxtMenu");
	SetupAppMenu(&m_TxtMenu);
	SetupMenu(&m_CapMenu,"CapMenu");
	SetupAppMenu(&m_CapMenu);
	SetupMenu(&m_TblMenu,"TblMenu");
	SetupAppMenu(&m_TblMenu);

	m_MainMenu.LoadToolbars(toolbars,3);
	m_TxtMenu.LoadToolbars(toolbars,3);
	m_CapMenu.LoadToolbars(toolbars,3);
	m_TblMenu.LoadToolbars(toolbars,3);

	((CMainFrame*)m_pMainWnd)->RefreshMenu();

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (cmdInfo.m_nShellCommand!=CCommandLineInfo::FileNew)
	 {
  	  if (!ProcessShellCommand(cmdInfo))
		return FALSE;
	 }
	 else
     {
	  CString s=GetProfileString("Settings","CreateTxtDoc");
      max=TRUE;
	  if (s!="")
	  {
       POSITION p=GetFirstDocTemplatePosition();
       CDocTemplate* t=GetNextDocTemplate(p);
       t->OpenDocumentFile(NULL);
	  }
     }
    initiated=TRUE;
    logdocument=NULL;
	m_pdf = GetProfileString("Settings","PDF");
	if (m_pdf=="") m_pdf=Path+"default.pdf";
	m_iff = GetProfileString("Settings","IFF");
	if (m_iff=="") m_iff=Path+"default.iff";
	m_dff = GetProfileString("Settings","DFF");
	if (m_dff=="") m_dff=Path+"default.dff";

	m_lfo = GetProfileString("Settings","LFO");
	if (m_lfo=="") m_lfo=Path+"Objects\\default.lfo";
	m_pdo = GetProfileString("Settings","PDO");
	if (m_pdo=="") m_pdo=Path+"Objects\\default.pdo";
	m_ifo = GetProfileString("Settings","IFO");
	if (m_ifo=="") m_ifo=Path+"Objects\\default.ifo";
	m_dfo = GetProfileString("Settings","DFO");
	if (m_dfo=="") m_dfo=Path+"Objects\\default.dfo";
	m_TmpDat = GetProfileString("Settings","TmpDat","TmpList.dat");
	m_Clipboard = GetProfileString("Settings","Clipboard");
	DefinedFont = GetProfileString("Settings","Font");
	if (DefinedFont=="") DefinedFont="Analyzer";
	DefinedDim = GetProfileInt("Settings","FontDim",100);
	m_PlotApp = GetProfileString("Settings","PlotApp","wgnuplot");
	if (m_PlotApp[1]!=':') m_PlotApp=Path+m_PlotApp;
	CString h;
	h = GetProfileString("Settings","CsvSep","3B");
	CsvSep=';';
	int y;
	if(sscanf(h,"%x",&y)==1) CsvSep=(char)y;
	if (m_Clipboard=="") m_Clipboard=Path+"Objects\\clipboard.acp";
	remove(m_Clipboard);

	if (m_pdf[1]!=':') m_pdf=Path+m_pdf;
	if (m_iff[1]!=':') m_iff=Path+m_iff;
	if (m_dff[1]!=':') m_dff=Path+m_dff;
	if (m_lfo[1]!=':') m_lfo=Path+m_lfo;
	if (m_pdo[1]!=':') m_pdo=Path+m_pdo;
	if (m_ifo[1]!=':') m_ifo=Path+m_ifo;
	if (m_dfo[1]!=':') m_dfo=Path+m_dfo;
	if (m_TmpDat[1]!=':') m_TmpDat=Path+m_TmpDat;
	DeleteAllTemps();

	AskCsv = GetProfileInt("Settings","AskCSV",0);
	m_IndexSep = GetProfileString("Settings","IndexSep","20");

	InitCapDll(m_pszProfileName);
	m_CapDll.SetPath(Path);

	LoadCapFormats();
	dlgPageSetup.Initialize();

	// Verifica delle versioni dei file
	if (UpdateFile(m_pdf,m_pdo)) SelProtos(m_pdf,m_pdo,0,1);
	if (UpdateFile(m_pdo,m_dfo)) SelDFF(m_dff,m_dfo,0,1);
	if (UpdateFile(m_pdo,m_ifo)) SelIFF(m_iff,m_ifo,0,1);
	if (UpdateFile(m_dff,m_dfo)) SelDFF(m_dff,m_dfo,0,1);
	if (UpdateFile(m_iff,m_ifo)) SelIFF(m_iff,m_ifo,0,1);

	return TRUE;
}

extern const char* szAnalyzerClass;

BOOL CAnalyzerApp::FirstInstance()
{                                       
	CString strCaption;
	strCaption.LoadString(AFX_IDS_APP_TITLE);

	CWnd* pwndFirst = CWnd::FindWindow(szAnalyzerClass, 
									   NULL/*strCaption*/);
	if (pwndFirst)
	{
		// another instance is already running - activate it
		CWnd* pwndPopup = pwndFirst->GetLastActivePopup();								   
		pwndFirst->SetForegroundWindow();
		if (pwndFirst->IsIconic())
			pwndFirst->ShowWindow(SW_SHOWNORMAL);
		if (pwndFirst != pwndPopup)
			pwndPopup->SetForegroundWindow(); 
		return FALSE;			
	}
	else
	{   
		// this is the first instance  
		return TRUE;
	}
}	

void CAnalyzerApp::OnFileOpen()
{
    POSITION p=GetFirstDocTemplatePosition();
    CDocTemplate* pTemplate1=GetNextDocTemplate(p);
    CDocTemplate* pTemplate=GetNextDocTemplate(p);

	CFileDialog dlgFile(TRUE);

	CString title=M_OPEN;
	CString fileName;
    UINT nIDSTitle=AFX_IDS_OPENFILE;
    DWORD lFlags=OFN_HIDEREADONLY | OFN_FILEMUSTEXIST;
    BOOL bOpenFileDialog=TRUE;

	dlgFile.m_ofn.Flags |= lFlags;

	CString strFilter="";
	strFilter += M_TEXTFILES;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_TXTFLT);
	strFilter += (TCHAR)'\0';   // last string
	strFilter += "File LFF (*.lff)";
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.lff");
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += "File DFF (*.pdf)";
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.pdf");
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += "File DFF (*.dff)";
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.dff");
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += "File DFF (*.iff)";
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.iff");
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += "File DFF (*.mac)";
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.mac");
	strFilter += (TCHAR)'\0';   // next string please
	CString strDefault;
	// append the '*.*' all files filter
	CString allFilter;
	VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	strFilter += allFilter;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_ALLFLT);
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	BOOL bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	fileName.ReleaseBuffer();

    if (bResult)
     {
	  CFileStatus rStatus;
	  CFile f;
	  if(!f.GetStatus((LPCTSTR)fileName,rStatus )) AfxMessageBox(E_RDATTR);
	  DWORD d=GetFileAttributes(rStatus.m_szFullName);
	  CPadDoc* pad;
	  if (d&FILE_ATTRIBUTE_READONLY)
        pad=(CPadDoc*) pTemplate->OpenDocumentFile(fileName);
      else pad=(CPadDoc*) pTemplate1->OpenDocumentFile(fileName);
	  if (pad) pad->m_IsConf=TRUE;
     }
}


void CAnalyzerApp::OnFileNew()
{
    POSITION p=GetFirstDocTemplatePosition();
    CDocTemplate* t=GetNextDocTemplate(p);
    t->OpenDocumentFile(NULL);
}

int CAnalyzerApp::CreateRoDoc(CString title,CString s)
    {
        CDocument* t=roTemplate->OpenDocumentFile(NULL);
        if(title!="")t->SetTitle (title);
        POSITION p=t->GetFirstViewPosition();
        CMultiView *v=(CMultiView*)t->GetNextView(p);
        v->NewFromStrings(s);
        return 0;
    }

int CAnalyzerApp::CreateCsvDoc(CString title,CString s)
    {
        CCsvDocument* t=(CCsvDocument*)csvTemplate->OpenDocumentFile(NULL);
        if(title!="")t->SetTitle (title);
        POSITION p=t->GetFirstViewPosition();
        CTableView *v=(CTableView*)t->GetNextView(p);
		LineCollection lc(&s);
        t->NewFromLC(lc);
		if (t->IsInit) return 0;
		t->Close();
		return 1;
    }

void CAnalyzerApp::OnLogOpen()
{
	CFileDialog dlgFile(TRUE);

	CString title=M_OPEN;
	CString fileName;
    UINT nIDSTitle=AFX_IDS_OPENFILE;
    DWORD lFlags=OFN_HIDEREADONLY | OFN_FILEMUSTEXIST;
    BOOL bOpenFileDialog=TRUE;

	dlgFile.m_ofn.Flags |= lFlags;

/*	CString strFilter="Files cap (*.cap)";
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.cap");
	strFilter += (TCHAR)'\0';   // last string
	strFilter += M_LOGFILES;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_LOGFLT);
	strFilter += (TCHAR)'\0';   // last string*/

	CString strFilter,str;
	for(int i=0;i<CapFormats.GetSize();i++)
	{
		str.Format("%s (*.%s)",CapFormats[i],CapExts[i]);
		strFilter += str;
		strFilter += (TCHAR)'\0';
		strFilter += "*.";
		strFilter += CapExts[i];
		strFilter += (TCHAR)'\0';
	}
	CString strDefault;
	// append the '*.*' all files filter
	CString allFilter;
	VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	strFilter += allFilter;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_ALLFLT);
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	BOOL bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	fileName.ReleaseBuffer();
    if (bResult)
     {
		CString str=dlgFile.GetFileExt();
		CString str2;
		for (int j=0;j<CapFormats.GetSize();j++)
		{
			if (!str.CompareNoCase(CapExts[j]))
			{
				str2=CapLFF[j];
				break;
			}
		}
		if (str2=="") WriteHdr(fileName);
		CString s1,s2;
		s2="";
		char tmp[2];
		tmp[1]='\0';
		for(int h=0;h<fileName.GetLength();h++)
		{
			if (fileName[h]=='/') s2+="\\"; 
			else
			{
				tmp[0]=fileName[h];
				s2+=tmp;
			}
		}
		POSITION pos;
		pos=logTemplate->GetFirstDocPosition();
		CDocument* log;
		for(int jj=0;jj<2;jj++)
		{
		 while(pos!=NULL)
		 {
			log=logTemplate->GetNextDoc(pos);
			s1=log->GetPathName();
			if (!s1.CompareNoCase(s2)) 
			{
				AfxMessageBox(ERR_MCO /*Il documento  gi aperto. Impossibile aprirne pi copie*/);
				return;
			}
		 }
		 pos=logTreeTemplate->GetFirstDocPosition();
		}
		s1=m_Clipboard;
		if (!s1.CompareNoCase(s2)) 
			{
				AfxMessageBox(ERR_MCC);
				return;
			}
		OpenLog(fileName,0,str2);
     }
}

void CAnalyzerApp::OnQryNew()
{
    // New Query Wizard
    CQuerySheet QuerySht;
	CDocument *l=((CMDIFrameWnd*)m_pMainWnd)->GetActiveDocument();
	if (l==NULL)
		{
			CMDIChildWnd* child=((CMDIFrameWnd*)m_pMainWnd)->MDIGetActive();
			if (child) l=child->GetActiveDocument(); else l=NULL;
		}

	if (l && l->IsKindOf(RUNTIME_CLASS(CLogDocument)))
		QuerySht.m_pDoc=(CLogDocument*) l;
	else 
		QuerySht.m_pDoc=NULL;
    qsp=&QuerySht;
    QuerySht.SetWizardMode();
    QuerySht.DoModal();
    if (qsp==NULL)
     {
      QuerySht.SaveToDisk();
	  CMainFrame* f=(CMainFrame*)m_pMainWnd;
	  BOOL b;
	  CLogDocument* d;
	  d=(CLogDocument*)f->GetCompatibleDoc(logTreeTemplate,b);
	  if (!b) d=(CLogDocument*)f->GetCompatibleDoc(logTemplate,b);
	  if (d!=NULL)
	  {
		if (AfxMessageBox(MP_STAT /*Si vogliono valutare le Statistiche sul documento di catture attivo?*/,MB_YESNO)==IDNO)
			d=NULL;
		else
		{
			d->LogQuery(QuerySht.GetName());
		}
	  }
	  if (d==NULL)
	  {
       POSITION p=GetFirstDocTemplatePosition();
	   CPadDoc* pad;
       CDocTemplate* t=GetNextDocTemplate(p);
       pad=(CPadDoc*)t->OpenDocumentFile(QuerySht.GetName());
	   if(pad) pad->m_IsQry=TRUE;
	  }
     }
	if (QuerySht.GetCreateFile()==0) 
		remove(QuerySht.GetName());
}

CLogDocument* CAnalyzerApp::OpenLog(const char * fileName, int IsTemp, const char* lff)
{
	  CString str;
  	  CString s;
	  if (lff!=NULL && lff[0]!='\0')
	  {
		str=lff;
	    if (str.GetLength()>=2 && str[1]!=':') str=Path+str;
		SelFLog(str,m_lfo,0,1);
		if (m_lff!=str) {AfxMessageBox(ERR_LFF /*Il file LFF  errato*/);return NULL;}
	  }
	  else m_lff="";
	  CString ext=".acp";
	  for (int ii=strlen(fileName)-1;ii>=0;ii--)
		if (fileName[ii]=='.') {ext=fileName+ii;break;}
	  if (!OpenOrig && IsTemp==0)
		{
			str=theApp.GetTempFile(ext);
			if (str=="") {return NULL;}
			if (CopyFile(fileName,str,0)==0){AfxMessageBox(MFR_TEMP_ERR /*Impossibile Creare un file temporaneo*/);return NULL;}
			IsTemp=1;
		}
	  else str=fileName;
	  if (OpenTree)
		log=logTreeTemplate->OpenDocumentFile(str);
	  else 
		log=logTemplate->OpenDocumentFile(str);
      if(logdocument && logdocument->erroropening)
      {
        logdocument->Close();
        return NULL;
	  }
      CLogDocument* l =  (CLogDocument*) log;
	  if (l)
	  {
	    if (!OpenOrig) l->IsCopy=TRUE;
		if (l->lfName!=NULL) delete[]l->lfName;
		l->lfName=new char[strlen(fileName)+1];
		strcpy (l->lfName,fileName);
		CString s=fileName;
		int i,j;
		for(i=strlen(fileName)-1,j=0;i>=0;i--,j++)
			if (s[i]=='\\' || s[i]=='/') {s=s.Right(j);break;}
		if (l->m_IsCapTmp) s=APP_NONAME;
		log->SetTitle(E_LOGTITLE+s);
		if (log!=NULL) LogOpened=1; else LogOpened=0;
		l->SetTemp(IsTemp,fileName);
	  }
	  return l;
}

void CAnalyzerApp::OnCatturaSelFLog() 
{
	CGenSetupDlg dlg;
	dlg.m_Flt1="*.lfo";
	dlg.m_Flt2="*.lfo";
	dlg.m_File1="Files lfo (*.lfo)";
	dlg.m_File2="Files lfo (*.lfo)";
	dlg.m_F1=m_lfo;
	dlg.m_F2=m_lfo;
	dlg.m_Title=MP_T0B; //Selezione del formato delle catture*/
	dlg.m_AdvSimple=TRUE;
	if (dlg.DoModal()!=IDOK) return;
	SelFLog(m_lff,dlg.m_F1,1);
}

void CAnalyzerApp::OnImpDefProts() 
{
	CGenSetupDlg dlg;
	dlg.m_Flt1="*.pdf";
	dlg.m_Flt2="*.pdo";
	dlg.m_File1="Files pdf (*.pdf)";
	dlg.m_File2="Files pdo (*.pdo)";
	dlg.m_F1=m_pdf;
	dlg.m_F2=m_pdo;
	dlg.m_Title=MP_T1 /*Selezione file di Definizione Protocolli*/;
	if (dlg.DoModal()!=IDOK) return;
	SelProtos(dlg.m_F1,dlg.m_F2,dlg.m_IsAdvanced);
}

void CAnalyzerApp::OnImpDescPack() 
{
	CGenSetupDlg dlg;
	dlg.m_Flt1="*.dff";
	dlg.m_Flt2="*.dfo";
	dlg.m_File1="Files dff (*.dff)";
	dlg.m_File2="Files dfo (*.dfo)";
	dlg.m_F1=m_dff;
	dlg.m_F2=m_dfo;
	dlg.m_Title=MP_T2 /*Selezione file di Descrizione delle Analisi*/;
	if (dlg.DoModal()!=IDOK) return;
	SelDFF(dlg.m_F1,dlg.m_F2,dlg.m_IsAdvanced);
}

void CAnalyzerApp::OnImpIndex() 
{
	CGenSetupDlg dlg;
	dlg.m_Flt1="*.iff";
	dlg.m_Flt2="*.ifo";
	dlg.m_File1="Files iff (*.iff)";
	dlg.m_File2="Files ifo (*.ifo)";
	dlg.m_F1=m_iff;
	dlg.m_F2=m_ifo;
	dlg.m_Title=MP_T3 /*Selezione file di Creazione Indice*/;
	if (dlg.DoModal()!=IDOK) return;
	SelIFF(dlg.m_F1,dlg.m_F2,dlg.m_IsAdvanced);
}

int CAnalyzerApp::ExecuteApp(CString & s)
{
	int r;
	HANDLE in,out,err;
	HANDLE proc;
	DWORD dwProcessId;
	int l=0;
	r=ExecuteProgram ((const char*)s,&in,&out,&err,&proc,&dwProcessId);
	if (r) {AfxMessageBox(MP_ERROBJ /*Errore nel tentativo di generare il file oggetto.*/);return 1;}
	BOOL b;
	DWORD d=1;
	s="";
	if(d)
	{
		char t2[1000];
		do
		{
		 b=ReadFile(out,t2,998,&d,NULL);
		 t2[d]='\0';
		 s+=t2;
		} while (b);
		do
		{
		 b=ReadFile(err,t2,998,&d,NULL);
		 t2[d]='\0';
		 s+=t2;
		} while (b);
		d=WaitExit(proc);
		if (d)
		{
		 CreateRoDoc(MP_CAPERR /*Errori riscontrati nella cattura*/,s);
		 CloseHandle(in);
		 CloseHandle(out);
		 CloseHandle(err);
		 return 1;
		}
	}
	CloseHandle(in);
	CloseHandle(out);
	CloseHandle(err);
	return 0;
}

int CAnalyzerApp::ExitInstance()
{
	 //WriteProfileString("Settings","LFF",m_lff);
	 WriteProfileString("Settings","PDF",m_pdf);
	 WriteProfileString("Settings","IFF",m_iff);
	 WriteProfileString("Settings","DFF",m_dff);
	 WriteProfileString("Settings","LFO",m_lfo);
	 WriteProfileString("Settings","PDO",m_pdo);
	 WriteProfileString("Settings","IFO",m_ifo);
	 WriteProfileString("Settings","DFO",m_dfo);
	 dlgPageSetup.Terminate();
	 return CWinApp::ExitInstance();
}

void CAnalyzerApp::OnOpenQry() 
{
    POSITION p=GetFirstDocTemplatePosition();
    CDocTemplate* pTemplate1=GetNextDocTemplate(p);
    CDocTemplate* pTemplate=GetNextDocTemplate(p);

	CFileDialog dlgFile(TRUE);

	CString title=M_OPEN;
	CString fileName;
    UINT nIDSTitle=AFX_IDS_OPENFILE;
    DWORD lFlags=OFN_HIDEREADONLY | OFN_FILEMUSTEXIST;
    BOOL bOpenFileDialog=TRUE;

	dlgFile.m_ofn.Flags |= lFlags;

	CString strFilter="File QRY (*.stt)";
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.stt");
	strFilter += (TCHAR)'\0';   // next string please
	CString strDefault;
	// append the '*.*' all files filter
	CString allFilter;
	VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	strFilter += allFilter;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_ALLFLT);
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	BOOL bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	fileName.ReleaseBuffer();

    if (bResult)
     {
	  CFileStatus rStatus;
	  CFile f;
	  if(!f.GetStatus((LPCTSTR)fileName,rStatus )) AfxMessageBox(E_RDATTR);
	  DWORD d=GetFileAttributes(rStatus.m_szFullName);
	  CPadDoc* pad;
	  if (d&FILE_ATTRIBUTE_READONLY)
        pad=(CPadDoc*)pTemplate->OpenDocumentFile(fileName);
      else pad=(CPadDoc*)pTemplate1->OpenDocumentFile(fileName);
	  if(pad) pad->m_IsQry=TRUE;
     }
}

const char* UINT2charp(UINT message);

void CAnalyzerApp::WinHelp( DWORD dwData, UINT nCmd)
{
#ifdef NOHTMLHELPBUG
	CWnd* pMainWnd = AfxGetMainWnd();
	if (::HtmlHelp(pMainWnd->m_hWnd,Path+"analyzer.chm",0, (DWORD) UINT2charp(dwData))==INVALID_HANDLE_VALUE)
		AfxMessageBox(MP_HELPERR /*Impossibile aprire l'aiuto*/);
#else
    STARTUPINFO si;
    PROCESS_INFORMATION pip;
    ZeroMemory(&si,sizeof(si));
    si.cb=sizeof(si);
    BOOL b;
    char directory[1000],t1[1000];
    GetWindowsDirectory(t1,1000);
    if(t1[strlen(t1)-1]=='\\') t1[strlen(t1)-1]='\0';
    strcpy(t1+strlen(t1),"\\hh.exe");
    GetCurrentDirectory(1000,directory);
	CString s=UINT2charp(dwData);
	s="hh "+Path +"analyzer.chm::/"+s;
    b=CreateProcess(t1,(char*)(const char*)s,NULL,NULL,
                    FALSE,0,NULL,
                    directory,&si,&pip);
	if(!b) AfxMessageBox(MP_HELPERR /*Impossibile aprire l'aiuto*/);
#endif
}

BCMenu* CAnalyzerApp::SetupAppMenu(BCMenu * pTopMenu)
{
	int iPos;
	BCMenu* pMenu,uMenu;
	UINT nID;
	int nadd=0;
	int nMenu=pTopMenu->GetMenuItemCount();
	for (iPos = nMenu-1; iPos >= 0; iPos--)
	{
			if (pMenu = pTopMenu->GetSubMenu(iPos))
			{
				nID=pMenu->GetMenuItemID(0);
				if (nID!=ID_UTILIT_APP1) pMenu=NULL;
					else {pMenu->DeleteMenu(0,MF_BYPOSITION);break;}
			}
	}
	if (pMenu==NULL) return NULL;
	for(int n=0;n<10;n++)
		if (cmds[n]!="" && mnus[n]!="") 
		{
			//pMenu->AppendMenu(MF_STRING,ID_UTILIT_APP1+n,mnus[n]);
			pMenu->AppendODMenu(mnus[n],MF_OWNERDRAW,ID_UTILIT_APP1+n);
			nadd++;
		}
	if (!nadd) pTopMenu->DeleteMenu(iPos,MF_BYPOSITION);
	return pMenu;
}

BCMenu* CAnalyzerApp::SetupMenu(BCMenu * pTopMenu, const char * section)
{
	BCMenu* pCurMenu = NULL;
	int iPos;
	BCMenu* pMenu;
	int LastSep;
	int nMenu=pTopMenu->GetMenuItemCount();
	int nPrev=0;
	LastSep=-1;
	for (iPos = nMenu-1; iPos >= 0; iPos--)
	{
			if (pMenu = pTopMenu->GetSubMenu(iPos))
			{
				if (!SetupMenu(pMenu,section))
				{
					pTopMenu->DeleteMenu(iPos,MF_BYPOSITION);
					nMenu--;
				}
				else nPrev++;
			}
			else  
			{
				UINT nID=pTopMenu->GetMenuItemID(iPos);
				if (nID==ID_SEPARATOR)
				{
					if (nPrev==0)
					{
						pTopMenu->DeleteMenu(iPos,MF_BYPOSITION);
						//iPos--;
						nMenu--;
					}
					else 
					{
						nPrev=0;
						LastSep=iPos;
					}
				}
				else
				{
					CString str;
					str.Format("ID_%d",nID);
					UINT t;
					t=GetProfileInt(section,str,1);
					if (!t) 
					{
						pTopMenu->DeleteMenu(iPos,MF_BYPOSITION);
						nMenu--;
					}
					else
					{
						nPrev++;
						LastSep=-1;
					}
				}
			}
	}
	if (LastSep>=0 && pTopMenu->GetMenuItemID(0)==ID_SEPARATOR) 
		pTopMenu->DeleteMenu(0,MF_BYPOSITION);
	nMenu=pTopMenu->GetMenuItemCount();
	if (nMenu>0 && pTopMenu->GetMenuItemID(nMenu-1)==ID_SEPARATOR)
	{
		pTopMenu->DeleteMenu(nMenu-1,MF_BYPOSITION);
		nMenu--;
	}
	if (nMenu==0) return NULL;
	return pTopMenu;
}

typedef struct _Taghdr
{
	DWORD magic;
	WORD n1;
	WORD n2;
	DWORD d1;
	DWORD d2;
	DWORD s;
	DWORD lt;
} Hdr;

Hdr hdr={0xa1b2c3d4,2,4,0,0,0xffff,1}; 

void CAnalyzerApp::OnLogNew() 
{
	CString CapFile;
	CapFile=theApp.GetTempFile(".acp");
	if (CapFile=="") {return;}
	WriteHdr(CapFile);
	CString s;
	CAnalyzerApp* app=(CAnalyzerApp*)AfxGetApp();
	CLogDocument* log=app->OpenLog(CapFile,1);
	s=APP_NONAME;
	if (log)
	{
		log->SetTitle(E_LOGTITLE+s);
		log->m_IsNewTmp=TRUE;
	}
}

void CAnalyzerApp::WriteHdr(const char* CapFile)
{
	FILE* f=fopen(CapFile,"r");
	if(f!=NULL)
	{
		fseek(f,0,SEEK_END);
		long l=ftell(f);
		fclose(f);
		if (l) return;
	}
	f=fopen( CapFile,"wb");   
	fwrite (&hdr,sizeof(hdr),1,f);
	fclose(f);
}

void CAnalyzerApp::SetLinkType(int l)
{
	hdr.lt=l;
}

void CAnalyzerApp::SelFLog(CString & m_F1,CString & m_F2, int m_IsAdvanced,int silent)
{
	CString s;

	if (m_F2=="")
		if(m_IsAdvanced) {AfxMessageBox(MP_SPOGG /*Specificare almeno un file oggetto.*/);return;}
		else m_F2=m_lfo;
#ifndef ENGLISH
	s=Path+"fdreader \""+ m_F1+ "\" \""+ m_F2+ "\"";
#else
	s=Path+"fdreader_e \""+ m_F1+ "\" \""+ m_F2+ "\"";
#endif
	if(m_F1!="")
	{
		int i=ExecuteApp(s);
		if (i) return;
	}
	else if (!m_IsAdvanced)
	{
		AfxMessageBox(MP_SPSRC /*E' necessario specificare il file sorgente.*/);
		return;
	}
	m_lff=m_F1;
	m_lfo=m_F2;
	if (!silent)
		AfxMessageBox(MP_FUTMODLFF /*Queste impostazioni saranno valide a partire dalla prossima analisi*/);
}

void CAnalyzerApp::SelProtos(CString & m_F1, CString & m_F2, int m_IsAdvanced, int Silent)
{
	CString s;

	if (m_F2=="")
		if(m_IsAdvanced) {AfxMessageBox(MP_SPOGG /*Specificare almeno un file oggetto.*/);return;}
		else m_F2=m_pdo;
#ifndef ENGLISH
	s=Path+"pdreader \""+ m_F1+ "\" \""+ m_F2+ "\"";
#else
	s=Path+"pdreader_e \""+ m_F1+ "\" \""+ m_F2+ "\"";
#endif
	if(m_F1!="")
	{
		int i=ExecuteApp(s);
		if (i) return;
	}
	else if (!m_IsAdvanced)
	{
		AfxMessageBox(MP_SPSRC /*E' necessario specificare il file sorgente.*/);
		return;
	}
	m_pdf=m_F1;
	m_pdo=m_F2;
	if (Silent || AfxMessageBox(MP_AGG /*Si vogliono aggiornare anche i file dff ed iff?*/, MB_YESNO)==IDYES)
	{
		int i;
#ifndef ENGLISH
		s=Path+"ddreader \""+ m_dff+ "\" \""+ m_dfo + "\" \"" + m_pdo + "\"";
#else
		s=Path+"ddreader_e \""+ m_dff+ "\" \""+ m_dfo + "\" \"" + m_pdo + "\"";
#endif
		i=ExecuteApp(s);
		if (i) return;
#ifndef ENGLISH
		s=Path+"ddreader \""+ m_iff+ "\" \""+ m_ifo + "\" \"" + m_pdo + "\"";
#else
		s=Path+"ddreader_e \""+ m_iff+ "\" \""+ m_ifo + "\" \"" + m_pdo + "\"";
#endif
		i=ExecuteApp(s);
		if (i) return;
	}
	if (!Silent) AfxMessageBox(MP_FUTMOD /*Queste impostazioni saranno valide a partire dalla prossima analisi*/);
}

void CAnalyzerApp::SelDFF(CString & m_F1, CString & m_F2, int m_IsAdvanced, int Silent)
{
	CString s;

	if (m_F2=="")
		if (m_IsAdvanced) {AfxMessageBox(MP_SPOGG /*Specificare almeno un file oggetto.*/);return;}
		else m_F2=m_dfo;
#ifndef ENGLISH
	s=Path+"ddreader \""+ m_F1+ "\" \""+ m_F2+ "\" \"" + m_pdo + "\"";
#else
	s=Path+"ddreader_e \""+ m_F1+ "\" \""+ m_F2+ "\" \"" + m_pdo + "\"";
#endif
	if(m_F1!="")
	{
		int i=ExecuteApp(s);
		if (i) return;
	}
	else if (!m_IsAdvanced)
	{
		AfxMessageBox(MP_SPSRC /*E' necessario specificare il file sorgente.*/);
		return;
	}
	m_dff=m_F1;
	m_dfo=m_F2;
	if (!Silent)AfxMessageBox(MP_FUTMOD /*Queste impostazioni saranno valide a partire dalla prossima analisi*/);
}

void CAnalyzerApp::SelIFF(CString & m_F1, CString & m_F2, int m_IsAdvanced, int Silent)
{
	CString s;

	if (m_F2=="")
		if(m_IsAdvanced) {AfxMessageBox(MP_SPOGG /*Specificare almeno un file oggetto.*/);return;}
		else m_F2=m_ifo;
#ifndef ENGLISH
	s=Path+"ddreader \""+ m_F1+ "\" \""+ m_F2+ "\" \"" + m_pdo + "\"";
#else
	s=Path+"ddreader_e \""+ m_F1+ "\" \""+ m_F2+ "\" \"" + m_pdo + "\"";
#endif
	if(m_F1!="")
	{
		int i=ExecuteApp(s);
		if (i) return;
	}
	else if (!m_IsAdvanced)
	{
		AfxMessageBox(MP_SPSRC /*E' necessario specificare il file sorgente.*/);
		return;
	}
	m_iff=m_F1;
	m_ifo=m_F2;
	if(!Silent)AfxMessageBox(MP_FUTMOD /*Queste impostazioni saranno valide a partire dalla prossima analisi*/);
}

void CAnalyzerApp::OnImpostazioniApriConAlbero() 
{
	if (OpenTree) OpenTree=0;
	else OpenTree=1;
}

void CAnalyzerApp::OnUpdateImpostazioniApriConAlbero(CCmdUI* pCmdUI) 
{
	if (OpenTree) pCmdUI->SetCheck(TRUE);
	else pCmdUI->SetCheck(FALSE);
}


void CAnalyzerApp::LoadCapFormats()
{
	CString m_FileName;
	m_FileName=GetProfileString(FLTR_FILE_SEC, "Exts", 
		Path+ERR_EXT);
	if(m_FileName[1]!=':') 
		m_FileName=Path+m_FileName;
	FILE* f;
	f=fopen(m_FileName,"r");
	int c=0;
	if (f)
	{
		char t[1000];
		CapFormats.SetSize(1);
		CapExts.SetSize(1);
		CapLFF.SetSize(1);
		CString tmp,tmp2;
		while (fgets(t,1998,f))
		{
			if (t[strlen(t)-1]=='\n') t[strlen(t)-1]='\0';
			tmp="";
			for (int i=0;i<(signed)strlen(t);i++) 
				if (t[i]==';') 
				{
					t[i]='\0'; 
					tmp2=t;
					tmp2.TrimRight();
					tmp=(t+i+1); 
					tmp.TrimLeft(); 
					strcpy(t,tmp);
					for (int j=0;j<(signed)strlen(t);j++) 
						if (t[j]==';') 
						{
							t[j]='\0'; 
							tmp=t;
							tmp.TrimRight();
							strcpy(t,tmp);
							tmp=t+j+1;
							tmp.TrimLeft(); 
							tmp.TrimRight(); 
							break;
						}
					break;
				}
			if (tmp=="" || t[0]=='\0') continue;
			c++;
			int n=CapFormats.GetSize();
			CapFormats.SetSize(n+1);
			CapExts.SetSize(n+1);
			CapLFF.SetSize(n+1);
			CapFormats[c]=tmp2;
			CapExts[c]=t;
			CapLFF[c]=tmp;
		}
		fclose(f);
	}
}

void CAnalyzerApp::SaveCapFormats()
{
	int i;
	CString m_FileName;
	m_FileName=GetProfileString(FLTR_FILE_SEC, "Exts", 
		Path+ERR_EXT);
	if(m_FileName[1]!=':') 
		m_FileName=Path+m_FileName;
	FILE* f;
	f=fopen(m_FileName,"w");
	int c=0;
	if (f)
	for(i=1;i<CapFormats.GetSize();i++)
		fprintf(f,"%s;%s;%s\n",(LPCTSTR)CapFormats[i],(LPCTSTR)CapExts[i],(LPCTSTR)CapLFF[i]);
	else AfxMessageBox(ERR_ACC /*Impossibile salvare le associazioni*/);
	fclose(f);
}

#include "sellff.h"

void CAnalyzerApp::OnAssociazioniCatture() 
{
	CSelLFF d;
	d.DoModal();
}

#include "SelFilter.h"

void CAnalyzerApp::OnPersonalizza() 
{
    CString str;
 	CSelFilter dlg;
	dlg.m_pDoc=NULL;
	dlg.m_nImage=9;
#ifdef ENGLISH
	dlg.m_FileName=GetProfileString(FLTR_FILE_SEC, "Apps", 
		Path+"Apps_e.dat");
	if(dlg.m_FileName[1]!=':') 
		dlg.m_FileName=Path+dlg.m_FileName;
	dlg.m_C1="Menu Name";
	dlg.m_C2="Application";
	dlg.m_Title="External Applications";
	dlg.m_St1="Menu Name";
	dlg.m_St2="Application";
#else
	dlg.m_FileName=GetProfileString(FLTR_FILE_SEC, "Apps", 
		Path+"Apps.dat");
	if(dlg.m_FileName[1]!=':') 
		dlg.m_FileName=Path+dlg.m_FileName;
	dlg.m_C1="Nome Menu";
	dlg.m_C2="Applicazione";
	dlg.m_Title="Applicazioni eseguibili da Analyzer";
	dlg.m_St1="Nome Menu";
	dlg.m_St2="Applicazione";
#endif
	dlg.m_AddNull=0;
	if (dlg.DoModal()==IDOK)
	{
		LoadCmds();
		((CMainFrame*)m_pMainWnd)->OnMenuSilent(IDOK);
	}
}

BOOL CAnalyzerApp::OnCmdMsg(UINT nID, int nCode, void* pExtra,
							AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// If pHandlerInfo is NULL, then handle the message
	if (pHandlerInfo == NULL)
	{
		// Filter the commands sent to a text color menu option
			if (nID >= ID_UTILIT_APP1 && nID <= ID_UTILIT_APP10)
			{
				if (nCode == CN_COMMAND)
				{
					// Handle WM_COMMAND message
					DoSelectApp(nID);
				}
				else if (nCode == CN_UPDATE_COMMAND_UI)
				{
					// Update UI element state
					DoUpdateSelectApp(nID, (CCmdUI*)pExtra);
				}
				return TRUE;
			}
	}

	return CWinApp::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

#include "parameterdlg.h"

void CAnalyzerApp::DoSelectApp(int iApp)
{
	CParameterDlg dlg;
	iApp-=ID_UTILIT_APP1;
	char t[MAX_PATH*4+1];
	GetCurrentDirectory(MAX_PATH*4,t);
	SetCurrentDirectory(Path);
    STARTUPINFO si;
    PROCESS_INFORMATION pip;
    ZeroMemory(&si,sizeof(si));
    si.cb=sizeof(si);
    BOOL b;
	CString str=cmds[iApp];
	int l=str.GetLength();
	if (str[l-1]=='!' && str[l-2]=='$' && str[l-3]=='!')
	{
		str=str.Left(l-3);
		if (dlg.DoModal()==IDCANCEL) return;
		str+=dlg.m_Command;
	}
    b=CreateProcess(NULL,(char*)(LPCTSTR)str,NULL,NULL,
                    FALSE,0,NULL,
                    NULL,&si,&pip);
	if(!b) AfxMessageBox(MP_ERRAPP /*Impossibile eseguire l'applicazione*/);
	SetCurrentDirectory(t);
}

void CAnalyzerApp::DoUpdateSelectApp(int iApp, CCmdUI* pCmdUI)
{
	pCmdUI->Enable(TRUE);
}

void CAnalyzerApp::LoadCmds()
{
	CString m_FileName;
	FILE* f;
#ifdef ENGLISH
	m_FileName=GetProfileString(FLTR_FILE_SEC, "Apps", 
		Path+"Apps_e.dat");
	if(m_FileName[1]!=':') 
		m_FileName=Path+m_FileName;
#else
	m_FileName=GetProfileString(FLTR_FILE_SEC, "Apps", 
		Path+"Apps.dat");
	if(m_FileName[1]!=':') 
		m_FileName=Path+m_FileName;
#endif
		f=fopen(m_FileName,"r");
		int c=0;
		int n=0,i;
		for(i=0;i<10;i++){cmds[i]="";mnus[i]="";}
		if (f)
		{
			char t[500];
			CString tmp;
			while (fgets(t,498,f))
			{
				if (n>=10) {AfxMessageBox (TOO_CMDS); fclose(f); return;}
				if (t[strlen(t)-1]=='\n') t[strlen(t)-1]='\0';
				tmp="";
				for (int i=0;i<(signed)strlen(t);i++) 
					if (t[i]=='=') 
					{
						t[i]='\0'; 
						tmp=t;
						tmp.TrimRight();
						strcpy(t,tmp);
						tmp=(t+i+1); 
						tmp.TrimLeft(); 
						tmp.TrimRight(); 
						break;
					}
				if (tmp=="") continue;
				cmds[n]=tmp;
				mnus[n]=t;
				n++;
				c++;
			}
			fclose(f);
		}
}

void CAnalyzerApp::OnPageSetup() 
{
	dlgPageSetup.DoModal();
}

void CAnalyzerApp::OnOrigCap() 
{
	OpenOrig=!OpenOrig;	
}

void CAnalyzerApp::OnUpdateOrigCap(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(!OpenOrig);
}

BOOL CAnalyzerApp::OnIdle(LONG lCount) 
{
	CMainFrame* pFrame = (CMainFrame*) AfxGetMainWnd();
	CStatusBar* pStatusBar = (CStatusBar*) pFrame->GetDescendantWindow(AFX_IDW_STATUS_BAR);
	CMainFrame* f= pFrame;

	if(pStatusBar)
	{
	  CMDIChildWnd* pChild=pFrame->MDIGetActive();
	  if (pChild!=NULL && pChild->IsKindOf(RUNTIME_CLASS(CMDINormalWnd)))
	  {
		int s,e;
		CView* pView=pChild->GetActiveView();
	    if (pView==NULL || !pView->IsKindOf(RUNTIME_CLASS(CMultiView))) goto delstbar;
		CEdit& edit=((CEditView*)pView)->GetEditCtrl();
		edit.GetSel(s,e);
		int l,l2;
		l=edit.LineFromChar(-1);
		l2=edit.LineFromChar(s);
		if (l!=l2) s=e;
		CString str;
		edit.GetWindowText(str);
		int i;
		for(i=0;i<s;i++)
			if (str[s-i-1]=='\n') break;
		str.Format("L:%d",l+1);
		f->m_StatusBar.SetPaneText(f->m_StatusBar.CommandToIndex(IDS_INDICATOR_LIN) ,str);
		str.Format("C:%d",i+1);
		f->m_StatusBar.SetPaneText(f->m_StatusBar.CommandToIndex(IDS_INDICATOR_COL),str);
	  }
	  else if (pChild!=NULL && pChild->IsKindOf(RUNTIME_CLASS(CMDISplittedWnd)))
	  {
		CLogDocument* pDoc=(CLogDocument*)pChild->GetActiveDocument();
	    if (pDoc==NULL || !pDoc->IsKindOf(RUNTIME_CLASS(CLogDocument))) goto delstbar;
		CMyTreeView* pView=(CMyTreeView*)pDoc->GetCompatibleView(RUNTIME_CLASS(CMyTreeView));
	    if (pView==NULL) goto delstbar;
		int i,l;
		pView->GetSelection(l,i);
		CString str;
		if (l>=0) str.Format("S:%d",l); else str="";
		f->m_StatusBar.SetPaneText(f->m_StatusBar.CommandToIndex(IDS_INDICATOR_LIN) ,str);
		if (i>=0 && i<INT_MAX) str.Format("D:%d",i); 
		else if (i==INT_MAX) str.Format("D:...");	
		else str="";
		f->m_StatusBar.SetPaneText(f->m_StatusBar.CommandToIndex(IDS_INDICATOR_COL),str);
	  }
	  else
	  {
delstbar:
		f->m_StatusBar.SetPaneText(f->m_StatusBar.CommandToIndex(IDS_INDICATOR_LIN),"");
		f->m_StatusBar.SetPaneText(f->m_StatusBar.CommandToIndex(IDS_INDICATOR_COL),"");
	  }
	}
	return CWinApp::OnIdle(lCount);
}

void CAnalyzerApp::OnStatTable() 
{
	AskCsv=0;
}

void CAnalyzerApp::OnUpdateStatTable(CCmdUI* pCmdUI) 
{
	if(AskCsv==0) pCmdUI->SetCheck(TRUE);
	else pCmdUI->SetCheck(FALSE);
}

void CAnalyzerApp::OnStatCsv() 
{
	AskCsv=1;
}

void CAnalyzerApp::OnUpdateStatCsv(CCmdUI* pCmdUI) 
{
	if(AskCsv==1) pCmdUI->SetCheck(TRUE);
	else pCmdUI->SetCheck(FALSE);
}

void CAnalyzerApp::OnStatTbl() 
{
	AskCsv=2;
}

void CAnalyzerApp::OnUpdateStatTbl(CCmdUI* pCmdUI) 
{
	if(AskCsv==2) pCmdUI->SetCheck(TRUE);
	else pCmdUI->SetCheck(FALSE);
}

void CAnalyzerApp::OnTblOpen() 
{
	CFileDialog dlgFile(TRUE);

	CString title=M_OPEN;
	CString fileName;
    UINT nIDSTitle=AFX_IDS_OPENFILE;
    DWORD lFlags=OFN_HIDEREADONLY | OFN_FILEMUSTEXIST;
    BOOL bOpenFileDialog=TRUE;

	dlgFile.m_ofn.Flags |= lFlags;

	CString strFilter="";
	strFilter += M_CSVFILES;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_CSVFLT);
	strFilter += (TCHAR)'\0';   // last string
	strFilter += M_DATFILES;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_DATFLT);
	strFilter += (TCHAR)'\0';   // last string
	CString strDefault;
	// append the '*.*' all files filter
	CString allFilter;
	VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	strFilter += allFilter;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_ALLFLT);
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	BOOL bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	fileName.ReleaseBuffer();

    if (bResult)
	{
 	 CString str=fileName;
	 for(int i=fileName.GetLength()-1;i>=0;i--)
	 if (fileName[i]=='.') 
			{
			 str=((const char*)fileName)+1+i;
		     break;
			}
	 str.MakeUpper();
	 if (str=="DAT")
     {
      CDocTemplate* pTemplate=tblTemplate;
	  CFile f;
	  CTblDocument* csv;
      csv=(CTblDocument*) pTemplate->OpenDocumentFile(fileName);
	  if (csv && !csv->IsInit) csv->Close();
     }
	 else
     {
      CDocTemplate* pTemplate=csvTemplate;
	  CFile f;
	  CCsvDocument* csv;
      csv=(CCsvDocument*) pTemplate->OpenDocumentFile(fileName);
	  if (csv && !csv->IsInit) csv->Close();
     }
	}
}

CString CAnalyzerApp::GetTempFile(const char * ext)
{
	int i;
	const char* c=getenv("TEMP");
	if (ext==NULL) ext=".TMP"; 
	CString s,m_File;
	if (c!=NULL) s=c; else s="\\";
	if (s[s.GetLength()-1]!='\\' || s[s.GetLength()-1]!='/') s+="\\";
	FILE* f=!NULL;
	for (i=0;i<1000;i++)
	{
		m_File.Format("TMP%d",i);
		m_File+=ext;
		m_File=s+m_File; 
		f=fopen(m_File,"r");
		if (f==NULL) break; else {fclose(f);}
	}
	if (f!=NULL) 
	{
		AfxMessageBox(MFR_TEMP_ERR /*Impossibile Creare un file temporaneo*/);
		fclose(f);
		return "";
	}
	FILE* reg;
	reg=fopen(m_TmpDat,"a");
	if (reg){fputs(m_File,reg);fputs("\n",reg);fclose(reg);}
	return m_File;
}

void CAnalyzerApp::DeleteAllTemps(int Silent)
{
	FILE* f,* d;
	char t[2000];
	f=fopen(m_TmpDat,"r");
	CArray<CString,CString&> v;
	int i=0;
	CString s;
	if (!f) return;
	const char* tmp;
	t[0]='\0';
	do
	{
		tmp=fgets(t,1999,f);
		if(t[0]!='\0')
		{
			if (t[strlen(t)-1]=='\n')t[strlen(t)-1]='\0';
			d=fopen(t,"r");
			if (d)
			{
				fclose(d);
				s=AN_DELTMP /*Si desidera cancellare il file temporaneo: */;
				s+=t;
				s+="?";
				if (Silent || AfxMessageBox(s,MB_YESNO)==IDYES)
				{
					if (!DeleteFile(t))
					{
						v.SetSize(i+1);
						v[i]=t;
						i++;
					}
				}
			}
			t[0]='\0';
		}
	} while(tmp);
	if (f) fclose(f);
	if (i==0) DeleteFile(m_TmpDat);
	else
	{
		int j;
		f=fopen(m_TmpDat,"w");
		if(!f) return;
		for(j=0;j<i;j++)
		{
			fputs(v[j],f);
			fputs("\n",f);
		}
		fclose(f);
	}
}


int CAnalyzerApp::CreateTblDoc(CString title, CString s)
{
        CTblDocument* t=(CTblDocument*)tblTemplate->OpenDocumentFile(NULL);
        if(title!="")t->SetTitle (title);
        POSITION p=t->GetFirstViewPosition();
        CTblView *v=(CTblView*)t->GetNextView(p);
		LineCollection lc(&s,1);
        t->NewFromLC(lc);
		if (t->IsInit) return 0;
		t->Close();
		return 1;
}
