// Analyzer.h : main header file for the Analyzer application
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1995 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

#ifndef __Analyzer__
#define __Analyzer__

#include <afxext.h>
#include <afxmt.h>
#include "resource.h"
#include "CLogDocument.h"
#include "commanddlg.h"
#include "paddoc.h"
#include "mainframe.h"
#include "multiview.h"
#include "pageset.h"
#include <CapDll.h>
#include "BCMenu.h"
#include <stdlib.h>

class CCapDllApp;

class CAnalyzerApp : public CWinApp
{
	BOOL InitInstance();
	BOOL FirstInstance();
	//{{AFX_MSG(CAnalyzerApp)
	afx_msg void OnFileOpen();
	afx_msg void OnFileNew();
	afx_msg void OnLogOpen();
	afx_msg void OnQryNew();
	afx_msg void OnCatturaSelFLog();
	afx_msg void OnImpDefProts();
	afx_msg void OnImpDescPack();
	afx_msg void OnImpIndex();
	afx_msg void OnOpenQry();
	afx_msg void OnLogNew();
	afx_msg void OnImpostazioniApriConAlbero();
	afx_msg void OnUpdateImpostazioniApriConAlbero(CCmdUI* pCmdUI);
	afx_msg void OnAssociazioniCatture();
	afx_msg void OnPersonalizza();
	afx_msg void OnPageSetup();
	afx_msg void OnOrigCap();
	afx_msg void OnUpdateOrigCap(CCmdUI* pCmdUI);
	afx_msg void OnStatTable();
	afx_msg void OnUpdateStatTable(CCmdUI* pCmdUI);
	afx_msg void OnStatCsv();
	afx_msg void OnUpdateStatCsv(CCmdUI* pCmdUI);
	afx_msg void OnStatTbl();
	afx_msg void OnUpdateStatTbl(CCmdUI* pCmdUI);
	afx_msg void OnTblOpen();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
   public:
	   int CreateTblDoc(CString title,CString s);
	   CString m_PlotApp;
	   int CsvSep;
	   void DeleteAllTemps(int Silent=1);
	   CString GetTempFile(const char* ext=NULL);
	   CString m_IndexSep;
	virtual BOOL OnIdle(LONG lCount);
	   CCapDll m_CapDll;
	   void LoadCmds();
	   int AskCsv;
	   BOOL OpenOrig;
	   void SaveCapFormats();
	   virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra,
							  AFX_CMDHANDLERINFO* pHandlerInfo);
		void DoSelectApp(int iColor);
		void DoUpdateSelectApp(int iColor, CCmdUI* pCmdUI);
	   CString DefinedFont;
	   CArray<CString,CString&> CapFormats;
	   CArray<CString,CString&> CapExts;
	   CArray<CString,CString&> CapLFF;
	   CString cmds[10];
	   CString mnus[10];
	   int DefinedDim;
	   void SelProtos(CString& m_F1, CString& m_F2, int m_IsAdvanced=0 , int Silent=0);
	   void SelFLog(CString & m_F1,CString & m_F2, int m_IsAdvanced=0, int silent=0);
	   void SelDFF(CString & m_F1, CString & m_F2, int m_IsAdvanced=0, int Silent=0);
	   void SelIFF(CString & m_F1, CString & m_F2, int m_IsAdvanced=0, int Silent=0);
	   void SetLinkType(int l);
	   BCMenu* SetupAppMenu(BCMenu * pTopMenu);
	   BCMenu* SetupMenu(BCMenu *pTopMenu, const char* section);
	   BCMenu m_MainMenu;
	   BCMenu m_CapMenu;
	   BCMenu m_TxtMenu;
	   BCMenu m_AppMenu;
	   BCMenu m_TblMenu;
	   BOOL m_ClbFull;
	   CString m_Clipboard;
	CAnalyzerApp();
	~CAnalyzerApp() {Sleep(3000);remove(m_Clipboard);DeleteAllTemps();}
	int ExecuteApp(CString& s);
	CLogDocument* OpenLog(const char* fileName, int IsTemp=0, const char* lff=NULL);
	CString m_lfo;
	CString m_pdo;
	CString m_ifo;
	CString m_dfo;
	CString m_lff;
	CString m_pdf;
	CString m_iff;
	CString m_dff;
    BOOL max;
    CString Path;
    CLogDocument *logdocument;
    void *qsp;
    void WinHelp( DWORD dwData, UINT nCmd = HELP_CONTEXT );
    BOOL initiated;
    int LogOpened;
    CDocument* log;
	int OpenTree;
    CMultiDocTemplate* logTemplate;
    CMultiDocTemplate* logTreeTemplate;
    CMultiDocTemplate* logListTemplate;
    CMultiDocTemplate* logRawTemplate;
    CMultiDocTemplate* csvTemplate;
	CMultiDocTemplate* tblTemplate;
    int CreateRoDoc(CString t,CString s);
    int CreateCsvDoc(CString t,CString s);
    CMultiDocTemplate *defTemplate;
    CMultiDocTemplate *roTemplate;
protected:
	virtual int ExitInstance();
private:
	CString m_TmpDat;
	void LoadCapFormats();
	void WriteHdr(const char*);
};

#endif
