// CFilterDialog.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"

#include "CFilterDialog.h"
#include "Filterwiz.h"
#include "SelFilter.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define LOG_TITLE "Inserire il filtro di Navigazione"
#define FLTRS "filters.dat"
#define FLTR_FILE_SEC "DAT"
#else
#define LOG_TITLE "Insert Navigation Filter"
#define FLTRS "filters_e.dat"
#define FLTR_FILE_SEC "DAT_E"
#endif

/////////////////////////////////////////////////////////////////////////////
// CFilterDialog

BEGIN_MESSAGE_MAP(CFilterDialog, CDialog)
	//{{AFX_MSG_MAP(CFilterDialog)
	ON_BN_CLICKED(IDC_RESET,OnClickedReset)
	ON_BN_CLICKED(IDC_FILT_WIZ, OnFiltWiz)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP();

CFilterDialog::CFilterDialog(CWnd* pParent)
    : CDialog((unsigned)CFilterDialog::IDD, pParent)
{

    //{{AFX_DATA_INIT(CFilterDialog)
        // NOTE: the ClassExpress will add member initialization here
    //}}AFX_DATA_INIT
	filter=NULL;
	m_pDoc=NULL;
	m_Title=LOG_TITLE /*Inserire il filtro di Navigazione*/;
}

void CFilterDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CFilterDialog)
	DDX_Control(pDX, IDC_EDIT1, m_EditCtrl);
	//}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CFilterDialog message handlers


void CFilterDialog::OnClickedReset()
{
    m_EditCtrl.SetWindowText("TRUE");
}


void CFilterDialog::OnOK()
{
    CString t;
    m_EditCtrl.GetWindowText(t);
    if(filter!=NULL) delete[]filter;
    filter=new char[strlen(t)+1];
    strcpy(filter,t);
	if (m_pDoc && m_pDoc->OnLogFilter(t)) CDialog::OnOK();
}


void CFilterDialog::OnCancel()
{
	((CMainFrame*)AfxGetMainWnd())->m_Fltr=FALSE;
    CDialog::OnCancel();
}


BOOL CFilterDialog::OnInitDialog()
{
	CDialog:: OnInitDialog();
	if (filter) m_EditCtrl.SetWindowText(filter);
	SetWindowText(m_Title);
   	return TRUE;
}

CFilterDialog::~CFilterDialog()
{
	if(filter) delete[]filter;
}

void CFilterDialog::OnFiltWiz() 
{
	CSelFilter dlg;
	CWinApp* pApp = AfxGetApp();   
	dlg.m_FileName=pApp->GetProfileString(FLTR_FILE_SEC, "Filters", 
		(((CAnalyzerApp*)AfxGetApp())->Path)+FLTRS);
	if(dlg.m_FileName[1]!=':') 
		dlg.m_FileName=((CAnalyzerApp*)AfxGetApp())->Path+dlg.m_FileName;
	dlg.m_pDoc=m_pDoc;
	if(dlg.DoModal()==IDOK)
	{
	  if (!m_pDoc->OnLogFilter(dlg.m_Filter))
			m_pDoc->OnLogFilter((CString)"TRUE");
	  m_EditCtrl.SetWindowText(dlg.m_Filter);
	}
}
