// CLogDocument.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"

#include "CLogDocument.h"
#include "MyTreeVw.h"
#include "CFilterDialog.h"
#include "CRepDial.h"
#include "messages.h"
#include "query.h"
#include "CRawview.h"
#include "CListview.h"
#include "SuppProtos.h"
#include "resource.h"
#include "firstproto.h"
#include "SelFilter.h"

#include "resource.h"

extern CAnalyzerApp theApp;

#ifndef ENGLISH
#define FLTRS "filters.dat"
#define FLTR_FILE_SEC "DAT"
#define LOG_ERR_SERV "Problemi nell'apertura del server"
#define LOG_INT_ERR "Errore Interno"
#define LOG_LFO_ERROR "Warning: il file lfo non  valido"
#define LOG_PDO_ERROR "Warning: il file pdo non  valido"
#define LOG_DFO_ERROR "Warning: il file dfo non  valido"
#define LOG_IFO_ERROR "Warning: il file ifo non  valido"
#define LOG_CAP_SAVE "Si desidera salvare la cattura?"
#define LOG_ERR_INDEX "Impossibile creare l'indice"
#define LOG_PRINT "E' necessario aprire una finestra contenente il testo da stampare. Si vuole procedere ?"
#define LOG_WRONG_DIR "Analyzer non  stato lanciato dalla directory dell'eseguibile.\r\nL'esecuzione  possibile ma si deve ricercare il file di configurazione per query (query.ini)."
#define LOG_QUERY_INI "Selezionare un file INI per Query"
#define LOG_CAP_CREATE "Selezionare il file ACP da creare"
#define LOG_RESULT "Risultati dei comandi impartiti"
#define LOG_MAC_TITLE "Esecuzione Macro"
#define LOG_MO_ERROR "Specificare almeno un file 'mo'."
#define LOG_MAC_CERR "Impossibile compilare la macro"
#define LOG_MAC_SRCERR "E' necessario specificare il file sorgente."
#define LOG_MACRO_END "Attenzione! L'esecuzione di una macro richiede che poi il file di catture\ncorrente venga chiuso. Si desidera procedere?"
#define LOG_MACRO_RES "Risultati della macro"
#define LOG_PROTOS_ERR "Impossibile determinare i protocolli supportati"
#define LOG_PROTSET_ERR "Impossibile impostare il primo protocollo"
#define LOG_SAVE_ERR "Errore nel salvataggio"
#define LOG_CAP_FILENAME "File di Cattura: "
#define LOG_NOITEM_ERR "Nessun elemento soddisfa il criterio"
#define ERR_SAVEASCAP "La cattura  stata salvata. Ulteriori modifiche verranno comunque effettuate su quella attuale"
#define ASK_CSV "Si desidera l'output in formato CSV?"
#define ERR_EXT "Estensione del file non fornita. Salvataggio in formato ACP"
#define ERRS1 "Non  possibile determinare se le modifiche\n"
#define ERRS2 "sono state salvate completamente.\n"
#define ERRS3 "Si desidera chiudere comunque il documento?"
#else
#define FLTRS "filters_e.dat"
#define FLTR_FILE_SEC "DAT_E"
#define LOG_ERR_SERV "Error opening Server"
#define LOG_INT_ERR "Internal Error"
#define LOG_LFO_ERROR "Warning: Invalid LFO File"
#define LOG_PDO_ERROR "Warning: Invalid PDO File"
#define LOG_DFO_ERROR "Warning: Invalid DFO File"
#define LOG_IFO_ERROR "Warning: Invalid IFO File"
#define LOG_CAP_SAVE "Do you want to save this capture document?"
#define LOG_ERR_INDEX "Error Creating Index"
#define LOG_PRINT "Analyzer must open a Text Window. Can it do this ?"
#define LOG_WRONG_DIR "Analyzer was not launched from Installation directory.\r\nPlease find query.ini file manually."
#define LOG_QUERY_INI "Please, find query.ini file"
#define LOG_CAP_CREATE "Choose Cap File to Create"
#define LOG_RESULT "Command Results"
#define LOG_MAC_TITLE "Macro Processing"
#define LOG_MO_ERROR "You must insert at least a MO file."
#define LOG_MAC_CERR "Error compiling macro"
#define LOG_MAC_SRCERR "You must specify a source file"
#define LOG_MACRO_END "Warning! After macro processing this capture document will be closed. Do you wish to continue?"
#define LOG_MACRO_RES "Macro Results"
#define LOG_PROTOS_ERR "Analyzer cannot obtain supported protocols"
#define LOG_PROTSET_ERR "Analyzer cannot det first protocol"
#define LOG_SAVE_ERR "Saving Error"
#define LOG_CAP_FILENAME "Capture File: "
#define LOG_NOITEM_ERR "No Item satisfies expression"
#define ERR_SAVEASCAP "Capture was saved. Modifications will not be done on saved capture"
#define ASK_CSV "Do you wish CSV output?"
#define ERR_EXT "File extension missing. Saving in ACP format"
#define ERRS1 "Unable to know if changes are fully saved.\n"
#define ERRS2 "Can Analyzer close this document?\n"
#define ERRS3 "Any unsaved modification will be lost."
#endif

//QueryContainer query;

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLogDocument

BEGIN_MESSAGE_MAP(CLogDocument, CDocument)
	//{{AFX_MSG_MAP(CLogDocument)
	ON_COMMAND(ID_NAVIGAZIONE_FILTRO,OnLogFilter)
	ON_COMMAND(IDM_LOG_NEXT,OnLogNext)
	ON_COMMAND(IDM_LOG_NEXTF,OnLogNextf)
	ON_COMMAND(IDM_LOG_PREV,OnLogPrev)
	ON_COMMAND(IDM_LOG_PREVF,OnLogPrevf)
	ON_COMMAND(IDM_LOG_QUERY,OnLogQuery)
	ON_COMMAND(IDM_FILE_SAVE,OnFileSave)
	ON_COMMAND(IDM_FILE_SAVE_AS,OnFileSaveAs)
	ON_COMMAND(IDM_REP_OPEN,OnRepOpen)
	ON_COMMAND(IDM_REP_CLOSE,OnRepClose)
	ON_COMMAND(IDM_REP_ADD,OnRepAdd)
	ON_COMMAND(IDM_LOG_FIRST,OnLogFirst)
	ON_COMMAND(IDM_LOG_LAST,OnLogLast)
	ON_UPDATE_COMMAND_UI(IDM_REP_CLOSE,OnUpdateRepClose)
	ON_UPDATE_COMMAND_UI(IDM_REP_ADD,OnUpdateRepAdd)
	ON_UPDATE_COMMAND_UI(IDM_LOG_FIRST,OnUpdateLogFirst)
	ON_UPDATE_COMMAND_UI(IDM_LOG_LAST,OnUpdateLogLast)
	ON_UPDATE_COMMAND_UI(IDM_LOG_NEXT,OnUpdateLogNext)
	ON_UPDATE_COMMAND_UI(IDM_LOG_NEXTF,OnUpdateLogNextf)
	ON_UPDATE_COMMAND_UI(IDM_LOG_PREV,OnUpdateLogPrev)
	ON_UPDATE_COMMAND_UI(IDM_LOG_PREVF,OnUpdateLogPrevf)
	ON_COMMAND(IDM_VIEW_CHAR,OnViewChar)
	ON_COMMAND(IDM_VIEW_TREE,OnViewTree)
	ON_UPDATE_COMMAND_UI(IDM_VIEW_CHAR,OnUpdateViewChar)
	ON_UPDATE_COMMAND_UI(IDM_VIEW_TREE,OnUpdateViewTree)
	ON_COMMAND(ID_FILE_CLOSE,OnCloseDocument)
	ON_COMMAND(ID_CAP_ADD, OnCapAdd)
	ON_UPDATE_COMMAND_UI(ID_CAP_ADD, OnUpdateCapAdd)
	ON_COMMAND(ID_CAP_CLOSE, OnCapClose)
	ON_UPDATE_COMMAND_UI(ID_CAP_CLOSE, OnUpdateCapClose)
	ON_COMMAND(ID_CAP_OPEN, OnCapOpen)
	ON_COMMAND(IDM_VIEW_PROTOS, OnViewProtos)
	ON_COMMAND(IDM_VIEW_PROTOS_TXT, OnViewProtosTxt)
	ON_COMMAND(ID_LOG_MACRO, OnLogMacro)
	ON_COMMAND(ID_CATTURA_PRIMOPROTOCOLLO, OnCatturaPrimoprotocollo)
	ON_COMMAND(ID_EDIT_CLEAR, OnEditClearP)
	ON_COMMAND(ID_EDIT_COPY, OnModificaCopiaP)
	ON_COMMAND(ID_EDIT_PASTE, OnModificaIncollaP)
	ON_COMMAND(ID_EDIT_CUT, OnModificaTagliaP)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, OnUpdateModificaIncollap)
	ON_COMMAND(ID_LOG_FIND_NEXT, OnLogFindNext)
	ON_UPDATE_COMMAND_UI(ID_LOG_FIND_NEXT, OnUpdateLogFindNext)
	ON_COMMAND(IDM_LOG_FIND, OnLogFind)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateModificaCopiap)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CUT, OnUpdateModificaTagliap)
	ON_UPDATE_COMMAND_UI(IDM_LOG_FIND, OnUpdateLogFind)
	ON_COMMAND(IDM_SELECT_EXP, OnSelectExp)
	ON_UPDATE_COMMAND_UI(IDM_SELECT_EXP, OnUpdateSelectExp)
	ON_COMMAND(IDM_INV_SEL, OnInvSel)
	ON_UPDATE_COMMAND_UI(IDM_INV_SEL, OnUpdateInvSel)
	ON_COMMAND(ID_REM_SEL, OnRemSel)
	ON_UPDATE_COMMAND_UI(ID_REM_SEL, OnUpdateRemSel)
	ON_COMMAND(ID_PACCHETTI_MODIFICA_RINFRESCAINDICE, OnRinfrescaIndice)
	ON_UPDATE_COMMAND_UI(ID_PACCHETTI_MODIFICA_RINFRESCAINDICE, OnUpdateRinfrescaIndice)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
	ON_COMMAND(IDM_CLIP_TEXT, OnClipText)
	ON_UPDATE_COMMAND_UI(IDM_CLIP_TEXT, OnUpdateClipText)
	ON_COMMAND(IDM_CLIP_PCK, OnClipPck)
	ON_UPDATE_COMMAND_UI(IDM_CLIP_PCK, OnUpdateClipPck)
	ON_COMMAND(ID_FILE_SAVE,OnFileSave)
	ON_COMMAND(IDM_EDIT_DATA_EXT, OnEditDataExt)
	ON_UPDATE_COMMAND_UI(IDM_EDIT_DATA_EXT, OnUpdateEditDataExt)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP();

/////////////////////////////////////////////////////////////////////////////
// CLogDocument

IMPLEMENT_SERIAL(CLogDocument, CDocument, 0 /* schema number*/ )

CLogDocument::CLogDocument():sync(FALSE,"AnalyzerSync")
{
    filter=new char[5];
	m_FindF=TRUE;
	m_IsCapModified=FALSE;
	m_IsCapTmp=FALSE;
	m_IsNewTmp=FALSE;
	IsCopy=FALSE;
    strcpy(filter,"TRUE");
    RepFileName="report.txt";
    m_pView2=NULL;
    lfName=NULL;
    RepOpened=FALSE;
    CapOpened=FALSE;
    AddData=TRUE;
    AddParsed=TRUE;
	sp_cr=FALSE;
    RepOpened=FALSE;
    Enabled.first=TRUE;
    Enabled.prevf=TRUE;
    Enabled.prev=TRUE;
    Enabled.next=TRUE;
    Enabled.nextf=TRUE;
    Enabled.last=TRUE;
    closewithoutconfirm=FALSE;
    CAnalyzerApp* app=(CAnalyzerApp*)AfxGetApp();
	app->logdocument=this;
	m_mo=app->Path;
	m_mo+="Objects\\macro.mo";
	m_mac="";
    ((CMainFrame*)theApp.m_pMainWnd)->IsClosing=FALSE;
	if (query.NomePrg==NULL)
	{
		AfxMessageBox(LOG_ERR_SERV/*Problemi nell'apertura del server*/);
	}
	m_IsTemp=0;
	m_IsCap=1;
	query.SetDoc(this);
	m_ClipPck=TRUE;
	m_ClipTxt=TRUE;
}

BOOL CLogDocument::OnNewDocument()
{
    if (!CDocument::OnNewDocument())
        return FALSE;
    return TRUE;
}

DWORD WINAPI DelThr(LPVOID fn)
{
	if (fn)
	{
		do
		{
			Sleep(1000);
		} while (!DeleteFile((const char*)fn));
		delete[]fn;
	}
	ExitThread(0);
	return 0;
}

CLogDocument::~CLogDocument()
{
    if (filter!=NULL) {delete[]filter;}
	filter=NULL;
    if (lfName!=NULL) delete[] lfName;
    m_pView2=NULL;
    theApp.LogOpened=FALSE;
    theApp.logdocument=NULL;
	char* file=new char[GetPathName().GetLength()+1];
	DWORD d;
	if (file)
	{
		strcpy(file,(const char*)GetPathName());
		if (m_IsTemp) CreateThread(NULL,1024,&DelThr,file,0,&d);
	}
	((CMainFrame*)AfxGetMainWnd())->RefreshMenu();
}

/////////////////////////////////////////////////////////////////////////////
// CLogDocument serialization

void CLogDocument::Serialize(CArchive& ar)
{
	short errors;
	CString s;
    if (ar.IsStoring())
    {
		AfxMessageBox(LOG_INT_ERR /*Errore Interno*/);
    }
    else
    {
	  CString str;
	  CAnalyzerApp*app=(CAnalyzerApp*)AfxGetApp();
	  str=app->Path;
	  str="chdir "+str;
	  char const * t= (char const *)str;
	  s=query.ExecuteCommand(t,&errors);
	  OnLogIni();
	  if(ar.GetFile()->GetFilePath().Right(3)!="acp" && app->m_lff!="")
	  {
	   str="lfoopen $"+app->m_lfo;
	   s=query.ExecuteCommand((const char*)str,&errors);
	   if (!errors) AfxMessageBox(LOG_LFO_ERROR /*Warning: il file lfo non  valido*/);
	  }
	  str="pfoopen $"+app->m_pdo;
	  s=query.ExecuteCommand((const char*)str,&errors);
	  if (!errors) AfxMessageBox(LOG_PDO_ERROR /*Warning: il file pdo non  valido*/);
	  str="dfoopen $"+app->m_dfo;
	  s=query.ExecuteCommand((const char*)str,&errors);
	  if (!errors) AfxMessageBox(LOG_DFO_ERROR /*Warning: il file dfo non  valido*/);
	  str="ifoopen $"+app->m_ifo;
	  s=query.ExecuteCommand((const char*)str,&errors);
	  if (!errors) AfxMessageBox(LOG_IFO_ERROR /*Warning: il file ifo non  valido*/);
	  str=ar.GetFile()->GetFilePath();
	  if (str.Right(3)=="acp" || app->m_lff=="") {str="capopen "+str;m_IsCap=1;}
	  else {str="logopen "+str;m_IsCap=0;}
	  t= (char const *)str;
	  s=query.ExecuteCommand(t,&errors);
      if (errors==0)
      {
		  erroropening=TRUE;
		  return;
	  }
	  OnLogIndex();
      OnLogFirst();
	  s=query.ExecuteCommand("getlinktype",&errors);
	  int lt;
	  if(sscanf(s,"Link Type:%d",&lt))
		((CAnalyzerApp*)(AfxGetApp()))->SetLinkType(lt);
      erroropening=FALSE;
    }
}

/////////////////////////////////////////////////////////////////////////////
// CLogDocument message handlers


void CLogDocument::OnLogFilter()
{
	  CFilterDialog fltr;
	  fltr.filter=new char[strlen(filter)+1];
	  strcpy(fltr.filter,filter);
	  fltr.m_pDoc=this;
	  fltr.DoModal();
}

void CLogDocument::OnCloseDocument()
{
    if (((CMainFrame*)theApp.m_pMainWnd)->IsClosing==TRUE)
	{
		CDocument::OnCloseDocument();
		return;
	}
    if(erroropening) CDocument::OnCloseDocument();
	else if (m_IsTemp && IsCapModified() &&
			 AfxMessageBox(LOG_CAP_SAVE //Si desidera salvare la cattura?
			 ,MB_YESNO)==IDYES)
		{
			 OnFileSaveAs();
			 if (IsCapModified())
			 {
				 if (AfxMessageBox(ERRS1 /*Non  possibile determinare se le modifiche\n*/
					 ERRS2 /*sono state salvate completamente.\n*/
					 ERRS3 /*Si desidera chiudere comunque il documento?*/,MB_YESNO)==IDNO) return;
			 }
			 CDocument::OnCloseDocument();
		}
		else CDocument::OnCloseDocument();
	CMainFrame* f=(CMainFrame*)AfxGetMainWnd();
	if (f->m_Fltr)
	  {
		  f->fltr->SendMessage(WM_CLOSE,0,0);
		  f->m_Fltr=FALSE;
	  }
}

void CLogDocument::RefreshViews()
    {
       m_pView1=(CMultiView*) GetCompatibleView(RUNTIME_CLASS(CMultiView));
       m_pView2=(CMyTreeView*) GetCompatibleView(RUNTIME_CLASS(CMyTreeView));
       if (m_pView1)
        {
            m_pView1->NewFromStrings(query.result);
        }
       if (m_pView2) 
	   {
		   int i;
		   lc=query.result;
		   i=m_pView2->NewFromLCs(lc);
		   CRawView* m_pView3=(CRawView*) GetCompatibleView(RUNTIME_CLASS(CRawView));
		   if (m_pView3) m_pView3->Update(lc,i);
		   CListAllView* m_pView4=(CListAllView*) GetCompatibleView(RUNTIME_CLASS(CListAllView));
		   if (m_pView4) 
		   {
			   int n;
			   short errors;
			   CString str=query.ExecuteCommand("getpos",&errors);
			   if(errors) 
			   {
				  for (n=0;n<str.GetLength();n++)
					  if (str[n]==':')
					  {
						  sscanf(((LPCTSTR)str)+n+1,"%d",&n);
						  break;
					  }
			      m_pView4->UpdateSel(n);
			   }
		   }
	   }
    }

void CLogDocument::OnLogThis()
    {
	short errors;
	CString str;
	str=query.ExecuteCommand("this",&errors);
	if(errors) RefreshViews();
    }

void CLogDocument::OnLogNext()
{
    if(!Enabled.next) return;
	short errors;
	CString str;
	str=query.ExecuteCommand("next",&errors);
	if(errors!=0) {RefreshViews();AdjustToolbar(errors);}
}


void CLogDocument::OnLogNextf()
{
    theApp.DoWaitCursor(1);
	short errors;
	CString str;
	str=query.ExecuteCommand("nextf",&errors);
	if(errors!=0) {RefreshViews();AdjustToolbar(errors);}
    theApp.DoWaitCursor(-1);
}


void CLogDocument::OnLogPrev()
{
    if(!Enabled.prev) return;
	short errors;
	CString str;
	str=query.ExecuteCommand("prev",&errors);
	if(errors!=0) {RefreshViews();AdjustToolbar(errors);}
}


void CLogDocument::OnLogPrevf()
{
    theApp.DoWaitCursor(1);
	short errors;
	CString str;
	str=query.ExecuteCommand("prevf",&errors);
	if(errors!=0) {RefreshViews();AdjustToolbar(errors);}
    theApp.DoWaitCursor(-1);
}


void CLogDocument::OnLogFirst()
{
	short errors;
	CString str;
	str=query.ExecuteCommand("first",&errors);
	if(errors!=0) {RefreshViews();AdjustToolbar(errors);}
	
	int i,j;
	str=query.ExecuteCommand("getitemnr",&errors);
	if(errors==0) {AfxMessageBox(LOG_ERR_INDEX /*Impossibile creare l'indice*/);return;}
	for(i=0;i<(signed)strlen(str);i++) 
	{
		if (str[i]==':') str=((const char*) str)+i+1;
	}
	str.TrimLeft();
	sscanf(str,"%d",&j);
	if(j==0)
		AdjustToolbar(-1);
	else if(j==1)
		AdjustToolbar(0);
}


void CLogDocument::OnLogLast()
{
    theApp.DoWaitCursor(1);
	short errors;
	CString str;
	str=query.ExecuteCommand("last",&errors);
	if(errors!=0) {RefreshViews();AdjustToolbar(errors);}
    theApp.DoWaitCursor(-1);
}

void CLogDocument::OnLogQuery()
{
	CFileDialog dlgFile(TRUE);

	CString title=M_OPENQUERY;
	CString fileName;
    UINT nIDSTitle=AFX_IDS_OPENFILE;
    DWORD lFlags=OFN_HIDEREADONLY | OFN_FILEMUSTEXIST;
    BOOL bOpenFileDialog=TRUE;

	dlgFile.m_ofn.Flags |= lFlags;

	CString strFilter=M_QRYFILES;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_QRYFLT);
	strFilter += (TCHAR)'\0';   // last string
	CString strDefault;
	// append the '*.*' all files filter
	CString allFilter;
	VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	strFilter += allFilter;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_ALLFLT);
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	BOOL bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	fileName.ReleaseBuffer();
    if (bResult)
     {
		LogQuery(fileName);
		OnLogFirst();
     }
}

void CLogDocument::OnFileSave()
{
	if(m_IsTemp && m_IsCapTmp==0 && m_IsNewTmp==0 && IsCopy)
	{
		CString str=lfName;
        CFile f(str,CFile::modeCreate | CFile::modeWrite);
        CArchive ar( &f, CArchive::store);
		SerializeCAP(ar,4);
		SetCapModifiedFlag(FALSE);
	}
	else
		OnFileSaveAs();
}

#include "savewnd.h"

void CLogDocument::OnFileSaveAs()
{
	CSaveWnd dlgFile(FALSE);
	dlgFile.m_pDoc=this;

	CString title=M_SAVEAS;
	CString fileName;
    UINT nIDSTitle=AFX_IDS_OPENFILE;
    DWORD lFlags=OFN_HIDEREADONLY ;
    BOOL bOpenFileDialog=FALSE;

	dlgFile.m_ofn.Flags |= lFlags;

	CString strFilter = "Analyzer CaPture (*.acp)";
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.acp");
	strFilter += (TCHAR)'\0';   // last string
	strFilter += M_TEXTFILES;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_TXTFLT);
	strFilter += (TCHAR)'\0';   // last string
    strFilter += _T(M_HTMLFILES);
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_HTMLFLT);
	strFilter += (TCHAR)'\0';   // last string	CString strDefault;
	// append the '*.*' all files filter
	CString allFilter;
	VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	strFilter += allFilter;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_ALLFLT);
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	BOOL bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	BOOL found=FALSE;
	fileName.ReleaseBuffer();
    if (bResult)
	{
		if (!OnLogFilter(dlgFile.SaveOptions->Filter)) return;
		CString str=fileName;
		for(int i=fileName.GetLength()-1;i>=0;i--)
		 if (fileName[i]=='.') 
			{
			 fileName=((const char*)fileName)+1+i;
			 found=TRUE;
		     break;
			}
		fileName.MakeUpper();
		if (!found) 
		{
			str+=".acp";
			AfxMessageBox(ERR_EXT /*Estensione del file non fornita. Salvataggio in formato ACP*/);
		}
		else if ((fileName!="ACP") &&
				 (fileName!="HTM") && 
				 (fileName!="HTML") &&
				 (fileName!="TXT"))
			str+=".acp";
        CFile f(str,CFile::modeCreate | CFile::modeWrite);
        CArchive ar( &f, CArchive::store);
		if (fileName=="HTM" || fileName=="HTML")
		{
			SerializeHTML(ar,dlgFile.Option);
		}
		else if (fileName=="TXT")
		{
			SerializeTXT(ar,dlgFile.Option);
		}
		else
		{
			if (!SerializeCAP(ar,dlgFile.Option) && dlgFile.Option==4) 
			{
				SetCapModifiedFlag(FALSE);
				int i,j;
				for(i=strlen(str)-1,j=0;i>=0;i--,j++)
					if (str[i]=='\\' || str[i]=='/') {str=str.Right(j);break;}
				SetTitle(E_LOGTITLE+str);
				m_IsCapTmp=0;
				m_IsNewTmp=0;
			}
			else AfxMessageBox(ERR_SAVEASCAP /*La cattura  stata salvata. Ulteriori modifiche verranno comunque effettuate su quella attuale*/);
		}
	}
}

char* CLogDocument::SeparateRows(char* c)
{
    int i,t=strlen(c);
    // First character is not valid for separation
    for (i=1;i<t;i++)
     {
      if (c[i]==':' || c[i]=='=') {c[i]='\0';return c+i+1;}
      if (c[i]=='[') {c[i-1]='\0';return c+i;}
     }
    return NULL;
}

CString &CLogDocument::FormatRow(const char* const c,CString& r, int i)
{
    CString t;
    t.Format(M_CRLF);
    char tt[300];
    strcpy(tt,c);
    CString etr="</TR>"+t;
    CString td="<TD>",etd="</TD>"+t;
    if (i) {td+="<PRE>";etd="</PRE>"+etd;}
    char* chr=SeparateRows(tt);
    r="<TR>";
    r+=td+tt+etd;
    if (chr) r+=td+chr+etd;
    r+=etr;
    return r;
}

CString *CLogDocument::Lc2HTMLCString(LineCollection &up,CString &c)
   {
    CString t;
    t.Format(M_CRLF);
    CString table="<TABLE BORDER>",etable="</TABLE>"+t;
    CString caption="<CAPTION>",ecaption="</CAPTION>"+t;

    c=t;
    int i,n=up.getLineCount();
    c+=table;
    c+=caption+"----- Position -----"+ecaption;
    c+=FormatRow(up.line(1),t);
    c+=etable;
    c+=table;
    c+=caption+"----- Time Informations -----"+ecaption;
    char* chr;
    for(i=2;i<n;i++)
         {
          chr = (char*) up.line(i);
          if ((chr[4]=='-')&&(chr[0]=='-'))
           {
            c+=etable;
            c+=table;
            c+=caption+chr+ecaption;
           }
          else if ((chr[4]=='=')&&(chr[0]=='='))break;
          else c+=FormatRow(chr,t);
         }
    c+=etable;
    c+=table;
    c+=caption+T_RAW+ecaption;
    for(i++;i<n;i++)
         {
          c+=FormatRow((char*)up.line(i),t,1);
         }
    c+=etable;
    return &c;
   }

void CLogDocument::AdjustToolbar(int i)
    {
        CToolBar* g=&((CMainFrame*)theApp.m_pMainWnd)->m_ToolBar1;
		Enabled.cutcopy=TRUE;
        if (i==1)
         {
            Enabled.first=FALSE;
            Enabled.prevf=FALSE;
            Enabled.prev=FALSE;
            Enabled.next=TRUE;
            Enabled.nextf=TRUE;
            Enabled.last=TRUE;
         }
        else if (i==2)
         {
            Enabled.first=TRUE;
            Enabled.prevf=TRUE;
            Enabled.prev=TRUE;
            Enabled.next=TRUE;
            Enabled.nextf=TRUE;
            Enabled.last=TRUE;
         }
        else if (i==3)
         {
            Enabled.first=TRUE;
            Enabled.prevf=TRUE;
            Enabled.prev=TRUE;
            Enabled.next=FALSE;
            Enabled.nextf=FALSE;
            Enabled.last=FALSE;
         }
        else if (i<=0)
         {
            Enabled.first=FALSE;
            Enabled.prevf=FALSE;
            Enabled.prev=FALSE;
            Enabled.next=FALSE;
            Enabled.nextf=FALSE;
            Enabled.last=FALSE;
			if (i<0)
				Enabled.cutcopy=FALSE;
         }
		if (!strcmp (filter,"") || !strcmp (filter,"TRUE") || !strcmp (filter,"true")) 
		 {
            Enabled.prevf=FALSE;
            Enabled.nextf=FALSE;
		 }
    }

void CLogDocument::OnUpdateLogFirst(CCmdUI *pCmdUI)
{
    pCmdUI->Enable(Enabled.first);
}


void CLogDocument::OnUpdateLogLast(CCmdUI *pCmdUI)
{
    pCmdUI->Enable(Enabled.last);
}


void CLogDocument::OnUpdateLogNext(CCmdUI *pCmdUI)
{
    pCmdUI->Enable(Enabled.next);
}


void CLogDocument::OnUpdateLogNextf(CCmdUI *pCmdUI)
{
    pCmdUI->Enable(Enabled.nextf);
}


void CLogDocument::OnUpdateLogPrev(CCmdUI *pCmdUI)
{
    pCmdUI->Enable(Enabled.prev);
}


void CLogDocument::OnUpdateLogPrevf(CCmdUI *pCmdUI)
{
    pCmdUI->Enable(Enabled.prevf);
}


void CLogDocument::OnViewChar()
{
    CreateOrDestroyFrame(theApp.logTemplate,
        RUNTIME_CLASS(CMultiView),this);
    m_pView1=(CMultiView*) GetCompatibleView(RUNTIME_CLASS(CMultiView));
    if(m_pView1)m_pView1->SetTemp();
    OnLogThis();
}


void CLogDocument::OnViewTree()
{
    CreateOrDestroyFrame(theApp.logTreeTemplate,
        RUNTIME_CLASS(CMyTreeView),this);
    m_pView2=(CMyTreeView*) GetCompatibleView(RUNTIME_CLASS(CMyTreeView));
    OnLogThis();
	if(m_pView2) OnLogIndex();
}

void CLogDocument::CreateOrDestroyFrame(CDocTemplate* pTemplate,
	CRuntimeClass* pViewClass, CDocument* pDocument)
{
	// If a check view or book view (specified by pViewClass)
	// already exists, then activate the MDI child window containing
	// the view.  Otherwise, create a new view for the document.

	CDocument* pDoc=pDocument;
	if(pDoc==NULL)
	 {
	 CMDIChildWnd* pMDIActive = ((CMDIFrameWnd*)theApp.m_pMainWnd)->MDIGetActive();
	 ASSERT(pMDIActive != NULL);
	 pDoc= pMDIActive->GetActiveDocument();
	 }
	ASSERT(pDoc != NULL);

	CView* pView;
	POSITION pos = pDoc->GetFirstViewPosition();
	while (pos != NULL)
	{
		pView = pDoc->GetNextView(pos);
		if (pView->IsKindOf(pViewClass))
		{
            if (pos==NULL)
            {
             (pView->GetParentFrame())->PostMessage(WM_CLOSE);
			}
			 else pView->GetParentFrame()->DestroyWindow();
			return;
		}
	}

	CMDIChildWnd* pNewFrame
		= (CMDIChildWnd*)(pTemplate->CreateNewFrame(pDoc, NULL));
	if (pNewFrame == NULL)
		return;     // not created
	ASSERT_KINDOF(CMDIChildWnd, pNewFrame);
	pTemplate->InitialUpdateFrame(pNewFrame, pDoc);
}

CView* CLogDocument::GetCompatibleView(CRuntimeClass* pViewClass)
   {
    CView* pView;
	POSITION pos = GetFirstViewPosition();
	while (pos != NULL)
	{
		pView = GetNextView(pos);
		if (pView->IsKindOf(pViewClass))
		{
			return pView;
		}
	}
    return NULL;
   }

void CLogDocument::OnUpdateViewChar(CCmdUI *pCmdUI)
{
    BOOL t=(GetCompatibleView(RUNTIME_CLASS(CMultiView)) != NULL)?TRUE:FALSE;
	pCmdUI->SetCheck(t);
}


void CLogDocument::OnUpdateViewTree(CCmdUI *pCmdUI)
{
	BOOL t=(GetCompatibleView(RUNTIME_CLASS(CMyTreeView)) != NULL)?TRUE:FALSE;
	pCmdUI->SetCheck(t);
}

void CLogDocument::Close()
   {
	CView*pView,*pView2;
	((CMainFrame*)theApp.m_pMainWnd)->IsClosing=TRUE;
	pView = GetCompatibleView(RUNTIME_CLASS(CMultiView));
	pView2 = GetCompatibleView(RUNTIME_CLASS(CMyTreeView));
	if (pView) pView->GetParentFrame()->DestroyWindow();
	if (pView2) pView2->GetParentFrame()->DestroyWindow();
    return;
   }

void CLogDocument::OnRepOpen()
    {
        CRepDial repdial;
        if (RepOpened) OnRepClose();
        repdial.AddData=AddData;
        repdial.AddParsed=AddParsed;
        repdial.FileName=RepFileName;
        if(repdial.DoModal()==IDOK)
         {
		  CString tt;
		  if (repdial.AddData&&repdial.AddParsed) tt="-a ";
		  else if (repdial.AddData) tt="-d ";
		  else if (repdial.AddParsed) tt="-p ";
		  else tt="-n ";
		  short errors;
		  CString str="repopen "+tt+repdial.FileName;
		  char const * t= (char const *)str;
		  str=query.ExecuteCommand(t,&errors);
		  if(errors) RepOpened=TRUE;
		   else RepOpened=FALSE;
         }
    }

void CLogDocument::OnRepClose()
    {
		short errors;
		CString str;
		str=query.ExecuteCommand("repclose",&errors);
        RepOpened=FALSE;
    }

void CLogDocument::OnRepAdd()
    {
		short errors;
		CString str;
		str=query.ExecuteCommand("repadd",&errors);
    }

void CLogDocument::OnUpdateRepClose(CCmdUI *pCmdUI)
    {
     pCmdUI->Enable(RepOpened);
    }

void CLogDocument::OnUpdateRepAdd(CCmdUI *pCmdUI)
    {
     pCmdUI->Enable(RepOpened);
    }


CString & CLogDocument::GetResult()
{
	return query.result;
}

void CLogDocument::DoPrint()
{

       m_pView1=(CMultiView*) GetCompatibleView(RUNTIME_CLASS(CMultiView));
	   if (m_pView1) m_pView1->OnFilePrint();
	    else
		{
			if (AfxMessageBox(LOG_PRINT /*E' necessario aprire una finestra contenente il testo da stampare.*/
				, MB_YESNO)==IDYES) 
			CreateOrDestroyFrame(theApp.logTemplate,
				RUNTIME_CLASS(CMultiView),this);
			m_pView1=(CMultiView*) GetCompatibleView(RUNTIME_CLASS(CMultiView));
			if (m_pView1)m_pView1->SetTemp();
			OnLogThis();
		    if (m_pView1) m_pView1->OnFilePrint();
		}
}

void CLogDocument::DoPrintPreview()
{

       m_pView1=(CMultiView*) GetCompatibleView(RUNTIME_CLASS(CMultiView));
	   if (m_pView1) m_pView1->OnFilePrintPreview();
	    else
		{
			if (AfxMessageBox(LOG_PRINT /*E' necessario aprire una finestra contenente il testo da stampare.*/
				, MB_YESNO)==IDYES) 
			CreateOrDestroyFrame(theApp.logTemplate,
				RUNTIME_CLASS(CMultiView),this);
			m_pView1=(CMultiView*) GetCompatibleView(RUNTIME_CLASS(CMultiView));
			if (m_pView1)m_pView1->SetTemp();
			OnLogThis();
		    if (m_pView1) m_pView1->OnFilePrintPreview();
		}
}

void CLogDocument::DoPrintChars()
{

       m_pView1=(CMultiView*) GetCompatibleView(RUNTIME_CLASS(CMultiView));
	   if (m_pView1) m_pView1->OnSelectPrinterFont();
	    else
		{
			if (AfxMessageBox(LOG_PRINT /*E' necessario aprire una finestra contenente il testo da stampare.*/
				, MB_YESNO)==IDYES) 
			CreateOrDestroyFrame(theApp.logTemplate,
				RUNTIME_CLASS(CMultiView),this);
			m_pView1=(CMultiView*) GetCompatibleView(RUNTIME_CLASS(CMultiView));
			if (m_pView1)m_pView1->SetTemp();
			OnLogThis();
		    if (m_pView1) m_pView1->OnSelectPrinterFont();
		}
}

#include "IndexThread.h"
#include "ProgressDialog.h"

void CLogDocument::OnLogIndex()
{
	CListAllView* m_pView4=(CListAllView*) GetCompatibleView(RUNTIME_CLASS(CListAllView));
	if (!m_pView4) return;
	CProgressDialog d;
	ProgDlg=&d;
	d.m_pDoc=this;
	HANDLE h;
	h=GetCurrentThread();
	DuplicateHandle(GetCurrentProcess(),h,GetCurrentProcess(),&thisthread,0,FALSE,DUPLICATE_SAME_ACCESS);
	CloseHandle(h);
	CWinThread* th=AfxBeginThread(IndexThread,this,
		THREAD_PRIORITY_NORMAL, 0,CREATE_SUSPENDED);
	if (th==NULL) {AfxMessageBox(LOG_ERR_INDEX /*Impossibile creare l'indice*/);return;}
	th->ResumeThread();
	AfxGetApp()->DoWaitCursor(1);
	d.DoModal();
	AfxGetApp()->DoWaitCursor(-1);
	sync.Lock();
	ProgDlg=NULL;
	thisthread=NULL;
	sync.Unlock();
}

void CLogDocument::OnLogIni()
{
	CString s;
	CString str;
	int n=0;
	s=((CAnalyzerApp*)AfxGetApp())->Path;
	s+="query.ini";
	short errors=1;
	do
	{
	 if (errors==0) 
	 {
		 if (n==0) AfxMessageBox(LOG_WRONG_DIR /*Analyzer non  stato lanciato dalla directory dell'eseguibile.\r\n
			 L'esecuzione  possibile ma si deve ricercare il file di configurazione per query (query.ini).*/);
		 s=BrowseIni();
		 ((CAnalyzerApp*)AfxGetApp())->m_lfo="default.lfo";
		 ((CAnalyzerApp*)AfxGetApp())->m_pdo="default.pdo";
		 ((CAnalyzerApp*)AfxGetApp())->m_dfo="default.dfo";
		 ((CAnalyzerApp*)AfxGetApp())->m_ifo="default.ifo";
		 n=1;
	 }
	 for(int i=s.GetLength()-1;i>=0;i--) 
		 if (s[i]=='\\' || s[i]=='/')
			 {((CAnalyzerApp*)AfxGetApp())->Path=s.Left(i+1);break;}
	 s="iniopen "+s;
	 str="chdir "+((CAnalyzerApp*)AfxGetApp())->Path;
	 str=query.ExecuteCommand(str,&errors);
	 query.ExecuteCommand(s,&errors);
	} while (errors==0);
}

CString CLogDocument::BrowseIni()
{
	 CFileDialog dlgFile(TRUE);
	 BOOL bResult;

	 CString title=LOG_QUERY_INI /*Selezionare un file INI per Query*/;
	 CString fileName;
     UINT nIDSTitle=AFX_IDS_OPENFILE;
     DWORD lFlags=OFN_HIDEREADONLY | OFN_FILEMUSTEXIST;
     BOOL bOpenFileDialog=TRUE; 

	 dlgFile.m_ofn.Flags |= lFlags;

	 CString strFilter="files ini (*.ini)";
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += _T("*.ini");
	 strFilter += (TCHAR)'\0';   // last string
	 CString strDefault;
	 // append the '*.*' all files filter
	 CString allFilter;
	 VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	 strFilter += allFilter;
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += _T(M_ALLFLT);
	 strFilter += (TCHAR)'\0';   // last string
	 dlgFile.m_ofn.nMaxCustFilter++;

	 dlgFile.m_ofn.lpstrFilter = strFilter;
	 dlgFile.m_ofn.lpstrTitle = title;
	 dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	 do {
	  bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	  fileName.ReleaseBuffer();
	 } while (!bResult);
	  return fileName;
}

void CLogDocument::OnLogJump(int i)
{
	short errors;
	CString str; 
	str.Format ("jump %d",i);
	str=query.ExecuteCommand(str,&errors);
	if(errors!=0) {RefreshViews();AdjustToolbar(errors);}
}

void CLogDocument::OnCapAdd() 
{
		short errors;
		CString str;
		str=query.ExecuteCommand("wcapadd",&errors);
}

void CLogDocument::OnUpdateCapAdd(CCmdUI* pCmdUI) 
{
     pCmdUI->Enable(CapOpened);
}

void CLogDocument::OnCapClose() 
{
		short errors;
		CString str;
		str=query.ExecuteCommand("wcapclose",&errors);
        CapOpened=FALSE;
}

void CLogDocument::OnUpdateCapClose(CCmdUI* pCmdUI) 
{
     pCmdUI->Enable(CapOpened);
}

void CLogDocument::OnCapOpen() 
{
	 CFileDialog dlgFile(TRUE);
	 BOOL bResult;

	 CString title=LOG_CAP_CREATE /*Selezionare il file ACP da creare*/;
	 CString fileName;
     UINT nIDSTitle=AFX_IDS_OPENFILE;
     DWORD lFlags=OFN_HIDEREADONLY; 
     BOOL bOpenFileDialog=FALSE; 

	 dlgFile.m_ofn.Flags |= lFlags;

	 CString strFilter="files cap (*.acp)";
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += _T("*.acp");
	 strFilter += (TCHAR)'\0';   // last string
	 CString strDefault;
	 // append the '*.*' all files filter
	 CString allFilter;
	 VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	 strFilter += allFilter;
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += _T(M_ALLFLT);
	 strFilter += (TCHAR)'\0';   // last string
	 dlgFile.m_ofn.nMaxCustFilter++;

	 dlgFile.m_ofn.lpstrFilter = strFilter;
	 dlgFile.m_ofn.lpstrTitle = title;
	 dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	 bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	 fileName.ReleaseBuffer();
	 if (!bResult) return;
     short errors;
	 CString str="wcapopen " + fileName;
	 char const * t= (char const *)str;
	 str=query.ExecuteCommand(t,&errors);
	 if(errors) CapOpened=TRUE;
	  else CapOpened=FALSE;
	 return ;
}

#include "suppprotos.h"

void CLogDocument::OnViewProtos() 
{
	short errors;
	CString String=query.ExecuteCommand("getprotos",&errors);
	if(errors!=0) 
	{
	  if (!sp_cr)
	  {
		  sp.Create(IDD_SUPP_PROTOS);
		  sp.UpdateWindow();
		  sp_cr=TRUE;
	  }
	  sp.ShowWindow(SW_SHOW);
	  LineCollection lc(&String);
	  sp.UpdateTree(lc);
	} else 
		{
		 AfxMessageBox(String);
		}
}

void CLogDocument::OnViewProtosTxt() 
{
	short errors;
	CString String=query.ExecuteCommand("getprotos",&errors);
	if(errors!=0) 
	{
	  ((CAnalyzerApp*)AfxGetApp())->CreateRoDoc(LOG_RESULT /*"Risultati dei comandi impartiti*/,String);
	} else 
		{
		 AfxMessageBox(String);
		}
}

void CLogDocument::SetTemp(int IsTemp, const char * fileName)
{
	m_IsTemp=IsTemp;
	m_File=fileName;
}

#include "GenSetupDlg.h"

void CLogDocument::OnLogMacro() 
{
	CGenSetupDlg dlg;
	dlg.m_Flt1="*.mac";
	dlg.m_Flt2="*.mo";
	dlg.m_File1="Files Macro (*.mac)";
	dlg.m_File2="Files Macro (*.mo)";
	dlg.m_F1=m_mac;
	dlg.m_F2=m_mo;
	dlg.m_Title=LOG_MAC_TITLE /*Esecuzione Macro*/;
	dlg.m_AdvVisible=1;
	if (dlg.DoModal()!=IDOK) return;
	CString s;
	m_mac=dlg.m_F1;
	m_mo=dlg.m_F2;
	if (m_mo=="")
		if(dlg.m_IsAdvanced) {AfxMessageBox(LOG_MO_ERROR /*Specificare almeno un file 'mo'.*/);return;}
		else dlg.m_F2=m_mo;
	if (m_mac!="")
	{
#ifndef ENGLISH
		s=((CAnalyzerApp*)(AfxGetApp()))->Path+"ddreader \""+ dlg.m_F1+ "\" \""+ dlg.m_F2+ "\"";
#else
		s=((CAnalyzerApp*)(AfxGetApp()))->Path+"ddreader_e \""+ dlg.m_F1+ "\" \""+ dlg.m_F2+ "\"";
#endif
		int i=((CAnalyzerApp*)(AfxGetApp()))->ExecuteApp(s);
		if (i) {AfxMessageBox(LOG_MAC_CERR /*Impossibile compilare la macro*/);return;}
	}
	else if (!dlg.m_IsAdvanced)
	{
		AfxMessageBox(LOG_MAC_SRCERR /*E' necessario specificare il file sorgente.*/);
		return;
	}
	short errors;
	if(AfxMessageBox(LOG_MACRO_END /*Attenzione! L'esecuzione di una macro richiede che poi il file di catture
				  corrente venga chiuso. Si desidera procedere?*/,MB_YESNO)==IDNO) return;
	s=query.ExecuteCommand("macro "+m_mo,&errors);
	if(s!="")
		((CAnalyzerApp*)AfxGetApp())->CreateRoDoc(LOG_MACRO_RES /*Risultati della macro*/,s);
	Close();
}

void CLogDocument::OnCatturaPrimoprotocollo() 
{
	short errors;
	CString s=query.ExecuteCommand("getprotos -s",&errors);
	if(errors==0) {AfxMessageBox(LOG_PROTOS_ERR /*Impossibile determinare i protocolli supportati*/);return;}
	LineCollection lc(&s);
	CFirstProto dlg;	
	dlg.SetLC(lc);
	if (dlg.DoModal()==IDOK)
	{
		s=query.ExecuteCommand("setfirstpr "+dlg.m_First,&errors);
		if(errors==0) {AfxMessageBox(LOG_PROTSET_ERR /*Impossibile impostare il primo protocollo*/);return;}
		OnLogThis();
	}
}

int CLogDocument::OnLogDelete(CString & s)
{
		short errors;
		query.ExecuteCommand(s,&errors);
		return errors;
}

void CLogDocument::OnEditClearP() 
{
	 CListAllView* m_pView4=(CListAllView*) GetCompatibleView(RUNTIME_CLASS(CListAllView));
	 CString s;
	 int Refresh=0;
	 if (IsCopy) SetCapModifiedFlag(TRUE);
	 if (m_pView4) 
		   {
			int i,j;
			CString t;
			s="delete ";
			i=0;j=0;
			if (m_pView4->GetSelectedCount()==1)
			{
				i=GetCurPos();
				t.Format("%d ",i);
				s+=t;
			}
			else
			while ((i=m_pView4->GetSelectedItem(i))>=0)
			{
				i++;
				t.Format("%d ",i);
				s+=t;
			}
		   }
	   else
	   {
		short errors;
		s=query.ExecuteCommand("getpos",&errors);
		int n;
		for (int i=0;i<s.GetLength();i++)
		 if (s[i]==':') {sscanf (((const char*)s)+i+1, "%d", &n);break;}
		s.Format("delete %d",n);
	   }
	if (OnLogDelete(s)==0) {Close();return;}
	Refresh=1;
	if (m_IsCap==0 || Refresh)
	{
		RefreshIndex();
	}
	query.result="";
	RefreshViews();
	OnLogFirst();
}

void CLogDocument::OnModificaCopiaP() 
{
	if(!m_ClipPck) return;
	ModificaCopiaP();
	OnLogFirst();
}

void CLogDocument::OnModificaIncollaP() 
{
	if(!m_ClipPck) return;
	if (IsCopy) SetCapModifiedFlag(TRUE);
	CAnalyzerApp* app= (CAnalyzerApp*)AfxGetApp();
	CString str;
	str="merge " + app->m_Clipboard;
	short errors;
	query.ExecuteCommand(str,&errors);
	if (!errors) {Close();return;}
	RefreshIndex();
	query.result="";
	RefreshViews();
	OnLogFirst();
}

void CLogDocument::OnModificaTagliaP() 
{
	if(!m_ClipPck) return;
	if (IsCopy) SetCapModifiedFlag(TRUE);
	if (ModificaCopiaP()) {OnLogFirst(); return;}
	OnEditClearP();
	query.result="";
	RefreshViews();
	OnLogFirst();
}

void CLogDocument::RefreshIndex()
{
	CString t,s;
	short errors; 
	s=query.ExecuteCommand("getfirstpr",&errors);
	t="";
	for (int i=0;i<s.GetLength();i++)
	{if (s[i]==':') t=s.Right(s.GetLength()-i-1);break;}
	query.ExecuteCommand("setfirstpr",&errors);
	OnLogIndex();
	s.TrimLeft();
	if (s!="") query.ExecuteCommand("setfirstpr "+t,&errors);
}

void CLogDocument::OnUpdateModificaIncollap(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_ClipPck && ((CAnalyzerApp*)AfxGetApp())->m_ClbFull);
}

int CLogDocument::Str2VecInt(CString & s, CArray<int,int> &dels)
{
	int i,j,l,found,n;
	l=strlen(s);
	found=0;
	n=0;
	dels.SetSize(1);
	for (i=0,j=0;i<l;i++)
	{
		if (s[i]<'0' && s[i]>9) 
		{
			if (found) 
				if (sscanf(((const char*)s)+j,"%d",&dels[n])) 
				{
					n++; 
					dels.SetSize(n+1);
				}
			j=i+1; 
			found=0;
		}
		else found=1;
	}
	if (found) 
		if (sscanf(((const char*)s)+j,"%d",&dels[n])) n++; 
	return n;
}

int CLogDocument::OnLogFilter(CString & flt)
{
	if(filter) delete[]filter;
	filter=new char[strlen(flt)+1];
	strcpy(filter,flt);
	CString str="filter ";
	str+=filter;
	char const * t= (char const *)str;
	short errors;
	str=query.ExecuteCommand(t,&errors);
	int err=errors;
	if(errors==0)
	{
		delete[]filter;
		filter=new char[5];
		strcpy(filter,"TRUE");
		str="filter ";
		str+=filter;
		t= (char const *)str;
		str=query.ExecuteCommand(t,&errors);
	}
	OnLogThis();
	AdjustToolbar(errors);
	return err;
}

int CLogDocument::SerializeCAP(CArchive &ar,int option)
{
	 CFile* f;
	 f=ar.GetFile();
	 CString fileName=f->GetFilePath();
	 ar.Close();
	 f->Close();
	 return SerializeCAP(fileName,option);
}

int CLogDocument::SerializeCAP(CString & fileName,int option)
{
	AfxGetApp()->DoWaitCursor(1);
	 for (int y=0;y<fileName.GetLength();y++)
	 {
		 if (fileName[y]==' ') 
		 {
			 fileName= "\""+ fileName + "\"";
			 break;
		 }
	 }
	 CString str;
	 CString s="copy -f" + fileName+ " ";
	 if (option==1)
	 {
	   CListAllView* m_pView4=(CListAllView*) GetCompatibleView(RUNTIME_CLASS(CListAllView));
	   if (m_pView4) 
		   {
			   if (m_pView4->GetSelectedCount()<=1) goto OnlyOne;
			   int n=GetCurPos();
			   short errors;
			   CString str;
			   int sel=0;
			   while((sel=m_pView4->GetSelectedItem(sel))>=0)
			   {
				sel++;
				str.Format("%d ",sel);
				s+=str;
			   }
			   str=query.ExecuteCommandSilent(s,&errors);
			   if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
			   OnLogJump(n);
		   }
  		else goto OnlyOne;
	 }
	 else if (option==3)
	   {
			   int n=GetCurPos();
			   short errors;
			   CString str;
			   str=query.ExecuteCommandSilent("getfltpck -",&errors);
			   if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
			   int l;
			   for(int i=0;l=str.GetLength(),i<l;i++) 
				   if (str[i]=='\n') 
					   if(l-1-i>0)str=str.Left(i-1)+str.Right(l-i-1);
					   else str=str.Left(i-1);
			   str=query.ExecuteCommandSilent(s + str,&errors);
			   if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
			   OnLogJump(n);
	   }
	 else if (option==4)
	   {
			   int n=GetCurPos();
			   short errors;
			   CString str;
			   str=query.ExecuteCommandSilent("getitemnr",&errors);
			   if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
			   int l,len=-1;
			   int i;
			   for(i=0;l=str.GetLength(),i<l;i++) 
				   if (str[i]==':') 
					   {str=str.Mid(i+1);sscanf(str,"%d",&len); break;}
			   str="";
			   char t[10];
			   for(i=1;i<=len;i++) 
			   {
				   sprintf(t,"%d ",i);
				   str+=t;
			   }
			   str=query.ExecuteCommandSilent(s + str,&errors);
			   if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
			   OnLogJump(n);
	   }
	 else
	   {
OnlyOne:
		short errors;
		str=query.ExecuteCommandSilent("getpos",&errors);
		if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
		for(int u=0;u<str.GetLength();u++)
			if (str[u]==':') {str=str.Mid(u+1);break;}
		s+=str;
	    query.ExecuteCommandSilent(s,&errors);
		if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
	    query.ExecuteCommandSilent("jump "+str,&errors);
		if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
	   }
	 return 0;
}

int CLogDocument::SerializeHTML(CArchive& ar,int option)
    {
       ar.WriteString("<HTML><HEAD><TITLE>Report</TITLE></HEAD><BODY>");
	   AfxGetApp()->DoWaitCursor(1);
	   if (option==1)
	   {
	     CListAllView* m_pView4=(CListAllView*) GetCompatibleView(RUNTIME_CLASS(CListAllView));
	     if (m_pView4) 
		   {
			   if (m_pView4->GetSelectedCount()<=1) goto OnlyOne;
			   int n=GetCurPos();
			   short errors;
			   CString str;
			   int sel=0;
			   while((sel=m_pView4->GetSelectedItem(sel))>=0)
			   {
				sel++;
				str.Format("jump %d",sel);
				str=query.ExecuteCommandSilent(str,&errors);
				if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
				lc=str;
				Lc2HTMLCString(lc,str);
				ar.WriteString(str);
				ar.WriteString("<HR>");
			   }
			   OnLogJump(n);
		   }
		 else goto OnlyOne;
	   }
	 else if (option==3)
	   {
			   int n=GetCurPos();
			   short errors;
			   CString str;
			   str=query.ExecuteCommandSilent("getfltpck -",&errors);
			   if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
			   int l;
			   for(int i=0;l=str.GetLength(),i<l;i++) 
				   if (str[i]=='\n') 
					   if(l-1-i>0)str=str.Left(i-1)+str.Right(l-i-1);
					   else str=str.Left(i-1);
			   CArray<int,int> tmp;
			   l=Str2VecInt(str,tmp);
			   LineCollection lc;
			   for (i=0;i<l;i++)
			   {
				str.Format("jump %d",tmp[i]);
				str=query.ExecuteCommandSilent(str,&errors);
				if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
				lc=str;
				Lc2HTMLCString(lc,str);
				ar.WriteString(str);
				ar.WriteString("<HR>");
			   }
			   OnLogJump(n);
	   }
	 else if (option==4)
	   {
			   int n=GetCurPos();
			   short errors;
			   CString str;
			   str=query.ExecuteCommandSilent("getitemnr",&errors);
			   if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
			   int l,len=-1;
			   for(int i=0;l=str.GetLength(),i<l;i++) 
				   if (str[i]==':') 
					   {str=str.Mid(i+1);sscanf(str,"%d",&len); break;}
			   LineCollection lc;
			   for (i=1;i<=len;i++)
			   {
				str.Format("jump %d",i);
				str=query.ExecuteCommandSilent(str,&errors);
				if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
				lc=str;
				Lc2HTMLCString(lc,str);
				ar.WriteString(str);
				ar.WriteString("<HR>");
			   }
			   OnLogJump(n);
	   }
	   else
	   {
OnlyOne:
	    CString Up;
		short errors;
		lc=query.ExecuteCommandSilent("this",&errors);
		if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
        Lc2HTMLCString(lc,Up);
	    ar.WriteString(Up);
	   }
       ar.WriteString("</BODY></HTML>");
	   return 0;
    }

int CLogDocument::SerializeTXT(CArchive & ar,int option)
{
	   AfxGetApp()->DoWaitCursor(1);
	   if(option==1)
	   {
	     CListAllView* m_pView4=(CListAllView*) GetCompatibleView(RUNTIME_CLASS(CListAllView));
	     if (m_pView4) 
		   {
			   if (m_pView4->GetSelectedCount()<=1) goto OnlyOneS;
			   int n=GetCurPos();
			   short errors;
			   CString str;
			   int sel=0;
			   while((sel=m_pView4->GetSelectedItem(sel))>=0)
			   {
				sel++;
				str.Format("jump %d",sel);
				str=query.ExecuteCommandSilent(str,&errors);
				if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
				ar.WriteString(str);
				ar.WriteString("\r\n###############################################################\r\n\r\n");
			   }
			   OnLogJump(n);
		   }
		 else goto OnlyOneS;
	   } 
	 else if (option==3)
	   {
			   int n=GetCurPos();
			   short errors;
			   CString str;
			   str=query.ExecuteCommandSilent("getfltpck -",&errors);
			   if (!errors) {AfxMessageBox(LOG_SAVE_ERR/*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
			   int l;
			   for(int i=0;l=str.GetLength(),i<l;i++) 
				   if (str[i]=='\n') 
					   if(l-1-i>0)str=str.Left(i-1)+str.Right(l-i-1);
					   else str=str.Left(i-1);
			   CArray<int,int> tmp;
			   l=Str2VecInt(str,tmp);
			   for (i=0;i<l;i++)
			   {
				str.Format("jump %d",tmp[i]);
				str=query.ExecuteCommandSilent(str,&errors);
				if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
				ar.WriteString(str);
				ar.WriteString("\r\n###############################################################\r\n\r\n");
			   }
			   OnLogJump(n);
	   }
	 else if (option==4)
	   {
			   int n=GetCurPos();
			   short errors;
			   CString str;
			   str=query.ExecuteCommandSilent("getitemnr",&errors);
			   if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
			   int l,len=-1;
			   for(int i=0;l=str.GetLength(),i<l;i++) 
				   if (str[i]==':') 
					   {str=str.Mid(i+1);sscanf(str,"%d",&len); break;}
			   LineCollection lc;
			   for (i=1;i<=len;i++)
			   {
				str.Format("jump %d",i);
				str=query.ExecuteCommandSilent(str,&errors);
				if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
				ar.WriteString(str);
				ar.WriteString("\r\n###############################################################\r\n\r\n");
			   }
			   OnLogJump(n);
	   }
	   else
	   {
OnlyOneS:
	    CString Up;
		short errors;
		Up=query.ExecuteCommandSilent("this",&errors);
		if (!errors) {AfxMessageBox(LOG_SAVE_ERR /*Errore nel salvataggio*/);AfxGetApp()->DoWaitCursor(-1);return 1;}
	    ar.WriteString(Up);
	   }
	   return 0;
}


int CLogDocument::GetCurPos()
{
   int n;
   short errors;
   CString str=query.ExecuteCommand("getpos",&errors);
   if(errors) 
   {
	  for (n=0;n<str.GetLength();n++)
		  if (str[n]==':')
		  {
			  sscanf(((LPCTSTR)str)+n+1,"%d",&n);
			  break;
		  }
   }
   else return 1;
   return n;
}

void CLogDocument::RefreshMenu()
{
	CMenu* pCurMenu = NULL;
	CMenu* pTopMenu = AfxGetMainWnd()->GetMenu();
}


void CLogDocument::OnLogFindNext() 
{
	if(!m_FindF) LogPrevf();
		else LogNextf();
}

void CLogDocument::OnUpdateLogFindNext(CCmdUI* pCmdUI) 
{
    if (m_FindF) pCmdUI->Enable(Enabled.nextf);
		else pCmdUI->Enable(Enabled.prevf);
}

void CLogDocument::OnLogFind() 
{
	CMainFrame* f=(CMainFrame*)AfxGetMainWnd();
	if (!f->m_Fltr)
	  {
		  f->fltr=new CFinderDlg;
		  if (f->fltr->filter) delete[] f->fltr->filter;
		  f->fltr->filter=new char[strlen(filter)+1];
		  strcpy(f->fltr->filter,filter);
		  f->fltr->Create(IDD_LOG_FINDER);
		  f->fltr->m_pDoc=this;
		  f->fltr->UpdateWindow();
		  f->m_Fltr=TRUE;
	  }
	else
	  {
		  f->fltr->SendMessage(WM_CLOSE,0,0);
		  f->m_Fltr=FALSE;
		  delete f->fltr;
		  f->fltr=NULL;
	  }
	f->fltr->ShowWindow(SW_SHOW);
}

void CLogDocument::UpdateFindDial()
{
	CMainFrame* f=(CMainFrame*)AfxGetMainWnd();
	if (f->m_Fltr)
	{
		f->fltr->m_pDoc=this;
		if (m_FindF) 
			f->fltr->m_FindNext.SetCheck(TRUE);
		else 
			f->fltr->m_FindPrev.SetCheck(TRUE);
	}
}

void CLogDocument::OnUpdateModificaCopiap(CCmdUI* pCmdUI) 
{
    pCmdUI->Enable(m_ClipPck && Enabled.cutcopy);
}

void CLogDocument::OnUpdateModificaTagliap(CCmdUI* pCmdUI) 
{
    pCmdUI->Enable(m_ClipPck && Enabled.cutcopy);
}

void CLogDocument::OnUpdateLogFind(CCmdUI* pCmdUI) 
{
    pCmdUI->Enable(Enabled.first|Enabled.last);
}

void CLogDocument::LogQuery(const char * fileName)
{
      theApp.DoWaitCursor(1);
	  short errors;
/*	  CString str="query -f - ";
	  if (theApp.AskCsv)
	  {
		  if (AfxMessageBox(ASK_CSV ,MB_YESNO)==IDYES)
			  str="query -t -f - ";
	  }*/
	  CString str;
	  if (theApp.AskCsv==0) str="query -f - ";
	  else str="query -t -f - ";

	  str+=fileName;
	  char const * t= (char const *)str;
	  str=query.ExecuteCommand(t,&errors);
      CString tt=E_QRYTITLE1;
      tt+=fileName;
	  if (theApp.AskCsv==2)
		theApp.CreateCsvDoc(tt,str);
	  else
		theApp.CreateRoDoc(tt,str);
      theApp.DoWaitCursor(-1);
}

void CLogDocument::SetPathName(LPCTSTR lpszPathName, BOOL bAddToMRU)
{
	// store the path fully qualified
	m_strPathName = lpszPathName;
	ASSERT(!m_strPathName.IsEmpty());       // must be set to something
	m_bEmbedded = FALSE;
	ASSERT_VALID(this);

	// set the document title based on path name
	CString str;
	str=GetTitle();
	if (str="")
	{
		str=lpszPathName;
		int l=str.GetLength();
		for (int i=l-1;i>=0;i--)
			if (str[i]=='\\') {str=LOG_CAP_FILENAME /*File di Cattura: */ + str.Mid(i+1);break;}
		SetTitle(str);
	}
	if (m_IsTemp==0)AfxGetApp()->AddToRecentFileList( lpszPathName );
}

void CLogDocument::OnSelectExp() 
{
	CListAllView* m_pView4=(CListAllView*) GetCompatibleView(RUNTIME_CLASS(CListAllView));
	if(m_pView4) 
	{
	    short errors;
	    CString str;
		//Scambiare le due aree commentate se si vuole inserire una finestra intermedia
		// /*
	 	CSelFilter dlg;
		CWinApp* pApp = AfxGetApp();   
		dlg.m_FileName=pApp->GetProfileString(FLTR_FILE_SEC, "Filters", 
		(((CAnalyzerApp*)AfxGetApp())->Path)+FLTRS);
		if(dlg.m_FileName[1]!=':') 
			dlg.m_FileName=((CAnalyzerApp*)AfxGetApp())->Path+dlg.m_FileName;
		dlg.m_pDoc=this;
		if(dlg.DoModal()==IDOK)
		{
			   if (!OnLogFilter(dlg.m_Filter))
			   OnLogFilter((CString)"TRUE");
		// */
	   /*
	    CFilterDialog fltr;
	    fltr.m_Title="Inserire il filtro di Selezione";
	    fltr.filter=new char[strlen(filter)+1];
	    strcpy(fltr.filter,filter);
	    fltr.m_pDoc=this;
	    if(fltr.DoModal()==IDOK)
			{
	   */
			   int n=GetCurPos();
			   str=query.ExecuteCommand("getfltpck -",&errors);
			   if (!errors) 
				{
					AfxMessageBox("Errore nella selezione");
					OnLogJump(n);
					return;
				}
			   int l;
			   AfxGetApp()->DoWaitCursor(1);
			   for(int i=0;l=str.GetLength(),i<l;i++) 
				   if (str[i]=='\n' || str[i]=='\r') 
					   str.SetAt(i,' ');
					   //if(l-1-i>0)str=str.Left(i-1)+str.Right(l-i-1);
					   //else str=str.Left(i-1);
			   CArray<int,int> tmp;
			   l=Str2VecInt(str,tmp);
			   if (l>0) m_pView4->SelNone();
				else 
				{
					AfxMessageBox(LOG_NOITEM_ERR /*Nessun elemento soddisfa il criterio*/); 			   
					OnLogJump(n);
					AfxGetApp()->DoWaitCursor(-1);
					return;
				}
			   for (i=0;i<l;i++) m_pView4->SelectItem(tmp[i]-1);
			   OnLogJump(tmp[0]);
			   m_pView4->SetFocus();
			   AfxGetApp()->DoWaitCursor(-1);
			}
	}
}

void CLogDocument::OnUpdateSelectExp(CCmdUI* pCmdUI) 
{
	CListAllView* m_pView4=(CListAllView*) GetCompatibleView(RUNTIME_CLASS(CListAllView));
	if(m_pView4) pCmdUI->Enable(TRUE);
	else pCmdUI->Enable(FALSE);
}


void CLogDocument::OnInvSel() 
{
	CListAllView* m_pView4=(CListAllView*) GetCompatibleView(RUNTIME_CLASS(CListAllView));
	if(m_pView4) 
		m_pView4->InvertSelection();
}

void CLogDocument::OnUpdateInvSel(CCmdUI* pCmdUI) 
{
	CListAllView* m_pView4=(CListAllView*) GetCompatibleView(RUNTIME_CLASS(CListAllView));
	if(m_pView4) pCmdUI->Enable(TRUE); else pCmdUI->Enable(FALSE);
}

void CLogDocument::OnRemSel() 
{
	CListAllView* m_pView4=(CListAllView*) GetCompatibleView(RUNTIME_CLASS(CListAllView));
	if(m_pView4) 
		m_pView4->RemoveSelected();
}

void CLogDocument::OnUpdateRemSel(CCmdUI* pCmdUI) 
{
	CListAllView* m_pView4=(CListAllView*) GetCompatibleView(RUNTIME_CLASS(CListAllView));
	if(m_pView4) pCmdUI->Enable(TRUE); else pCmdUI->Enable(FALSE);
}

int CLogDocument::ModificaCopiaP()
{
	CAnalyzerApp* app= (CAnalyzerApp*)AfxGetApp();
	CString str=app->m_Clipboard;
	if (!SerializeCAP (str,1))
		app->m_ClbFull=TRUE;
	else return 1;
	return 0;
}

void CLogDocument::OnRinfrescaIndice() 
{
	OnLogIndex();
}

void CLogDocument::OnUpdateRinfrescaIndice(CCmdUI* pCmdUI) 
{
	CListAllView* m_pView4=(CListAllView*) GetCompatibleView(RUNTIME_CLASS(CListAllView));
	if(m_pView4) pCmdUI->Enable(TRUE); else pCmdUI->Enable(FALSE);
}

void CLogDocument::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(FALSE);
}

void CLogDocument::OnClipText() 
{
	m_ClipTxt=!m_ClipTxt;
}

void CLogDocument::OnUpdateClipText(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_ClipTxt);
}

void CLogDocument::OnClipPck() 
{
	m_ClipPck=!m_ClipPck;
}

void CLogDocument::OnUpdateClipPck(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_ClipPck);
}

BOOL CLogDocument::UpdateModificaTaglia()
{
	if (m_ClipPck) return Enabled.cutcopy;
	return FALSE;
}

BOOL CLogDocument::UpdateModificaCopia()
{
	if (m_ClipPck) return Enabled.cutcopy;
	return FALSE;
}

BOOL CLogDocument::UpdateModificaIncolla()
{
	if (m_ClipPck) return ((CAnalyzerApp*)AfxGetApp())->m_ClbFull;
	return FALSE;
}

void CLogDocument::OnEditDataExt() 
{
	CListAllView* m_pView4=(CListAllView*) GetCompatibleView(RUNTIME_CLASS(CListAllView));
	if(!m_pView4) return;
	m_pView4->ExtData();
}

void CLogDocument::OnUpdateEditDataExt(CCmdUI* pCmdUI) 
{
	CListAllView* m_pView4=(CListAllView*) GetCompatibleView(RUNTIME_CLASS(CListAllView));
	if(m_pView4) pCmdUI->Enable(TRUE); else pCmdUI->Enable(FALSE);
}
