// CLogDocument.h : header file
//

#ifndef _CLOGDOCUMENT
#define _CLOGDOCUMENT

#include <linecoll.h>
#include "query.h"	// Added by ClassView
#include <afxmt.h>

class CMyTreeView;
class CMultiView;
class ThreadDial;

#include "SuppProtos.h"

/////////////////////////////////////////////////////////////////////////////
// CLogDocument frame

class EnableMenu
{
    public:
    BOOL first;
    BOOL prevf;
    BOOL prev;
    BOOL next;
    BOOL nextf;
    BOOL last;
    BOOL cutcopy;
};

class CProgressDialog;

class CLogDocument : public CDocument
{
    DECLARE_SERIAL(CLogDocument)
protected:
    CLogDocument();            // protected constructor used by dynamic creation

// Attributes
public:
    char* lfName;
	HANDLE thisthread;
	CProgressDialog *ProgDlg;
    BOOL IsCopy;
	BOOL m_IsCapModified;
	BOOL IsCapModified(){return m_IsCapModified;}
	void SetCapModifiedFlag(BOOL b){m_IsCapModified=b;}
	void OnClose(){OnCloseDocument();}
// Operations
public:
	void EditCut(){OnModificaTagliaP();}
	void EditCopy(){OnModificaCopiaP();}
	void EditPaste(){OnModificaIncollaP();}

// Implementation
protected:
    virtual ~CLogDocument();
    virtual void Serialize(CArchive& ar);    // overridden for document i/o
    virtual BOOL OnNewDocument();
    void CreateOrDestroyFrame(CDocTemplate* pTemplate,
	 CRuntimeClass* pViewClass,CDocument* pDocument=NULL);

protected:
    int SerializeHTML(CArchive& ar,int option);
    BOOL closewithoutconfirm;
    BOOL VTree;
    // Generated message map functions
    //{{AFX_MSG(CLogDocument)
    afx_msg void OnLogFilter();
    afx_msg void OnLogNext();
    afx_msg void OnLogNextf();
    afx_msg void OnLogPrev();
    afx_msg void OnLogPrevf();
    afx_msg void OnLogQuery();
    afx_msg void OnFileSave();
    afx_msg void OnFileSaveAs();
    afx_msg void OnRepOpen();
    afx_msg void OnRepClose();
    afx_msg void OnRepAdd();
    afx_msg void OnLogFirst();
    afx_msg void OnLogLast();
    afx_msg void OnUpdateRepClose(CCmdUI *pCmdUI);
    afx_msg void OnUpdateRepAdd(CCmdUI *pCmdUI);
    afx_msg void OnUpdateLogFirst(CCmdUI *pCmdUI);
    afx_msg void OnUpdateLogLast(CCmdUI *pCmdUI);
    afx_msg void OnUpdateLogNext(CCmdUI *pCmdUI);
    afx_msg void OnUpdateLogNextf(CCmdUI *pCmdUI);
    afx_msg void OnUpdateLogPrev(CCmdUI *pCmdUI);
    afx_msg void OnUpdateLogPrevf(CCmdUI *pCmdUI);
    afx_msg void OnViewChar();
    afx_msg void OnViewTree();
    afx_msg void OnUpdateViewChar(CCmdUI *pCmdUI);
    afx_msg void OnUpdateViewTree(CCmdUI *pCmdUI);
    afx_msg void OnCloseDocument();
	afx_msg void OnCapAdd();
	afx_msg void OnUpdateCapAdd(CCmdUI* pCmdUI);
	afx_msg void OnCapClose();
	afx_msg void OnUpdateCapClose(CCmdUI* pCmdUI);
	afx_msg void OnCapOpen();
	afx_msg void OnViewProtos();
	afx_msg void OnViewProtosTxt();
	afx_msg void OnLogMacro();
	afx_msg void OnCatturaPrimoprotocollo();
	afx_msg void OnEditClearP();
	afx_msg void OnModificaCopiaP();
	afx_msg void OnModificaIncollaP();
	afx_msg void OnModificaTagliaP();
	afx_msg void OnUpdateModificaIncollap(CCmdUI* pCmdUI);
	afx_msg void OnLogFindNext();
	afx_msg void OnUpdateLogFindNext(CCmdUI* pCmdUI);
	afx_msg void OnLogFind();
	afx_msg void OnUpdateModificaCopiap(CCmdUI* pCmdUI);
	afx_msg void OnUpdateModificaTagliap(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLogFind(CCmdUI* pCmdUI);
	afx_msg void OnSelectExp();
	afx_msg void OnUpdateSelectExp(CCmdUI* pCmdUI);
	afx_msg void OnInvSel();
	afx_msg void OnUpdateInvSel(CCmdUI* pCmdUI);
	afx_msg void OnRemSel();
	afx_msg void OnUpdateRemSel(CCmdUI* pCmdUI);
	afx_msg void OnRinfrescaIndice();
	afx_msg void OnUpdateRinfrescaIndice(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSave(CCmdUI* pCmdUI);
	afx_msg void OnClipText();
	afx_msg void OnUpdateClipText(CCmdUI* pCmdUI);
	afx_msg void OnClipPck();
	afx_msg void OnUpdateClipPck(CCmdUI* pCmdUI);
	afx_msg void OnEditDataExt();
	afx_msg void OnUpdateEditDataExt(CCmdUI* pCmdUI);
	//}}AFX_MSG
    DECLARE_MESSAGE_MAP();
 public:
	IQuery query;
	CMutex sync;
    void LogNextf() {OnLogNextf();}
    void LogPrevf() {OnLogPrevf();}
	 BOOL m_FindF;
 private:
	 int ModificaCopiaP();
	 int GetCurPos();
	 void RefreshIndex();
	 LineCollection lc;
	 char* filter;
    int RapNum;
    BOOL RepOpened;
    BOOL CapOpened;
    CFile RepFile;
    BOOL AddParsed;
    BOOL AddData;
	char* SeparateRows(char* c);
    CString RepFileName;
    FILE* tables;
    EnableMenu Enabled;
	CString &FormatRow(const char* const c,CString& r, int i=0 );
    CString BrowseIni();
 public:
	 BOOL UpdateModificaTaglia();
	 BOOL UpdateModificaCopia();	 
	 BOOL UpdateModificaIncolla();
	 BOOL m_ClipTxt;
	 BOOL m_ClipPck;
	 virtual void SetPathName(LPCTSTR lpszPathName, BOOL bAddToMRU);
	 void LogQuery(const char* fileName);
	 void UpdateFindDial();
	 void RefreshMenu();
    CView* GetCompatibleView(CRuntimeClass* pViewClass);
	 int OnLogFilter(CString & flt);
	 int SerializeTXT(CArchive &ar,int option);
	 int Str2VecInt(CString& s, CArray<int,int>& v);
	 int SerializeCAP(CString & fileName,int option);
	 int m_IsCap;
	 int m_IsCapTmp;
	 int m_IsNewTmp;
	 int OnLogDelete(CString & s);
	 int SerializeCAP(CArchive &ar,int option);
	 CString m_File;
	 CString m_mac;
	 CString m_mo;
	 int m_IsTemp;
	 void SetTemp(int IsTemp,const char* fileName);
	 void OnLogJump(int i);
	 void OnLogIni();
	 void OnLogIndex();
    void AdjustToolbar(int i);
    void RefreshViews();
	void DoPrint();
	void DoPrintChars();
	void DoPrintPreview();
	CString & GetResult();
    void Close();
    BOOL erroropening;
    void OnLogThis();
	CString *Lc2HTMLCString(LineCollection &,CString &);
    CFrameWnd* m_pFrame2;
    BOOL VChar;
    CMultiView *m_pView1;
    CMyTreeView *m_pView2;
	CSuppProtos sp;
	BOOL sp_cr;
};

/////////////////////////////////////////////////////////////////////////////


#endif
