// CListAllView.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"

#include "CListView.h"
#include "LineColl.h"
#include "mytreevw.h"
#include "selcols.h"
#include "datadialog.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define LIST_TIME "Tempo di cattura"
#define LIST_DESC "Descrizione"
#define ERR_SAVE_INDEX "Impossibile salvare l'indice"
#define SAVE_SEL "Salvare solo gli elementi selezionati?"
#else
#define LIST_TIME "Capture Time"
#define LIST_DESC "Description"
#define ERR_SAVE_INDEX "Unable to save packet index"
#define SAVE_SEL "Does Analyzer save only selected items?"
#endif

/////////////////////////////////////////////////////////////////////////////
// CListAllView

IMPLEMENT_DYNCREATE(CListAllView, CListViewEx);

BEGIN_MESSAGE_MAP(CListAllView, CListViewEx)
    //{{AFX_MSG_MAP(CListAllView)
	ON_WM_LBUTTONDOWN()
	ON_COMMAND(IDM_SELECT_ALL_PCK, OnEditSelectAll)
	ON_COMMAND(ID_EDIT_SELECT_ALL, OnEditSelectAll)
	ON_COMMAND(IDM_LOG_EXPAND, OnLogExpand)
	ON_UPDATE_COMMAND_UI(IDM_LOG_EXPAND, OnUpdateLogExpand)
	ON_COMMAND(IDM_LOG_COLLAPSE, OnLogCollapse)
	ON_UPDATE_COMMAND_UI(IDM_LOG_COLLAPSE, OnUpdateLogCollapse)
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnClick)
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(IDM_SORT_NUM, OnSortNum)
	ON_COMMAND(IDM_SORT_LAYER3, OnSortLayer3)
	ON_COMMAND(IDM_SORT_DESTMAC, OnSortDestmac)
	ON_COMMAND(IDM_SORT_DESCRIZIONE, OnSortDescrizione)
	ON_COMMAND(IDM_SORT_SRCMAC, OnSortSrcmac)
	ON_COMMAND(IDM_SORT_TIMESTAMP, OnSortTimestamp)
	ON_UPDATE_COMMAND_UI(IDM_SORT_DESCRIZIONE, OnUpdateSortDescrizione)
	ON_UPDATE_COMMAND_UI(IDM_SORT_DESTMAC, OnUpdateSortDestmac)
	ON_UPDATE_COMMAND_UI(IDM_SORT_LAYER3, OnUpdateSortLayer3)
	ON_UPDATE_COMMAND_UI(IDM_SORT_NUM, OnUpdateSortNum)
	ON_UPDATE_COMMAND_UI(IDM_SORT_SRCMAC, OnUpdateSortSrcmac)
	ON_UPDATE_COMMAND_UI(IDM_SORT_TIMESTAMP, OnUpdateSortTimestamp)
	ON_WM_LBUTTONDBLCLK()
	ON_COMMAND(IDM_SAVEINDEX, OnSaveindex)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	ON_COMMAND(IDM_LIST_COLS, OnListCols)
	ON_WM_CREATE()
	ON_COMMAND(IDM_EDIT_DATA_EXT, OnEditDataExt)
	//}}AFX_MSG_MAP
	//ON_COMMAND(ID_VIEW_STATUS_BAR, OnBarCheck)
	ON_COMMAND(IDM_PRINT_CHAR, OnSelectPrinterFont)
	ON_COMMAND(ID_FILE_PRINT, CListViewEx::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CListViewEx::OnFilePrintPreview)
END_MESSAGE_MAP();

CListAllView::CListAllView()
{
	m_ArrowsType=0;
	f=NULL;
	m_LastSel=-1;
	m_Inc=FALSE;
	m_SortType=0;
	m_C1=1;
	m_C2=1;
	m_C3=1;
	m_C4=1;
	m_C5=1;
	m_C6=1;
	m_Separator=" | ";
}

CListAllView::~CListAllView()
{
	if (f) delete f;
}

/////////////////////////////////////////////////////////////////////////////
// CListAllView message handlers

int hexcmp(CArray<int,int> & v,const unsigned char* str);
CArray<int,int> &StrToHex(char const * s,CArray<int,int> &dest);
CString &HexToStr(CArray<int,int>& s,CString &d);

void CListAllView::Update(LineCollection & lc)
    {
        doc=(CLogDocument*)GetDocument();
	    int n;
		int l,m,i;
		m=list->GetItemCount();
		CString t,q;
		CAnalyzerApp* app=(CAnalyzerApp*)AfxGetApp();
		CArray<int,int> v; 
		StrToHex((const char*)app->m_IndexSep,v);
        for(n=lc.getLineCount(),i=0;i<n;i++)
         {
			t=lc.line(i);
			if(t=="") continue;
			q.Format("%d",m+i+1);
	        AddItem(m+i,0,q,8);
			for (l=0;l<t.GetLength();l++)
				if (hexcmp(v,(const unsigned char*)((const char*)t)+l)==0) break;
			q=t.Left(l); if (q[0]!=' ') q=" "+q;
	        AddItem(m+i,1,q); 
			t=t.Right(t.GetLength()-l-v.GetSize());
			for(l=0;l<t.GetLength();l++)
				if (hexcmp(v,(const unsigned char*)((const char*)t)+l)==0) break;
			q=t.Left(l);
			t=t.Right(t.GetLength()-l-v.GetSize());
		    AddItem(m+i,2,q);
			for(l=0;l<t.GetLength();l++)
				if (hexcmp(v,(const unsigned char*)((const char*)t)+l)==0) break;
			q=t.Left(l);
			t=t.Right(t.GetLength()-l-v.GetSize());
		    AddItem(m+i,3,q);
			for(l=0;l<t.GetLength();l++)
				if (hexcmp(v,(const unsigned char*)((const char*)t)+l)==0) break;
			q=t.Left(l);
			t=t.Right(t.GetLength()-l-v.GetSize());
		    AddItem(m+i,4,q);
		    AddItem(m+i,5,t);
         }
		list->UpdateWindow();
    }

int CListAllView::OnCreate(LPCREATESTRUCT lpCreateStruct)
    {
	lpCreateStruct->style |= LVS_REPORT | LVS_ICON | LVS_SHOWSELALWAYS;
	lpCreateStruct->style &= ~LVS_SINGLESEL;
	if (CListView::OnCreate(lpCreateStruct) == -1)
		return -1;
    list = &GetListCtrl();
    f=new CFont();
    if (f->CreatePointFont(((CAnalyzerApp*)AfxGetApp())->DefinedDim,
		((CAnalyzerApp*)AfxGetApp())->DefinedFont)==0)
     {
       if (!f->CreateStockObject(OEM_FIXED_FONT))
        {delete[]f;f=NULL;}
     }
	if(f) list->SetFont(f);
	LOGFONT l;
	f->GetLogFont(&l);
    list->InsertColumn(0,"Num.", LVCFMT_LEFT,50);
    list->InsertColumn(1,LIST_TIME /*Tempo di cattura*/, LVCFMT_LEFT,200);
    list->InsertColumn(2,"Dest. MAC", LVCFMT_LEFT,120);
    list->InsertColumn(3,"Src. MAC", LVCFMT_LEFT,120);
    list->InsertColumn(4,"Lay. 3", LVCFMT_LEFT,80);
    list->InsertColumn(5,LIST_DESC /*Descrizione*/, LVCFMT_LEFT,500);
	m_ctlImage.Create(IDB_TREE,16,0,RGB(255,0,255));
	list->SetImageList(&m_ctlImage,LVSIL_SMALL);
	SetFullRowSel(TRUE);
	ModifyStyle(0L, LVS_SHOWSELALWAYS);

    return 0;
    }


void CListAllView::AddItem(int nItem,int nSubItem,LPCTSTR strItem,int nImageIndex)
{
	LV_ITEM lvItem;
	lvItem.mask = LVIF_TEXT;
	lvItem.iItem = nItem;
	lvItem.iSubItem = nSubItem;
	if (nSubItem==0)
	{
		lvItem.mask= LVIF_TEXT | LVIF_PARAM;
		lvItem.lParam=nItem;
	}
	while(strItem[0]==' ') strItem++;
	lvItem.pszText = (LPTSTR) strItem;
	if(nImageIndex != -1){
		lvItem.mask |= LVIF_IMAGE;
		lvItem.iImage = nImageIndex;
	}
	if(nSubItem == 0)
		list->InsertItem(&lvItem);
	else list->SetItem(&lvItem);
}


void CListAllView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	point.x=10;
	CListView::OnLButtonDown(nFlags, point);
	UINT uFlags=LVHT_ONITEM|LVHT_TOLEFT;
	int nHitItem=GetListCtrl().HitTest(point,&uFlags);
	if (GetListCtrl().GetItemCount()==0) return;
	if (nHitItem<0) {doc->OnLogThis();return;}
	LV_ITEM it;
	it.mask=LVIF_PARAM;
	it.iItem=nHitItem;
	it.iSubItem=0;
	GetListCtrl().GetItem(&it);
	doc->OnLogJump(it.lParam+1);
}

void CListAllView::Clear()
{
    list->DeleteAllItems();
	m_SortType=0;
}


void CListAllView::UpdateSel(int n)
{
	unsigned int ni=list->GetSelectedCount();
	n--;
	LV_FINDINFO it;
	it.flags=LVFI_PARAM;
	it.lParam=n;
	n=GetListCtrl().FindItem(&it);
	if (ni<=1)
	{
		if (m_LastSel>=0) list->SetItemState(m_LastSel,0,LVIS_SELECTED);
		list->SetItemState(n,0xFFFFFFFF,LVIS_SELECTED|LVIS_FOCUSED);
	}
	else list->SetItemState(n,0xFFFFFFFF,LVIS_FOCUSED);
	list->EnsureVisible(n,FALSE);
	m_LastSel=n;
}

int CListAllView::GetSelectedItem(int start)
{
	unsigned int ni=list->GetItemCount();
	if (start<0) start=0;
	if (start>=(signed)ni) return -1;
	int i,ii;
	for(i=start; i<(signed)ni; i++)
	{
	 LV_FINDINFO it;
	 it.flags=LVFI_PARAM;
	 it.lParam=i;
	 ii=GetListCtrl().FindItem(&it);
	 if (list->GetItemState(ii,LVIS_SELECTED)) 
		return ii;
	}
	return -1;
}

int CListAllView::GetSelectedCount()
{
	return list->GetSelectedCount();
}

void CListAllView::OnEditSelectAll() 
{
	unsigned int ni=list->GetItemCount();
	int i;
	AfxGetApp()->DoWaitCursor(1);
	for(i=0; i<(signed)ni; i++)
	{
	 list->SetItemState(i,0xFFFFFFFF,LVIS_SELECTED);
	}
	AfxGetApp()->DoWaitCursor(-1);
}

void CListAllView::OnLogExpand() 
{
	CLogDocument* doc=(CLogDocument*) GetDocument();
	CMyTreeView* m_pView4=(CMyTreeView*) doc->GetCompatibleView(RUNTIME_CLASS(CMyTreeView));
	if(m_pView4) m_pView4->OnExpand();
}

void CListAllView::OnUpdateLogExpand(CCmdUI* pCmdUI) 
{
	CLogDocument* doc=(CLogDocument*) GetDocument();
	CMyTreeView* m_pView4=(CMyTreeView*) doc->GetCompatibleView(RUNTIME_CLASS(CMyTreeView));
	if(m_pView4) pCmdUI->Enable((m_pView4->expansion<3)?TRUE:FALSE);
	else pCmdUI->Enable(FALSE);
}

void CListAllView::OnLogCollapse() 
{
	CLogDocument* doc=(CLogDocument*) GetDocument();
	CMyTreeView* m_pView4=(CMyTreeView*) doc->GetCompatibleView(RUNTIME_CLASS(CMyTreeView));
	if(m_pView4) m_pView4->OnCollapse();
}

void CListAllView::OnUpdateLogCollapse(CCmdUI* pCmdUI) 
{
	CLogDocument* doc=(CLogDocument*) GetDocument();
	CMyTreeView* m_pView4=(CMyTreeView*) doc->GetCompatibleView(RUNTIME_CLASS(CMyTreeView));
	if(m_pView4) pCmdUI->Enable((m_pView4->expansion>0)?TRUE:FALSE);
	else pCmdUI->Enable(FALSE);
}


void CListAllView::SelectItem(int i)
{
	LV_FINDINFO it;
	it.flags=LVFI_PARAM;
	it.lParam=i;
	i=GetListCtrl().FindItem(&it);
	list->SetItemState(i,0xFFFFFFFF,LVIS_SELECTED);
}

void CListAllView::SelNone()
{
	unsigned int ni=list->GetItemCount();
	int i;
	AfxGetApp()->DoWaitCursor(1);
	for(i=0; i<(signed)ni; i++)
	{
	 list->SetItemState(i,0,LVIS_SELECTED);
	}
	AfxGetApp()->DoWaitCursor(-1);
}

typedef struct {
	int n;
	CListCtrl* l; 
} lststr;

int CALLBACK CompareFunc(LPARAM lParam1, LPARAM lParam2, 
    LPARAM lParamSort)
{
	lststr* l=(lststr*)lParamSort;
	LV_FINDINFO it1;
	it1.flags=LVFI_PARAM;
	it1.lParam=lParam1;
	lParam1=l->l->FindItem(&it1);
	LV_FINDINFO it2;
	it2.flags=LVFI_PARAM;
	it2.lParam=lParam2;
	lParam2=l->l->FindItem(&it2);
	return strcmp(l->l->GetItemText(lParam1,l->n),l->l->GetItemText(lParam2,l->n));
}

int CALLBACK CompareFuncNum(LPARAM lParam1, LPARAM lParam2, 
    LPARAM lParamSort)
{
	if (lParam1<lParam2) return -1;
	if (lParam1>lParam2) return 1;
	return 0;
}

void CListAllView::OnColumnClick(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	lststr t;
	t.n=pNMListView->iSubItem;
	if (t.n==0) 
	{
		OnSortNum();
		return;
	}
	t.l=&GetListCtrl();

	m_SortType=t.n+1;
	AfxGetApp()->DoWaitCursor(1);
	GetListCtrl().SortItems(CompareFunc,(LPARAM)&t);
	AfxGetApp()->DoWaitCursor(-1);
	
	*pResult = 0;
}

void CListAllView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	CListView::OnRButtonDown(nFlags, point);
	BCMenu m1;
	BCMenu *m2;
	CPoint p2=point;
	ClientToScreen(&point);
	m1.LoadMenu(IDR_INDEXMENU);
	m2=m1.GetSubMenu(0);
	m2->LoadToolbar(IDR_BMP_1);
	if(m_SortType==0) m2->CheckMenuItem(IDM_SORT_NUM,MF_CHECKED|MF_BYCOMMAND);
	if(m_SortType==1) m2->CheckMenuItem(IDM_SORT_TIMESTAMP,MF_CHECKED|MF_BYCOMMAND);
	if(m_SortType==2) m2->CheckMenuItem(IDM_SORT_DESTMAC,MF_CHECKED|MF_BYCOMMAND);
	if(m_SortType==3) m2->CheckMenuItem(IDM_SORT_SRCMAC,MF_CHECKED|MF_BYCOMMAND);
	if(m_SortType==4) m2->CheckMenuItem(IDM_SORT_LAYER3,MF_CHECKED|MF_BYCOMMAND);
	if(m_SortType==5) m2->CheckMenuItem(IDM_SORT_DESCRIZIONE,MF_CHECKED|MF_BYCOMMAND);
	m2->TrackPopupMenu(0,point.x,point.y,this);
	m1.DestroyMenu();
}

void CListAllView::OnSortNum() 
{
	m_SortType=0;
	AfxGetApp()->DoWaitCursor(1);
	GetListCtrl().SortItems(CompareFuncNum,0);
	AfxGetApp()->DoWaitCursor(-1);
}

void CListAllView::OnSortLayer3() 
{
	lststr t;
	t.n=4;
	t.l=&GetListCtrl();
	m_SortType=4;

	AfxGetApp()->DoWaitCursor(1);
	GetListCtrl().SortItems(CompareFunc,(LPARAM)&t);
	AfxGetApp()->DoWaitCursor(-1);
}

void CListAllView::OnSortDestmac() 
{
	lststr t;
	t.n=2;
	t.l=&GetListCtrl();
	m_SortType=2;

	AfxGetApp()->DoWaitCursor(1);
	GetListCtrl().SortItems(CompareFunc,(LPARAM)&t);
	AfxGetApp()->DoWaitCursor(-1);
}

void CListAllView::OnSortDescrizione() 
{
	lststr t;
	t.n=5;
	t.l=&GetListCtrl();
	m_SortType=5;

	AfxGetApp()->DoWaitCursor(1);
	GetListCtrl().SortItems(CompareFunc,(LPARAM)&t);
	AfxGetApp()->DoWaitCursor(-1);
}

void CListAllView::OnSortSrcmac() 
{
	lststr t;
	t.n=3;
	t.l=&GetListCtrl();
	m_SortType=3;

	AfxGetApp()->DoWaitCursor(1);
	GetListCtrl().SortItems(CompareFunc,(LPARAM)&t);
	AfxGetApp()->DoWaitCursor(-1);
}

void CListAllView::OnSortTimestamp() 
{
	lststr t;
	t.n=1;
	t.l=&GetListCtrl();
	m_SortType=1;

	AfxGetApp()->DoWaitCursor(1);
	GetListCtrl().SortItems(CompareFunc,(LPARAM)&t);
	AfxGetApp()->DoWaitCursor(-1);
}

void CListAllView::OnUpdateSortDescrizione(CCmdUI* pCmdUI) 
{
	if (m_SortType==5) pCmdUI->SetCheck(TRUE);
		else pCmdUI->SetCheck(FALSE);
}

void CListAllView::OnUpdateSortDestmac(CCmdUI* pCmdUI) 
{
	if (m_SortType==2) pCmdUI->SetCheck(TRUE);
		else pCmdUI->SetCheck(FALSE);
}

void CListAllView::OnUpdateSortLayer3(CCmdUI* pCmdUI) 
{
	if (m_SortType==4) pCmdUI->SetCheck(TRUE);
		else pCmdUI->SetCheck(FALSE);
}

void CListAllView::OnUpdateSortNum(CCmdUI* pCmdUI) 
{
	if (m_SortType==0) pCmdUI->SetCheck(TRUE);
		else pCmdUI->SetCheck(FALSE);
}

void CListAllView::OnUpdateSortSrcmac(CCmdUI* pCmdUI) 
{
	if (m_SortType==3) pCmdUI->SetCheck(TRUE);
		else pCmdUI->SetCheck(FALSE);
}

void CListAllView::OnUpdateSortTimestamp(CCmdUI* pCmdUI) 
{
	if (m_SortType==1) pCmdUI->SetCheck(TRUE);
		else pCmdUI->SetCheck(FALSE);
}

void CListAllView::RemoveSelected()
{
	unsigned int ni=list->GetItemCount();
	int i,ii;
	LV_FINDINFO it;
	it.flags=LVFI_PARAM;
	AfxGetApp()->DoWaitCursor(1);
	for(i=0; i<(signed)ni; i++)
	{
	 it.lParam=i;
	 ii=list->FindItem(&it);
	 if (list->GetItemState(ii,LVIS_SELECTED)) 
		list->SetItemState(i,0,LVIS_SELECTED);
		//list->DeleteItem(ii);
	}
	AfxGetApp()->DoWaitCursor(-1);
}

void CListAllView::InvertSelection()
{
	unsigned int ni=list->GetItemCount();
	int i,ii;
	LV_FINDINFO it;
	it.flags=LVFI_PARAM;
	AfxGetApp()->DoWaitCursor(1);
	for(i=0; i<(signed)ni; i++)
	{
	 it.lParam=i;
	 ii=list->FindItem(&it);
	 if (list->GetItemState(ii,LVIS_SELECTED)) 
		list->SetItemState(i,0,LVIS_SELECTED);
	 else
		list->SetItemState(i,0xFFFFFFFF,LVIS_SELECTED);
	}
	AfxGetApp()->DoWaitCursor(-1);
}

/////////////////////////////////////////////////////////////////////////////
// CListAllView Printing support

#include "pageset.h"

extern CPageSetupDlg dlgPageSetup;

void CListAllView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	CView::OnBeginPrinting(pDC, pInfo);

	LPCTSTR pszFileName = GetDocument()->GetPathName();
	BOOL bForceSysTime = _tcschr(pszFileName, '.') == NULL;
	CTime timeSys = CTime::GetCurrentTime();
	CFileStatus status;
	CFile::GetStatus(pszFileName, status);

	if (::dlgPageSetup.m_iHeaderTime != 0 || bForceSysTime)
		m_timeHeader = timeSys;
	else
		m_timeHeader = status.m_mtime;

	if (::dlgPageSetup.m_iFooterTime != 0 || bForceSysTime)
		m_timeFooter = timeSys;
	else
		m_timeFooter = status.m_mtime;

	if (!pInfo->m_bPreview)
		return;

}

void CListAllView::OnPrint(CDC* pDC, CPrintInfo* pInfo)
{
	// get string to show as "filename" in header/footer
	LPCTSTR pszFileName = GetDocument()->GetPathName();
    CFont* pOldFont = pDC->SelectObject (&m_fontPrint);

	if (pszFileName[0] == 0)
		pszFileName = GetDocument()->GetTitle();

	// go thru global CPageSetupDlg to format the header and footer
	::dlgPageSetup.FormatHeader(strHeader, m_timeHeader, pszFileName,
		pInfo->m_nCurPage);
	::dlgPageSetup.FormatFooter(strFooter, m_timeFooter, pszFileName,
		pInfo->m_nCurPage);
	RECT RightBorder;
	RightBorder.top=::dlgPageSetup.m_Top;
	RightBorder.bottom=::dlgPageSetup.m_Bottom;
	RightBorder.left=::dlgPageSetup.m_Left;
	RightBorder.right=::dlgPageSetup.m_Right;
	SetBorders(&RightBorder);
	CListViewEx::OnPrint(pDC, pInfo);
	pDC->SelectObject (pOldFont);
}

void ScaleLogFont(LPLOGFONT plf, const CDC& dcFrom, const CDC& dcTo)
	// helper to scale log font member from one DC to another!
{
	plf->lfHeight = MulDiv(plf->lfHeight,
		dcTo.GetDeviceCaps(LOGPIXELSY), dcFrom.GetDeviceCaps(LOGPIXELSY));
	plf->lfWidth = MulDiv(plf->lfWidth,
		dcTo.GetDeviceCaps(LOGPIXELSX), dcFrom.GetDeviceCaps(LOGPIXELSX));
}

void CListAllView::OnSelectPrinterFont()
{
	CWaitCursor wait;
	CFont* pFont = GetPrinterFont();
	LOGFONT lf;
	LPLOGFONT plf = NULL;
	if (pFont != NULL)
	{
		pFont->GetObject(sizeof(LOGFONT), &lf);
		plf = &lf;
	}

	// magic to get printer dialog that would be used if we were printing!
	CPrintDialog dlgPrint(FALSE);
	if (!AfxGetApp()->GetPrinterDeviceDefaults(&dlgPrint.m_pd))
	{
		AfxMessageBox("Cannot get printer defaults.");
		return;
	}
	wait.Restore();
	HDC hdcPrint = dlgPrint.CreatePrinterDC();
	if (hdcPrint == NULL)
	{
		AfxMessageBox("Cannot get printer device context.");
		return;
	}

	CDC dcScreen;
	dcScreen.Attach(::GetDC(NULL));
	CDC dcPrint;
	dcPrint.Attach(hdcPrint);

	if (plf != NULL)
	{
		// need to map initial logfont to screen metrics.
		::ScaleLogFont(plf, dcPrint, dcScreen);
	}

	// now bring up the dialog since we know the printer DC
	CFontDialog dlg(plf, CF_PRINTERFONTS, &dcPrint);
	if (dlg.DoModal() == IDOK)
	{
		// map the resulting logfont back to printer metrics.
		lf = dlg.m_lf;
		::ScaleLogFont(&lf, dcScreen, dcPrint);

		SetPrinterFont(NULL);
		m_fontPrint.DeleteObject();
		if (m_fontPrint.CreateFontIndirect(&lf))
		{
			SetPrinterFont(&m_fontPrint);
			m_lfDefPrintFont = lf;

			// notify container that content has changed
			GetDocument()->UpdateAllViews(NULL);
		}
	}
	//NOTE: destructor will call dcPrint.DeleteDC

	::ReleaseDC(NULL, dcScreen.Detach());

}

void CListAllView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	OnLButtonDown(nFlags, point);
}

#include "messages.h"

void CListAllView::OnSaveindex() 
{
	CFileDialog dlgFile(FALSE);

	CString title=M_SAVEAS;
	CString fileName;
    UINT nIDSTitle=AFX_IDS_OPENFILE;
    DWORD lFlags=OFN_HIDEREADONLY ;
    BOOL bOpenFileDialog=FALSE;

	dlgFile.m_ofn.Flags |= lFlags;

	CString strFilter=M_TEXTFILES;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_TXTFLT);
	strFilter += (TCHAR)'\0';   // last string
	CString strDefault;
	// append the '*.*' all files filter
	CString allFilter;
	VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	strFilter += allFilter;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_ALLFLT);
	strFilter += (TCHAR)'\0';   // last string
	strFilter += _T(M_CSVFILES);
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_CSVFLT);
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	BOOL bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	fileName.ReleaseBuffer();
    if (bResult)
    {
	  FILE* f;
	  f=fopen(fileName,"w");
	  int l=fileName.GetLength();
	  CString str=fileName.Mid(l-4);
	  BOOL csv=0;
	  if (str.CompareNoCase(".csv")==0) csv=1;
	  if (f==NULL) {AfxMessageBox(ERR_SAVE_INDEX /*Impossibile salvare l'indice*/);return;}
	  BOOL savesel=0;
	  if (AfxMessageBox(SAVE_SEL /*Does Analyzer save only selected items?*/, MB_YESNO)) savesel=TRUE;
	  unsigned int ni=list->GetItemCount();
	  int i;
	  LV_FINDINFO it;
	  it.flags=LVFI_PARAM;
	  AfxGetApp()->DoWaitCursor(1);
	  for(i=0; i<(signed)ni; i++)
	  {
		if (savesel && GetListCtrl().GetItemState(i,LVIS_SELECTED)==0) continue;
		for(int j=0;j<6;j++)
		{
			str=GetListCtrl().GetItemText(i,j);
			fputs(str,f);
			if (csv)
			{
			 if (j!=5) fputs("; ",f); 
			 else fputs(";\n",f);
			}
			else
			{
			 if (j!=5) fputs(" | ",f); 
			 else fputs("\n",f);
			}
		}
	  }
	  fclose(f);
	  AfxGetApp()->DoWaitCursor(-1);
	}
}


void CListAllView::OnEditCopy() 
{
  CLogDocument* log=(CLogDocument*)GetDocument();
  BOOL b;
  if (!log) return;
  b=log->UpdateModificaCopia();
  if (log->m_ClipPck) log->EditCopy();
  if (!log->m_ClipTxt) return;
  EditCopy();
}

void CListAllView::OnUpdateEditCopy(CCmdUI* pCmdUI) 
{
	BOOL b=FALSE;
	CLogDocument* log=(CLogDocument*)GetDocument();
	if (!log) {pCmdUI->Enable(b); return;}
	b=log->UpdateModificaCopia();
	if (log->m_ClipTxt)
	{
	    int ni = (DWORD) GetListCtrl().GetSelectedCount();
		if (ni>0) b=TRUE; 
	}
	pCmdUI->Enable(b); 
}

void CListAllView::OnListCols() 
{
	CSelCols dlg;
	dlg.m_C1=m_C1;
	dlg.m_C2=m_C2;
	dlg.m_C3=m_C3;
	dlg.m_C4=m_C4;
	dlg.m_C5=m_C5;
	dlg.m_C6=m_C6;
	dlg.m_Sep=m_Separator;
	if (dlg.DoModal()==IDOK)
	{
		m_C1=dlg.m_C1;
		m_C2=dlg.m_C2;
		m_C3=dlg.m_C3;
		m_C4=dlg.m_C4;
		m_C5=dlg.m_C5;
		m_C6=dlg.m_C6;
		m_Separator=dlg.m_Sep;
	}
}

void CListAllView::EditCopy()
{
  LPTSTR  lpDataBuffer;
  HGLOBAL hDataBuffer;
  DWORD dwMemSize;

  int ni = (DWORD) GetListCtrl().GetItemCount();
  LV_COLUMN lvc;
  lvc.mask = LVCF_FMT | LVCF_WIDTH;
  int nColumn=6,i;			   
  CString string,str;
  for(i=0; i<(signed)ni; i++)
	  {
		if (GetListCtrl().GetItemState(i,LVIS_SELECTED)==0) continue;
		if (m_C1)
		{
			str=GetListCtrl().GetItemText(i,0);
			string+=str;
			string+=m_Separator; 
		}
		if (m_C2)
		{
			str=GetListCtrl().GetItemText(i,1);
			string+=str;
			string+=m_Separator; 
		}
		if (m_C3)
		{
			str=GetListCtrl().GetItemText(i,2);
			string+=str;
			string+=m_Separator; 
		}
		if (m_C4)
		{
			str=GetListCtrl().GetItemText(i,3);
			string+=str;
			string+=m_Separator; 
		}
		if (m_C5)
		{
			str=GetListCtrl().GetItemText(i,4);
			string+=str;
			string+=m_Separator; 
		}
		if (m_C6)
		{
			str=GetListCtrl().GetItemText(i,5);
			string+=str;
			string+=m_Separator; 
		}
		string+="\r\n"; 
	  }
  string+="\0";
  dwMemSize=string.GetLength()+1;

  if( !(hDataBuffer = GlobalAlloc( GMEM_DDESHARE, dwMemSize ) ) ) {
    AfxMessageBox("Out of memory");
    return;
  }
  if( !(lpDataBuffer = (LPTSTR) GlobalLock( hDataBuffer ) ) ) {
    GlobalFree( hDataBuffer );
    AfxMessageBox("Out of memory");
    return;
  }

  *lpDataBuffer = '\0';
  memcpy(lpDataBuffer,(const char*)string,dwMemSize);

  GlobalUnlock( hDataBuffer );

  if( !OpenClipboard() ) {
    Sleep( 250 );  // wait a quarter second and try again.
    if( !OpenClipboard() ) {
      AfxMessageBox("Could not open the Clipboard!");
      GlobalFree( hDataBuffer );
      return;
    }
  }
  if( !EmptyClipboard() ) {
    AfxMessageBox("Could not empty the Clipboard!");
    GlobalFree( hDataBuffer );
    return;
  }
  if( !SetClipboardData( CF_TEXT, hDataBuffer ) ) {
    AfxMessageBox("Could not copy data to the Clipboard!");
    GlobalFree( hDataBuffer );
    return;
  }
  CloseClipboard();

  return;
}

const char* FindToken(const char* str,const char* token)
{
	int n=strlen(token);
	int i,l=strlen(str);
	for(i=0;i<l-n;i++)
		if(strncmp(str+i,token,n)==0) return str+i+n;
	return NULL;
}

void CListAllView::OnEditDataExt() 
{
	ExtData();
}

int CListAllView::GetDataStr(int inizio, CString & string)
{
  int i,ni = (DWORD) GetListCtrl().GetItemCount();
  CString str;
  for(i=inizio; i<(signed)ni; i++)
	  {
		if (GetListCtrl().GetItemState(i,LVIS_SELECTED)==0) continue;
		if (m_C1)
		{
			str=GetListCtrl().GetItemText(i,0);
			string+=str;
			string+=m_Separator; 
		}
		if (m_C2)
		{
			str=GetListCtrl().GetItemText(i,1);
			string+=str;
			string+=m_Separator; 
		}
		if (m_C3)
		{
			str=GetListCtrl().GetItemText(i,2);
			string+=str;
			string+=m_Separator; 
		}
		if (m_C4)
		{
			str=GetListCtrl().GetItemText(i,3);
			string+=str;
			string+=m_Separator; 
		}
		if (m_C5)
		{
			str=GetListCtrl().GetItemText(i,4);
			string+=str;
			string+=m_Separator; 
		}
		if (m_C6)
		{
			str=GetListCtrl().GetItemText(i,5);
			string+=str;
			string+=m_Separator; 
		}
		string+="\r\n"; 
		return i+1;
	  }
	return -1;
}

void CListAllView::ExtData()
{
	CDataDialog dlg;
	dlg.m_pView=this;
	if(dlg.DoModal()==IDOK)
	{
		CString str;
		CString string;
		CString t;
		const char* c;
		int i,n=0;
		int ni=dlg.m_Vals.GetSize();
		int v;
		while((n=GetDataStr(n,str))>=0)
		{
			t=str;
			for(i=0;i<ni;i++)
			{
				c=t;
				v=dlg.m_Vals[i];
				//c=FindToken(c,dlg.m_Tags[i]);
				//if(c) sscanf(c,"%d",&v);
				v=dlg.FindToken(c,i);
				str.Format("%d ",v);
				string +=str;
			}
			string +="\r\n";
			str="";
		}
		((CAnalyzerApp*)AfxGetApp())->CreateTblDoc("",string);
	}
}
