// CListAllView.h : header file
//

#include <afxcview.h>
#include "clogdocument.h"
#include "listvwex.h"

class LineCollection;
/////////////////////////////////////////////////////////////////////////////
// CListAllView view

class CListAllView : public CListViewEx
{
    DECLARE_DYNCREATE(CListAllView);

protected:
    CListAllView();            // protected constructor used by dynamic creation
	int m_SortType;
	CFont m_fontPrint;

// Attributes
private:
	UINT m_nPreviewPage;
	CTime m_timeHeader;
	CTime m_timeFooter;
	CString strHeader;
	CString strFooter;
	virtual void SetStrHeader(CString& str) {str=strHeader;}
	virtual void SetStrFooter(CString& str) {str=strFooter;}

public:
	LOGFONT m_lfDefPrintFont;
	LOGFONT m_lfDefPrintFontOld;
	void SaveIndex(){OnSaveindex();}
	void SelectCols(){OnListCols();}

// Operations
public:
	void ExtData();
	int GetDataStr(int inizio,CString& string);
	void EditCopy();
	void InvertSelection();
	void RemoveSelected();
	void SelNone();
	void SelectItem(int i);
	void OnSelectAll(){OnEditSelectAll();SetFocus();}
	int GetSelectedCount();
	int GetSelectedItem(int start);
	BOOL m_Inc;
	int m_LastSel;
	void UpdateSel(int n);
	void Clear();
	int m_ArrowsType;
	void UpdateCurVect(int n);
    CImageList m_ctlImage;
    void AddItem(int nItem,int nSubItem,LPCTSTR strItem,int nImageIndex=-1);
    void Update(LineCollection & lc);
    int OnCreate(LPCREATESTRUCT lpCreateStruct);
    CListCtrl *list;

// Printing...
	virtual void OnPrint(CDC* pDC, CPrintInfo *pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);

// Implementation
protected:
    virtual ~CListAllView();

protected:
    CLogDocument * doc;
    // Generated message map functions
    //{{AFX_MSG(CListAllView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnEditSelectAll();
	afx_msg void OnLogExpand();
	afx_msg void OnUpdateLogExpand(CCmdUI* pCmdUI);
	afx_msg void OnLogCollapse();
	afx_msg void OnUpdateLogCollapse(CCmdUI* pCmdUI);
	afx_msg void OnColumnClick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnSortNum();
	afx_msg void OnSortLayer3();
	afx_msg void OnSortDestmac();
	afx_msg void OnSortDescrizione();
	afx_msg void OnSortSrcmac();
	afx_msg void OnSortTimestamp();
	afx_msg void OnUpdateSortDescrizione(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSortDestmac(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSortLayer3(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSortNum(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSortSrcmac(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSortTimestamp(CCmdUI* pCmdUI);
	afx_msg void OnSelectPrinterFont();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnSaveindex();
	afx_msg void OnEditCopy();
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	afx_msg void OnListCols();
	afx_msg void OnEditDataExt();
	//}}AFX_MSG
    DECLARE_MESSAGE_MAP();


private:
	CString m_Separator;
	CFont* f;
	CStatusBar m_StatusBar;
    UINT indicators[2];
	BOOL	m_C1;
	BOOL	m_C2;
	BOOL	m_C3;
	BOOL	m_C4;
	BOOL	m_C5;
	BOOL	m_C6;
};

/////////////////////////////////////////////////////////////////////////////

