// CQry4Page.cpp : implementation file
//

#include "stdafx.h"

#include "CQry4Page.h"
#include "Analyzer.h"
#include "messages.h"

#include "resource.h"

#include "CQuerySheet.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define Q4_FINE "Selezionare il file da creare"
#else
#define Q4_FINE "Select file created"
#endif
/////////////////////////////////////////////////////////////////////////////
// CQry4Page

IMPLEMENT_DYNCREATE(CQry4Page, CPropertyPage);

BEGIN_MESSAGE_MAP(CQry4Page, CPropertyPage)
	//{{AFX_MSG_MAP(CQry4Page)
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_EN_KILLFOCUS(IDC_EDIT1,OnKillFocusEdit1)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_BN_CLICKED(IDC_EXPWIZ1, OnExpwiz1)
	ON_BN_CLICKED(IDC_EXPWIZ2, OnExpwiz2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP();

CQry4Page::CQry4Page() : CPropertyPage((unsigned)CQry4Page::IDD)
{
    //{{AFX_DATA_INIT(CQry4Page)
        // ClassExpress member initialization
    //}}AFX_DATA_INIT
    CurGroup=1;
}

CQry4Page::~CQry4Page()
{
}

void CQry4Page::DoDataExchange(CDataExchange* pDX)
{
    CPropertyPage::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CQry4Page)
	DDX_Control(pDX, IDC_EXPWIZ2, m_Wiz2);
	DDX_Control(pDX, IDC_EXPWIZ1, m_Wiz1);
	//}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CQry4Page message handlers


BOOL CQry4Page::OnSetActive()
    {
     ((CPropertySheet*) theApp.qsp)->SetWizardButtons(PSWIZB_NEXT|PSWIZB_BACK);
     CString t;
     t.Format("%d",p->GroupNumber);
     GroupNumber->SetWindowText(t);
     GroupName->SetWindowText(p->Groups[CurGroup-1].GroupName);
     Predicate->SetWindowText(p->Groups[CurGroup-1].Predicate);
     CapName->SetWindowText(p->Groups[CurGroup-1].CapName);
     LengthParameter->SetWindowText(p->Groups[CurGroup-1].LengthParameter);
     Scroll1->SetScrollRange(1,100);
     Scroll1->SetScrollPos(p->GroupNumber);
     Scroll2->SetScrollRange(1,p->GroupNumber);
     Scroll2->SetScrollPos(CurGroup);
	 if (q->m_pDoc==NULL)
	 {
		Enable(m_Wiz1,FALSE);
		Enable(m_Wiz2,FALSE);
	 }
	 else
	 {
		Enable(m_Wiz1,TRUE);
		Enable(m_Wiz2,TRUE);
	 }
     return TRUE;
    }

BOOL CQry4Page::OnWizardFinish()
    {
     theApp.qsp=NULL;
        return TRUE;
    }

BOOL CQry4Page::OnInitDialog()
    {
    GroupNumber=(CEdit*) GetDlgItem(IDC_EDIT1);
    GroupName=(CEdit*) GetDlgItem(IDC_EDIT2);
    Predicate=(CEdit*) GetDlgItem(IDC_EDIT3);
    LengthParameter=(CEdit*) GetDlgItem(IDC_EDIT4);
    CapName=(CEdit*) GetDlgItem(IDC_EDIT5);
    Scroll1=(CScrollBar*)GetDlgItem(IDC_SCROLLBAR1);
    Scroll2=(CScrollBar*)GetDlgItem(IDC_SCROLLBAR2);
	CDialog::OnInitDialog();
    return OnSetActive();
    }

BOOL CQry4Page::OnKillActive()
    {
    CString t;
    int i;
    BOOL err=FALSE;
    GroupNumber->GetWindowText(t);
    if(sscanf((LPCTSTR)t,"%d",&i)) p->GroupNumber=i;
     else err=TRUE;
    GroupName->GetWindowText(p->Groups[CurGroup-1].GroupName);
    Predicate->GetWindowText(p->Groups[CurGroup-1].Predicate);
    CapName->GetWindowText(p->Groups[CurGroup-1].CapName);
    LengthParameter->GetWindowText(p->Groups[CurGroup-1].LengthParameter);
    if (err) AfxMessageBox(E_NUMDATA);
        return TRUE;
    }

void CQry4Page::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
    if(!pScrollBar) return;
    nPos=Scroll2->GetScrollPos();
    switch(nSBCode)
     {
       case SB_LINEDOWN:
        nPos++;
        break;
       case SB_LINEUP:
        nPos--;
        break;
       case SB_PAGEDOWN:
        nPos+=5;
        break;
       case SB_PAGEUP:
        nPos-=5;
        break;
       default:
        break;
     }
    if (nPos<1) nPos=1;
    if ((int)nPos>(int)p->GroupNumber) nPos=p->GroupNumber;
    Scroll2->SetScrollPos(nPos);
    OnKillActive();
    CurGroup=nPos;
    OnSetActive();
}


void CQry4Page::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    CPropertyPage::OnVScroll(nSBCode, nPos, pScrollBar);
    if(!pScrollBar) return;
    nPos=Scroll1->GetScrollPos();
    switch(nSBCode)
     {
       case SB_LINEDOWN:
        nPos++;
        break;
       case SB_LINEUP:
        nPos--;
        break;
       case SB_PAGEDOWN:
        nPos+=5;
        break;
       case SB_PAGEUP:
        nPos-=5;
        break;
       default:
        return;
        break;
     }
    if (nPos<1) nPos=1;
    if (nPos>100) nPos=100;
    Scroll1->SetScrollPos(nPos);
    if((int)nPos<(int)p->GroupNumber)
     {
     if (AfxMessageBox(A_REDQRY,MB_YESNO)==IDYES)
      {
       p->GroupNumber=nPos;
       p->Groups.SetSize(nPos);
      }
     }
     else
      {
       p->GroupNumber=nPos;
       p->Groups.SetSize(nPos);
      }
    if((int)CurGroup>(int)nPos)
     {
        CurGroup=nPos;
        OnSetActive();
     }
     else
     {
      CString t;
      t.Format("%d",p->GroupNumber);
      GroupNumber->SetWindowText(t);
     }
    Scroll2->SetScrollRange(1,p->GroupNumber);
}


void CQry4Page::OnKillFocusEdit1()
{
  CString t;
  int nPos;
  GroupNumber->GetWindowText(t);
  if(sscanf((LPCTSTR)t,"%d",&nPos))
   {
    if (nPos<=100)
    if(nPos<p->GroupNumber)
     {
     if (AfxMessageBox(A_REDQRY,MB_YESNO)==IDYES)
      {
       p->GroupNumber=nPos;
       p->Groups.SetSize(nPos);
      }
     }
     else
      {
       p->GroupNumber=nPos;
       p->Groups.SetSize(nPos);
      }
    if(CurGroup>nPos)
      CurGroup=nPos;
   }
  OnSetActive();
}


void CQry4Page::OnBrowse() 
{
	 CFileDialog dlgFile(TRUE);
	 BOOL bResult;

	 CString title=Q4_FINE /*Selezionare il file da creare*/;
	 CString fileName;
     UINT nIDSTitle=AFX_IDS_OPENFILE;
     DWORD lFlags=OFN_HIDEREADONLY;
     BOOL bOpenFileDialog=TRUE; 

	 dlgFile.m_ofn.Flags |= lFlags;

	 CString strFilter="Files cap (*.acp)";
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += "*.acp";
	 strFilter += (TCHAR)'\0';   // last string
	 CString strDefault;
	 // append the '*.*' all files filter
	 CString allFilter;
	 VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	 strFilter += allFilter;
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += _T("*.*");
	 strFilter += (TCHAR)'\0';   // last string
	 dlgFile.m_ofn.nMaxCustFilter++;

	 dlgFile.m_ofn.lpstrFilter = strFilter;
	 dlgFile.m_ofn.lpstrTitle = title;
	 dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	 bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	 fileName.ReleaseBuffer();
	 if (!bResult) return;
	 CapName->SetWindowText(fileName);
	 return ;
}

void CQry4Page::OnExpwiz1() 
{
	CString exp;
	if (q->DefineExpression(exp)==1) return;
	Predicate->SetWindowText(exp);
}

void CQry4Page::OnExpwiz2() 
{
	CString exp;
	if (q->DefineExpression(exp)==1) return;
	LengthParameter->SetWindowText(exp);
}
