// CQry3Page.cpp : implementation file
//

#include "stdafx.h"

#include "CQry3Page.h"
#include "Analyzer.h"
#include "messages.h"

#include "CQuerySheet.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#include "resource.h"

/////////////////////////////////////////////////////////////////////////////
// CQry3Page

IMPLEMENT_DYNCREATE(CQry3Page, CPropertyPage);

BEGIN_MESSAGE_MAP(CQry3Page, CPropertyPage)
    //{{AFX_MSG_MAP(CQry3Page)
	ON_BN_CLICKED(IDC_EXPWIZ1, OnExpwiz1)
	ON_BN_CLICKED(IDC_EXPWIZ2, OnExpwiz2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP();

CQry3Page::CQry3Page() : CPropertyPage((unsigned)CQry3Page::IDD)
{
    //{{AFX_DATA_INIT(CQry3Page)
        // ClassExpress member initialization
    //}}AFX_DATA_INIT
}

CQry3Page::~CQry3Page()
{
}

void CQry3Page::DoDataExchange(CDataExchange* pDX)
{
    CPropertyPage::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CQry3Page)
	DDX_Control(pDX, IDC_EXPWIZ2, m_Wiz2);
	DDX_Control(pDX, IDC_EXPWIZ1, m_Wiz1);
	DDX_Control(pDX, IDC_EDIT5, m_C5);
	DDX_Control(pDX, IDC_EDIT4, m_C4);
	DDX_Control(pDX, IDC_C3, m_C3);
	DDX_Control(pDX, IDC_C2, m_C2);
	DDX_Control(pDX, IDC_C1, m_C1);
	//}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CQry3Page message handlers


BOOL CQry3Page::OnSetActive()
    {
      ((CPropertySheet*) theApp.qsp)->SetWizardButtons(PSWIZB_NEXT|PSWIZB_BACK);
      CString t;
      t.Format("%d",p->LengthOfInterval[0]);
      Hours->SetWindowText(t);
      t.Format("%d",p->LengthOfInterval[1]);
      Minutes->SetWindowText(t);
      t.Format("%d",p->LengthOfInterval[2]);
      Seconds->SetWindowText(t);
      ExcludedFrames->SetWindowText(p->ExcludedFrames);
      DefaultLengthParameter->SetWindowText(p->DefaultLengthParameter);
	  if (!p->Advanced)
	  {
		  m_C1.ShowWindow(SW_HIDE);
		  m_C2.ShowWindow(SW_HIDE);
		  m_C3.ShowWindow(SW_HIDE);
		  m_C4.ShowWindow(SW_HIDE);
		  m_C5.ShowWindow(SW_HIDE);
		  m_Wiz1.ShowWindow(SW_HIDE);
		  m_Wiz2.ShowWindow(SW_HIDE);
	  }
	  else
	  {
		  m_C1.ShowWindow(SW_SHOW);
		  m_C2.ShowWindow(SW_SHOW);
		  m_C3.ShowWindow(SW_SHOW);
		  m_C4.ShowWindow(SW_SHOW);
		  m_C5.ShowWindow(SW_SHOW);
		  m_Wiz1.ShowWindow(SW_SHOW);
		  m_Wiz2.ShowWindow(SW_SHOW);
	  }
	  if (q->m_pDoc==NULL)
		{
			Enable(m_Wiz1,FALSE);
			Enable(m_Wiz2,FALSE);
		}
	  else
		{
			Enable(m_Wiz1,TRUE);
			Enable(m_Wiz2,TRUE);
		}
      return TRUE;
    }

BOOL CQry3Page::OnInitDialog()
{
    Hours=(CEdit*)GetDlgItem(IDC_EDIT1);
    Minutes=(CEdit*)GetDlgItem(IDC_EDIT2);
    Seconds=(CEdit*)GetDlgItem(IDC_EDIT3);
    ExcludedFrames=(CEdit*)GetDlgItem(IDC_EDIT4);
    DefaultLengthParameter=(CEdit*)GetDlgItem(IDC_EDIT5);
	CDialog::OnInitDialog();
    return OnSetActive();
}

BOOL CQry3Page::OnKillActive()
    {
    CString t;
    int i;
    BOOL err=FALSE;
    Hours->GetWindowText(t);
    if(sscanf((LPCTSTR)t,"%d",&i)) p->LengthOfInterval[0]=i;
     else err=TRUE;
    Minutes->GetWindowText(t);
    if(sscanf((LPCTSTR)t,"%d",&i)) p->LengthOfInterval[1]=i;
     else err=TRUE;
    Seconds->GetWindowText(t);
    if(sscanf((LPCTSTR)t,"%d",&i)) p->LengthOfInterval[2]=i;
     else err=TRUE;
	if (p->Advanced)
	{
		ExcludedFrames->GetWindowText(p->ExcludedFrames);
		DefaultLengthParameter->GetWindowText(p->DefaultLengthParameter);
	}
    if (err) AfxMessageBox(E_NUMDATA);
        return TRUE;
    }

void CQry3Page::OnExpwiz1() 
{
	CString exp;
	if (q->DefineExpression(exp)==1) return;
	ExcludedFrames->SetWindowText(exp);
}

void CQry3Page::OnExpwiz2() 
{
	CString exp;
	if (q->DefineExpression(exp)==1) return;
	DefaultLengthParameter->SetWindowText(exp);
}
