#include "CQueryPrj.h"
#include "messages.h"
#include "analyzer.h"
extern CAnalyzerApp theApp;

#ifndef ENGLISH
#define QP_FILE_ERR "Impossibile Creare un file temporaneo"
#else
#define QP_FILE_ERR "Unable to create a temporary file"
#endif


CQueryPrj::CQueryPrj()
    {
      ExitOk=FALSE;
      UseSemigraphicCharacters=FALSE;
      FrameCount=TRUE;
      FrameRate=FALSE;
      FramePercentage=FALSE;
      ByteCount=FALSE;
      ByteRate=FALSE;
      BytePercentage=TRUE;
      FrameSize=TRUE;
      Totals=FALSE;
      Averages=TRUE;
      Maximums=TRUE;
      Minimums=TRUE;
      ExtremeFramesizes=TRUE;
      JustFinal=TRUE;
      LengthOfInterval[0]=0;
      LengthOfInterval[1]=0;
      LengthOfInterval[2]=5;
      ExcludedFrames="GetVMVar (\"FrameSize\")=CantTell";
      DefaultLengthParameter="GetVMVar (\"FrameSize\")";
      GroupNumber=1;
      FileName=A_QRYNEW;
      Comment=A_QRYCOMMENT;
      Groups.SetSize(1);
	  Advanced=FALSE;
	  CreateFile=FALSE;
    }

CQueryPrj::SaveToDisk()
   {
	 if (CreateFile==FALSE) 
		{
			FileName=theApp.GetTempFile(".stt");
			if (FileName=="") {return FALSE;}
		}
    CString temp;
    CFile f;
    char buf[512];
    if( !f.Open(FileName, CFile::modeCreate | CFile::modeWrite ) ) {
       #ifdef _DEBUG
          afxDump << "Unable to open file" << "\n";
          exit( 1 );
       #endif
    }
    CArchive ar( &f, CArchive::store, 512, buf );
    temp=";\t"+FileName+M_CRLF;
    ar.WriteString(temp);
    ar.WriteString(M_QRYCMT);
    ar.WriteString(";\r\n");
    ar.WriteString(Comment+M_CRLF);
    ar.WriteString(";\r\n");
    ar.WriteString(M_CRLF);
    if(UseSemigraphicCharacters) ar.WriteString("UseSemigraphicCharacters=yes\r\n");
    else ar.WriteString("UseSemigraphicCharacters=no\r\n");
    if(FrameCount) ar.WriteString("ReportFrameCount=yes\r\n");
    else ar.WriteString("ReportFrameCount=no\r\n");
    if(FrameRate) ar.WriteString("ReportFrameRate=yes\r\n");
    else ar.WriteString("ReportFrameRate=no\r\n");
    if(FramePercentage) ar.WriteString("ReportFramePercentage=yes\r\n");
    else ar.WriteString("ReportFramePercentage=no\r\n");
    if(ByteCount) ar.WriteString("ReportByteCount=yes\r\n");
    else ar.WriteString("ReportByteCount=no\r\n");
    if(ByteRate) ar.WriteString("ReportByteRate=yes\r\n");
    else ar.WriteString("ReportByteRate=no\r\n");
    if(BytePercentage) ar.WriteString("ReportBytePercentage=yes\r\n");
    else ar.WriteString("ReportBytePercentage=no\r\n");
    if(FrameSize) ar.WriteString("ReportFrameSize=yes\r\n");
    else ar.WriteString("ReportFrameSize=no\r\n");
    if(Totals) ar.WriteString("ReportTotals=yes\r\n");
    else ar.WriteString("ReportTotals=no\r\n");
    if(Averages) ar.WriteString("ReportAverages=yes\r\n");
    else ar.WriteString("ReportAverages=no\r\n");
    if(Maximums) ar.WriteString("ReportMaximums=yes\r\n");
    else ar.WriteString("ReportMaximums=no\r\n");
    if(Minimums) ar.WriteString("ReportMinimums=yes\r\n");
    else ar.WriteString("ReportMinimums=no\r\n");
    if(ExtremeFramesizes) ar.WriteString("ReportExtremeFramesizes=yes\r\n");
    else ar.WriteString("ReportExtremeFramesizes=no\r\n");
    if(JustFinal) ar.WriteString("ReportJustFinal=yes\r\n");
    else ar.WriteString("ReportJustFinal=no\r\n");
    ar.WriteString(M_CRLF);
    temp.Format("LengthOfInterval= %d %d %d\r\n"
                ,LengthOfInterval[0]
                ,LengthOfInterval[1]
                ,LengthOfInterval[2]);
    ar.WriteString(temp);
    temp.Format("ExcludedFrames=%s\r\n",(LPCTSTR)ExcludedFrames);
    ar.WriteString(temp);
    temp.Format("DefaultLengthParameter=%s\r\n",(LPCTSTR)DefaultLengthParameter);
    ar.WriteString(temp);
    ar.WriteString("\r\n");
    int i;
    for(i=0;i<GroupNumber;i++)
     {
        temp="GroupName="+Groups[i].GroupName+"\r\n";
        ar.WriteString(temp);
        temp="OutCap="+Groups[i].CapName+"\r\n";
        ar.WriteString(temp);
        temp="Predicate="+Groups[i].Predicate+"\r\n";
        ar.WriteString(temp);
        temp="LengthParameter="+Groups[i].LengthParameter+"\r\n";
        ar.WriteString(temp);
        ar.WriteString("\r\n");
     }
     ar.Close();
     return TRUE;
   }
