// CQuerySheet.cpp : implementation file
//

#include "stdafx.h"

#include "CQuerySheet.h"
#include "FilterWiz.h"
#include "messages.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CQuerySheet

IMPLEMENT_DYNAMIC(CQuerySheet, CPropertySheet)

BEGIN_MESSAGE_MAP(CQuerySheet, CPropertySheet)
    //{{AFX_MSG_MAP(CQuerySheet)
        // NOTE - the ClassExpress will add and remove mapping macros here.
    //}}AFX_MSG_MAP
END_MESSAGE_MAP();

CQuerySheet::CQuerySheet()
    :CPropertySheet(),CQueryPrj()
{
    Construct(M_QRYWIZARD,this);
    page1.Construct(IDD_QRY1,0);
    page2.Construct(IDD_QRY2,0);
    page3.Construct(IDD_QRY3,0);
    page4.Construct(IDD_QRY4,0);
    page1.p=(CQueryPrj*) this;
    page1.q=(CQuerySheet*) this;
    page2.p=(CQueryPrj*) this;
    page2.q=(CQuerySheet*) this;
    page3.p=(CQueryPrj*) this;
    page3.q=(CQuerySheet*) this;
    page4.p=(CQueryPrj*) this;
    page4.q=(CQuerySheet*) this;
    AddPage(&page2);
    AddPage(&page3);
    AddPage(&page1);
}

CQuerySheet::~CQuerySheet()
{
}

/////////////////////////////////////////////////////////////////////////////
// CQuerySheet message handlers


void CQuerySheet::SetupPage4(BOOL add)
{
	if ((add&&GetPageCount()>=4) || (!add&&GetPageCount()<4)) return;
	if (add)
	{
		RemovePage(&page1);
		AddPage(&page4);
		AddPage(&page1);
	}
	else 
	{
		RemovePage(&page1);
		RemovePage(&page4);
		AddPage(&page1);
	}
}

#include "CLogDocument.h"

int CQuerySheet::DefineExpression(CString & exp)
{
		if(m_pDoc==NULL) return 1;
		short errors;
		CString String=m_pDoc->query.ExecuteCommand("getprotos",&errors);
		if(errors!=0) 
		{
			CFilterWiz sp;
			LineCollection lc(&String);
			sp.lc=&lc;
			sp.Filter=exp;
			sp.m_pDoc=m_pDoc;
			if(sp.DoModal()==IDOK)
			{
				if (!m_pDoc->OnLogFilter(sp.Filter))
				{
					m_pDoc->OnLogFilter((CString)"TRUE");
					sp.Filter="TRUE";
				}
				exp=sp.Filter;
				return 0;
			}
			return 1;
		} 
		else 
		{
			AfxMessageBox(String);
		}
		return 1;
}
