// CRawView.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"
#include "CRawView.h"
#include "clistview.h"
#include "mytreevw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRawView

IMPLEMENT_DYNCREATE(CRawView, CRichEditView);

BEGIN_MESSAGE_MAP(CRawView, CRichEditView)
    //{{AFX_MSG_MAP(CRawView)
	ON_COMMAND(IDM_SELECT_ALL_PCK, OnEditSelectAll)
	ON_COMMAND(IDM_LOG_COLLAPSE, OnLogCollapse)
	ON_UPDATE_COMMAND_UI(IDM_LOG_COLLAPSE, OnUpdateLogCollapse)
	ON_COMMAND(IDM_LOG_EXPAND, OnLogExpand)
	ON_UPDATE_COMMAND_UI(IDM_LOG_EXPAND, OnUpdateLogExpand)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CUT, OnUpdateEditCut)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, OnUpdateEditPaste)
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	ON_COMMAND(IDM_PRINT_CHAR, OnPrintChar)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, OnFilePrintPreview)
	ON_WM_KILLFOCUS()
	ON_WM_SETFOCUS()
	ON_COMMAND(IDM_SAVEINDEX, OnSaveindex)
	ON_WM_CREATE()
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	//}}AFX_MSG_MAP
	//ON_COMMAND(ID_VIEW_STATUS_BAR, OnBarCheck)
END_MESSAGE_MAP();

CRawView::CRawView()
{
	m_ArrowsType=0;
	m_bFocus=FALSE;
}

CRawView::~CRawView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CRawView message handlers


void CRawView::Update(LineCollection & lc, int &j)
    {
		CString str,t;
		int i;

        doc=(CLogDocument*)CView::GetDocument();
	    int n=lc.getLineCount();
		if(j<n)
		{
		 str=lc.line(j);
         for(i=j+1;i<n;i++)
         {
			t=lc.line(i);
			if (t[0]!='*' && i<n-1) {j=i;break;}
			else
			 j=-1;
  		    str+=((CString)"\r\n")+t;
         }
		}
		list->SetWindowText(str);
		list->HideSelection(TRUE, FALSE);
		CLogDocument* doc=(CLogDocument*) CView::GetDocument();
		CMyTreeView* m_pView4=(CMyTreeView*) doc->GetCompatibleView(RUNTIME_CLASS(CMyTreeView));
		if(m_pView4) m_pView4->UpdateSelection();
    }

int CRawView::OnCreate(LPCREATESTRUCT lpCreateStruct)
    {
	CAnalyzerApp* app=(CAnalyzerApp*)AfxGetApp();
	if (CRichEditView::OnCreate(lpCreateStruct) == -1)
		return -1;
	list=&GetRichEditCtrl();
	CHARFORMAT c;
	list->GetDefaultCharFormat(c);
	c.dwMask=CFM_FACE| CFM_SIZE;
	c.bPitchAndFamily=FIXED_PITCH;
	strcpy(c.szFaceName,app->DefinedFont);
	c.yHeight=app->DefinedDim*c.yHeight/100;
	GetRichEditCtrl().SetSel(0,-1);
	GetRichEditCtrl().SetDefaultCharFormat(c);
	GetRichEditCtrl().SetSelectionCharFormat(c);

	GetRichEditCtrl().SetReadOnly(TRUE);

	GetRichEditCtrl().SetSel(0,0);
	list->GetDefaultCharFormat(c);

    return 0;
    }

void CRawView::OnEditSelectAll() 
{
	CLogDocument* doc=(CLogDocument*) CView::GetDocument();
	CListAllView* m_pView4=(CListAllView*) doc->GetCompatibleView(RUNTIME_CLASS(CListAllView));
	if(m_pView4) m_pView4->OnSelectAll();
}

void CRawView::OnLogExpand() 
{
	CLogDocument* doc=(CLogDocument*) CView::GetDocument();
	CMyTreeView* m_pView4=(CMyTreeView*) doc->GetCompatibleView(RUNTIME_CLASS(CMyTreeView));
	if(m_pView4) m_pView4->OnExpand();
}

void CRawView::OnUpdateLogExpand(CCmdUI* pCmdUI) 
{
	CLogDocument* doc=(CLogDocument*) CView::GetDocument();
	CMyTreeView* m_pView4=(CMyTreeView*) doc->GetCompatibleView(RUNTIME_CLASS(CMyTreeView));
	if(m_pView4) pCmdUI->Enable((m_pView4->expansion<3)?TRUE:FALSE);
	else pCmdUI->Enable(FALSE);
}

void CRawView::OnLogCollapse() 
{
	CLogDocument* doc=(CLogDocument*) CView::GetDocument();
	CMyTreeView* m_pView4=(CMyTreeView*) doc->GetCompatibleView(RUNTIME_CLASS(CMyTreeView));
	if(m_pView4) m_pView4->OnCollapse();
}

void CRawView::OnUpdateLogCollapse(CCmdUI* pCmdUI) 
{
	CLogDocument* doc=(CLogDocument*) CView::GetDocument();
	CMyTreeView* m_pView4=(CMyTreeView*) doc->GetCompatibleView(RUNTIME_CLASS(CMyTreeView));
	if(m_pView4) pCmdUI->Enable((m_pView4->expansion>0)?TRUE:FALSE);
	else pCmdUI->Enable(FALSE);
}

void CRawView::OnSelect(int s, int e)
{
	int i,j,n,eoln,ss,ee,fn,st,et,r,h,rowsel;
	ss=ee=-1;
	rowsel=0;
	st=0;
	et=0;
	r=0;
	CString mystr;
	list->GetWindowText(mystr);
	n=mystr.GetLength();
	if (n==0) return;
	list->SetSel(0,n);
	CHARFORMAT cf,cf2;

	cf2.dwMask=CFM_COLOR;
	cf2.dwEffects=0;
	m_bFocus=0;
	if(m_bFocus==0)
		cf2.crTextColor=::GetSysColor(COLOR_MENU);
	else
		cf2.crTextColor=::GetSysColor(COLOR_HIGHLIGHT);
	cf.dwMask=CFM_COLOR;
	cf.dwEffects=0;
	cf.crTextColor=RGB(0,0,0);
	list->SetSelectionCharFormat( cf );
	// Hide Selection
	list->HideSelection(TRUE, FALSE);
	if (mystr[0]=='+') 
	{
		list->SetSel(0,1);
		list->ReplaceSel("*");
	}
		list->SetSelectionCharFormat(cf);
	for(i=1;i<n;i++)
	 if (mystr[i]=='+' && mystr[i-1]=='\n')
	 {
		list->SetSel(i,i+1);
		list->ReplaceSel("*");
	 } 
	if(s==INT_MIN || e==INT_MIN) 
		return;
	if (s>=0 && e>=0) 
	{
		cf.crTextColor=RGB(0,255,0);
	}
	else if(s<0 && e<0) 
	{
		cf.crTextColor=RGB(255,0,0);
		s=-s;
		e=-e;
	} else return;

	list->HideSelection(TRUE, FALSE);

	for (i=0,j=0,eoln=1,fn=0;i<n;i++)
	{
		if (mystr[i]=='[')
		{
			if(ss>=0) 
			{
				if (ss>st) st=ss;
				list->SetSel(st,i);
				list->SetSelectionCharFormat( cf );
				rowsel=1;
				et=i;
				i++;
				for(h=0;h<16&&i<n-1;h++,i++)
					if (r+h>=s && r+h<=e)
					{
						list->SetSel(i,i+1);
						list->SetSelectionCharFormat( cf );
					}
				list->HideSelection(TRUE, FALSE);
			}
			r+=16;
			continue;
		}
		if ((j&0xf)==0 && fn!=1)
			if (eoln)
			{
				if (!isalnum(mystr[i])) continue;
			}
			else
			{
				if (mystr[i]=='\n') 
				{
					eoln=1;
					if(rowsel)
					{
						for(int iq=i-1;iq>=0;iq--)
							if (mystr[iq]=='\n') break;
						list->SetSel(iq+1,iq+2);
						list->ReplaceSel("+");
						list->SetSel(iq+1,iq+2);
						list->SetSelectionCharFormat( cf2 );
					}
				}
				continue;
			}
		eoln=0;
		if (isalnum(mystr[i]))
		{
			if(fn==0) 
			{
				if ((j&0xf)==0)st=i;
				j++;
				if (j==s+1) 
					ss=i;
				fn=1;
			}
		}
		else
		{
			fn=0;
			if (j==e+1) {ee=i;et=ee;break;}
		}
	}
	if (ss<0) ss=n-1;
	if (ss<st) ss=st;
	if (ee<0) ee=n-1;
	if (et<ee) ee=et;
	list->SetSel(ss,ee);
	rowsel=1;
	if(ss==ee)
		list->HideSelection(TRUE, FALSE);
	else
	{
		list->SetSelectionCharFormat( cf );
		list->HideSelection(TRUE, FALSE);
	}
	for(;i<n-1;i++) 
		if (mystr[i]=='[') break;
	i++;
	for(h=0;h<16&&i<n-1;h++,i++)
	if (r+h>=s && r+h<=e)
	{
		list->SetSel(i,i+1);
		list->SetSelectionCharFormat( cf );
	}
	i--;
	if(rowsel)
	{
		for(int iq=i-1;iq>=0;iq--)
			if (mystr[iq]=='\n') break;
		list->SetSel(iq+1,iq+2);
		list->ReplaceSel("+");
		list->SetSel(iq+1,iq+2);
		list->SetSelectionCharFormat( cf2 );
	}
}

void CRawView::OnFilePrint() 
{
   CLogDocument* pDoc= ((CLogDocument*)CView::GetDocument());
   pDoc->DoPrint();
}

void CRawView::OnPrintChar() 
{
   CLogDocument* pDoc= ((CLogDocument*)CView::GetDocument());
   pDoc->DoPrintChars();
}

void CRawView::OnFilePrintPreview() 
{
   CLogDocument* pDoc= ((CLogDocument*)CView::GetDocument());
   pDoc->DoPrintPreview();
}

void CRawView::OnKillFocus(CWnd* pNewWnd) 
{
	CRichEditView::OnKillFocus(pNewWnd);
	
	m_bFocus=TRUE;
	UpdateFocus(::GetSysColor(COLOR_HIGHLIGHT),::GetSysColor(COLOR_MENU));
}

void CRawView::OnSetFocus(CWnd* pOldWnd) 
{
	CRichEditView::OnSetFocus(pOldWnd);
	
	m_bFocus=FALSE;
	UpdateFocus(::GetSysColor(COLOR_MENU),::GetSysColor(COLOR_HIGHLIGHT));
}

void CRawView::UpdateFocus(COLORREF r1,COLORREF r2)
{
	CHARFORMAT cf,cf2;

	cf.dwMask=CFM_COLOR;
	cf.dwEffects=0;
	cf.crTextColor=r2;
	cf2.dwMask=CFM_COLOR;
	cf2.dwEffects=0;
	CString mystr;
	list->GetWindowText(mystr);
	int n=mystr.GetLength();
	int i;
	list->SetSel(0,1);
	list->GetSelectionCharFormat(cf2);
	if (cf2.crTextColor==r1)
		list->SetSelectionCharFormat(cf);
	for(i=1;i<n;i++)
	 if (mystr[i]=='+' && mystr[i-1]=='\n')
	 {
		list->SetSel(i,i+1);
		list->GetSelectionCharFormat(cf2);
		if (cf2.crTextColor==r1)
			list->SetSelectionCharFormat(cf);
	 } 
	list->HideSelection(TRUE, FALSE);
}

void CRawView::OnSaveindex() 
{
	CLogDocument* doc=(CLogDocument*) CView::GetDocument();
	CListAllView* m_pView4=(CListAllView*) doc->GetCompatibleView(RUNTIME_CLASS(CListAllView));
	if(m_pView4) m_pView4->SaveIndex();
}

void CRawView::OnEditCopy() 
{
	CLogDocument* log=(CLogDocument*)CView::GetDocument();
  if (!log || !log->IsKindOf(RUNTIME_CLASS(CLogDocument)))
  {
	  CRichEditView::OnEditCut();
	  return;
  }
  if (log->m_ClipTxt) CRichEditView::OnEditCopy();
  if (log->m_ClipPck) log->EditCut();
}

void CRawView::OnUpdateEditCopy(CCmdUI* pCmdUI) 
{
	BOOL b=FALSE;
	CLogDocument* log=(CLogDocument*)CView::GetDocument();
	if (!log) {pCmdUI->Enable(b); return;}
	if (!log->IsKindOf(RUNTIME_CLASS(CLogDocument)))
	{
	    long s,e;
		GetRichEditCtrl().GetSel(s,e);
		if (e>s) pCmdUI->Enable(TRUE); 
		else pCmdUI->Enable(FALSE); 
		return;
	}
	b=log->UpdateModificaCopia();
	if (log->m_ClipTxt)
	{
	    long s,e;
		GetRichEditCtrl().GetSel(s,e);
		if (e>s) b=TRUE; 
	}
	pCmdUI->Enable(b); 
}

void CRawView::OnUpdateEditCut(CCmdUI* pCmdUI) 
{
	BOOL b=FALSE;
	CLogDocument* log=(CLogDocument*)CView::GetDocument();
	if (!log|| !log->IsKindOf(RUNTIME_CLASS(CLogDocument))) {pCmdUI->Enable(b); return;}
	b=log->UpdateModificaTaglia();
	pCmdUI->Enable(b); 
}

void CRawView::OnUpdateEditPaste(CCmdUI* pCmdUI) 
{
	BOOL b=FALSE;
	CLogDocument* log=(CLogDocument*)CView::GetDocument();
	if (!log || !log->IsKindOf(RUNTIME_CLASS(CLogDocument))) {pCmdUI->Enable(b); return;}
	b=log->UpdateModificaIncolla();
	pCmdUI->Enable(b); 
}

void CRawView::OnEditCut() 
{
  CLogDocument* log=(CLogDocument*)CView::GetDocument();
  if (!log || !log->IsKindOf(RUNTIME_CLASS(CLogDocument)))
  {
	  CRichEditView::OnEditCut();
	  return;
  }
  if (log->m_ClipTxt) CRichEditView::OnEditCopy();
  if (log->m_ClipPck) log->EditCut();
}

void CRawView::OnEditPaste() 
{
  CLogDocument* log=(CLogDocument*)CView::GetDocument();
  if (!log || !log->IsKindOf(RUNTIME_CLASS(CLogDocument)))
  {
	  CRichEditView::OnEditPaste();
	  return;
  }
  if (log->m_ClipPck) log->EditPaste();
}
