// CommandDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Query.h"
#include "CommandDlg.h"
#include "Analyzer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define CMDDLG_ERR "Inserire un comando"
#define CMDDLG_RIS "Risultati dei comandi impartiti"
#define CMDDLG_ERRORS "Errori nei comandi impartiti"
#define CMDDLG_PRB "Problemi nell'esecuzione del comando. Non  aperta alcuna cattura."
#else
#define CMDDLG_ERR "Please insert a command"
#define CMDDLG_RIS "Command results"
#define CMDDLG_ERRORS "Command Errors"
#define CMDDLG_PRB "Problems executing command. No capture opened"
#endif

/////////////////////////////////////////////////////////////////////////////
// CCommandDlg dialog


CCommandDlg::CCommandDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCommandDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCommandDlg)
	//}}AFX_DATA_INIT
	m_FComando=0;
	m_NComandi=0;
}


void CCommandDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCommandDlg)
	DDX_Control(pDX, IDC_COMBO1, m_ComboBox);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCommandDlg, CDialog)
	//{{AFX_MSG_MAP(CCommandDlg)
	ON_BN_CLICKED(IDC_OK, OnOk)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCommandDlg message handlers

void CCommandDlg::OnOk() 
{
	CString String,String1;
	m_ComboBox.SetItemHeight(10,100);
	m_ComboBox.GetWindowText(String);
	if(String.Compare("")==0) 
		{AfxMessageBox(CMDDLG_ERR /*Inserire un comando*/);return;}
	int n=m_ComboBox.FindStringExact(0, "");
	if(n!=CB_ERR)
		{m_ComboBox.SetCurSel(n);return;}
	m_ComboBox.InsertString(0,String);
	m_ComboBox.SetCurSel(0);
	int t=m_ComboBox.GetCount();
	if(t>20)m_ComboBox.DeleteString(20);
	short errors;
	BOOL IsActive;
	CLogDocument* pDoc=(CLogDocument*)padre->GetCompatibleDoc(((CAnalyzerApp*)AfxGetApp())->logTemplate,IsActive);
	if (pDoc==NULL|| !IsActive) 
		pDoc=(CLogDocument*)padre->GetCompatibleDoc(((CAnalyzerApp*)AfxGetApp())->logTreeTemplate,IsActive);
	if (pDoc)
	{
		String.MakeLower();
		String1=pDoc->query.ExecuteCommand(String,&errors);
		if(errors!=0) 
		{
			if (String=="next" || String=="first" || String=="last" ||
				String=="nextf" || String=="prev" || String=="prevf" ||
				(String[0]=='j' && String[0]=='u' &&String[0]=='m' &&String[0]=='p'))
			{pDoc->RefreshViews();pDoc->AdjustToolbar(errors);}
			else if (strncmp(String,"logopen",7)==0)
				 {
				  pDoc->OnLogIndex();
				  pDoc->OnLogJump(1);
				 }
			else if (strncmp(String,"capopen",7)==0)
				 {
				  pDoc->OnLogIndex();
				  pDoc->OnLogJump(1);
				 }
			else if (String.GetLength())
				   ((CAnalyzerApp*)AfxGetApp())->CreateRoDoc(CMDDLG_RIS /*Risultati dei comandi impartiti*/,String1);
		} else 
			{
			 ((CAnalyzerApp*)AfxGetApp())->CreateRoDoc(CMDDLG_ERRORS /*Errori nei comandi impartiti*/,String1);
			}
	}
	else 
	 AfxMessageBox(CMDDLG_PRB /*Problemi nell'esecuzione del comando. Non  aperta alcuna cattura.*/);
}

CCommandDlg::~CCommandDlg()
{
}

BOOL CCommandDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCommandDlg::OnClose()
{
	padre->m_isCmdVis=FALSE;
	ShowWindow(SW_HIDE);
}

void CCommandDlg::OnCancel() 
{
	padre->m_isCmdVis=FALSE;
	ShowWindow(SW_HIDE);
}
