// ConfigDialog.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"
#include "ConfigDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define CDLG_FILE "Selezionare il file sorgente"
#define CDLG_FCATT "Formato Catture"
#define CDLG_DPROT "Def. Protocolli"
#define CDLG_DPACK "Desc. Pacchetti"
#define CDLG_DIND "Desc. Indice"
#define CDLG_MPDF "Si vuole modificare l'impostazione dei file PDF?"
#define CDLG_MDFF "Si vuole modificare l'impostazione dei file DFF?"
#define CDLG_MIFF "Si vuole modificare l'impostazione dei file IFF?"
#define CDLG_DLFF "Definizione del formato del file contenente le catture:"
#define CDLG_DPDF "Definizione del formato dei protocolli supportati:"
#define CDLG_DDFF "Descrizione letterale dei campi dei pacchetti:"
#define CDLG_DIFF "Definizione del formato indicizzato dei pacchetti:"
#else
#define CDLG_FILE "Choose Source File"
#define CDLG_FCATT "Capture Format"
#define CDLG_DPROT "Protocol Def."
#define CDLG_DPACK "Packet Desc."
#define CDLG_DIND "Index Desc."
#define CDLG_MPDF "Can Analyzer modifies PDF definitions?"
#define CDLG_MDFF "Can Analyzer modifies DFF definitions?"
#define CDLG_MIFF "Can Analyzer modifies IFF definitions?"
#define CDLG_DLFF "Capture file format definition:"
#define CDLG_DPDF "Supported protocols definition:"
#define CDLG_DDFF "Packet Description definition:"
#define CDLG_DIFF "Packet Index definition:"
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigDialog dialog


CConfigDialog::CConfigDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConfigDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_App=(CAnalyzerApp*) AfxGetApp();
}


void CConfigDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigDialog)
	DDX_Control(pDX, IDC_DESCRIZIONE, m_Desc);
	DDX_Control(pDX, IDC_EDIT1, m_FileName);
	DDX_Control(pDX, IDC_TAB1, m_Tab);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConfigDialog, CDialog)
	//{{AFX_MSG_MAP(CConfigDialog)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB1, OnSelchangeTab1)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_EDIT, OnEdit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigDialog message handlers

void CConfigDialog::OnBrowse() 
{
	 CFileDialog dlgFile(TRUE);
	 BOOL bResult;

	 CString title=CDLG_FILE /*Selezionare il file sorgente*/;
	 CString fileName;
     UINT nIDSTitle=AFX_IDS_OPENFILE;
     DWORD lFlags=OFN_HIDEREADONLY| OFN_FILEMUSTEXIST;
     BOOL bOpenFileDialog=TRUE; 

	 dlgFile.m_ofn.Flags |= lFlags;

	 CString strFilter=m_File1;
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += m_Flt1;
	 strFilter += (TCHAR)'\0';   // last string
	 CString strDefault;
	 // append the '*.*' all files filter
	 CString allFilter;
	 VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	 strFilter += allFilter;
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += _T("*.*");
	 strFilter += (TCHAR)'\0';   // last string
	 dlgFile.m_ofn.nMaxCustFilter++;

	 dlgFile.m_ofn.lpstrFilter = strFilter;
	 dlgFile.m_ofn.lpstrTitle = title;
	 dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	 bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	 fileName.ReleaseBuffer();
	 if (!bResult) return;
	 m_FileName.SetWindowText(fileName);
	 return ;
}

void CConfigDialog::OnOK() 
{
	old_sel=-1;
	OnSelchangeTab1(NULL,NULL);
	CDialog::OnOK();
}

BOOL CConfigDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	TC_ITEM tci;
	tci.mask=TCIF_TEXT;
	tci.iImage=-1;
	tci.pszText=CDLG_DPROT /*Def. Protocolli*/;
	m_Tab.InsertItem(0,&tci);
	tci.pszText=CDLG_DPACK /*Desc. Pacchetti*/;
	m_Tab.InsertItem(1,&tci);
	tci.pszText=CDLG_DIND /*Desc. Indice*/;
	m_Tab.InsertItem(2,&tci);

	m_FileName.SetWindowText(m_App->m_pdf);
	m_Tab.SetCurSel(0);
	old_sel=0;
	OnSelchangeTab1(NULL,NULL);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CConfigDialog::OnSelchangeTab1(NMHDR* pNMHDR, LRESULT* pResult) 
{

	CString str;
	m_FileName.GetWindowText(str);
	int n=m_Tab.GetCurSel();
	int agg=0;
	if (old_sel<0) {agg++;old_sel=n;}
	if (old_sel==0)
	{
		if (agg||(str!=m_App->m_pdf && AfxMessageBox(CDLG_MPDF /*Si vuole modificare l'impostazione dei file PDF?*/, MB_YESNO)==IDYES))
			m_App->SelProtos(str,m_App->m_pdo);
	} 
	else if (old_sel==1)
	{
		if (agg||(str!=m_App->m_dff && AfxMessageBox(CDLG_MDFF /*Si vuole modificare l'impostazione dei file DFF?*/, MB_YESNO)==IDYES))
			m_App->SelDFF(str,m_App->m_dfo);
	} 
	else
	{
		if (agg||(str!=m_App->m_iff && AfxMessageBox(CDLG_MIFF /*Si vuole modificare l'impostazione dei file IFF?*/, MB_YESNO)==IDYES))
			m_App->SelIFF(str,m_App->m_ifo);
	} 

	old_sel=n;
	if (n==0)
	{
	m_Desc.SetWindowText(CDLG_DPDF /*Definizione del formato dei protocolli supportati:*/);
	m_Flt1="*.pdf";
	m_File1="Files pdf (*.pdf)";
	m_F1=m_App->m_pdf;
	}
	else if (n==1)
	{
	m_Desc.SetWindowText(CDLG_DDFF /*Descrizione letterale dei campi dei pacchetti:*/);
	m_Flt1="*.dff";
	m_File1="Files dff (*.dff)";
	m_F1=m_App->m_dff;
	}
	else
	{
	m_Desc.SetWindowText(CDLG_DIFF /*Definizione del formato indicizzato dei pacchetti:*/);
	m_Flt1="*.iff";
	m_File1="Files iff (*.iff)";
	m_F1=m_App->m_iff;
	}
	m_FileName.SetWindowText(m_F1);

	if (pResult)*pResult = 0;
}

void CConfigDialog::OnDestroy() 
{
	CDialog::OnDestroy();
}

void CConfigDialog::OnEdit() 
{
    POSITION p=m_App->GetFirstDocTemplatePosition();
    CDocTemplate* pTemplate1=m_App->GetNextDocTemplate(p);
	CPadDoc* pad;
	CString fileName;
	m_FileName.GetWindowText(fileName);
    pad=(CPadDoc*) pTemplate1->OpenDocumentFile(fileName);
	if (pad) pad->m_IsConf=TRUE;
	OnCancel();
}
