// CsvDoc.cpp : implementation file
//

#include "stdafx.h"
#include "analyzer.h"
#include "CsvDoc.h"
#include <linecoll.h>
#include "mytablevw.h"
#include "messages.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define TBL_RES "Statistics Results"
#define TBL_SAVE "Salvare le modifiche al documento?"
#else
#define TBL_RES "Risultati Statistiche"
#define TBL_SAVE "Do you wish to save this document?"
#endif
/////////////////////////////////////////////////////////////////////////////
// CCsvDocument

IMPLEMENT_DYNCREATE(CCsvDocument, CDocument)

CCsvDocument::CCsvDocument()
{
	m_Separator=';';
	m_CurGroup=0;
	m_Ts0=-1;
	m_Tsf=-1;
	m_IsCsvModified=FALSE;
	IsInit=0;
}

BOOL CCsvDocument::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	return TRUE;
}

CCsvDocument::~CCsvDocument()
{
}


BEGIN_MESSAGE_MAP(CCsvDocument, CDocument)
	//{{AFX_MSG_MAP(CCsvDocument)
	ON_COMMAND(IDM_LOG_FIRST, OnLogFirst)
	ON_COMMAND(IDM_LOG_LAST, OnLogLast)
	ON_COMMAND(IDM_LOG_NEXT, OnLogNext)
	ON_COMMAND(IDM_LOG_PREV, OnLogPrev)
	ON_UPDATE_COMMAND_UI(IDM_LOG_FIRST, OnUpdateLogFirst)
	ON_UPDATE_COMMAND_UI(IDM_LOG_PREV, OnUpdateLogPrev)
	ON_UPDATE_COMMAND_UI(IDM_LOG_NEXT, OnUpdateLogNext)
	ON_UPDATE_COMMAND_UI(IDM_LOG_LAST, OnUpdateLogLast)
	ON_COMMAND(IDM_TBL_SAVE, OnTblSave)
	ON_COMMAND(IDM_TBL_OTHER, OnTblOther)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_SAVE, OnTblSave)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCsvDocument diagnostics

#ifdef _DEBUG
void CCsvDocument::AssertValid() const
{
	CDocument::AssertValid();
}

void CCsvDocument::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCsvDocument serialization

void CCsvDocument::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		int n=m_ValGroup.GetSize();
		if(!n) return;
		char sep[2];
		sep[1]='\0';
		sep[0]=((CAnalyzerApp*)AfxGetApp())->CsvSep;
		CString str,t;
		ar.WriteString(m_L1+"\r\n");
		ar.WriteString(m_L2+"\r\n");
		int i,r,c;
		m_ValGroup[0].GetSize(r,c);
		int ng;
		if(m_Int==0) ng=n; else ng=m_Int;
		for(i=0;i<ng;i++)
		{
			str=m_ValGroup[i].GetName();
			ar.WriteString("\" "+str+"\" \r\n");
		}
		if (m_L3!="")
		{
			ar.WriteString("\r\n"+m_L3);
			ar.WriteString("\r\n"+m_L4);
		}
		int rr,cc,ts1,ts2;
		if(m_Int && m_L3!="") 
		 for (rr=0;rr<r;rr++)
		 {
			ts1=m_ValGroup[0].TimeStamp(rr)+m_Ts0;
			ts2=m_ValGroup[0].FinTimeStamp(rr)+m_Ts0;
			t.Format("\"%d:%d:%d\"%s\"%d:%d:%d\"%s",
					ts1/3600,(ts1%3600)/60,ts1%60,sep,
					ts2/3600,(ts2%3600)/60,ts2%60,sep);
			str="\r\n"+t;
			for(cc=0;cc<c;cc++)
			{
				for(i=0;i<m_Int;i++)
					{
						t.Format("%d%s",m_ValGroup[i].At(rr,cc),sep);
						str+=t;
					}
			}
			ar.WriteString(str);
		 }
		int Int=m_Int;
		if (m_L5!="")
		{
			if (m_L3!="")
				ar.WriteString("\r\n");
			else Int=0;
			ar.WriteString("\r\n"+m_L5);
			ar.WriteString("\r\n"+m_L6);
		}
		i=0;
		if(Int<n) 
		{
		 m_ValGroup[Int].GetSize(r,c);
		 for (rr=0;rr<r;rr++)
		 {
			t.Format("\"%s\"%s\"\"%s",
					(const char*)m_ValGroup[Int].GetRowName(rr),sep,sep);
			str="\r\n"+t;
			for(cc=0;cc<c;cc++)
			{
				for(i=Int;i<n;i++)
					{
						t.Format("%d%s",m_ValGroup[i].At(rr,cc),sep);
						str+=t;
					}
			}
			ar.WriteString(str);
		 }
		}
		if (m_L5!="")
			ar.WriteString("\r\n");
		else if (m_L5=="" && m_L3!="")
			ar.WriteString("\r\n");
		ar.WriteString(m_Other);
	}
	else
	{
		LineCollection lc(ar);
		SetTitle(ar.GetFile()->GetFileName());
		NewFromLC(lc);
		SetTitle(ar.GetFile()->GetFileName()+ " - "+ m_ValGroup[0].GetName());
	}
}

/////////////////////////////////////////////////////////////////////////////
// CCsvDocument commands

int CCsvDocument::NewFromLC(LineCollection & lc)
{
    int n,m;
	int ng;
	int l=lc.GetSize();
	// Estrae le prime due righe dell'intestazione
	m_Separator=((CAnalyzerApp*)AfxGetApp())->CsvSep;
	if (l>=2)
	{
		m_L1=lc.line(0);
		m_L2=lc.line(1);
	}
	// Conta i gruppi delle statistiche;
	for(n=2;n<l;n++) 
	{
		CString hjk;
		hjk=lc.line(n);
		if (hjk.GetLength()==0 || hjk[0]==m_Separator) {m=n-2;break;}
	}
	// Dimensiona i gruppi presenti ipotizzando che ci sia almeno i valori finali
	m=n-2;
	m_ValGroup.SetSize(m);
	ng=m;
	CString st;
	// Copia i nomi dei gruppi
	for(n=2;n<l;n++)
	{
		st=lc.line(n);
		if (!st.GetLength() || st[0]==m_Separator) {m=n;break;}
		else
		{
			st=st.Mid(1,st.GetLength()-3);
			st.TrimLeft();
			m_ValGroup[n-2].SetName(st);
		}
	}
	// Conta le colonne dei gruppi
	m++;
	st=lc.line(m);
	int i,ni=0,j;
	for(i=0;i<st.GetLength();i++)
		if (st[i]==m_Separator) ni++;
	ni-=2;
	int ns,k=0;
	ns=ni/ng;
	ni=0;
	// Salta i primi due  campi
	for(i=0;i<st.GetLength()&&ni<2;i++)
		if (st[i]==m_Separator) ni++;
	// Estrae i nomi delle colonne
	CArray<CString,CString&> tmp0;
	//tmp0=new CString[ns];
	//if (tmp0==NULL) return 1;
	for(ni=0;i<st.GetLength();i++)
		if (st[i]=='"')
		{
			for(j=1;i+j<st.GetLength()&&st[i+j]!='"';j++);
			if(i+j<st.GetLength())
			{
			 tmp0.SetSize(k+1);
			 tmp0[k]=
				 st.Mid(i+1,j-1);
			 i+=j;
			 k++;
			} else return 1;
		}
	// Conta il numero di campi per le tabelle dei dati intermedi e 
	// dimensiona le tabelle per contenerli
	int a,b,c;
	int d=0,o,p=0,q;
	for(n=m+2;n<l;n++)
	{
		st=lc.line(n);
		if (sscanf(st,"\"%u:%u:%u\"",&a,&b,&c)!=3) break;
		d++;
	}
	if (d) 
	{
		for(j=0;j<ng;j++) 
			m_ValGroup[j].SetSize(d,ns);
		// Imposta i nomi delle colonne
		for(i=0;i<ng;i++)
			for(j=0;j<ns;j++)
				m_ValGroup[i].SetColName(tmp0[j],j);
		//delete[]tmp0;
	}
	// Conta il numero di campi per le tabelle dei dati finali e
	// dimensiona le tabelle per contenerli
	if (d) o=n+3; else o=m+2;
	q=o;
	p=0;
	for(;o<l;o++)
	{
		st=lc.line(o);
		if (st.GetLength()==0 || st[0]==m_Separator || st[0]=='\0') break;
		if (st[0]!='\"') break;
		p++;
	}
	// Se  esistevano dati intermedi bisogna creare nuovi gruppi per i dati finali
	if(p && d)
	{
		m_ValGroup.SetSize(m_ValGroup.GetSize()+ng);
		for(j=ng;j<2*ng;j++) m_ValGroup[j].SetSize(p,ns);
		// Imposta i nomi delle colonne
		for(i=ng;i<ng+ng;i++)
			for(j=0;j<ns;j++)
				m_ValGroup[i].SetColName(m_ValGroup[i-ng].GetColName(j),j);
		// Imposta i nomi dei gruppi

		for(n=0;n<ng;n++)
		{
			m_ValGroup[n+ng].SetName(m_ValGroup[n].GetName());
		}
	}
	else if (p)
	{
		for(j=0;j<ng;j++) m_ValGroup[j].SetSize(p,ns);
		// Imposta i nomi delle colonne
		for(i=0;i<ng;i++)
			for(j=0;j<ns;j++)
				m_ValGroup[i].SetColName(tmp0[j],j);
		//delete[]tmp0;
	}
	int ts0=-1;
	int a1,b1,c1;
	CString ht;
	char tc[2];
	tc[0]='\0';
	tc[1]='\0';
	// Legge gli eventuali dati intermedi
	if(d)
	{
	 m_L3=lc.line(m);
	 m_L4=lc.line(m+1);
	 for(n=m+2;n<l;n++)
	 {
		st=lc.line(n);
		ht="\"%u:%u:%u\"";
		tc[0]=m_Separator;
		ht+=tc;
		ht+="\"%u:%u:%u\"";
		if (sscanf(st,ht,&a,&b,&c,&a1,&b1,&c1)==6) 
			m_Tsf=a1*3600+b1*60+c1;
		else break;
		for(j=0;j<ng;j++) 
		{
			if (ts0<0) {ts0=a*3600+b*60+c;m_Ts0=ts0;}
			m_ValGroup[j].TimeStamp(n-m-2)=a*3600+b*60+c-ts0;
			m_ValGroup[j].FinTimeStamp(n-m-2)=a1*3600+b1*60+c1-ts0;
		}
		for(i=0,ni=0;i<st.GetLength() && ni<2;i++)
		{
			if (st[i]==m_Separator) ni++;
		}
		char* s=(char*)(const char*) st;
		s+=i;
		int d;
		for (a=0;a<ns;a++)
			for (b=0;b<ng;b++)
			{
				c=0;
				sscanf(s,"%d",&c);
				for (d=0;d<(signed)strlen(s);d++)
					if (s[d]==m_Separator) {s=s+d+1;break;}
				m_ValGroup[b].SetAt(n-m-2,a,c);
			}
	 }
	}
	// Legge gli eventuali dati finali
	if(p)
	{
	 m_L5=lc.line(q-2);
	 m_L6=lc.line(q-1);
	 for(n=q;n<l;n++)
	 {
		st=lc.line(n);
		if (st.GetLength()==0 || st[0]==m_Separator || st[0]=='\0') break;
		if (st[0]!='\"') break;
		for(i=0,ni=0;i<st.GetLength() && ni<2;i++)
		{
			if (st[i]==m_Separator) 
			{
			 ni++;
			 if (ni==1)
			 {
				int hj;
				if (d) hj=ng; else hj=0;
				for(j=hj;j<hj+ng;j++) 
				{
					m_ValGroup[j].TimeStamp(n-q)=-1;
					m_ValGroup[j].FinTimeStamp(n-q)=-1;
					m_ValGroup[j].SetRowName(n-q,st.Mid(1,i-2));
				}
			 }
			}
		}
		char* s=(char*)(const char*) st;
		s+=i;
		int dd,kk;

		if (d) kk=ng; else kk=0;
		for (a=0;a<ns;a++)
			for (b=kk;b<kk+ng;b++)
			{
				c=0;
				sscanf(s,"%d",&c);
				for (dd=0;dd<(signed)strlen(s);dd++)
					if (s[dd]==m_Separator) {s=s+dd+1;break;}
				m_ValGroup[b].SetAt(n-q,a,c);
			}
	 }
	}
	for(;n<l;n++)
	{
		m_Other+=lc.line(n);
		m_Other+="\r\n";
	}
	m_Int=ng;
	if (m_ValGroup.GetSize()==0) return 1;
	int aa,bb;
	m_ValGroup[0].GetSize(aa,bb);
	if (aa==0 || bb==0) return 1;
	CMyTableView* vw=(CMyTableView*)GetCompatibleView(RUNTIME_CLASS(CMyTableView));
	if (!vw) return 1;
	vw->Update(m_CurGroup);
	IsInit=1;
	return 0;
}

void CCsvDocument::SetSeparator(const char s)
{
	m_Separator=s;
}

CView* CCsvDocument::GetCompatibleView(CRuntimeClass * pViewClass)
{
    CView* pView;
	POSITION pos = GetFirstViewPosition();
	while (pos != NULL)
	{
		pView = GetNextView(pos);
		if (pView->IsKindOf(pViewClass))
		{
			return pView;
		}
	}
    return NULL;
}

void CCsvDocument::OnLogFirst() 
{
	m_CurGroup=0;
	CMyTableView* vw=(CMyTableView*)GetCompatibleView(RUNTIME_CLASS(CMyTableView));
	if (!vw) return;
	vw->Update(m_CurGroup);
}

void CCsvDocument::OnLogLast() 
{
	m_CurGroup=m_ValGroup.GetSize()-1;
	CMyTableView* vw=(CMyTableView*)GetCompatibleView(RUNTIME_CLASS(CMyTableView));
	if (!vw) return;
	vw->Update(m_CurGroup);
}

void CCsvDocument::OnLogNext() 
{
	m_CurGroup++;
	CMyTableView* vw=(CMyTableView*)GetCompatibleView(RUNTIME_CLASS(CMyTableView));
	if (!vw) return;
	vw->Update(m_CurGroup);
}

void CCsvDocument::OnLogPrev() 
{
	m_CurGroup--;
	CMyTableView* vw=(CMyTableView*)GetCompatibleView(RUNTIME_CLASS(CMyTableView));
	if (!vw) return;
	vw->Update(m_CurGroup);
}

void CCsvDocument::OnUpdateLogFirst(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_ValGroup.GetSize()>0);
}

void CCsvDocument::OnUpdateLogPrev(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_ValGroup.GetSize()>0 && m_CurGroup >0);
}

void CCsvDocument::OnUpdateLogNext(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_ValGroup.GetSize()>0 && m_CurGroup <m_ValGroup.GetSize()-1);
}

void CCsvDocument::OnUpdateLogLast(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_ValGroup.GetSize()>0);
}

int CCsvDocument::RemoveRow(int r)
{
	int i,n=m_ValGroup.GetSize();
	i=0;
	if (m_CurGroup<m_Int) n=m_Int;
	else i=m_Int;
	for(;i<n;i++)
		m_ValGroup[i].RemoveRow(r);
	return 0;
}

int CCsvDocument::RemoveCol(int c)
{
	int i,n=m_ValGroup.GetSize();
	for(i=0;i<n;i++)
		m_ValGroup[i].RemoveCol(c);
	UpdateRows(m_L3);
	UpdateRows(m_L5);
	return 0;
}

void CCsvDocument::Close()
{
	CView*pView;
	pView = GetCompatibleView(RUNTIME_CLASS(CMyTableView));
	if (pView) pView->GetParentFrame()->DestroyWindow();
    return;
}

void CCsvDocument::OnCloseDocument() 
{
	if (m_IsCsvModified) 
	{
		if (AfxMessageBox(TBL_SAVE /*Salvare le modifiche al documento?*/,MB_YESNO)==IDYES)
			if(Save()) return;
	}
	CDocument::OnCloseDocument();
}

void CCsvDocument::OnTblSave() 
{
	Save();
}

int CCsvDocument::Save()
{
	CFileDialog dlgFile(FALSE);

	CString title=M_SAVEAS;
	CString fileName;
    UINT nIDSTitle=AFX_IDS_OPENFILE;
    DWORD lFlags=OFN_HIDEREADONLY ;
    BOOL bOpenFileDialog=FALSE;

	dlgFile.m_ofn.Flags |= lFlags;

	CString strFilter=M_CSVFILES;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_CSVFLT);
	strFilter += (TCHAR)'\0';   // last string
	CString strDefault;
	// append the '*.*' all files filter
	CString allFilter;
	VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	strFilter += allFilter;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_ALLFLT);
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	BOOL bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	fileName.ReleaseBuffer();
    if (bResult)
     {
	  CString F=fileName;
      CFile f(fileName,CFile::modeCreate | CFile::modeWrite);
      CArchive ar( &f, CArchive::store);
      fileName=dlgFile.GetFileExt();
      fileName.MakeUpper();
	  Serialize(ar);
	  m_IsCsvModified=0;
     }
	else return 1;
	return 0;
}

void CCsvDocument::OnTblOther() 
{
	((CAnalyzerApp*)AfxGetApp())->CreateRoDoc(TBL_RES /*Statistics Results*/,m_Other);
}


void CCsvDocument::Jump(int n)
{
	if(n>=m_ValGroup.GetSize() || n<0) return;
	m_CurGroup=n;
	CMyTableView* vw=(CMyTableView*)GetCompatibleView(RUNTIME_CLASS(CMyTableView));
	if (!vw) return;
	vw->Update(m_CurGroup);
}

void CCsvDocument::UpdateRows(CString & str)
{
	if (str.GetLength()==0) return;
	int i,n=m_ValGroup.GetSize();
	if (m_Int>0) n=m_Int;
	int ni=0;
	for(i=0;i<str.GetLength()&&ni<2;i++)
		if (str[i]==m_Separator) ni++;
	str=str.Left(i);
	int r,c;
	m_ValGroup[0].GetSize(r,c);
	char t[2];
	t[1]='\0';
	t[0]=m_Separator;
	for(r=0;r<c;r++)
	{
		str+=(CString)"\""+m_ValGroup[0].GetColName(r)+"\"";
		for(int j=0;j<n;j++) str+=t;
	}
}
