#if !defined(AFX_CSVDOC_H__1DBB48E2_D397_11D2_B748_0048540133F7__INCLUDED_)
#define AFX_CSVDOC_H__1DBB48E2_D397_11D2_B748_0048540133F7__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// CsvDoc.h : header file
//

#include <afxtempl.h>
#include "valgroup.h"

/////////////////////////////////////////////////////////////////////////////
// CCsvDocument document

class LineCollection;

class CCsvDocument : public CDocument
{
protected:
	CCsvDocument();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CCsvDocument)

// Attributes
private:
	void UpdateRows(CString& str);
	CString m_Other;
	int Save();
	BOOL m_IsCsvModified;
	CString m_L1;
	CString m_L2;
	CString m_L3;
	CString m_L4;
	CString m_L5;
	CString m_L6;
	CString m_Le;
	char m_Separator;

// Operations
public:
	void SetCsvModifiedFlag(BOOL b){m_IsCsvModified=b;}
	void First(){OnLogFirst();}
	void Last(){OnLogLast();}
	void Next(){OnLogNext();}
	void Prev(){OnLogPrev();}
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCsvDocument)
	public:
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
	virtual void OnCloseDocument();
	protected:
	virtual BOOL OnNewDocument();
	//}}AFX_VIRTUAL

// Implementation
public:
	void Jump(int n);
	int m_Int;
	void Close();
	int RemoveCol(int c);
	int RemoveRow(int r);
	BOOL IsInit;
	int m_Ts0;
	int m_Tsf;
	CView* GetCompatibleView(CRuntimeClass* pViewClass);
	int m_CurGroup;
	CArray<CValGroup,CValGroup&> m_ValGroup;
	void SetSeparator(const char s);
	int NewFromLC(LineCollection& lc);
	virtual ~CCsvDocument();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CCsvDocument)
	afx_msg void OnLogFirst();
	afx_msg void OnLogLast();
	afx_msg void OnLogNext();
	afx_msg void OnLogPrev();
	afx_msg void OnUpdateLogFirst(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLogPrev(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLogNext(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLogLast(CCmdUI* pCmdUI);
	afx_msg void OnTblSave();
	afx_msg void OnTblOther();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CSVDOC_H__1DBB48E2_D397_11D2_B748_0048540133F7__INCLUDED_)
