// DataDialog.cpp : implementation file
//

#include "stdafx.h"
#include "analyzer.h"
#include "DataDialog.h"
#include "clistview.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDataDialog dialog

#ifndef ENGLISH
#define DATA_INT "Decimale"
#define DATA_HEX "Esadecimale"
#define DATA_OCT "Ottale"
#define DATA_BIN "Binario"
#else
#define DATA_INT "Decimal"
#define DATA_HEX "Exadecimal"
#define DATA_OCT "Octal"
#define DATA_BIN "Binary"
#endif

CDataDialog::CDataDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CDataDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDataDialog)
	//}}AFX_DATA_INIT
	m_CurItem=0;
	m_pView=NULL;
	m_EnableUpdate=TRUE;
}


void CDataDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDataDialog)
	DDX_Control(pDX, IDC_SCROLLBAR2, m_Scroll);
	DDX_Control(pDX, IDC_EDIT7, m_Occurrence);
	DDX_Control(pDX, IDC_CHECK1, m_Skip);
	DDX_Control(pDX, IDC_COMBO2, m_Type);
	DDX_Control(pDX, IDC_COLUMNS, m_Columns);
	DDX_Control(pDX, IDC_REMOVE, m_Remove);
	DDX_Control(pDX, IDC_EDIT6, m_Default);
	DDX_Control(pDX, IDC_EDIT1, m_Tag);
	DDX_Control(pDX, IDC_TAB1, m_Tab);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDataDialog, CDialog)
	//{{AFX_MSG_MAP(CDataDialog)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_REMOVE, OnRemove)
	ON_BN_CLICKED(IDC_COLUMNS, OnColumns)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB1, OnTabSelChange)
	ON_WM_CREATE()
	ON_WM_VSCROLL()
	ON_EN_KILLFOCUS(IDC_EDIT7, OnOccurrenceKillFocus)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDataDialog message handlers

void CDataDialog::OnAdd() 
{
	int n;
	n=m_Tags.GetSize();
	m_Tags.SetSize(n+1);
	m_Vals.SetSize(n+1);
	m_Skips.SetSize(n+1);
	m_Types.SetSize(n+1);
	m_Occurrences.SetSize(n+1);
	CString str;
	m_Tag.GetWindowText(str);
	m_Tags[m_CurItem]=str;
	m_Default.GetWindowText(str);
	int v=m_Vals[m_CurItem];
	sscanf(str,"%d",&v);
	m_Vals[m_CurItem]=v;
	m_Occurrence.GetWindowText(str);
	v=m_Occurrences[m_CurItem];
	if(v<1||v>100) v=1;
	sscanf(str,"%d",&v);
	m_Occurrences[m_CurItem]=v;
	m_Types[m_CurItem]=m_Type.GetCurSel();
	m_Skips[m_CurItem]=m_Skip.GetCheck();
	m_CurItem=n;
	m_Tag.SetWindowText("");
	m_Default.SetWindowText("0");
	m_Occurrence.SetWindowText("1");
	m_Type.SetCurSel(0);
	m_Skip.SetCheck(0);
	str.Format("%d.",n+1);
	TC_ITEM tci;
	tci.mask=TCIF_TEXT;
	tci.iImage=-1;
	tci.pszText=(char*)(const char*)str;
	m_Tab.InsertItem(n,&tci);
	m_Tab.SetCurSel(n);
	Enable(m_Remove,TRUE);
	m_Tag.SetFocus();
}

void CDataDialog::OnRemove() 
{
	int i,n;
	m_EnableUpdate=FALSE;
	n=m_Tags.GetSize();
	for(i=m_CurItem;i<n-1;i++)
	{
		m_Tags[i]=m_Tags[i+1];
		m_Vals[i]=m_Vals[i+1];
		m_Types[i]=m_Types[i+1];
		m_Skips[i]=m_Skips[i+1];
		m_Occurrences[i]=m_Occurrences[i+1];
	}
	m_CurItem=0;
	m_Tab.DeleteItem(n-1);
	m_Tags.SetSize(n-1);
	m_Vals.SetSize(n-1);
	m_Skips.SetSize(n-1);
	m_Types.SetSize(n-1);
	m_Occurrences.SetSize(n-1);
	m_Tab.SetCurSel(0);
	CString str;
	m_Tag.SetWindowText(m_Tags[m_CurItem]);
	str.Format("%d",m_Vals[m_CurItem]);
	m_Default.SetWindowText(str);
	str.Format("%d",m_Occurrences[m_CurItem]);
	m_Occurrence.SetWindowText(str);
	m_Type.SetCurSel(m_Types[m_CurItem]);
	m_Skip.SetCheck(m_Skips[m_CurItem]);
	if(n<=2) Enable(m_Remove,FALSE);
	m_EnableUpdate=TRUE;
}

void CDataDialog::OnColumns() 
{
	if(m_pView) m_pView->SelectCols();
	else Enable (m_Columns,FALSE);
}

void CDataDialog::OnTabSelChange(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int n;
	if(pResult) *pResult = 0;
	if(m_EnableUpdate==FALSE) return;
	n=m_Tab.GetCurSel();
	CString str;
	m_Tag.GetWindowText(str);
	m_Tags[m_CurItem]=str;
	m_Default.GetWindowText(str);
	int v=0;
	v=m_Vals[m_CurItem];
	sscanf(str,"%d",&v);
	m_Vals[m_CurItem]=v;
	m_Occurrence.GetWindowText(str);
	v=m_Occurrences[m_CurItem];
	sscanf(str,"%d",&v);
	if(v<1||v>100) v=1;
	m_Occurrences[m_CurItem]=v;
	m_Types[m_CurItem]=m_Type.GetCurSel();
	m_Skips[m_CurItem]=m_Skip.GetCheck();
	m_CurItem=n;
	m_Tag.SetWindowText(m_Tags[m_CurItem]);
	str.Format("%d",m_Vals[m_CurItem]);
	m_Default.SetWindowText(str);
	str.Format("%d",m_Occurrences[m_CurItem]);
	m_Occurrence.SetWindowText(str);
	m_Type.SetCurSel(m_Types[m_CurItem]);
	m_Skip.SetCheck(m_Skips[m_CurItem]);
}

int CDataDialog::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	return 0;
}

BOOL CDataDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	TC_ITEM tci;
	tci.mask=TCIF_TEXT;
	tci.iImage=-1;
	tci.pszText="1.";
	m_Tab.InsertItem(0,&tci);
	m_Tags.SetSize(1);
	m_Vals.SetSize(1);
	m_Skips.SetSize(1);
	m_Types.SetSize(1);
	m_Occurrences.SetSize(1);
	m_Occurrences[0]=1;
	m_Tags[0]="";
	m_Vals[0]=0;
	Enable(m_Remove,FALSE);
	m_CurItem=0;
	if(m_pView) {Enable (m_Columns,TRUE);}
	else {Enable (m_Columns,FALSE);m_Columns.ShowWindow(SW_HIDE);}
	m_Default.SetWindowText("0");
	m_Occurrence.SetWindowText("1");
	m_Tag.SetWindowText("");
	m_Type.AddString(DATA_INT /*Intero*/);
	m_Type.AddString(DATA_HEX /*Esadecimale*/);
	m_Type.AddString(DATA_OCT /*Ottale*/);
	m_Type.AddString(DATA_BIN /*Binario*/);
	m_Type.SetCurSel(0);
	m_Skip.SetCheck(0);
	m_Tag.SetFocus();
	return FALSE;
}

void CDataDialog::Enable(CButton & button, BOOL b)
{
	if (button.m_hWnd==NULL) return;
	DWORD d=button.GetStyle();
	if (b) button.ModifyStyle(WS_DISABLED,0);
	else button.ModifyStyle(0,WS_DISABLED);
	button.Invalidate();
}

void CDataDialog::OnOK() 
{
	OnTabSelChange(NULL,NULL);
	
	CDialog::OnOK();
}

int CDataDialog::FindToken(const char * str, int ii)
{
	int n=strlen(m_Tags[ii]);
	int i,l=strlen(str);
	int found;
	const char* s;
	found=0;
	for(i=0;i<l-n;i++)
		if(strncmp(str+i,m_Tags[ii],n)==0) 
		{
			found++;
			s=str+i+n;
			if (found == m_Occurrences[ii])	break;
		}
	if(found<m_Occurrences[ii]) return m_Vals[ii];
	if(m_Skips[ii])
	{
		l=strlen(s);
		for(i=0;i<l;i++)
			if (m_Types[ii]==0)
			{
				if (s[i]=='-' || (s[i]>='0' && s[i]<='9'))
					break;
			}
			else if (m_Types[ii]==1)
			{
					if (((s[i]>='0' && s[i]<='9') || 
					 (s[i]>='a' && s[i]<='f') || 
					 (s[i]>='A' && s[i]<='F'))) 
					 break;
			}
			else if (m_Types[ii]==2)
			{
			    if(s[i]>='0' && s[i]<='7') 
					break;
			}
			else if (m_Types[ii]==3) 
			{
			    if ((s[i]=='-' || (s[i]>='0' && s[i]<='1'))) 
					break;
			}
		s=s+i;
	}
	int v=m_Vals[ii];
	int val=0;
	if(m_Types[ii]==0) sscanf(s,"%d",&v);
	else if(m_Types[ii]==1) sscanf(s,"%x",&v);
	else if(m_Types[ii]==2) sscanf(s,"%o",&v);
	else if(m_Types[ii]==3) 
		{
			if (strlen(s))v=0;
				else return v;
			for(i=0;i<(signed)strlen(s);i++)
				if (s[i]=='0') {v<<=1;}
				else if (s[i]=='1') {v<<=1;v+=1;}
				else break;
		}
	return v;
}

void CDataDialog::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	nPos=m_Occurrences[m_CurItem];
    switch(nSBCode)
     {
       case SB_LINEDOWN:
        nPos++;
        break;
       case SB_LINEUP:
        nPos--;
        break;
       case SB_PAGEDOWN:
        nPos+=5;
        break;
       case SB_PAGEUP:
        nPos-=5;
        break;
       default:
        return;
        break;
     }
    if (nPos<1) nPos=1;
    if (nPos>100) nPos=100;
	m_Occurrences[m_CurItem]=nPos;
	CString str;
	str.Format("%d",nPos);
	m_Occurrence.SetWindowText(str);
}

void CDataDialog::OnOccurrenceKillFocus() 
{
	CString str;
	int v;
	m_Occurrence.GetWindowText(str);
	v=m_Occurrences[m_CurItem];
	sscanf(str,"%d",&v);
	if(v<1||v>100) v=1;
	m_Occurrences[m_CurItem]=v;
	str.Format("%d",v);
	m_Occurrence.SetWindowText(str);
}
