// FilterWiz.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"
#include "FilterWiz.h"
#include "SelFilter.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define FLTRS "filters.dat"
#define FLTR_FILE_SEC "DAT"
#define FW_ASK1 "Si vogliono inserire delle parentesi tra altre parentesi non bilanciate?"
#define FW_ERR1 "Impossibile inserire l'operatore NOT a destra di un valore"
#define FW_PR "Protocolli"
#define FW_VAR "Variabili"
#define FW_VAL "Valori"
#define FW_ASCII "Ascii"
#define FW_HEX "Hex"
#define FW_ERR2 "Impossibile inserire un operatore a destra di un operatore"
#define FW_ERR3 "Impossibile inserire un operatore a sinistra di un operatore"
#define FW_DEST_IT "Descrizione"
#define FW_VAL_IT "Valore"
#define FW_V1 "Byte disponibili del pacchetto"
#define FW_V2 "Lunghezza in byte del pacchetto"
#define FW_V3 "Posizione attuale del pacchetto"
#define FW_V4 "Posizione attuale del pacchetto in percentuale"
#define FW_V5 "Secondi del timestamp del pacchetto"
#define FW_V6 "Microsecondi del timestamp del pacchetto"
#define FW_V7 "Tipo del pacchetto attuale"
#define FW_V8 "Pacchetti scritti su disco dall'ultima informazione statistica"
#define FW_V9 "Pacchetti scartati dall'ultima informazione statistica"
#define FW_ERR4 "Impossibile inserire un valore a destra di un valore"
#define FW_ERR5 "Impossibile inserire un valore a sinistra di un valore"
#define FW_ERR6 "Il valore inserito non  un numero decimale"
#define FW_ERR7 "Il valore inserito non  un numero esadecimale"
#define FW_ERR8 "Il valore inserito non  un numero ottale"
#define FW_SAVE "Si vuole sostituire una selezione con parentesi non bilanciate?"
#define FW_ERR9 "Impossibile provare il filtro"
#define FW_ERR10 "Impossibile salvare un filtro vuoto"
#else
#define FLTRS "filters_e.dat"
#define FLTR_FILE_SEC "DAT_E"
#define FW_ASK1 "Do you wish to insert parentesis between non balanced parentesis?"
#define FW_ERR1 "Unable to insert NOT operator to the right of a value"
#define FW_PR "Protocols"
#define FW_VAR "Variables"
#define FW_VAL "Values"
#define FW_ASCII "Ascii"
#define FW_HEX "Hex"
#define FW_ERR2 "Unable to insert operators to the right of another operator"
#define FW_ERR3 "Unable to insert operators to the left of another operator"
#define FW_DEST_IT "Description"
#define FW_VAL_IT "Value"
#define FW_V1 "Avilable bytes"
#define FW_V2 "Packet Length"
#define FW_V3 "Current Position"
#define FW_V4 "Current Position (%)"
#define FW_V5 "Packet Seconds"
#define FW_V6 "Packet Micro-Seconds"
#define FW_V7 "Packet Type"
#define FW_V8 "Writed Packets"
#define FW_V9 "Discarded Packets"
#define FW_ERR4 "Unable to insert a value to the right of a value"
#define FW_ERR5 "Unable to insert a value to the left of a value"
#define FW_ERR6 "Bad decimal value"
#define FW_ERR7 "Bad hexadecimal value"
#define FW_ERR8 "Bad octal value"
#define FW_SAVE "Do you wish to substitute selection with non balanced parentesis?"
#define FW_ERR9 "Unable to test filter"
#define FW_ERR10 "Unable to save empty filter"
#endif

/////////////////////////////////////////////////////////////////////////////
// CFilterWiz dialog


CFilterWiz::CFilterWiz(CWnd* pParent /*=NULL*/)
	: CDialog(CFilterWiz::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFilterWiz)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	Filter="";
	lc=NULL;
	m_pDoc=NULL;
	images[0].n=0;
	images[0].s=1;
	images[1].n=2;
	images[1].s=3;
	images[2].n=4;
	images[2].s=5;
}


void CFilterWiz::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFilterWiz)
	DDX_Control(pDX, IDC_STATIC_TXT, m_Static);
	DDX_Control(pDX, IDC_VALUE, m_Value);
	DDX_Control(pDX, IDC_FRAME, m_Frame);
	DDX_Control(pDX, IDC_INSERT, m_Ins);
	DDX_Control(pDX, IDC_RADIO3, m_Oct);
	DDX_Control(pDX, IDC_RADIO2, m_Hex);
	DDX_Control(pDX, IDC_RADIO1, m_Dec);
	DDX_Control(pDX, IDC_LIST1, m_VmVars);
	DDX_Control(pDX, IDC_TAB1, m_Tab);
	DDX_Control(pDX, IDC_TREE1, m_Tree);
	DDX_Control(pDX, IDC_EDIT2, m_Val);
	DDX_Control(pDX, IDC_EDIT1, m_Exp);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFilterWiz, CDialog)
	//{{AFX_MSG_MAP(CFilterWiz)
	ON_BN_CLICKED(IDC_BUTTON2, OnPlus)
	ON_BN_CLICKED(IDC_BUTTON3, OnMinus)
	ON_BN_CLICKED(IDC_BUTTON4, OnMul)
	ON_BN_CLICKED(IDC_BUTTON5, OnDiv)
	ON_BN_CLICKED(IDC_BUTTON10, OnParC)
	ON_BN_CLICKED(IDC_BUTTON6, OnAnd)
	ON_BN_CLICKED(IDC_BUTTON7, OnOr)
	ON_BN_CLICKED(IDC_BUTTON8, OnNot)
	ON_BN_CLICKED(IDC_BUTTON11, OnEq)
	ON_BN_CLICKED(IDC_BUTTON13, OnMAU)
	ON_BN_CLICKED(IDC_BUTTON12, OnMIU)
	ON_BN_CLICKED(IDC_BUTTON14, OnNotEq)
	ON_BN_CLICKED(IDC_BUTTON15, OnMi)
	ON_BN_CLICKED(IDC_BUTTON16, OnMa)
	ON_BN_CLICKED(IDC_BUTTON9, OnMod)
	ON_NOTIFY(NM_DBLCLK, IDC_TREE1, OnDblclkTree1)
	ON_BN_CLICKED(IDC_SHL, OnShl)
	ON_BN_CLICKED(IDC_SHR, OnShr)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB1, OnTabSelChange)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST1, OnDblclkList)
	ON_BN_CLICKED(IDC_INSERT, OnInsert)
	ON_BN_CLICKED(IDC_PAR_L, OnParL)
	ON_BN_CLICKED(IDC_PAR_R, OnParR)
	ON_BN_CLICKED(IDC_LEFT, OnLeft)
	ON_BN_CLICKED(IDC_CUR, OnCurrent)
	ON_BN_CLICKED(IDC_RIGHT, OnRight)
	ON_BN_CLICKED(IDC_TEST, OnTest)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_BN_CLICKED(IDC_SAVE, OnSave)
	ON_EN_CHANGE(IDC_EDIT2, OnChangeValue)
	ON_EN_UPDATE(IDC_EDIT2, OnChangeValue)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFilterWiz message handlers

void CFilterWiz::OnPlus() 
{
	InsertOperator("+");
}

void CFilterWiz::OnMinus() 
{
	m_Exp.ReplaceSel("-",TRUE);
}

void CFilterWiz::OnMul() 
{
	InsertOperator("*");
}

void CFilterWiz::OnDiv() 
{
	InsertOperator("/");
}

void CFilterWiz::OnParC() 
{
	CString st;
	m_Exp.GetWindowText(st);
	int s,e;
	m_Exp.GetSel(s,e);
	st=st.Mid(s,e-s);
	int n=0,l=st.GetLength();
	for(int i=0;i<l;i++)
	if (st[i]=='(') n++;
	else if (st[i]==')') n--;
	if (n && AfxMessageBox(FW_ASK1 /*Si vogliono inserire delle parentesi tra altre parentesi non bilanciate?*/, MB_YESNO)==IDNO)
		return; 
	InsertText("("+st+")");
	m_Exp.SetSel(e+1,e+1);
}

void CFilterWiz::OnAnd() 
{
	InsertOperator("&&");
}

void CFilterWiz::OnOr() 
{
	InsertOperator("||");
}

void CFilterWiz::OnNot() 
{
	int s,e;
	m_Exp.GetSel(s,e);
	CString str;
	m_Exp.GetWindowText(str);
	if (!FindOp(str,s-1,0)) {AfxMessageBox(FW_ERR1 /*Impossibile inserire l'operatore NOT a destra di un valore*/);return;}
	m_Exp.ReplaceSel("!",TRUE);
}

void CFilterWiz::OnEq() 
{
	InsertOperator("==");
}

void CFilterWiz::OnMAU() 
{
	InsertOperator(">=");
}

void CFilterWiz::OnMIU() 
{
	InsertOperator("<=");
}

void CFilterWiz::OnNotEq() 
{
	InsertOperator("!=");
}

void CFilterWiz::OnMi() 
{
	InsertOperator("<");
}

void CFilterWiz::OnMa() 
{
	InsertOperator(">");
}

void CFilterWiz::OnMod() 
{
	InsertOperator("%");
}

void CFilterWiz::OnShl() 
{
	InsertOperator("<<");
}

void CFilterWiz::OnShr() 
{
	InsertOperator(">>");
}

void CFilterWiz::UpdateTree(LineCollection &lc)
{
     int level=0,i;

        TV_INSERTSTRUCT tvs;
        TV_ITEM tvi;
        HTREEITEM it[4];

		it[0]=TVI_ROOT;
		it[1]=TVI_ROOT;
		it[2]=TVI_ROOT;
        m_Tree.DeleteAllItems();

        for(i=0;i<lc.getLineCount();i++)
		{
		// Insert root;
			CString s=(char*)lc.line(i);
			for(level=0;level<2;level++) if (s[level]!=' ') break;
			while (s.GetLength()>0 && s[0]=='-') s=(const char*)s+1;
			while (s.GetLength()>0 && s[s.GetLength()-1]=='-') s=s.Left(s.GetLength()-1);
			s.TrimLeft();
			if (s[0]=='[' || s[0]=='(') continue;
			s.TrimRight();
			tvi.pszText=(char*)(const char*) s;
			tvs.hInsertAfter= TVI_LAST;
			tvi.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
			tvi.iImage=images[level].n;
			tvi.iSelectedImage=images[level].s;

			tvs.hParent=it[level];
			tvs.item=tvi;
			it[level+1]=m_Tree.InsertItem(&tvs);
		}
		return ;
}


BOOL CFilterWiz::OnInitDialog() 
{
	CDialog::OnInitDialog();
	m_ctlImage.Create(IDB_BITMAP3,16,0,RGB(255,0,255));
	m_ctlImage.SetBkColor(GetSysColor(COLOR_WINDOW));
	m_Tree.SetImageList(&m_ctlImage,TVSIL_NORMAL);
	m_Exp.SetWindowText(Filter);
	m_Val.SetWindowText("");
	TC_ITEM tci;
	tci.mask=TCIF_TEXT;
	tci.iImage=-1;
	tci.pszText=FW_PR /*Protocolli*/;
	m_Tab.InsertItem(0,&tci);
	tci.pszText=FW_VAR /*Variabili*/;
	m_Tab.InsertItem(1,&tci);
	tci.pszText=FW_VAL /*Valori*/;
	m_Tab.InsertItem(2,&tci);
	tci.pszText=FW_ASCII /*Ascii*/;
	m_Tab.InsertItem(3,&tci);
	tci.pszText=FW_HEX /*Hex*/;
	m_Tab.InsertItem(4,&tci);
	m_Tab.BringWindowToTop();
	if (lc) UpdateTree(*lc);
	OnInitList();
	m_Dec.SetCheck(TRUE);
	m_Hex.SetCheck(FALSE);
	m_Oct.SetCheck(FALSE);
	m_Exp.SetSel(0,Filter.GetLength());
	m_Exp.SetFocus();
	return FALSE;
}

void CFilterWiz::OnOK() 
{
	m_Exp.GetWindowText(Filter);
	CDialog::OnOK();
}

void CFilterWiz::OnDblclkTree1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	if(pResult)*pResult = 0;
	HTREEITEM it=m_Tree.GetSelectedItem();
	if (it==NULL) return;
	CString s=m_Tree.GetItemText(it);
	for(int i=0;i<s.GetLength();i++)
		if (s[i]==' ' || s[i]=='(') s=s.Left(i);
	CString t=s;
	while (it=m_Tree.GetParentItem(it))
	{
		t=m_Tree.GetItemText(it)+"."+s;
	}
	InsertText(t);
}

void CFilterWiz::OnTabSelChange(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int s,e;
	m_Exp.GetSel(s,e);
	switch(m_Tab.GetCurSel())
	{
	case 0: 
		SetProtos(); 
		break;
	case 1: 
		SetVars(); 
		break;
	case 2: 
		SetNums(); 
		break;
	case 3: 
		SetAscii(); 
		break;
	default: 
		SetHex(); 
		break;
	}
	m_Exp.SetSel(s,e);
	*pResult = 0;
}

void CFilterWiz::InsertOperator(const char * op)
{
	int s,e;
	m_Exp.GetSel(s,e);
	CString str;
	m_Exp.GetWindowText(str);
	if (!FindVarNum(str,s-1,0)) {AfxMessageBox(FW_ERR2 /*Impossibile inserire un operatore a destra di un operatore*/);return;}
	if (!FindVarNum(str,e,1)) {AfxMessageBox(FW_ERR3 /*Impossibile inserire un operatore a sinistra di un operatore*/);return;}
	if (!CheckPars(str.Mid(s,e-s))) return;
	m_Exp.ReplaceSel(op,TRUE);
	m_Exp.SetFocus();
}

void CFilterWiz::SetProtos()
{
	m_Frame.ShowWindow(SW_HIDE);
	m_Tree.ShowWindow(SW_SHOW);
	m_Value.ShowWindow(SW_HIDE);
	m_Static.ShowWindow(SW_HIDE);
	m_Dec.ShowWindow(SW_HIDE);
	m_Hex.ShowWindow(SW_HIDE);
	m_Oct.ShowWindow(SW_HIDE);
	m_Val.ShowWindow(SW_HIDE);
	m_VmVars.ShowWindow(SW_HIDE);
}

void CFilterWiz::SetVars()
{
	m_Frame.ShowWindow(SW_HIDE);
	m_Tree.ShowWindow(SW_HIDE);
	m_Value.ShowWindow(SW_HIDE);
	m_Static.ShowWindow(SW_HIDE);
	m_Dec.ShowWindow(SW_HIDE);
	m_Hex.ShowWindow(SW_HIDE);
	m_Oct.ShowWindow(SW_HIDE);
	m_Val.ShowWindow(SW_HIDE);
	m_VmVars.ShowWindow(SW_SHOW);
}

void CFilterWiz::SetNums()
{
	m_Val.SetWindowText(""); 
	m_VmVars.ShowWindow(SW_HIDE);
	m_Tree.ShowWindow(SW_HIDE);
	m_Value.ShowWindow(SW_HIDE);
	m_Static.ShowWindow(SW_HIDE);
	m_Frame.ShowWindow(SW_SHOW);
	m_Dec.ShowWindow(SW_SHOW);
	m_Hex.ShowWindow(SW_SHOW);
	m_Oct.ShowWindow(SW_SHOW);
	m_Val.ShowWindow(SW_SHOW);
}

BOOL CFilterWiz::OnInitList() 
{
    m_VmVars.InsertColumn(0,FW_DEST_IT /*Descrizione*/, LVCFMT_LEFT,200);
    m_VmVars.InsertColumn(0,FW_VAL_IT /*Valore*/, LVCFMT_LEFT,200);
	m_VmVars.SetImageList(&m_ctlImage,LVSIL_SMALL);
	return UpdateList();
}

BOOL CFilterWiz::UpdateList()
{
        m_VmVars.DeleteAllItems();
		
		AddItem(0,0,
				FW_V1 /*Byte disponibili del pacchetto*/,2);
		AddItem(1,0,
				FW_V2 /*Lunghezza in byte del pacchetto*/,2);
		AddItem(2,0,
				FW_V3 /*Posizione attuale del pacchetto*/,2);
		AddItem(3,0,
				FW_V4 /*Posizione attuale del pacchetto in percentuale*/,2);
		AddItem(4,0,
				FW_V5 /*Secondi del timestamp del pacchetto*/,2);
		AddItem(5,0,
				FW_V6 /*Microsecondi del timestamp del pacchetto*/,2);
		AddItem(6,0,
				FW_V7 /*Tipo del pacchetto attuale*/,2);
		AddItem(7,0,
				FW_V8 /*Pacchetti scritti su disco dall'ultima informazione statistica*/,2);
		AddItem(8,0,
				FW_V9 /*Pacchetti scartati dall'ultima informazione statistica*/,2);

		AddItem(0,1,
				"GetVmVar(\"FrameAvail\")",2);
		AddItem(1,1,
				"GetVmVar(\"FrameSize\")",2);
		AddItem(2,1,
				"GetVmVar(\"ItemNumber\")",2);
		AddItem(3,1,
				"GetVmVar(\"Position\")",2);
		AddItem(4,1,
				"GetVmVar(\"FrameSecs\")",2);
		AddItem(5,1,
				"GetVmVar(\"FrameUSecs\")",2);
		AddItem(6,1,
				"GetVmVar(\"FrameType\")",2);
		AddItem(7,1,
				"GetVmVar(\"Written\")",2);
		AddItem(8,1,
				"GetVmVar(\"Discarded\")",2);

		m_VmVars.UpdateWindow();
		return TRUE;
}

void CFilterWiz::AddItem(int nItem, int nSubItem, LPCTSTR strItem, int nImageIndex)
{
	LV_ITEM lvItem;
	lvItem.mask = LVIF_TEXT;
	lvItem.iItem = nItem;
	lvItem.iSubItem = nSubItem;
	lvItem.pszText = (LPTSTR) strItem;
	if(nImageIndex != -1){
		lvItem.mask |= LVIF_IMAGE;
		lvItem.iImage = nImageIndex;
	}
	if(nSubItem == 0)
		m_VmVars.InsertItem(&lvItem);
	else m_VmVars.SetItem(&lvItem);
}

void CFilterWiz::OnDblclkList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int i,n=m_VmVars.GetItemCount();
	for(i=0;i<n;i++)
	{
		if (m_VmVars.GetItemState(i,LVIS_SELECTED))
		{
			InsertText(m_VmVars.GetItemText(i,1));
			break;
		}
	}
	if(pResult)*pResult = 0;
}

void CFilterWiz::InsertText(const char * t)
{
	int s,e;
	m_Exp.GetSel(s,e);
	CString str;
	m_Exp.GetWindowText(str);
	if (!FindOp(str,s-1,0)) {AfxMessageBox(FW_ERR4 /*Impossibile inserire un valore a destra di un valore*/);return;}
	if (!FindOp(str,e,1)) {AfxMessageBox(FW_ERR5 /*Impossibile inserire un valore a sinistra di un valore*/);return;}
	if (!CheckPars(str.Mid(s,e-s))) return;
	m_Exp.ReplaceSel(t,TRUE);
	m_Exp.SetFocus();
}

void CFilterWiz::OnInsert() 
{
	switch(m_Tab.GetCurSel())
	{
	case 0: 
		OnDblclkTree1(NULL,NULL); 
		break;
	case 1: 
		OnDblclkList(NULL,NULL); 
		break;
	case 2: 
		OnInsNum();
		break;
	case 3: 
		OnInsAscii(); 
		break;
	default: 
		OnInsHex(); 
		break;
	}
}

int CFilterWiz::FindOp(CString & s, int start,int dir)
{
	int i;
	int l=s.GetLength();
	if (dir==0)
	{
		if (start>=l) start=l-1;
		for (i=start;i>=0;i--)
			if (s[i]==' '||s[i]=='\t') continue;
			else if(isalnum(s[i])) return 0;
			else 
			{
				if (s[i]==')') return 0;
				return 1;
			}
		return 1;
	}
	else
	{
		if (start<s.GetLength())
		for (i=start;i<l;i++)
			if (s[i]==' '||s[i]==')'||s[i]=='\t') continue;
			else if(isalnum(s[i])) return 0;
			else return 1;
		return 1;
	}
}

int CFilterWiz::FindVarNum(CString & s, int start,int dir)
{
	int i;
	int l=s.GetLength();
	if (dir==0)
	{
		if (start>=l) start=l-1;
		for (i=start;i>=0;i--)
			if (s[i]==' '||s[i]=='\t') continue;
			else if(!isalnum(s[i])) 
			{
				if (s[i]==')') return 1;
				return 0;
			}
			else 
			{
				return 1;
			}
		return 0;
	}
	else
	{
		if (start<l)
		for (i=start;i<l;i++)
			if (s[i]==' '||s[i]=='\t') continue;
			else if(!isalnum(s[i])) 
			{
				if (s[i]=='(')
				{
					if (i+1<l && s[i+1]=='"') return 0;
					return 1;
				}
				if (s[i]==')') return 1;
				return 0;
			}
			else return 1;
		return 1;
	}
}

void CFilterWiz::OnParL() 
{
	int s,e,i;
	m_Exp.GetSel(s,e);
	CString str;
	m_Exp.GetWindowText(str);
	s--;
	int n=1;
	for (i=s;i>=0;i--)
	{
		if(str[i]=='(') {n--;if (n==0) {m_Exp.SetSel(i,i);m_Exp.SetFocus();return;}}
		else if (str[i]==')') n++;
	}
	m_Exp.SetSel(0,0);
	m_Exp.SetFocus();
}

void CFilterWiz::OnParR() 
{
	int s,e,i;
	m_Exp.GetSel(s,e);
	CString str;
	m_Exp.GetWindowText(str);
	int n=1;
	int l=str.GetLength();
	for (i=e;i<l;i++)
	{
		if(str[i]==')') {n--;if (n==0) {m_Exp.SetSel(i+1,i+1);m_Exp.SetFocus();return;}}
		else if (str[i]=='(') n++;
	}
	m_Exp.SetSel(l,l);
	m_Exp.SetFocus();
}


void CFilterWiz::OnInsNum()
{
	CString s;
	m_Val.GetWindowText(s);
	int val;
	if (m_Dec.GetCheck())
	{
		if(sscanf(s,"%d",&val)>0) {s.Format("%d",val);InsertText(s);}
		else AfxMessageBox(FW_ERR6 /*Il valore inserito non  un numero decimale*/);
	}
	else if (m_Hex.GetCheck())
	{
		if(sscanf(s,"%x",&val)>0) {s.Format("0x%X",val);InsertText(s);}
		else AfxMessageBox(FW_ERR7 /*Il valore inserito non  un numero esadecimale*/);
	}
	else
	{
		if(sscanf(s,"%o",&val)>0) {s.Format("%d",val);InsertText(s);}
		else AfxMessageBox(FW_ERR8 /*Il valore inserito non  un numero ottale*/);
	}
}

int CFilterWiz::CheckPars(CString & st)
{
	int n=0,l=st.GetLength();
	for(int i=0;i<l;i++)
	if (st[i]=='(') n++;
	else if (st[i]==')') n--;

	if (n)
	{
		if (AfxMessageBox(FW_SAVE /*Si vuole sostituire una selezione con parentesi non bilanciate?*/, MB_YESNO)==IDNO) 
			return 0; 
		return 1;
	}
	return 1;
}

void CFilterWiz::OnLeft() 
{
	int s,e;
	m_Exp.GetSel(s,e);
	if (s>0) m_Exp.SetSel(s-1,s-1);
		else m_Exp.SetSel(-1,-1);
	m_Exp.SetFocus();
}

void CFilterWiz::OnCurrent() 
{
	m_Exp.SetFocus();
}

void CFilterWiz::OnRight() 
{
	int s,e;
	m_Exp.GetSel(s,e);
	CString str;
	m_Exp.GetWindowText(str);
	int l=str.GetLength();
	if (e<l) m_Exp.SetSel(e+1,e+1);
		else m_Exp.SetSel(l,l);
	m_Exp.SetFocus();
}

void CFilterWiz::OnTest() 
{
	m_Exp.GetWindowText(Filter);
	if (m_pDoc) m_pDoc->OnLogFilter(Filter);
	else AfxMessageBox(FW_ERR9 /*Impossibile provare il filtro*/);
}


void CFilterWiz::OnBrowse() 
{
	CSelFilter dlg;
	CWinApp* pApp = AfxGetApp();   
	dlg.m_FileName=pApp->GetProfileString(FLTR_FILE_SEC, "Filters", 
		(((CAnalyzerApp*)AfxGetApp())->Path)+FLTRS);
	if(dlg.m_FileName[1]!=':') 
		dlg.m_FileName=((CAnalyzerApp*)AfxGetApp())->Path+dlg.m_FileName;
	if(dlg.DoModal()==IDOK)
	{
		m_Exp.SetWindowText(dlg.m_Filter);
	}
}

void CFilterWiz::OnSave() 
{
	CSelFilter dlg;
	dlg.m_FileName=((CAnalyzerApp*)AfxGetApp())->Path+"filters.dat";
	m_Exp.GetWindowText(dlg.m_Add);
	if (dlg.m_Add=="") {AfxMessageBox(FW_ERR10 /*Impossibile salvare un filtro vuoto*/);return;}
	if(dlg.DoModal()==IDOK)
	{
		m_Exp.SetWindowText(dlg.m_Filter);
	}
}

void CFilterWiz::SetAscii()
{
	m_Val.SetWindowText(""); 
	m_VmVars.ShowWindow(SW_HIDE);
	m_Tree.ShowWindow(SW_HIDE);
	m_Value.ShowWindow(SW_SHOW);
	m_Static.ShowWindow(SW_SHOW);
	m_Frame.ShowWindow(SW_SHOW);
	m_Dec.ShowWindow(SW_HIDE);
	m_Hex.ShowWindow(SW_HIDE);
	m_Oct.ShowWindow(SW_HIDE);
	m_Val.ShowWindow(SW_SHOW);
}

void CFilterWiz::SetHex()
{
	m_Val.SetWindowText(""); 
	m_VmVars.ShowWindow(SW_HIDE);
	m_Tree.ShowWindow(SW_HIDE);
	m_Value.ShowWindow(SW_SHOW);
	m_Static.ShowWindow(SW_SHOW);
	m_Frame.ShowWindow(SW_SHOW);
	m_Dec.ShowWindow(SW_HIDE);
	m_Hex.ShowWindow(SW_HIDE);
	m_Oct.ShowWindow(SW_HIDE);
	m_Val.ShowWindow(SW_SHOW);
}

void CFilterWiz::OnInsAscii()
{
	CString s;
	m_Value.GetWindowText(s);
	s="ContainASCII(\""+s+"\")";
	InsertText(s);
}

void CFilterWiz::OnInsHex()
{
	CString s;
	m_Value.GetWindowText(s);
	s="ContainHEX(\""+s+"\")";
	InsertText(s);
}

int hexcmp(CArray<int,int> & v,const unsigned char* str);
CArray<int,int> &StrToHex(char const * s,CArray<int,int> &dest);
CString &HexToStr(CArray<int,int>& s,CString &d);

void CFilterWiz::OnChangeValue() 
{
	CString str;
	CArray<int,int> v;
	switch(m_Tab.GetCurSel())
	{
	case 0: 
	case 1: 
	case 2: 
		break;
	case 3: 
		m_Val.GetWindowText(str); 
		m_Value.SetWindowText(str); 
		break;
	default: 
		m_Val.GetWindowText(str); 
		StrToHex((char const *) str,v);
		HexToStr(v,str);
		m_Value.SetWindowText(str); 
		break;
	}
}
