// FinderDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"
#include "FinderDlg.h"
#include "FilterWiz.h"
#include "CLogDocument.h"
#include "SelFilter.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define FLTRS "filters.dat"
#define FLTR_FILE_SEC "DAT"
#else
#define FLTRS "filters_e.dat"
#define FLTR_FILE_SEC "DAT_E"
#endif

/////////////////////////////////////////////////////////////////////////////
// CFinderDlg dialog


CFinderDlg::CFinderDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFinderDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFinderDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	filter=NULL;
	m_pDoc=NULL;
}


void CFinderDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFinderDlg)
	DDX_Control(pDX, IDC_RADIO1, m_FindNext);
	DDX_Control(pDX, IDC_RADIO2, m_FindPrev);
	DDX_Control(pDX, IDC_EDIT1, m_Filter);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFinderDlg, CDialog)
	//{{AFX_MSG_MAP(CFinderDlg)
	ON_BN_CLICKED(IDC_FILTERWIZ, OnFilterwiz)
	ON_BN_CLICKED(IDC_RADIO1, OnRadio1)
	ON_BN_CLICKED(IDC_RADIO2, OnRadio2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFinderDlg message handlers

void CFinderDlg::OnFilterwiz() 
{
	CSelFilter dlg;
	CWinApp* pApp = AfxGetApp();   
	dlg.m_FileName=pApp->GetProfileString(FLTR_FILE_SEC, "Filters", 
		(((CAnalyzerApp*)AfxGetApp())->Path)+FLTRS);
	if(dlg.m_FileName[1]!=':') 
		dlg.m_FileName=((CAnalyzerApp*)AfxGetApp())->Path+dlg.m_FileName;
	dlg.m_pDoc=m_pDoc;
	if(dlg.DoModal()==IDOK)
	{
	  if (!m_pDoc->OnLogFilter(dlg.m_Filter))
			m_pDoc->OnLogFilter((CString)"TRUE");
	  m_Filter.SetWindowText(dlg.m_Filter);
	}
}

void CFinderDlg::OnOK() 
{
    CString t;
    m_Filter.GetWindowText(t);
    if(filter!=NULL) delete[]filter;
    filter=new char[strlen(t)+1];
    strcpy(filter,t);
	if (m_pDoc && m_pDoc->OnLogFilter(t))
	{
		if (m_pDoc)
			if(!m_pDoc->m_FindF) m_pDoc->LogPrevf();
			else m_pDoc->LogNextf();
	}
}

void CFinderDlg::OnCancel() 
{
	((CMainFrame*)AfxGetMainWnd())->m_Fltr=FALSE;
	CDialog::OnCancel();
}

BOOL CFinderDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	if (filter) m_Filter.SetWindowText(filter);
	m_FindNext.SetCheck(TRUE);
	return TRUE;
}

CFinderDlg::~CFinderDlg()
{
	if(filter) delete[]filter;
}

void CFinderDlg::OnRadio1() 
{
	if (m_pDoc)
		m_pDoc->m_FindF=TRUE;
}

void CFinderDlg::OnRadio2() 
{
	if (m_pDoc)
		m_pDoc->m_FindF=FALSE;
}
