// FirstProto.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"
#include "FirstProto.h"
#include "LineColl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define FP_PROTO "Protocolli"
#define FP_ANYP "Qualunque Protocollo"
#define FP_ERR "Selezionare un protocollo valido!"
#else
#define FP_PROTO "Protocols"
#define FP_ANYP "Every Protocol"
#define FP_ERR "Choose a valid protocol!"
#endif

/////////////////////////////////////////////////////////////////////////////
// CFirstProto dialog


CFirstProto::CFirstProto(CWnd* pParent /*=NULL*/)
	: CDialog(CFirstProto::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFirstProto)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	lc=NULL;
}


void CFirstProto::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFirstProto)
	DDX_Control(pDX, IDC_LIST1, m_Protos);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFirstProto, CDialog)
	//{{AFX_MSG_MAP(CFirstProto)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFirstProto message handlers

BOOL CFirstProto::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
    m_Protos.InsertColumn(0,FP_PROTO /*Protocolli*/, LVCFMT_LEFT,200);
	m_ctlImage.Create(IDB_BITMAP3,16,0,RGB(255,0,255));
	m_Protos.SetImageList(&m_ctlImage,LVSIL_SMALL);
	if (lc) Update(); else OnCancel();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFirstProto::AddItem(int nItem,int nSubItem,LPCTSTR strItem,int nImageIndex)
{
	LV_ITEM lvItem;
	lvItem.mask = LVIF_TEXT;
	lvItem.iItem = nItem;
	lvItem.iSubItem = nSubItem;
	lvItem.pszText = (LPTSTR) strItem;
	if(nImageIndex != -1){
		lvItem.mask |= LVIF_IMAGE;
		lvItem.iImage = nImageIndex;
	}
	if(nSubItem == 0)
		m_Protos.InsertItem(&lvItem);
	else m_Protos.SetItem(&lvItem);
}

void CFirstProto::Update()
{
        m_Protos.DeleteAllItems();
	    int n=lc->getLineCount();
		CString t;
        for(n--;n>=0;n--)
         {
			t=lc->line(n);
	        AddItem(0,0,t,0);
         }
		AddItem(0,0,FP_ANYP /*Qualunque Protocollo*/,7);
		m_Protos.UpdateWindow();
}

void CFirstProto::SetLC(LineCollection & l)
{
	lc=&l;
}

void CFirstProto::OnOK() 
{
	int i,n=m_Protos.GetItemCount();
	m_First="";
	for(i=0;i<n;i++)
	{
		if (m_Protos.GetItemState(i,LVIS_SELECTED))
		{
			m_First=m_Protos.GetItemText(i,0);
			break;
		}
	}
	if(m_First=="")
	{
		AfxMessageBox(FP_ERR /*Selezionare un protocollo valido!*/);
		return;
	}
	if(i==0) m_First="";
	
	CDialog::OnOK();
}
