// GenSetupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"
#include "GenSetupDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define GEN_IMP "Impostazioni Generiche"
#define GEN_SF "Selezionare il file sorgente"
#define GEN_DF "Selezionare il file che verr creato"
#define GEN_AD1 "Avanzate >>"
#define GEN_AD2 "Avanzate <<"
#else
#define GEN_IMP "Generic Setup"
#define GEN_SF "Choose source file"
#define GEN_DF "Choose destination file"
#define GEN_AD1 "Advanced >>"
#define GEN_AD2 "Advanced <<"
#endif

/////////////////////////////////////////////////////////////////////////////
// CGenSetupDlg dialog


CGenSetupDlg::CGenSetupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGenSetupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGenSetupDlg)
	//}}AFX_DATA_INIT
	m_Title=GEN_IMP /*Impostazioni Generiche*/;
	m_AdvVisible=0;
	m_AdvSimple=FALSE;
}


void CGenSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGenSetupDlg)
	DDX_Control(pDX, IDC_ADVANCED, m_Advanced);
	DDX_Control(pDX, IDC_C2, m_C2);
	DDX_Control(pDX, IDC_C1, m_C1);
	DDX_Control(pDX, IDC_BROWSE2, m_C3);
	DDX_Control(pDX, IDC_EDIT2, m_Dest);
	DDX_Control(pDX, IDC_EDIT1, m_Src);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGenSetupDlg, CDialog)
	//{{AFX_MSG_MAP(CGenSetupDlg)
	ON_BN_CLICKED(IDC_BROWSE1, OnBrowse1)
	ON_BN_CLICKED(IDC_BROWSE2, OnBrowse2)
	ON_BN_CLICKED(IDC_ADVANCED, OnAdvanced)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGenSetupDlg message handlers

void CGenSetupDlg::OnBrowse1() 
{
	 CFileDialog dlgFile(TRUE);
	 BOOL bResult;

	 CString title=GEN_SF /*Selezionare il file sorgente*/;
	 CString fileName;
     UINT nIDSTitle=AFX_IDS_OPENFILE;
     DWORD lFlags=OFN_HIDEREADONLY| OFN_FILEMUSTEXIST;
     BOOL bOpenFileDialog=TRUE; 

	 dlgFile.m_ofn.Flags |= lFlags;

	 CString strFilter=m_File1;
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += m_Flt1;
	 strFilter += (TCHAR)'\0';   // last string
	 CString strDefault;
	 // append the '*.*' all files filter
	 CString allFilter;
	 VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	 strFilter += allFilter;
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += _T("*.*");
	 strFilter += (TCHAR)'\0';   // last string
	 dlgFile.m_ofn.nMaxCustFilter++;

	 dlgFile.m_ofn.lpstrFilter = strFilter;
	 dlgFile.m_ofn.lpstrTitle = title;
	 dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	 bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	 fileName.ReleaseBuffer();
	 if (!bResult) return;
	 m_Src.SetWindowText(fileName);
	 return ;
}

void CGenSetupDlg::OnBrowse2() 
{
	 CFileDialog dlgFile(TRUE);
	 BOOL bResult;

	 CString title=GEN_DF /*Selezionare il file che verr creato*/;
	 CString fileName;
     UINT nIDSTitle=AFX_IDS_OPENFILE;
     DWORD lFlags=OFN_HIDEREADONLY;
     BOOL bOpenFileDialog=FALSE; 

	 dlgFile.m_ofn.Flags |= lFlags;

	 CString strFilter=m_File2;
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += m_Flt2;
	 strFilter += (TCHAR)'\0';   // last string
	 CString strDefault;
	 // append the '*.*' all files filter
	 CString allFilter;
	 VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	 strFilter += allFilter;
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += _T("*.*");
	 strFilter += (TCHAR)'\0';   // last string
	 dlgFile.m_ofn.nMaxCustFilter++;

	 dlgFile.m_ofn.lpstrFilter = strFilter;
	 dlgFile.m_ofn.lpstrTitle = title;
	 dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	 bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	 fileName.ReleaseBuffer();
	 if (!bResult) return;
	 m_Dest.SetWindowText(fileName);
	 return ;
}

void CGenSetupDlg::OnOK() 
{
	m_Src.GetWindowText(m_F1);
	if (m_IsAdvanced)
		m_Dest.GetWindowText(m_F2);
	else
		m_F2="";
	CDialog::OnOK();
}

BOOL CGenSetupDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	SetWindowText(m_Title);
	m_Src.SetWindowText(m_F1);
	m_Dest.SetWindowText(m_F2);
	GetWindowRect(&rect);
	rect.bottom-=rect.top;
	rect.right-=rect.left;
	if (m_AdvSimple)
	{
		m_IsAdvanced=TRUE;
		OnAdvanced();
		m_Advanced.ShowWindow(SW_HIDE);
	}
	else
	if (m_AdvVisible)
	{
		m_Advanced.ShowWindow(SW_SHOW);
		m_IsAdvanced=TRUE;
		OnAdvanced();
	}
	else
	{
		m_Advanced.ShowWindow(SW_HIDE);
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CGenSetupDlg::OnAdvanced() 
{
	if (m_IsAdvanced) 
	{
		m_IsAdvanced=FALSE;
		m_C1.ShowWindow(SW_HIDE);
		m_C2.ShowWindow(SW_HIDE);
		m_C3.ShowWindow(SW_HIDE);
		m_Dest.ShowWindow(SW_HIDE);
		m_Advanced.SetWindowText(GEN_AD1 /*Avanzate >>*/);
		SetWindowPos(&wndTop,0,0,rect.right,(rect.bottom>>1)+22,SWP_NOMOVE);
	}
	else 
	{
		m_IsAdvanced=TRUE;
		m_C1.ShowWindow(SW_SHOW);
		m_C2.ShowWindow(SW_SHOW);
		m_C3.ShowWindow(SW_SHOW);
		m_Dest.ShowWindow(SW_SHOW);
		m_Advanced.SetWindowText(GEN_AD2 /*Avanzate <<*/);
		SetWindowPos(&wndTop,0,0,rect.right,rect.bottom,SWP_NOMOVE);
	}
}
