// MDINormalWnd.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"
#include "MDINormalWnd.h"
#include "clogdocument.h"
#include "csvdoc.h"
#include "tbldocument.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMDINormalWnd

IMPLEMENT_DYNCREATE(CMDINormalWnd, CMDIChildWnd)

CMDINormalWnd::CMDINormalWnd()
{
}

CMDINormalWnd::~CMDINormalWnd()
{
}


BEGIN_MESSAGE_MAP(CMDINormalWnd, CMDIChildWnd)
	//{{AFX_MSG_MAP(CMDINormalWnd)
	ON_WM_MDIACTIVATE()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMDINormalWnd message handlers

void CMDINormalWnd::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd) 
{
	CMDIChildWnd::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);
	
	if (bActivate)
	{
		CLogDocument* pDoc = (CLogDocument*)GetActiveDocument();
		CAnalyzerApp* app=(CAnalyzerApp*)AfxGetApp();
		CMDIFrameWnd* f=((CMDIFrameWnd*)AfxGetMainWnd());

		if (pDoc->IsKindOf(RUNTIME_CLASS(CLogDocument)))
		{
			int iMenu = app->m_CapMenu.GetMenuItemCount() - 2;
			CMenu* pMenu;
			if(iMenu >= 0);
				pMenu = app->m_CapMenu.GetSubMenu(iMenu);
			f->MDISetMenu(&(app->m_CapMenu),pMenu);
			pDoc->UpdateFindDial();
		}
		else if (pDoc->IsKindOf(RUNTIME_CLASS(CCsvDocument)) ||
				 pDoc->IsKindOf(RUNTIME_CLASS(CTblDocument)))
		{
			int iMenu = app->m_TblMenu.GetMenuItemCount() - 2;
			CMenu* pMenu;
			if(iMenu >= 0);
				pMenu = app->m_TblMenu.GetSubMenu(iMenu);
			f->MDISetMenu(&(app->m_TblMenu),pMenu);
			pDoc->UpdateFindDial();
		}
		else
		{
			int iMenu = app->m_TxtMenu.GetMenuItemCount() - 2;
			CMenu* pMenu;
			if(iMenu >= 0);
				pMenu = app->m_TxtMenu.GetSubMenu(iMenu);
			f->MDISetMenu(&(app->m_TxtMenu),pMenu);
		}
		f->DrawMenuBar();
		SetFocus();
	}
}


void CMDINormalWnd::OnClose() 
{
	AfxGetMainWnd()->PostMessage(WM_ACTIVATE,WA_CLICKACTIVE,0);
	CMDIChildWnd::OnClose();
}

