// MDISplittedWnd.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"
#include "MDISplittedWnd.h"
#include "CRawView.h"
#include "CListView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMDISplittedWnd

IMPLEMENT_DYNCREATE(CMDISplittedWnd, CMDIChildWnd)

CMDISplittedWnd::CMDISplittedWnd()
{
}

CMDISplittedWnd::~CMDISplittedWnd()
{
}


BEGIN_MESSAGE_MAP(CMDISplittedWnd, CMDIChildWnd)
	//{{AFX_MSG_MAP(CMDISplittedWnd)
	ON_WM_MDIACTIVATE()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMDISplittedWnd message handlers

BOOL CMDISplittedWnd::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	
	// create a splitter with 1 row, 2 columns
	if (!m_wndSplitter.CreateStatic(this, 2, 1))
	{
		TRACE0("Failed to CreateStaticSplitter\n");
		return FALSE;
	}

	// add the first splitter pane - the default view in column 0
	if (!m_wndSplitter.CreateView(0, 0,
		RUNTIME_CLASS(CListAllView), CSize(100, 100), pContext))
	{
		TRACE0("Failed to create first pane\n");
		return FALSE;
	}

	if (!m_wndSplitter2.CreateStatic(
		&m_wndSplitter,     // our parent window is the first splitter
		2, 1,               // the new splitter is 2 rows, 1 column
		WS_CHILD | WS_VISIBLE | WS_BORDER,  // style, WS_BORDER is needed
		m_wndSplitter.IdFromRowCol(1, 0)
			// new splitter is in the first row, 2nd column of first splitter
	   ))
	{
		TRACE0("Failed to create nested splitter\n");
		return FALSE;
	}
	// add the second splitter pane - an input view in column 1
	if (!m_wndSplitter2.CreateView(0, 0,
		pContext->m_pNewViewClass, CSize(200, 200), pContext))
	{
		TRACE0("Failed to create second pane\n");
		return FALSE;
	}

	if (!m_wndSplitter2.CreateView(1, 0,
		RUNTIME_CLASS(CRawView), CSize(100, 100), pContext))
	{
		TRACE0("Failed to create first pane\n");
		return FALSE;
	}

	// activate the input view
	SetActiveView((CView*)m_wndSplitter2.GetPane(0,0));

	return TRUE;
}

void CMDISplittedWnd::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd) 
{
	CMDIChildWnd::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);
	
	if (bActivate)
	{
		CLogDocument* pDoc = (CLogDocument*)GetActiveDocument();
		if (pDoc==NULL) return;
		ASSERT_KINDOF(CLogDocument, pDoc);
		CMDIFrameWnd* f=((CMDIFrameWnd*)AfxGetMainWnd());

		CAnalyzerApp* app=(CAnalyzerApp*)AfxGetApp();
		int iMenu = app->m_CapMenu.GetMenuItemCount() - 2;
		CMenu* pMenu;
		if(iMenu >= 0);
			pMenu = app->m_CapMenu.GetSubMenu(iMenu);
		f->MDISetMenu(&(app->m_CapMenu),pMenu);
		f->DrawMenuBar();
		SetFocus();
		pDoc->UpdateFindDial();
	}
}

void CMDISplittedWnd::OnClose() 
{
	AfxGetMainWnd()->PostMessage(WM_ACTIVATE,WA_CLICKACTIVE,0);
	CMDIChildWnd::OnClose();
}
