//
// _PROJ_VW.CPP
//
// Implementation of the CMyTreeView class
//
// Copyright (c) XYZ Corporation, 1998. All Rights Reserved.
//

#include <afxcview.h>
#include <afxole.h>

#include "stdafx.h"
#include "mytreevw.h"
#include "crawview.h"
#include "CLogDocument.h"
#include "Analyzer.h"
#include "messages.h"
#include "clistview.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

//
// CMyTreeView
//

IMPLEMENT_DYNCREATE(CMyTreeView, CTreeView)

BEGIN_MESSAGE_MAP(CMyTreeView, CTreeView)
	//{{AFX_MSG_MAP(CMyTreeView)
	ON_WM_CHAR()
	ON_WM_CREATE()
	ON_COMMAND(IDM_LOG_COLLAPSE,OnLogCollapse)
	ON_COMMAND(IDM_LOG_EXPAND,OnLogExpand)
	ON_UPDATE_COMMAND_UI(IDM_LOG_COLLAPSE,OnUpdateLogCollapse)
	ON_UPDATE_COMMAND_UI(IDM_LOG_EXPAND,OnUpdateLogExpand)
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	ON_COMMAND(IDM_SELECT_ALL_PCK, OnEditSelectAll)
	ON_NOTIFY_REFLECT(TVN_SELCHANGED, OnSelchanged)
	ON_COMMAND(ID_VISUALIZZA_RICORDAPOSIZIONE, OnRicordaPosizione)
	ON_UPDATE_COMMAND_UI(ID_VISUALIZZA_RICORDAPOSIZIONE, OnUpdateRicordaPosizione)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, OnFilePrintPreview)
	ON_COMMAND(IDM_PRINT_CHAR, OnPrintChar)
	ON_COMMAND(IDM_SAVEINDEX, OnSaveindex)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	//}}AFX_MSG_MAP

	// Use superclass for File/Print and File/Print Preview
END_MESSAGE_MAP()

//
// CMyTreeView constructor
//

CMyTreeView::CMyTreeView():CTreeView()
{
	ctrl=&GetTreeCtrl();
	images[0].n=0;
	images[0].s=1;
	images[1].n=2;
	images[1].s=3;
	images[2].n=4;
	images[2].s=5;
	images[3].n=6;
	images[3].s=7;
	images[4].n=10;
	images[4].s=11;
	expansion=1;
	clpbdata=NULL;
	vect=NULL;
	m_RicPos=TRUE;
	m_DisableSel=FALSE;
	m_NRows=-1;
}

//
// CMyTreeView destructor
//

CMyTreeView::~CMyTreeView()
{
	if (clpbdata) {GlobalFree (clpbdata); clpbdata=NULL;}
	if (f) delete f;
	if (vect) delete[] vect;
}

//
// CMyTreeView debug diagnostics
//

#ifdef _DEBUG
void CMyTreeView::AssertValid() const
{
	CView::AssertValid();
}

void CMyTreeView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

#endif
CLogDocument *CMyTreeView::GetDocument()
{
	return (CLogDocument *) m_pDocument;
}


void CMyTreeView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    CView::OnChar(nChar, nRepCnt, nFlags);
}


int CMyTreeView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	lpCreateStruct->style |= WS_VISIBLE|WS_CHILD|WS_BORDER
	                        |TVS_HASLINES|TVS_HASBUTTONS
            	            |TVS_LINESATROOT|TVS_SHOWSELALWAYS;
	if (CTreeView::OnCreate(lpCreateStruct) == -1)
		return -1;
	m_ctlImage.Create(IDB_TREE,16,0,RGB(255,0,255));
	m_ctlImage.SetBkColor(GetSysColor(COLOR_WINDOW));
	GetTreeCtrl().SetImageList(&m_ctlImage,TVSIL_NORMAL);
    f=new CFont();
    f->CreatePointFont(((CAnalyzerApp*)AfxGetApp())->DefinedDim,
		((CAnalyzerApp*)AfxGetApp())->DefinedFont);
	if(f)CWnd::SetFont(f);
	return 0;
}

HTREEITEM Prev (CTreeCtrl *ctrl, HTREEITEM it)
{
	HTREEITEM t;
	t=ctrl->GetPrevSiblingItem(it);
	if (t==NULL)
		return ctrl->GetParentItem(it);
	else
	{
		while(1)
		{
			if (ctrl->ItemHasChildren(t)) t=ctrl->GetChildItem(t);
				else return t;
			it=t;
			while (it!=NULL)
			{
				it=ctrl->GetNextSiblingItem(it);
				if (it!=NULL) t=it;
			}
		}
	}
}

HTREEITEM Next (CTreeCtrl *ctrl, HTREEITEM it)
{
	HTREEITEM t;
	if (ctrl->ItemHasChildren(it)) return ctrl->GetNextItem(it,TVGN_CHILD);
	t=ctrl->GetNextSiblingItem(it);
	while (t==NULL)
	{
		it=ctrl->GetParentItem(it);
		if (it==NULL) return NULL;
		t=ctrl->GetNextSiblingItem(it);
		if(t) return t;
	}
	return t;
}

int CMyTreeView::NewFromLCs(LineCollection & up)
    {
     int n=up.getLineCount();
     int level=0,i,gr=0;

        TV_INSERTSTRUCT tvs;
        TV_ITEM tvi;
        HTREEITEM it;
        HTREEITEM it1;
        HTREEITEM it2;
        HTREEITEM it3;
		int ni=0;

		if(m_RicPos)
		{
			m_DisableSel=TRUE;
			it=ctrl->GetSelectedItem();
			if (it)
			for(ni=0;it!=NULL;ni++)
			{
				it=Prev(ctrl,it);
			}
			m_DisableSel=FALSE;
		}

		m_DisableSel=TRUE;
        ctrl->DeleteAllItems();
        // Insert root;
        tvs.hInsertAfter= TVI_LAST;
        tvi.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE|TVIF_PARAM;
        tvi.iImage=images[level].n;
        tvi.iSelectedImage=images[level].s;
		tvi.lParam=NULL;
		if (vect) delete[] vect;
		vect=NULL;

		if (up.getLineCount()<=0) return 0;
        tvi.pszText=(char*)up.line(0);
        tvs.hParent=TVI_ROOT;
        tvs.item=tvi;
        it=ctrl->InsertItem(&tvs);
        if (expansion>=1) ctrl->Expand(it,TVE_EXPAND);
        // Insert description;
        level++;
        tvi.iImage=images[level].n;
        tvi.iSelectedImage=images[level].s;
        tvi.pszText="----- Item Position -----";
        tvs.hParent=it;
        tvs.item=tvi;
        it1=ctrl->InsertItem(&tvs);
        tvi.iImage=images[3].n;
        tvi.iSelectedImage=images[3].s;
		if (up.getLineCount()<=1) return 1;
        tvi.pszText=(char*)up.line(1);
        tvs.hParent=it1;
        tvs.item=tvi;
        it2=ctrl->InsertItem(&tvs);
        // Insert other data
        tvi.iImage=images[level].n;
        tvi.iSelectedImage=images[level].s;
        tvi.pszText="----- Time Informations -----";
        tvs.hParent=it;
        tvs.item=tvi;
        if (expansion>=2) ctrl->Expand(it1,TVE_EXPAND);
        it1=ctrl->InsertItem(&tvs);
		vect=new StrSE[n];
        for(i=2;i<n;i++)
         {
		  gr=0;
          tvi.pszText=(char*)up.line(i);
		  tvi.lParam=NULL;
		  int ll=strlen(tvi.pszText);
		  CString ss=tvi.pszText;
		  if (ss[ll-1]=='}') {gr=1; ss.SetAt(ll-1,']');}
		  if (ss[ll-1]==']')
		  {
			for(int ii=ll-2;ii>=0;ii--)
			{
				if (ss[ii]=='{') ss.SetAt(ii,'[');
				if (ss[ii]=='[')
				{
					int s,e;
					ss=ss.Mid(ii);
					tvi.lParam=NULL;
					if (sscanf(ss,"[%d-%d]",&s,&e)!=2) break;
					if (vect)
					{
					 if(gr==0)
					 {
					  vect[i].s=s;
					  vect[i].e=e;
					 }
					 else
					 {
					  vect[i].s=-s;
					  vect[i].e=-e;
					 }
					 tvi.lParam=(LPARAM)&(vect[i]);
					}
					tvi.pszText[ii-1]='\0';
					if (tvi.pszText[ii-2]=='-' && tvi.pszText[ii-3]==' ')
						tvi.pszText[ii-3]='\0';
					break;
				}
			}
		  }
          if ((tvi.pszText[4]=='-')&&(tvi.pszText[0]=='-'))
           {
            tvi.iImage=images[1].n;
            tvi.iSelectedImage=images[1].s;
            tvs.hParent=it;
            tvs.item=tvi;
            if (expansion>=2) ctrl->Expand(it1,TVE_EXPAND);
            it1=ctrl->InsertItem(&tvs);
           }
		   else if((tvi.pszText[4]=='=')&&(tvi.pszText[0]=='='))
			      break;
           else if (tvi.pszText[0]!=' ')
           {
            tvi.iImage=images[3].n;
            tvi.iSelectedImage=images[3].s;
            tvs.hParent=it1;
            tvs.item=tvi;
            it2=ctrl->InsertItem(&tvs);
           }
           else
           {
			tvi.pszText=tvi.pszText+1;
            tvi.iImage=images[4].n;
            tvi.iSelectedImage=images[4].s;
            tvs.hParent=it2;
            tvs.item=tvi;
            it3=ctrl->InsertItem(&tvs);
	        if (expansion>=3) 
				ctrl->Expand(it2,TVE_EXPAND);
           }
         }

        if (expansion>=3) 
			ctrl->Expand(it2,TVE_EXPAND);
        if (expansion>=2) 
			ctrl->Expand(it1,TVE_EXPAND);
        if (expansion>=1) 
			ctrl->Expand(it,TVE_EXPAND);

		m_DisableSel=FALSE;
		if(m_RicPos)
		{
			m_DisableSel=TRUE;
			if (m_NRows<0) m_NRows=i;
			// Rimuovere questi commenti per avere memoria proporzionale della posizione
			// rispetto alla dimensione dei pacchetti
			//double f;
			//f=((double)m_NRows)/((double)i);
			//if(ni>8)
			//ni=(int)(ni/f);
			m_NRows=i;
			it=ctrl->GetRootItem();
			for(int ti=0;ti<ni-1;ti++)
			{
				it=Next(ctrl,it);
				if (it==NULL) break;
			}
			if (it!=NULL) ctrl->SelectItem(it);
			m_DisableSel=FALSE;
		}
		i++;
		return i;
    }

void CMyTreeView::OnLogCollapse()
{
    if(expansion>0) expansion--;
    ((CLogDocument*)GetDocument())->OnLogThis();
}


void CMyTreeView::OnLogExpand()
{
    if(expansion<3) expansion++;
    ((CLogDocument*)GetDocument())->OnLogThis();
}


void CMyTreeView::OnUpdateLogCollapse(CCmdUI *pCmdUI)
{
    pCmdUI->Enable((expansion>0)?TRUE:FALSE);
}


void CMyTreeView::OnUpdateLogExpand(CCmdUI *pCmdUI)
{
    pCmdUI->Enable((expansion<3)?TRUE:FALSE);
}


void CMyTreeView::OnFilePrint() 
{
   CLogDocument* pDoc= ((CLogDocument*)GetDocument());
   pDoc->DoPrint();
}


void CMyTreeView::OnInitialUpdate()
{
    if (((CAnalyzerApp*)AfxGetApp())->max==TRUE) 
	{
		GetParent()->GetParent()->GetParent()->SendMessage(WM_SYSCOMMAND,SC_MAXIMIZE,0);
		((CAnalyzerApp*)AfxGetApp())->max=FALSE;
	}
    CView::OnInitialUpdate();
}

void CMyTreeView::OnEditSelectAll() 
{
	CLogDocument* doc=(CLogDocument*) GetDocument();
	CListAllView* m_pView4=(CListAllView*) doc->GetCompatibleView(RUNTIME_CLASS(CListAllView));
	if(m_pView4) m_pView4->OnSelectAll();
}

#include <limits.h>

void CMyTreeView::OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	HTREEITEM h=GetTreeCtrl().GetSelectedItem();
	if(pResult)*pResult = 0;
	if (h==NULL||m_DisableSel) return;
	CString ss;
	int n=0;
    CLogDocument* pDoc= ((CLogDocument*)GetDocument());
	CRawView* m_pView4=(CRawView*) pDoc->GetCompatibleView(RUNTIME_CLASS(CRawView));

	do
	{
	 TV_ITEM it;
	 it.mask=TVIF_PARAM|TVIF_HANDLE;
	 it.hItem=h;
	 if(GetTreeCtrl().GetItem(&it)!=0)
	 {
		if (it.lParam)
		{
			if(m_pView4) m_pView4->OnSelect(((StrSE*)(it.lParam))->s,((StrSE*)(it.lParam))->e);
			return;
		}
	 }
	 h=GetTreeCtrl().GetParentItem(h);
	 n++;
	} while (h);
	if (h==NULL && m_pView4)
		if(n>1)
		{
			m_pView4->OnSelect(0,INT_MAX);
		}
		else
			m_pView4->OnSelect(INT_MIN,INT_MIN);
}

void CMyTreeView::OnRicordaPosizione() 
{
	if (m_RicPos) m_RicPos=FALSE; else m_RicPos=TRUE;
}

void CMyTreeView::OnUpdateRicordaPosizione(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_RicPos);
}

void CMyTreeView::UpdateSelection()
{
	m_DisableSel=FALSE;
	OnSelchanged(NULL,NULL);
}

void CMyTreeView::OnFilePrintPreview() 
{
   CLogDocument* pDoc= ((CLogDocument*)GetDocument());
   pDoc->DoPrintPreview();
}

void CMyTreeView::OnPrintChar() 
{
   CLogDocument* pDoc= ((CLogDocument*)GetDocument());
   pDoc->DoPrintChars();
}

void CMyTreeView::GetSelection(int & s, int & e)
{
	HTREEITEM h=GetTreeCtrl().GetSelectedItem();
	s=INT_MIN;
	e=INT_MIN;
	CString ss;
	int n=0;
	do
	{
	 TV_ITEM it;
	 it.mask=TVIF_PARAM|TVIF_HANDLE;
	 it.hItem=h;
	 if(GetTreeCtrl().GetItem(&it)!=0)
	 {
		if (it.lParam)
		{
			s=((StrSE*)(it.lParam))->s;
			e=((StrSE*)(it.lParam))->e;
			if(s<0 && e<0) 
			{
				s=-s;
				e=-e;
			}
			return;
		}
	 }
	 h=GetTreeCtrl().GetParentItem(h);
	 n++;
	} while (h);
	if (h==NULL && n>1)
	{
		s=0;
		e=INT_MAX;
	}
}

void CMyTreeView::OnSaveindex() 
{
	CLogDocument* doc=(CLogDocument*) CView::GetDocument();
	CListAllView* m_pView4=(CListAllView*) doc->GetCompatibleView(RUNTIME_CLASS(CListAllView));
	if(m_pView4) m_pView4->SaveIndex();
}

// Clipboard support
void CMyTreeView::OnEditCopy() 
{
  CLogDocument* log=(CLogDocument*)GetDocument();
  if (log->m_ClipPck) log->EditCopy();
  if (!log->m_ClipTxt) return;

	
  LPTSTR  lpDataBuffer;
  HGLOBAL hDataBuffer;
  DWORD dwMemSize;

  CString string;
  HTREEITEM it=GetTreeCtrl().GetSelectedItem();
  if(!it) return;
  string=GetTreeCtrl().GetItemText(it);
  string+="\r\n\0"; 
  dwMemSize=string.GetLength()+1;

  if( !(hDataBuffer = GlobalAlloc( GMEM_DDESHARE, dwMemSize ) ) ) {
    AfxMessageBox("Out of memory");
    return;
  }
  if( !(lpDataBuffer = (LPTSTR) GlobalLock( hDataBuffer ) ) ) {
    GlobalFree( hDataBuffer );
    AfxMessageBox("Out of memory");
    return;
  }

  *lpDataBuffer = '\0';
  memcpy(lpDataBuffer,(const char*)string,dwMemSize);

  GlobalUnlock( hDataBuffer );

  if( !OpenClipboard() ) {
    Sleep( 250 );  // wait a quarter second and try again.
    if( !OpenClipboard() ) {
      AfxMessageBox("Could not open the Clipboard!");
      GlobalFree( hDataBuffer );
      return;
    }
  }
  if( !EmptyClipboard() ) {
    AfxMessageBox("Could not empty the Clipboard!");
    GlobalFree( hDataBuffer );
    return;
  }
  if( !SetClipboardData( CF_TEXT, hDataBuffer ) ) {
    AfxMessageBox("Could not copy data to the Clipboard!");
    GlobalFree( hDataBuffer );
    return;
  }
  CloseClipboard();

  return;
}


void CMyTreeView::OnUpdateEditCopy(CCmdUI* pCmdUI) 
{
	BOOL b=FALSE;
	CLogDocument* log=(CLogDocument*)GetDocument();
	if (!log) {pCmdUI->Enable(b); return;}
	b=log->UpdateModificaCopia();
	if (log->m_ClipTxt)
	{
		HTREEITEM it=GetTreeCtrl().GetSelectedItem();
		if (it) b=TRUE; 
	}
	pCmdUI->Enable(b); 
}
