//
// _PROJ_VW.H
//
// interface of the CMyTreeView class
//
// Copyright (c) XYZ Corporation, 1998. All Rights Reserved.
//

#ifndef _MYTREEVW
#define _MYTREEVW
#include <afxcview.h>
#include <afxwin.h>
#include <afxcmn.h>
#include <afxtempl.h>

#include "resource.h"
#include "linecoll.h"

typedef struct
{
  int n;
  int s;
} Images;

typedef struct
{
	int s;
	int e;
} StrSE;

class CLogDocument;

class CMyTreeView : public CTreeView
{
public:
	void GetSelection(int&s,int& e);
	void UpdateSelection();
	int m_NRows;
	char* clpbdata;
	CLogDocument *GetDocument();

	virtual ~CMyTreeView();
	void OnExpand(){OnLogExpand();}
	void OnCollapse(){OnLogCollapse();}
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
    int expansion;

protected:
	DECLARE_DYNCREATE(CMyTreeView)
    CFont *f;
	CMyTreeView();
    int NewFromLCs(LineCollection & up);
    CImageList m_ctlImage;
    Images images[6];
	StrSE* vect;
	// Message maps
protected:
	DECLARE_MESSAGE_MAP()
    CTreeCtrl *ctrl;

	//{{AFX_MSG(CMyTreeView)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnLogCollapse();
	afx_msg void OnLogExpand();
	afx_msg void OnUpdateLogCollapse(CCmdUI *pCmdUI);
	afx_msg void OnUpdateLogExpand(CCmdUI *pCmdUI);
	afx_msg void OnFilePrint();
	afx_msg void OnEditSelectAll();
	afx_msg void OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnRicordaPosizione();
	afx_msg void OnUpdateRicordaPosizione(CCmdUI* pCmdUI);
	afx_msg void OnFilePrintPreview();
	afx_msg void OnPrintChar();
	afx_msg void OnSaveindex();
	afx_msg void OnEditCopy();
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	//}}AFX_MSG
private:
	BOOL m_DisableSel;
	BOOL m_RicPos;
	virtual void OnInitialUpdate();
};

#endif
