#ifndef MAINFRAME
#define MAINFRAME

#include <afxext.h>
#include <afxmt.h>
#include "resource.h"
#include "FinderDlg.h"
#include "ToolBarEx.h"
#include "BCMenu.h"

class CDStatusBar: public CStatusBar
{
private:
    public:
    CDStatusBar(){n=0;}
    int n;
    inline void DoProgress(char*c);
};

class CProgCaptDlg;

class CAnalyzerApp;

class CMainFrame : public CMDIFrameWnd
{
public:
	~CMainFrame(){}
	CProgCaptDlg *prg;
	CMutex sync;
	CMenu windowmenu;
	CDocument* GetCompatibleDoc(CDocTemplate *pDocT, BOOL & IsActive);
    inline void DoProgress(char* c);
	DECLARE_DYNCREATE(CMainFrame)
    CToolBarEx    m_ToolBar1;
    int EditToolBar(int ID,int visible);
	CDStatusBar  m_StatusBar;
	CToolBarEx    m_ToolBar;
	void OnMenuSilent(int ret);
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnAppAbout();
	afx_msg void OnViewCmd();
	afx_msg void OnUpdateViewCmd(CCmdUI *pCmdUI);
	afx_msg void OnUpdateViewToolbar1(CCmdUI *pCmdUI);
	afx_msg void OnViewToolbar1(UINT nID);
	afx_msg void OnClose();
	afx_msg void OnCapture();
	afx_msg void OnMenu();
	afx_msg void OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized);
	afx_msg void OnViewEditToolbar();
	afx_msg void OnUpdateViewEditToolbar(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileClose(CCmdUI* pCmdUI);
	afx_msg void OnConfAnalyzer();
	afx_msg void OnDestroy();
	afx_msg void OnCatturaScegliadattatore();
	afx_msg void OnSelezioneCaratteri();
	afx_msg void OnInitMenu(CMenu* pMenu);
	//}}AFX_MSG
	afx_msg void OnMeasureItem(int nIDCtl, LPMEASUREITEMSTRUCT lpMeasureItemStruct);
	afx_msg LRESULT OnMenuChar( UINT nChar, UINT nFlags, CMenu* pMenu );
	afx_msg void OnInitMenuPopup( CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu );
	DECLARE_MESSAGE_MAP()
    public:
	    void RefreshMenu();
	CFinderDlg *fltr;
	BOOL m_Fltr;
    virtual BOOL PreCreateWindow( CREATESTRUCT& cs );
    CMainFrame();
    CString m_Cmd;
    BOOL IsClosing;
	CCommandDlg m_cDlg;
	BOOL m_isCmdVis;
#ifdef _DEBUG
	void AssertValid() const;
#endif
private:
	virtual HMENU GetWindowMenuPopup( HMENU hMenuBar );
	CAnalyzerApp* app;
	virtual BOOL OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext*);
	void AdjustToolBars(); 
	CString Adapter;
};

inline void CMainFrame::DoProgress(char* c)
    {
        m_StatusBar.DoProgress(c);
    }

inline void CDStatusBar::DoProgress(char *c)
    {
        n++;
        if (n>=101)
        {   n=0;
            SetPaneText(4,c,TRUE);}
        else
        {SetPaneText(4,c,FALSE);}
    }

#endif
